/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.geo.topic.gazetteer;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.tika.parser.geo.topic.GeoParserConfig;
import org.apache.tika.parser.geo.topic.gazetteer.Location;

public class GeoGazetteerClient {
    private static final String SEARCH_API = "/api/search";
    private static final String SEARCH_PARAM = "s";
    private static final String PING = "/api/ping";
    private static final Logger LOG = Logger.getLogger(GeoGazetteerClient.class.getName());
    private String url;

    public GeoGazetteerClient(String url) {
        this.url = url;
    }

    public GeoGazetteerClient(GeoParserConfig config) {
        this.url = config.getGazetteerRestEndpoint();
    }

    public Map<String, List<Location>> getLocations(List<String> locations) {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            URIBuilder uri = new URIBuilder(this.url + SEARCH_API);
            for (String loc : locations) {
                uri.addParameter(SEARCH_PARAM, loc);
            }
            HttpGet httpGet = new HttpGet(uri.build());
            HttpResponse resp = httpClient.execute((HttpUriRequest)httpGet);
            String respJson = IOUtils.toString((InputStream)resp.getEntity().getContent(), (Charset)Charsets.UTF_8);
            Type typeDef = new TypeToken<Map<String, List<Location>>>(){}.getType();
            return (Map)new Gson().fromJson(respJson, typeDef);
        }
        catch (Exception e) {
            LOG.severe(e.getMessage());
            return null;
        }
    }

    public boolean checkAvail() {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpGet httpGet = new HttpGet(this.url + PING);
            HttpResponse resp = httpClient.execute((HttpUriRequest)httpGet);
            if (resp.getStatusLine().getStatusCode() == 200) {
                return true;
            }
        }
        catch (Exception e) {
            LOG.severe(e.getMessage());
        }
        return false;
    }
}

