/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.image;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.image.ImageMetadataExtractor;
import org.apache.tika.parser.image.xmp.JempboxExtractor;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TiffParser
extends AbstractParser {
    private static final long serialVersionUID = -3941143576535464926L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.image((String)"tiff"));

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        stream.mark(Integer.MAX_VALUE);
        FilterInputStream first = new FilterInputStream(stream){

            public void close() throws IOException {
            }
        };
        new ImageMetadataExtractor(metadata).parseTiff(first);
        stream.reset();
        new JempboxExtractor(metadata).parse(stream);
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        xhtml.endDocument();
    }
}

