/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.definition;

import java.util.Locale;
import java.util.Map;
import org.apache.tiles.BasicAttributeContext;
import org.apache.tiles.Definition;
import org.apache.tiles.Initializable;
import org.apache.tiles.awareness.TilesApplicationContextAware;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.definition.NoSuchDefinitionException;
import org.apache.tiles.definition.UnresolvingLocaleDefinitionsFactory;
import org.apache.tiles.definition.dao.CachingLocaleUrlDefinitionDAO;
import org.apache.tiles.definition.dao.DefinitionDAO;
import org.apache.tiles.locale.LocaleResolver;
import org.apache.tiles.locale.impl.DefaultLocaleResolver;
import org.apache.tiles.reflect.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocaleDefinitionsFactory
extends UnresolvingLocaleDefinitionsFactory
implements Initializable {
    @Override
    public void init(Map<String, String> params) {
        String resolverClassName;
        String definitionDaoClassName = params.get("org.apache.tiles.definition.DefinitionsFactory.DefinitionDAO");
        this.definitionDao = definitionDaoClassName != null ? (DefinitionDAO)ClassUtil.instantiate((String)definitionDaoClassName) : this.createDefaultDefinitionDAO();
        if (this.definitionDao instanceof TilesApplicationContextAware) {
            ((TilesApplicationContextAware)((Object)this.definitionDao)).setApplicationContext(this.applicationContext);
        }
        if (this.definitionDao instanceof Initializable) {
            ((Initializable)this.definitionDao).init(params);
        }
        this.localeResolver = (resolverClassName = params.get("org.apache.tiles.locale.LocaleResolver")) != null ? (LocaleResolver)ClassUtil.instantiate((String)resolverClassName) : this.createDefaultLocaleResolver();
        this.localeResolver.init(params);
    }

    @Override
    public Definition getDefinition(String name, TilesRequestContext tilesContext) {
        Definition retValue;
        Locale locale = null;
        if (tilesContext != null) {
            locale = this.localeResolver.resolveLocale(tilesContext);
        }
        if ((retValue = this.definitionDao.getDefinition(name, locale)) != null) {
            retValue = new Definition(retValue);
            String parentDefinitionName = retValue.getExtends();
            while (parentDefinitionName != null) {
                Definition parent = this.definitionDao.getDefinition(parentDefinitionName, locale);
                if (parent == null) {
                    throw new NoSuchDefinitionException("Cannot find definition '" + parentDefinitionName + "' ancestor of '" + retValue.getName() + "'");
                }
                retValue.inherit((BasicAttributeContext)parent);
                parentDefinitionName = parent.getExtends();
            }
        }
        return retValue;
    }

    protected LocaleResolver createDefaultLocaleResolver() {
        return new DefaultLocaleResolver();
    }

    protected DefinitionDAO<Locale> createDefaultDefinitionDAO() {
        return new CachingLocaleUrlDefinitionDAO();
    }
}

