/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.definition.pattern.regexp;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tiles.Definition;
import org.apache.tiles.definition.pattern.DefinitionPatternMatcher;
import org.apache.tiles.definition.pattern.PatternUtil;

public class RegexpDefinitionPatternMatcher
implements DefinitionPatternMatcher {
    private Pattern pattern;
    private Definition definition;

    public RegexpDefinitionPatternMatcher(String pattern, Definition definition) {
        this.pattern = Pattern.compile(pattern);
        this.definition = definition;
    }

    public Definition createDefinition(String definitionName) {
        Definition retValue = null;
        Matcher matcher = this.pattern.matcher(definitionName);
        if (matcher.matches()) {
            int groupCount = matcher.groupCount() + 1;
            Object[] vars = new Object[groupCount];
            for (int i = 0; i < groupCount; ++i) {
                vars[i] = matcher.group(i);
            }
            retValue = PatternUtil.replacePlaceholders(this.definition, definitionName, vars);
        }
        return retValue;
    }
}

