/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.request.portlet;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletContext;
import org.apache.tiles.request.ApplicationContext;
import org.apache.tiles.request.ApplicationResource;
import org.apache.tiles.request.attribute.AttributeExtractor;
import org.apache.tiles.request.attribute.HasKeys;
import org.apache.tiles.request.collection.ReadOnlyEnumerationMap;
import org.apache.tiles.request.collection.ScopeMap;
import org.apache.tiles.request.locale.URLApplicationResource;
import org.apache.tiles.request.portlet.extractor.ApplicationScopeExtractor;
import org.apache.tiles.request.portlet.extractor.InitParameterExtractor;

public class PortletApplicationContext
implements ApplicationContext {
    private Map<String, Object> applicationScope = null;
    protected PortletContext context = null;
    private Map<String, String> initParam = null;

    public PortletApplicationContext(PortletContext context) {
        this.initialize(context);
    }

    public Object getContext() {
        return this.context;
    }

    public void initialize(PortletContext context) {
        this.context = context;
    }

    public PortletContext getPortletContext() {
        return this.context;
    }

    public Map<String, Object> getApplicationScope() {
        if (this.applicationScope == null && this.context != null) {
            this.applicationScope = new ScopeMap((AttributeExtractor)new ApplicationScopeExtractor(this.context));
        }
        return this.applicationScope;
    }

    public Map<String, String> getInitParams() {
        if (this.initParam == null && this.context != null) {
            this.initParam = new ReadOnlyEnumerationMap((HasKeys)new InitParameterExtractor(this.context));
        }
        return this.initParam;
    }

    public ApplicationResource getResource(String localePath) {
        try {
            URL url = this.context.getResource(localePath);
            if (url != null) {
                return new URLApplicationResource(localePath, url);
            }
            return null;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public ApplicationResource getResource(ApplicationResource base, Locale locale) {
        try {
            URL url = this.context.getResource(base.getLocalePath(locale));
            if (url != null) {
                return new URLApplicationResource(base.getPath(), locale, url);
            }
            return null;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public Collection<ApplicationResource> getResources(String path) {
        ArrayList<ApplicationResource> resources = new ArrayList<ApplicationResource>();
        resources.add(this.getResource(path));
        return resources;
    }
}

