/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.request.servlet;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.tiles.request.ApplicationAccess;
import org.apache.tiles.request.ApplicationContext;
import org.apache.tiles.request.Request;
import org.apache.tiles.request.RequestWrapper;
import org.apache.tiles.request.servlet.NotAServletEnvironmentException;
import org.apache.tiles.request.servlet.ServletApplicationContext;
import org.apache.tiles.request.servlet.ServletRequest;

public final class ServletUtil {
    private ServletUtil() {
    }

    public static IOException wrapServletException(ServletException ex, String message) {
        Throwable rootCause = ex.getRootCause();
        IOException retValue = rootCause != null ? new IOException(message, rootCause) : new IOException(message, (Throwable)ex);
        return retValue;
    }

    public static ApplicationContext getApplicationContext(ServletContext servletContext) {
        return (ApplicationContext)servletContext.getAttribute(ApplicationAccess.APPLICATION_CONTEXT_ATTRIBUTE);
    }

    public static ServletRequest getServletRequest(Request request) {
        Request currentRequest = request;
        while (true) {
            if (currentRequest == null) {
                throw new NotAServletEnvironmentException("Last Tiles request context is null");
            }
            if (currentRequest instanceof ServletRequest) {
                return (ServletRequest)currentRequest;
            }
            if (!(currentRequest instanceof RequestWrapper)) {
                throw new NotAServletEnvironmentException("Not a Servlet environment, not supported");
            }
            currentRequest = ((RequestWrapper)currentRequest).getWrappedRequest();
        }
    }

    public static ServletContext getServletContext(ApplicationContext applicationContext) {
        if (applicationContext instanceof ServletApplicationContext) {
            return (ServletContext)((ServletApplicationContext)applicationContext).getContext();
        }
        throw new NotAServletEnvironmentException("Not a Servlet-based environment");
    }
}

