/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Globals;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.modeler.Registry;

public abstract class ManagerBase
implements Manager,
MBeanRegistration {
    protected Log log = LogFactory.getLog(ManagerBase.class);
    private static final String devRandomSourceDefault;
    protected DataInputStream randomIS = null;
    protected String devRandomSource = devRandomSourceDefault;
    protected static final String DEFAULT_ALGORITHM = "MD5";
    protected String algorithm = "MD5";
    protected Container container;
    protected MessageDigest digest = null;
    protected boolean distributable;
    protected String entropy = null;
    private static final String info = "ManagerBase/1.0";
    protected int maxInactiveInterval = 60;
    protected int sessionIdLength = 16;
    protected static String name;
    protected Random random = null;
    protected String randomClass = "java.security.SecureRandom";
    protected int sessionMaxAliveTime;
    protected int sessionAverageAliveTime;
    protected static final int TIMING_STATS_CACHE_SIZE = 100;
    protected LinkedList<SessionTiming> sessionCreationTiming = new LinkedList();
    protected LinkedList<SessionTiming> sessionExpirationTiming = new LinkedList();
    protected int expiredSessions = 0;
    protected Map<String, Session> sessions = new ConcurrentHashMap<String, Session>();
    protected int sessionCounter = 0;
    protected volatile int maxActive = 0;
    private final Object maxActiveUpdateLock = new Object();
    protected int duplicates = 0;
    protected boolean initialized = false;
    protected long processingTime = 0L;
    private int count = 0;
    protected int processExpiresFrequency = 6;
    protected static StringManager sm;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected String domain;
    protected ObjectName oname;
    protected MBeanServer mserver;

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        String oldAlgorithm = this.algorithm;
        this.algorithm = algorithm;
        this.support.firePropertyChange("algorithm", oldAlgorithm, this.algorithm);
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        Container oldContainer = this.container;
        this.container = container;
        this.support.firePropertyChange("container", oldContainer, this.container);
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public synchronized MessageDigest getDigest() {
        if (this.digest == null) {
            long t1 = System.currentTimeMillis();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("managerBase.getting", this.algorithm));
            }
            try {
                this.digest = MessageDigest.getInstance(this.algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                this.log.error((Object)sm.getString("managerBase.digest", this.algorithm), (Throwable)e);
                try {
                    this.digest = MessageDigest.getInstance(DEFAULT_ALGORITHM);
                }
                catch (NoSuchAlgorithmException f) {
                    this.log.error((Object)sm.getString("managerBase.digest", DEFAULT_ALGORITHM), (Throwable)e);
                    this.digest = null;
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("managerBase.gotten"));
            }
            long t2 = System.currentTimeMillis();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("getDigest() " + (t2 - t1)));
            }
        }
        return this.digest;
    }

    public boolean getDistributable() {
        return this.distributable;
    }

    public void setDistributable(boolean distributable) {
        boolean oldDistributable = this.distributable;
        this.distributable = distributable;
        this.support.firePropertyChange("distributable", new Boolean(oldDistributable), new Boolean(this.distributable));
    }

    public String getEntropy() {
        if (this.entropy == null) {
            byte[] result = new byte[32];
            boolean apr = false;
            try {
                String methodName = "random";
                Class[] paramTypes = new Class[]{result.getClass(), Integer.TYPE};
                Object[] paramValues = new Object[]{result, new Integer(32)};
                Method method = Class.forName("org.apache.tomcat.jni.OS").getMethod(methodName, paramTypes);
                method.invoke(null, paramValues);
                apr = true;
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (apr) {
                try {
                    this.setEntropy(new String(result, "ISO-8859-1"));
                }
                catch (UnsupportedEncodingException ux) {
                    throw new Error(ux);
                }
            } else {
                this.setEntropy(this.toString());
            }
        }
        return this.entropy;
    }

    public void setEntropy(String entropy) {
        String oldEntropy = entropy;
        this.entropy = entropy;
        this.support.firePropertyChange("entropy", oldEntropy, this.entropy);
    }

    public String getInfo() {
        return info;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int interval) {
        int oldMaxInactiveInterval = this.maxInactiveInterval;
        this.maxInactiveInterval = interval;
        this.support.firePropertyChange("maxInactiveInterval", new Integer(oldMaxInactiveInterval), new Integer(this.maxInactiveInterval));
    }

    public int getSessionIdLength() {
        return this.sessionIdLength;
    }

    public void setSessionIdLength(int idLength) {
        int oldSessionIdLength = this.sessionIdLength;
        this.sessionIdLength = idLength;
        this.support.firePropertyChange("sessionIdLength", new Integer(oldSessionIdLength), new Integer(this.sessionIdLength));
    }

    public String getName() {
        return name;
    }

    public void setRandomFile(String s) {
        if (Globals.IS_SECURITY_ENABLED) {
            AccessController.doPrivileged(new PrivilegedSetRandomFile(s));
        } else {
            this.doSetRandomFile(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSetRandomFile(String s) {
        block23: {
            FilterInputStream is = null;
            try {
                if (s == null || s.length() == 0) {
                    return;
                }
                File f = new File(s);
                if (!f.exists()) {
                    return;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Opening " + s));
                }
                is = new DataInputStream(new FileInputStream(f));
                ((DataInputStream)is).readLong();
            }
            catch (IOException ex) {
                this.log.warn((Object)("Error reading " + s), (Throwable)ex);
                if (is == null) break block23;
                try {
                    is.close();
                }
                catch (Exception ex2) {
                    this.log.warn((Object)("Failed to close " + s), (Throwable)ex2);
                }
                is = null;
            }
            finally {
                DataInputStream oldIS = this.randomIS;
                this.devRandomSource = is != null ? s : null;
                this.randomIS = is;
                if (oldIS != null) {
                    try {
                        oldIS.close();
                    }
                    catch (Exception ex) {
                        this.log.warn((Object)"Failed to close RandomIS", (Throwable)ex);
                    }
                }
            }
        }
    }

    public String getRandomFile() {
        return this.devRandomSource;
    }

    public Random getRandom() {
        if (this.random == null) {
            long t2;
            long seed;
            long t1 = seed = System.currentTimeMillis();
            char[] entropy = this.getEntropy().toCharArray();
            for (int i = 0; i < entropy.length; ++i) {
                long update = (long)entropy[i] << i % 8 * 8;
                seed ^= update;
            }
            try {
                Class<?> clazz = Class.forName(this.randomClass);
                this.random = (Random)clazz.newInstance();
                this.random.setSeed(seed);
            }
            catch (Exception e) {
                this.log.error((Object)sm.getString("managerBase.random", this.randomClass), (Throwable)e);
                this.random = new Random();
                this.random.setSeed(seed);
            }
            if (this.log.isDebugEnabled() && (t2 = System.currentTimeMillis()) - t1 > 100L) {
                this.log.debug((Object)(sm.getString("managerBase.seeding", this.randomClass) + " " + (t2 - t1)));
            }
        }
        return this.random;
    }

    public String getRandomClass() {
        return this.randomClass;
    }

    public void setRandomClass(String randomClass) {
        String oldRandomClass = this.randomClass;
        this.randomClass = randomClass;
        this.support.firePropertyChange("randomClass", oldRandomClass, this.randomClass);
    }

    public int getExpiredSessions() {
        return this.expiredSessions;
    }

    public void setExpiredSessions(int expiredSessions) {
        this.expiredSessions = expiredSessions;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public void setProcessingTime(long processingTime) {
        this.processingTime = processingTime;
    }

    public int getProcessExpiresFrequency() {
        return this.processExpiresFrequency;
    }

    public void setProcessExpiresFrequency(int processExpiresFrequency) {
        if (processExpiresFrequency <= 0) {
            return;
        }
        int oldProcessExpiresFrequency = this.processExpiresFrequency;
        this.processExpiresFrequency = processExpiresFrequency;
        this.support.firePropertyChange("processExpiresFrequency", new Integer(oldProcessExpiresFrequency), new Integer(this.processExpiresFrequency));
    }

    public void backgroundProcess() {
        this.count = (this.count + 1) % this.processExpiresFrequency;
        if (this.count == 0) {
            this.processExpires();
        }
    }

    public void processExpires() {
        long timeNow = System.currentTimeMillis();
        Session[] sessions = this.findSessions();
        int expireHere = 0;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Start expire sessions " + this.getName() + " at " + timeNow + " sessioncount " + sessions.length));
        }
        for (int i = 0; i < sessions.length; ++i) {
            if (sessions[i] == null || sessions[i].isValid()) continue;
            ++expireHere;
        }
        long timeEnd = System.currentTimeMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("End expire sessions " + this.getName() + " processingTime " + (timeEnd - timeNow) + " expired sessions: " + expireHere));
        }
        this.processingTime += timeEnd - timeNow;
    }

    public void destroy() {
        if (this.oname != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.oname);
        }
        if (this.randomIS != null) {
            try {
                this.randomIS.close();
            }
            catch (IOException ioe) {
                this.log.warn((Object)"Failed to close randomIS.");
            }
            this.randomIS = null;
        }
        this.initialized = false;
        this.oname = null;
    }

    public void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.log = LogFactory.getLog(ManagerBase.class);
        if (this.oname == null) {
            try {
                StandardContext ctx = (StandardContext)this.getContainer();
                Engine eng = (Engine)ctx.getParent().getParent();
                this.domain = ctx.getEngineName();
                this.distributable = ctx.getDistributable();
                StandardHost hst = (StandardHost)ctx.getParent();
                String path = ctx.getPath();
                if (path.equals("")) {
                    path = "/";
                }
                this.oname = new ObjectName(this.domain + ":type=Manager,path=" + path + ",host=" + hst.getName());
                Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
            }
            catch (Exception e) {
                this.log.error((Object)"Error registering ", (Throwable)e);
            }
        }
        this.getRandomBytes(new byte[16]);
        while (this.sessionCreationTiming.size() < 100) {
            this.sessionCreationTiming.add(null);
        }
        while (this.sessionExpirationTiming.size() < 100) {
            this.sessionExpirationTiming.add(null);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Registering " + this.oname));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Session session) {
        this.sessions.put(session.getIdInternal(), session);
        int size = this.sessions.size();
        if (size > this.maxActive) {
            Object object = this.maxActiveUpdateLock;
            synchronized (object) {
                if (size > this.maxActive) {
                    this.maxActive = size;
                }
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public Session createSession() {
        return this.createSession(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session createSession(String sessionId) {
        Session session = this.createEmptySession();
        session.setNew(true);
        session.setValid(true);
        session.setCreationTime(System.currentTimeMillis());
        session.setMaxInactiveInterval(this.maxInactiveInterval);
        if (sessionId == null) {
            sessionId = this.generateSessionId();
        }
        session.setId(sessionId);
        ++this.sessionCounter;
        SessionTiming timing = new SessionTiming(session.getCreationTime(), 0);
        LinkedList<SessionTiming> linkedList = this.sessionCreationTiming;
        synchronized (linkedList) {
            this.sessionCreationTiming.add(timing);
            this.sessionCreationTiming.poll();
        }
        return session;
    }

    public Session createEmptySession() {
        return this.getNewSession();
    }

    public Session findSession(String id) throws IOException {
        if (id == null) {
            return null;
        }
        return this.sessions.get(id);
    }

    public Session[] findSessions() {
        return this.sessions.values().toArray(new Session[0]);
    }

    public void remove(Session session) {
        this.sessions.remove(session.getIdInternal());
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void changeSessionId(Session session) {
        String oldId = session.getIdInternal();
        session.setId(this.generateSessionId(), false);
        String newId = session.getIdInternal();
        if (this.container instanceof ContainerBase) {
            ((ContainerBase)this.container).fireContainerEvent("changeSessionId", new String[]{oldId, newId});
        }
    }

    protected StandardSession getNewSession() {
        return new StandardSession(this);
    }

    protected void getRandomBytes(byte[] bytes) {
        if (this.devRandomSource != null && this.randomIS == null) {
            this.setRandomFile(this.devRandomSource);
        }
        if (this.randomIS != null) {
            try {
                int len = this.randomIS.read(bytes);
                if (len == bytes.length) {
                    return;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Got " + len + " " + bytes.length));
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.devRandomSource = null;
            try {
                this.randomIS.close();
            }
            catch (Exception e) {
                this.log.warn((Object)"Failed to close randomIS.");
            }
            this.randomIS = null;
        }
        this.getRandom().nextBytes(bytes);
    }

    protected synchronized String generateSessionId() {
        byte[] random = new byte[16];
        String jvmRoute = this.getJvmRoute();
        String result = null;
        StringBuffer buffer = new StringBuffer();
        do {
            int resultLenBytes = 0;
            if (result != null) {
                buffer = new StringBuffer();
                ++this.duplicates;
            }
            while (resultLenBytes < this.sessionIdLength) {
                this.getRandomBytes(random);
                random = this.getDigest().digest(random);
                for (int j = 0; j < random.length && resultLenBytes < this.sessionIdLength; ++resultLenBytes, ++j) {
                    byte b1 = (byte)((random[j] & 0xF0) >> 4);
                    byte b2 = (byte)(random[j] & 0xF);
                    if (b1 < 10) {
                        buffer.append((char)(48 + b1));
                    } else {
                        buffer.append((char)(65 + (b1 - 10)));
                    }
                    if (b2 < 10) {
                        buffer.append((char)(48 + b2));
                        continue;
                    }
                    buffer.append((char)(65 + (b2 - 10)));
                }
            }
            if (jvmRoute == null) continue;
            buffer.append('.').append(jvmRoute);
        } while (this.sessions.containsKey(result = buffer.toString()));
        return result;
    }

    public Engine getEngine() {
        Engine e = null;
        for (Container c = this.getContainer(); e == null && c != null; c = c.getParent()) {
            if (c == null || !(c instanceof Engine)) continue;
            e = (Engine)c;
        }
        return e;
    }

    public String getJvmRoute() {
        Engine e = this.getEngine();
        return e == null ? null : e.getJvmRoute();
    }

    public void setSessionCounter(int sessionCounter) {
        this.sessionCounter = sessionCounter;
    }

    public int getSessionCounter() {
        return this.sessionCounter;
    }

    public int getDuplicates() {
        return this.duplicates;
    }

    public void setDuplicates(int duplicates) {
        this.duplicates = duplicates;
    }

    public int getActiveSessions() {
        return this.sessions.size();
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxActive(int maxActive) {
        Object object = this.maxActiveUpdateLock;
        synchronized (object) {
            this.maxActive = maxActive;
        }
    }

    public int getSessionMaxAliveTime() {
        return this.sessionMaxAliveTime;
    }

    public void setSessionMaxAliveTime(int sessionMaxAliveTime) {
        this.sessionMaxAliveTime = sessionMaxAliveTime;
    }

    public int getSessionAverageAliveTime() {
        return this.sessionAverageAliveTime;
    }

    public void setSessionAverageAliveTime(int sessionAverageAliveTime) {
        this.sessionAverageAliveTime = sessionAverageAliveTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSessionCreateRate() {
        long now = System.currentTimeMillis();
        ArrayList<SessionTiming> copy = new ArrayList<SessionTiming>();
        LinkedList<SessionTiming> linkedList = this.sessionCreationTiming;
        synchronized (linkedList) {
            copy.addAll(this.sessionCreationTiming);
        }
        long oldest = now;
        int counter = 0;
        int result = 0;
        for (SessionTiming timing : copy) {
            if (timing == null) continue;
            ++counter;
            if (timing.getTimestamp() >= oldest) continue;
            oldest = timing.getTimestamp();
        }
        if (counter > 0) {
            result = oldest < now ? (int)((long)(60000 * counter) / (now - oldest)) : Integer.MAX_VALUE;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSessionExpireRate() {
        long now = System.currentTimeMillis();
        ArrayList<SessionTiming> copy = new ArrayList<SessionTiming>();
        LinkedList<SessionTiming> linkedList = this.sessionExpirationTiming;
        synchronized (linkedList) {
            copy.addAll(this.sessionExpirationTiming);
        }
        long oldest = now;
        int counter = 0;
        int result = 0;
        for (SessionTiming timing : copy) {
            if (timing == null) continue;
            ++counter;
            if (timing.getTimestamp() >= oldest) continue;
            oldest = timing.getTimestamp();
        }
        if (counter > 0) {
            result = oldest < now ? (int)((long)(60000 * counter) / (now - oldest)) : Integer.MAX_VALUE;
        }
        return result;
    }

    public String listSessionIds() {
        StringBuffer sb = new StringBuffer();
        Iterator<String> keys = this.sessions.keySet().iterator();
        while (keys.hasNext()) {
            sb.append((Object)keys.next()).append(" ");
        }
        return sb.toString();
    }

    public String getSessionAttribute(String sessionId, String key) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Session not found " + sessionId));
            }
            return null;
        }
        Object o = s.getSession().getAttribute(key);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public HashMap getSession(String sessionId) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Session not found " + sessionId));
            }
            return null;
        }
        Enumeration ee = s.getSession().getAttributeNames();
        if (ee == null || !ee.hasMoreElements()) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        while (ee.hasMoreElements()) {
            String attrName = (String)ee.nextElement();
            map.put(attrName, this.getSessionAttribute(sessionId, attrName));
        }
        return map;
    }

    public void expireSession(String sessionId) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Session not found " + sessionId));
            }
            return;
        }
        s.expire();
    }

    public long getLastAccessedTimestamp(String sessionId) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            return -1L;
        }
        return s.getLastAccessedTime();
    }

    public String getLastAccessedTime(String sessionId) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Session not found " + sessionId));
            }
            return "";
        }
        return new Date(s.getLastAccessedTime()).toString();
    }

    public String getCreationTime(String sessionId) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Session not found " + sessionId));
            }
            return "";
        }
        return new Date(s.getCreationTime()).toString();
    }

    public long getCreationTimestamp(String sessionId) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            return -1L;
        }
        return s.getCreationTime();
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    static {
        File f = new File("/dev/urandom");
        devRandomSourceDefault = f.isAbsolute() && f.exists() ? f.getPath() : null;
        name = "ManagerBase";
        sm = StringManager.getManager("org.apache.catalina.session");
    }

    protected static final class SessionTiming {
        private long timestamp;
        private int duration;

        public SessionTiming(long timestamp, int duration) {
            this.timestamp = timestamp;
            this.duration = duration;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public int getDuration() {
            return this.duration;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PrivilegedSetRandomFile
    implements PrivilegedAction<Void> {
        private final String s;

        public PrivilegedSetRandomFile(String s) {
            this.s = s;
        }

        @Override
        public Void run() {
            ManagerBase.this.doSetRandomFile(this.s);
            return null;
        }
    }
}

