/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jdbc.test;

import java.sql.Connection;
import org.apache.tomcat.jdbc.pool.interceptor.ResetAbandonedTimer;
import org.apache.tomcat.jdbc.test.DefaultTestCase;

public class AbandonPercentageTest
extends DefaultTestCase {
    public AbandonPercentageTest(String name) {
        super(name);
    }

    public void testDefaultAbandon() throws Exception {
        this.init();
        this.datasource.setMaxActive(100);
        this.datasource.setMaxIdle(100);
        this.datasource.setInitialSize(0);
        this.datasource.getPoolProperties().setAbandonWhenPercentageFull(0);
        this.datasource.getPoolProperties().setTimeBetweenEvictionRunsMillis(100);
        this.datasource.getPoolProperties().setRemoveAbandoned(true);
        this.datasource.getPoolProperties().setRemoveAbandonedTimeout(1);
        Connection con = this.datasource.getConnection();
        AbandonPercentageTest.assertEquals((String)"Number of connections active/busy should be 1", (int)1, (int)this.datasource.getPool().getActive());
        Thread.sleep(2000L);
        AbandonPercentageTest.assertEquals((String)"Number of connections active/busy should be 0", (int)0, (int)this.datasource.getPool().getActive());
        con.close();
    }

    public void testMaxedOutAbandon() throws Exception {
        int size = 100;
        this.init();
        this.datasource.setMaxActive(size);
        this.datasource.setMaxIdle(size);
        this.datasource.setInitialSize(0);
        this.datasource.getPoolProperties().setAbandonWhenPercentageFull(100);
        this.datasource.getPoolProperties().setTimeBetweenEvictionRunsMillis(100);
        this.datasource.getPoolProperties().setRemoveAbandoned(true);
        this.datasource.getPoolProperties().setRemoveAbandonedTimeout(1);
        Connection con = this.datasource.getConnection();
        AbandonPercentageTest.assertEquals((String)"Number of connections active/busy should be 1", (int)1, (int)this.datasource.getPool().getActive());
        Thread.sleep(2000L);
        AbandonPercentageTest.assertEquals((String)"Number of connections active/busy should be 1", (int)1, (int)this.datasource.getPool().getActive());
        con.close();
    }

    public void testResetConnection() throws Exception {
        int size = 1;
        this.init();
        this.datasource.setMaxActive(size);
        this.datasource.setMaxIdle(size);
        this.datasource.setInitialSize(0);
        this.datasource.getPoolProperties().setAbandonWhenPercentageFull(100);
        this.datasource.getPoolProperties().setTimeBetweenEvictionRunsMillis(100);
        this.datasource.getPoolProperties().setRemoveAbandoned(true);
        this.datasource.getPoolProperties().setRemoveAbandonedTimeout(1);
        this.datasource.getPoolProperties().setJdbcInterceptors(ResetAbandonedTimer.class.getName());
        Connection con = this.datasource.getConnection();
        AbandonPercentageTest.assertEquals((String)"Number of connections active/busy should be 1", (int)1, (int)this.datasource.getPool().getActive());
        for (int i = 0; i < 20; ++i) {
            Thread.sleep(200L);
            con.isClosed();
        }
        AbandonPercentageTest.assertEquals((String)"Number of connections active/busy should be 1", (int)1, (int)this.datasource.getPool().getActive());
        con.close();
    }

    public void testHalfway() throws Exception {
        int i;
        int size = 100;
        this.init();
        this.datasource.setMaxActive(size);
        this.datasource.setMaxIdle(size);
        this.datasource.setInitialSize(0);
        this.datasource.getPoolProperties().setAbandonWhenPercentageFull(50);
        this.datasource.getPoolProperties().setTimeBetweenEvictionRunsMillis(500);
        this.datasource.getPoolProperties().setRemoveAbandoned(true);
        this.datasource.getPoolProperties().setRemoveAbandonedTimeout(1);
        Connection[] con = new Connection[size];
        con[0] = this.datasource.getConnection();
        AbandonPercentageTest.assertEquals((String)"Number of connections active/busy should be 1", (int)1, (int)this.datasource.getPool().getActive());
        for (i = 1; i < 25; ++i) {
            con[i] = this.datasource.getConnection();
        }
        AbandonPercentageTest.assertEquals((String)"Number of connections active/busy should be 25", (int)25, (int)this.datasource.getPool().getActive());
        Thread.sleep(2500L);
        AbandonPercentageTest.assertEquals((String)"Number of connections active/busy should be 25", (int)25, (int)this.datasource.getPool().getActive());
        this.datasource.getPoolProperties().setRemoveAbandonedTimeout(100);
        for (i = 25; i < con.length; ++i) {
            con[i] = this.datasource.getConnection();
        }
        int active = this.datasource.getPool().getActive();
        System.out.println("Active:" + active);
        AbandonPercentageTest.assertEquals((String)("Number of connections active/busy should be " + con.length), (int)con.length, (int)this.datasource.getPool().getActive());
        this.datasource.getPoolProperties().setRemoveAbandonedTimeout(1);
        Thread.sleep(2500L);
        AbandonPercentageTest.assertTrue((String)"Number of connections should be less than 50.", (this.datasource.getPool().getActive() < 50 ? 1 : 0) != 0);
        this.datasource.getPoolProperties().setAbandonWhenPercentageFull(0);
        Thread.sleep(2500L);
        AbandonPercentageTest.assertEquals((String)"Number of connections active/busy should be 0", (int)0, (int)this.datasource.getPool().getActive());
    }
}

