/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jdbc.test;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.concurrent.CountDownLatch;
import javax.sql.DataSource;
import org.apache.tomcat.jdbc.test.DefaultTestCase;

public class CheckOutThreadTest
extends DefaultTestCase {
    CountDownLatch latch = null;

    public CheckOutThreadTest(String name) {
        super(name);
    }

    public void testDBCPThreads10Connections10() throws Exception {
        this.init();
        this.datasource.getPoolProperties().setMaxActive(10);
        this.threadcount = 10;
        this.transferProperties();
        this.tDatasource.getConnection().close();
        this.latch = new CountDownLatch(this.threadcount);
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.threadcount; ++i) {
            TestThread t = new TestThread();
            t.setName("tomcat-dbcp-" + i);
            t.d = this.tDatasource;
            t.start();
        }
        this.latch.await();
        long delta = System.currentTimeMillis() - start;
        System.out.println("[testDBCPThreads10Connections10]Test complete:" + delta + " ms. Iterations:" + this.threadcount * this.iterations);
        this.tearDown();
    }

    public void testPoolThreads10Connections10() throws Exception {
        this.init();
        this.datasource.getPoolProperties().setMaxActive(10);
        this.datasource.getPoolProperties().setFairQueue(false);
        this.threadcount = 10;
        this.transferProperties();
        this.datasource.getConnection().close();
        this.latch = new CountDownLatch(this.threadcount);
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.threadcount; ++i) {
            TestThread t = new TestThread();
            t.setName("tomcat-pool-" + i);
            t.d = this.datasource;
            t.start();
        }
        this.latch.await();
        long delta = System.currentTimeMillis() - start;
        System.out.println("[testPoolThreads10Connections10]Test complete:" + delta + " ms. Iterations:" + this.threadcount * this.iterations);
        this.tearDown();
    }

    public void testPoolThreads10Connections10Fair() throws Exception {
        this.init();
        this.datasource.getPoolProperties().setMaxActive(10);
        this.datasource.getPoolProperties().setFairQueue(true);
        this.threadcount = 10;
        this.transferProperties();
        this.datasource.getConnection().close();
        this.latch = new CountDownLatch(this.threadcount);
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.threadcount; ++i) {
            TestThread t = new TestThread();
            t.setName("tomcat-pool-" + i);
            t.d = this.datasource;
            t.start();
        }
        this.latch.await();
        long delta = System.currentTimeMillis() - start;
        System.out.println("[testPoolThreads10Connections10Fair]Test complete:" + delta + " ms. Iterations:" + this.threadcount * this.iterations);
        this.tearDown();
    }

    public void testDBCPThreads20Connections10() throws Exception {
        this.init();
        this.datasource.getPoolProperties().setMaxActive(10);
        this.threadcount = 20;
        this.transferProperties();
        this.tDatasource.getConnection().close();
        this.latch = new CountDownLatch(this.threadcount);
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.threadcount; ++i) {
            TestThread t = new TestThread();
            t.setName("tomcat-dbcp-" + i);
            t.d = this.tDatasource;
            t.start();
        }
        this.latch.await();
        long delta = System.currentTimeMillis() - start;
        System.out.println("[testDBCPThreads20Connections10]Test complete:" + delta + " ms. Iterations:" + this.threadcount * this.iterations);
        this.tearDown();
    }

    public void testPoolThreads20Connections10() throws Exception {
        this.init();
        this.datasource.getPoolProperties().setMaxActive(10);
        this.datasource.getPoolProperties().setFairQueue(false);
        this.threadcount = 20;
        this.transferProperties();
        this.datasource.getConnection().close();
        this.latch = new CountDownLatch(this.threadcount);
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.threadcount; ++i) {
            TestThread t = new TestThread();
            t.setName("tomcat-pool-" + i);
            t.d = this.datasource;
            t.start();
        }
        this.latch.await();
        long delta = System.currentTimeMillis() - start;
        System.out.println("[testPoolThreads20Connections10]Test complete:" + delta + " ms. Iterations:" + this.threadcount * this.iterations);
        this.tearDown();
    }

    public void testPoolThreads20Connections10Fair() throws Exception {
        this.init();
        this.datasource.getPoolProperties().setMaxActive(10);
        this.datasource.getPoolProperties().setFairQueue(true);
        this.threadcount = 20;
        this.transferProperties();
        this.datasource.getConnection().close();
        this.latch = new CountDownLatch(this.threadcount);
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.threadcount; ++i) {
            TestThread t = new TestThread();
            t.setName("tomcat-pool-" + i);
            t.d = this.datasource;
            t.start();
        }
        this.latch.await();
        long delta = System.currentTimeMillis() - start;
        System.out.println("[testPoolThreads20Connections10Fair]Test complete:" + delta + " ms. Iterations:" + this.threadcount * this.iterations);
        this.tearDown();
    }

    public void testDBCPThreads10Connections10Validate() throws Exception {
        this.init();
        this.datasource.getPoolProperties().setMaxActive(10);
        this.datasource.getPoolProperties().setTestOnBorrow(true);
        this.threadcount = 10;
        this.transferProperties();
        this.tDatasource.getConnection().close();
        this.latch = new CountDownLatch(this.threadcount);
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.threadcount; ++i) {
            TestThread t = new TestThread();
            t.setName("tomcat-dbcp-validate-" + i);
            t.d = this.tDatasource;
            t.start();
        }
        this.latch.await();
        long delta = System.currentTimeMillis() - start;
        System.out.println("[testDBCPThreads10Connections10Validate]Test complete:" + delta + " ms. Iterations:" + this.threadcount * this.iterations);
        this.tearDown();
    }

    public void testPoolThreads10Connections10Validate() throws Exception {
        this.init();
        this.datasource.getPoolProperties().setMaxActive(10);
        this.datasource.getPoolProperties().setTestOnBorrow(true);
        this.datasource.getPoolProperties().setFairQueue(false);
        this.threadcount = 10;
        this.transferProperties();
        this.datasource.getConnection().close();
        this.latch = new CountDownLatch(this.threadcount);
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.threadcount; ++i) {
            TestThread t = new TestThread();
            t.setName("tomcat-pool-validate-" + i);
            t.d = this.datasource;
            t.start();
        }
        this.latch.await();
        long delta = System.currentTimeMillis() - start;
        System.out.println("[testPoolThreads10Connections10Validate]Test complete:" + delta + " ms. Iterations:" + this.threadcount * this.iterations);
        this.tearDown();
    }

    public void testPoolThreads10Connections10ValidateFair() throws Exception {
        this.init();
        this.datasource.getPoolProperties().setMaxActive(10);
        this.datasource.getPoolProperties().setTestOnBorrow(true);
        this.datasource.getPoolProperties().setFairQueue(true);
        this.threadcount = 10;
        this.transferProperties();
        this.datasource.getConnection().close();
        this.latch = new CountDownLatch(this.threadcount);
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.threadcount; ++i) {
            TestThread t = new TestThread();
            t.setName("tomcat-pool-validate-" + i);
            t.d = this.datasource;
            t.start();
        }
        this.latch.await();
        long delta = System.currentTimeMillis() - start;
        System.out.println("[testPoolThreads10Connections10ValidateFair]Test complete:" + delta + " ms. Iterations:" + this.threadcount * this.iterations);
        this.tearDown();
    }

    public void testDBCPThreads20Connections10Validate() throws Exception {
        this.init();
        this.datasource.getPoolProperties().setMaxActive(10);
        this.datasource.getPoolProperties().setTestOnBorrow(true);
        this.threadcount = 20;
        this.transferProperties();
        this.tDatasource.getConnection().close();
        this.latch = new CountDownLatch(this.threadcount);
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.threadcount; ++i) {
            TestThread t = new TestThread();
            t.setName("tomcat-dbcp-validate-" + i);
            t.d = this.tDatasource;
            t.start();
        }
        this.latch.await();
        long delta = System.currentTimeMillis() - start;
        System.out.println("[testDBCPThreads20Connections10Validate]Test complete:" + delta + " ms. Iterations:" + this.threadcount * this.iterations);
        this.tearDown();
    }

    public void testPoolThreads10Connections20Validate() throws Exception {
        this.init();
        this.datasource.getPoolProperties().setMaxActive(10);
        this.datasource.getPoolProperties().setTestOnBorrow(true);
        this.datasource.getPoolProperties().setFairQueue(false);
        this.threadcount = 20;
        this.transferProperties();
        this.datasource.getConnection().close();
        this.latch = new CountDownLatch(this.threadcount);
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.threadcount; ++i) {
            TestThread t = new TestThread();
            t.setName("tomcat-pool-validate-" + i);
            t.d = this.datasource;
            t.start();
        }
        this.latch.await();
        long delta = System.currentTimeMillis() - start;
        System.out.println("[testPoolThreads20Connections10Validate]Test complete:" + delta + " ms. Iterations:" + this.threadcount * this.iterations);
        this.tearDown();
    }

    public void testPoolThreads10Connections20ValidateFair() throws Exception {
        this.init();
        this.datasource.getPoolProperties().setMaxActive(10);
        this.datasource.getPoolProperties().setTestOnBorrow(true);
        this.datasource.getPoolProperties().setFairQueue(true);
        this.threadcount = 20;
        this.transferProperties();
        this.datasource.getConnection().close();
        this.latch = new CountDownLatch(this.threadcount);
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.threadcount; ++i) {
            TestThread t = new TestThread();
            t.setName("tomcat-pool-validate-" + i);
            t.d = this.datasource;
            t.start();
        }
        this.latch.await();
        long delta = System.currentTimeMillis() - start;
        System.out.println("[testPoolThreads20Connections10ValidateFair]Test complete:" + delta + " ms. Iterations:" + this.threadcount * this.iterations);
        this.tearDown();
    }

    public class TestThread
    extends Thread {
        protected DataSource d;
        protected String query = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long max = -1L;
            long totalmax = 0L;
            long totalcmax = 0L;
            long cmax = -1L;
            long nroffetch = 0L;
            long totalruntime = 0L;
            try {
                for (int i = 0; i < CheckOutThreadTest.this.iterations; ++i) {
                    long start = System.nanoTime();
                    Connection con = null;
                    try {
                        con = this.d.getConnection();
                        long delta = System.nanoTime() - start;
                        totalmax += delta;
                        max = Math.max(delta, max);
                        ++nroffetch;
                        if (this.query != null) {
                            Statement st = con.createStatement();
                            ResultSet rs = st.executeQuery(this.query);
                            while (rs.next()) {
                            }
                            rs.close();
                            st.close();
                        }
                    }
                    finally {
                        long cstart = System.nanoTime();
                        if (con != null) {
                            try {
                                con.close();
                            }
                            catch (Exception x) {
                                x.printStackTrace();
                            }
                        }
                        long cdelta = System.nanoTime() - cstart;
                        totalcmax += cdelta;
                        cmax = Math.max(cdelta, cmax);
                    }
                    totalruntime += System.nanoTime() - start;
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            finally {
                CheckOutThreadTest.this.latch.countDown();
            }
            if (System.getProperty("print-thread-stats") != null) {
                System.out.println("[" + this.getName() + "] " + "\n\tMax time to retrieve connection:" + (float)max / 1000.0f / 1000.0f + " ms." + "\n\tTotal time to retrieve connection:" + (float)totalmax / 1000.0f / 1000.0f + " ms." + "\n\tAverage time to retrieve connection:" + (float)totalmax / 1000.0f / 1000.0f / (float)nroffetch + " ms." + "\n\tMax time to close connection:" + (float)cmax / 1000.0f / 1000.0f + " ms." + "\n\tTotal time to close connection:" + (float)totalcmax / 1000.0f / 1000.0f + " ms." + "\n\tAverage time to close connection:" + (float)totalcmax / 1000.0f / 1000.0f / (float)nroffetch + " ms." + "\n\tRun time:" + (float)totalruntime / 1000.0f / 1000.0f + " ms." + "\n\tNr of fetch:" + nroffetch);
            }
        }
    }
}

