/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jdbc.test;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Random;
import org.apache.tomcat.jdbc.pool.interceptor.ResetAbandonedTimer;
import org.apache.tomcat.jdbc.test.DefaultTestCase;

public class CreateTestTable
extends DefaultTestCase {
    public static volatile boolean recreate = Boolean.getBoolean("recreate");
    public static Random random = new Random(System.currentTimeMillis());

    public CreateTestTable(String name) {
        super(name);
    }

    public void testCreateTestTable() throws Exception {
        this.init();
        Connection con = this.datasource.getConnection();
        Statement st = con.createStatement();
        try {
            st.execute("create table test(id int not null, val1 varchar(255), val2 varchar(255), val3 varchar(255), val4 varchar(255))");
        }
        catch (Exception exception) {
            // empty catch block
        }
        st.close();
        con.close();
    }

    public int testCheckData() throws Exception {
        int count = 0;
        String check = "select count (*) from test";
        this.init();
        Connection con = this.datasource.getConnection();
        Statement st = con.createStatement();
        try {
            ResultSet rs = st.executeQuery(check);
            if (rs.next()) {
                count = rs.getInt(1);
            }
            System.out.println("Count:" + count);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        return count;
    }

    public void testPopulateData() throws Exception {
        this.init();
        this.datasource.setJdbcInterceptors(ResetAbandonedTimer.class.getName());
        String insert = "insert into test values (?,?,?,?,?)";
        this.init();
        this.datasource.setRemoveAbandoned(false);
        Connection con = this.datasource.getConnection();
        if (recreate) {
            Statement st = con.createStatement();
            try {
                st.execute("drop table test");
            }
            catch (Exception ignore) {
                // empty catch block
            }
            st.execute("create table test(id int not null, val1 varchar(255), val2 varchar(255), val3 varchar(255), val4 varchar(255))");
            st.close();
        }
        PreparedStatement ps = con.prepareStatement(insert);
        ps.setQueryTimeout(0);
        for (int i = this.testCheckData(); i < 100000; ++i) {
            ps.setInt(1, i);
            String s = CreateTestTable.getRandom();
            ps.setString(2, s);
            ps.setString(3, s);
            ps.setString(4, s);
            ps.setString(5, s);
            ps.addBatch();
            ps.clearParameters();
            if ((i + 1) % 1000 == 0) {
                System.out.print(".");
            }
            if ((i + 1) % 10000 != 0) continue;
            System.out.print("\n" + (i + 1));
            ps.executeBatch();
            ps.close();
            ps = con.prepareStatement(insert);
            ps.setQueryTimeout(0);
        }
        ps.close();
        con.close();
    }

    public static String getRandom() {
        StringBuilder s = new StringBuilder(256);
        for (int i = 0; i < 254; ++i) {
            int b = Math.abs(random.nextInt() % 29);
            char c = (char)(b + 65);
            s.append(c);
        }
        return s.toString();
    }

    public static void main(String[] args) throws Exception {
        recreate = true;
        CreateTestTable test = new CreateTestTable("CreateTestTable");
        test.testPopulateData();
    }
}

