/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jdbc.test;

import java.lang.reflect.Method;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.tomcat.dbcp.dbcp.BasicDataSource;
import org.apache.tomcat.dbcp.dbcp.BasicDataSourceFactory;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;
import org.apache.tomcat.jdbc.test.DefaultProperties;

public class DefaultTestCase
extends TestCase {
    protected DataSource datasource;
    protected BasicDataSource tDatasource;
    protected int threadcount = 10;
    protected int iterations = 100000;
    private static final String PROP_DEFAULTAUTOCOMMIT = "defaultAutoCommit";
    private static final String PROP_DEFAULTREADONLY = "defaultReadOnly";
    private static final String PROP_DEFAULTTRANSACTIONISOLATION = "defaultTransactionIsolation";
    private static final String PROP_DEFAULTCATALOG = "defaultCatalog";
    private static final String PROP_DRIVERCLASSNAME = "driverClassName";
    private static final String PROP_MAXACTIVE = "maxActive";
    private static final String PROP_MAXIDLE = "maxIdle";
    private static final String PROP_MINIDLE = "minIdle";
    private static final String PROP_INITIALSIZE = "initialSize";
    private static final String PROP_MAXWAIT = "maxWait";
    private static final String PROP_TESTONBORROW = "testOnBorrow";
    private static final String PROP_TESTONRETURN = "testOnReturn";
    private static final String PROP_TIMEBETWEENEVICTIONRUNSMILLIS = "timeBetweenEvictionRunsMillis";
    private static final String PROP_NUMTESTSPEREVICTIONRUN = "numTestsPerEvictionRun";
    private static final String PROP_MINEVICTABLEIDLETIMEMILLIS = "minEvictableIdleTimeMillis";
    private static final String PROP_TESTWHILEIDLE = "testWhileIdle";
    private static final String PROP_PASSWORD = "password";
    private static final String PROP_URL = "url";
    private static final String PROP_USERNAME = "username";
    private static final String PROP_VALIDATIONQUERY = "validationQuery";
    private static final String PROP_ACCESSTOUNDERLYINGCONNECTIONALLOWED = "accessToUnderlyingConnectionAllowed";
    private static final String PROP_REMOVEABANDONED = "removeAbandoned";
    private static final String PROP_REMOVEABANDONEDTIMEOUT = "removeAbandonedTimeout";
    private static final String PROP_LOGABANDONED = "logAbandoned";
    private static final String PROP_POOLPREPAREDSTATEMENTS = "poolPreparedStatements";
    private static final String PROP_MAXOPENPREPAREDSTATEMENTS = "maxOpenPreparedStatements";
    private static final String PROP_CONNECTIONPROPERTIES = "connectionProperties";
    private static final String[] ALL_PROPERTIES = new String[]{"defaultAutoCommit", "defaultReadOnly", "defaultTransactionIsolation", "defaultCatalog", "driverClassName", "maxActive", "maxIdle", "minIdle", "initialSize", "maxWait", "testOnBorrow", "testOnReturn", "timeBetweenEvictionRunsMillis", "numTestsPerEvictionRun", "minEvictableIdleTimeMillis", "testWhileIdle", "password", "url", "username", "validationQuery", "accessToUnderlyingConnectionAllowed", "removeAbandoned", "removeAbandonedTimeout", "logAbandoned", "connectionProperties"};

    public DefaultTestCase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.init();
    }

    public DataSource createDefaultDataSource() {
        DataSource datasource = null;
        DefaultProperties p = new DefaultProperties();
        p.setFairQueue(false);
        p.setJmxEnabled(false);
        p.setTestWhileIdle(false);
        p.setTestOnBorrow(false);
        p.setTestOnReturn(false);
        p.setValidationInterval(30000L);
        p.setTimeBetweenEvictionRunsMillis(30000);
        p.setMaxActive(this.threadcount);
        p.setInitialSize(this.threadcount);
        p.setMaxWait(10000);
        p.setRemoveAbandonedTimeout(10);
        p.setMinEvictableIdleTimeMillis(10000);
        p.setMinIdle(this.threadcount);
        p.setLogAbandoned(false);
        p.setRemoveAbandoned(false);
        datasource = new DataSource();
        datasource.setPoolProperties((PoolConfiguration)p);
        return datasource;
    }

    protected void init() throws Exception {
        this.datasource = this.createDefaultDataSource();
    }

    protected void transferProperties() {
        try {
            Properties p = new Properties();
            for (int i = 0; i < ALL_PROPERTIES.length; ++i) {
                Object value;
                String name = "get" + Character.toUpperCase(ALL_PROPERTIES[i].charAt(0)) + ALL_PROPERTIES[i].substring(1);
                String bname = "is" + name.substring(3);
                Method get = null;
                try {
                    get = PoolProperties.class.getMethod(name, new Class[0]);
                }
                catch (NoSuchMethodException x) {
                    try {
                        get = PoolProperties.class.getMethod(bname, new Class[0]);
                    }
                    catch (NoSuchMethodException x2) {
                        System.err.println(x2.getMessage());
                    }
                }
                if (get == null || (value = get.invoke((Object)this.datasource.getPoolProperties(), new Object[0])) == null) continue;
                p.setProperty(ALL_PROPERTIES[i], value.toString());
            }
            this.tDatasource = (BasicDataSource)BasicDataSourceFactory.createDataSource((Properties)p);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    protected void transferPropertiesToC3P0() throws Exception {
    }

    protected void tearDown() throws Exception {
        try {
            this.datasource.close();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            this.tDatasource.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.datasource = null;
        this.tDatasource = null;
        System.gc();
    }
}

