/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jdbc.test;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.tomcat.jdbc.pool.DataSourceProxy;
import org.apache.tomcat.jdbc.test.DefaultTestCase;

public class FairnessTest
extends DefaultTestCase {
    protected boolean run = true;
    protected long sleep = Long.getLong("sleep", 10L);
    protected long complete = Long.getLong("complete", 20000L);
    protected boolean printthread = Boolean.getBoolean("printthread");
    CountDownLatch latch = null;

    public FairnessTest(String name) {
        super(name);
    }

    protected void printThreadResults(TestThread[] threads, String name, int active, int expected) {
        long minfetch = Long.MAX_VALUE;
        long maxfetch = Long.MIN_VALUE;
        long totalfetch = 0L;
        long maxwait = 0L;
        long minwait = Long.MAX_VALUE;
        long averagewait = 0L;
        long totalwait = 0L;
        float avgfetch = 0.0f;
        for (int i = 0; i < threads.length; ++i) {
            TestThread t = threads[i];
            totalfetch += t.nroffetch;
            totalwait += t.totalwait;
            maxwait = Math.max(maxwait, t.maxwait);
            minwait = Math.min(minwait, t.minwait);
            minfetch = Math.min(minfetch, t.nroffetch);
            maxfetch = Math.max(maxfetch, t.nroffetch);
            if (!this.printthread) continue;
            System.out.println(t.getName() + " : Nr-of-fetch:" + t.nroffetch + " Max fetch Time:" + (float)t.maxwait / 1000000.0f + "ms. :Max close time:" + (float)t.cmax / 1000000.0f + "ms.");
        }
        System.out.println("[" + name + "] Max fetch:" + maxfetch + " Min fetch:" + minfetch + " Average fetch:" + (float)totalfetch / (float)threads.length);
        System.out.println("[" + name + "] Max wait:" + (float)maxwait / 1000000.0f + "ms. Min wait:" + (float)minwait / 1000000.0f + "ms. Average wait:" + (float)totalwait / (float)totalfetch / 1000000.0f + " ms.");
        System.out.println("[" + name + "] Max active:" + active + " Expected Active:" + expected);
    }

    public void testDBCPThreads20Connections10() throws Exception {
        int i;
        System.out.println("[testDBCPThreads20Connections10] Starting fairness - DBCP");
        this.init();
        this.datasource.getPoolProperties().setMaxActive(10);
        this.threadcount = 20;
        this.transferProperties();
        this.tDatasource.getConnection().close();
        this.latch = new CountDownLatch(this.threadcount);
        long start = System.currentTimeMillis();
        TestThread[] threads = new TestThread[this.threadcount];
        for (i = 0; i < this.threadcount; ++i) {
            threads[i] = new TestThread();
            threads[i].setName("tomcat-dbcp-" + i);
            threads[i].d = this.tDatasource;
        }
        for (i = 0; i < this.threadcount; ++i) {
            threads[i].start();
        }
        if (!this.latch.await(this.complete + 1000L, TimeUnit.MILLISECONDS)) {
            System.out.println("Latch timed out.");
        }
        this.run = false;
        long delta = System.currentTimeMillis() - start;
        this.printThreadResults(threads, "testDBCPThreads20Connections10", this.tDatasource.getNumActive(), 10);
        this.tearDown();
    }

    public void testPoolThreads20Connections10() throws Exception {
        int i;
        System.out.println("[testPoolThreads20Connections10] Starting fairness - Tomcat JDBC - Non Fair");
        this.init();
        this.datasource.getPoolProperties().setMaxActive(10);
        this.datasource.getPoolProperties().setFairQueue(false);
        this.threadcount = 20;
        this.transferProperties();
        this.datasource.getConnection().close();
        this.latch = new CountDownLatch(this.threadcount);
        long start = System.currentTimeMillis();
        TestThread[] threads = new TestThread[this.threadcount];
        for (i = 0; i < this.threadcount; ++i) {
            threads[i] = new TestThread();
            threads[i].setName("tomcat-pool-" + i);
            threads[i].d = this.datasource;
        }
        for (i = 0; i < this.threadcount; ++i) {
            threads[i].start();
        }
        if (!this.latch.await(this.complete + 1000L, TimeUnit.MILLISECONDS)) {
            System.out.println("Latch timed out.");
        }
        this.run = false;
        long delta = System.currentTimeMillis() - start;
        this.printThreadResults(threads, "testPoolThreads20Connections10", this.datasource.getSize(), 10);
        this.tearDown();
    }

    public void testPoolThreads20Connections10Fair() throws Exception {
        int i;
        System.out.println("[testPoolThreads20Connections10Fair] Starting fairness - Tomcat JDBC - Fair");
        this.init();
        this.datasource.getPoolProperties().setMaxActive(10);
        this.datasource.getPoolProperties().setFairQueue(true);
        this.threadcount = 20;
        this.transferProperties();
        this.datasource.getConnection().close();
        this.latch = new CountDownLatch(this.threadcount);
        long start = System.currentTimeMillis();
        TestThread[] threads = new TestThread[this.threadcount];
        for (i = 0; i < this.threadcount; ++i) {
            threads[i] = new TestThread();
            threads[i].setName("tomcat-pool-" + i);
            threads[i].d = this.datasource;
        }
        for (i = 0; i < this.threadcount; ++i) {
            threads[i].start();
        }
        if (!this.latch.await(this.complete + 1000L, TimeUnit.MILLISECONDS)) {
            System.out.println("Latch timed out.");
        }
        this.run = false;
        long delta = System.currentTimeMillis() - start;
        this.printThreadResults(threads, "testPoolThreads20Connections10Fair", this.datasource.getSize(), 10);
        this.tearDown();
    }

    public void testPoolThreads20Connections10FairAsync() throws Exception {
        int i;
        System.out.println("[testPoolThreads20Connections10FairAsync] Starting fairness - Tomcat JDBC - Fair - Async");
        this.init();
        this.datasource.getPoolProperties().setMaxActive(10);
        this.datasource.getPoolProperties().setFairQueue(true);
        this.threadcount = 20;
        this.transferProperties();
        this.datasource.getConnection().close();
        this.latch = new CountDownLatch(this.threadcount);
        long start = System.currentTimeMillis();
        TestThread[] threads = new TestThread[this.threadcount];
        for (i = 0; i < this.threadcount; ++i) {
            threads[i] = new TestThread();
            threads[i].setName("tomcat-pool-" + i);
            threads[i].async = true;
            threads[i].d = this.datasource;
        }
        for (i = 0; i < this.threadcount; ++i) {
            threads[i].start();
        }
        if (!this.latch.await(this.complete + 1000L, TimeUnit.MILLISECONDS)) {
            System.out.println("Latch timed out.");
        }
        this.run = false;
        long delta = System.currentTimeMillis() - start;
        this.printThreadResults(threads, "testPoolThreads20Connections10FairAsync", this.datasource.getSize(), 10);
        this.tearDown();
    }

    public class TestThread
    extends Thread {
        protected DataSource d;
        protected String query = null;
        protected long sleep = 10L;
        protected boolean async = false;
        long minwait = Long.MAX_VALUE;
        long maxwait = -1L;
        long totalwait = 0L;
        long totalcmax = 0L;
        long cmax = -1L;
        long nroffetch = 0L;
        long totalruntime = 0L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                long now = System.currentTimeMillis();
                while (FairnessTest.this.run) {
                    if (System.currentTimeMillis() - now >= FairnessTest.this.complete) {
                        break;
                    }
                    long start = System.nanoTime();
                    Connection con = null;
                    try {
                        if (this.async) {
                            Future cf = ((DataSourceProxy)this.d).getConnectionAsync();
                            con = (Connection)cf.get();
                        } else {
                            con = this.d.getConnection();
                        }
                        long delta = System.nanoTime() - start;
                        this.totalwait += delta;
                        this.maxwait = Math.max(delta, this.maxwait);
                        this.minwait = Math.min(delta, this.minwait);
                        ++this.nroffetch;
                        if (this.query != null) {
                            Statement st = con.createStatement();
                            ResultSet rs = st.executeQuery(this.query);
                            while (rs.next()) {
                            }
                            rs.close();
                            st.close();
                        }
                        try {
                            if (FairnessTest.this.sleep > 0L) {
                                TestThread.sleep(FairnessTest.this.sleep);
                            }
                        }
                        catch (InterruptedException x) {
                            TestThread.interrupted();
                        }
                    }
                    finally {
                        long cstart = System.nanoTime();
                        if (con != null) {
                            try {
                                con.close();
                            }
                            catch (Exception x) {
                                x.printStackTrace();
                            }
                        }
                        long cdelta = System.nanoTime() - cstart;
                        this.totalcmax += cdelta;
                        this.cmax = Math.max(cdelta, this.cmax);
                    }
                    this.totalruntime += System.nanoTime() - start;
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            finally {
                FairnessTest.this.latch.countDown();
            }
            if (System.getProperty("print-thread-stats") != null) {
                System.out.println("[" + this.getName() + "] " + "\n\tMax time to retrieve connection:" + (float)this.maxwait / 1000.0f / 1000.0f + " ms." + "\n\tTotal time to retrieve connection:" + (float)this.totalwait / 1000.0f / 1000.0f + " ms." + "\n\tAverage time to retrieve connection:" + (float)this.totalwait / 1000.0f / 1000.0f / (float)this.nroffetch + " ms." + "\n\tMax time to close connection:" + (float)this.cmax / 1000.0f / 1000.0f + " ms." + "\n\tTotal time to close connection:" + (float)this.totalcmax / 1000.0f / 1000.0f + " ms." + "\n\tAverage time to close connection:" + (float)this.totalcmax / 1000.0f / 1000.0f / (float)this.nroffetch + " ms." + "\n\tRun time:" + (float)this.totalruntime / 1000.0f / 1000.0f + " ms." + "\n\tNr of fetch:" + this.nroffetch);
            }
        }
    }
}

