/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jdbc.test;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.tomcat.jdbc.test.DefaultTestCase;

public class StarvationTest
extends DefaultTestCase {
    public StarvationTest(String name) {
        super(name);
    }

    private void config() {
        this.datasource.getPoolProperties().setMaxActive(1);
        this.datasource.getPoolProperties().setMaxIdle(1);
        this.datasource.getPoolProperties().setInitialSize(1);
        this.datasource.getPoolProperties().setRemoveAbandoned(true);
        this.datasource.getPoolProperties().setRemoveAbandonedTimeout(5);
        this.datasource.getPoolProperties().setTimeBetweenEvictionRunsMillis(500);
        this.datasource.getPoolProperties().setMaxWait(10000);
        this.datasource.getPoolProperties().setLogAbandoned(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnectionStarvation() throws Exception {
        this.init();
        this.config();
        Connection con1 = this.datasource.getConnection();
        Connection con2 = null;
        try {
            con2 = this.datasource.getConnection();
            try {
                con2.setCatalog("mysql");
            }
            catch (SQLException x) {
                StarvationTest.assertFalse((String)("2nd Connection is not valid:" + x.getMessage()), (boolean)true);
            }
            StarvationTest.assertTrue((String)"Connection 1 should be closed.", (boolean)con1.isClosed());
        }
        catch (Exception x) {
            StarvationTest.assertFalse((String)("Connection got starved:" + x.getMessage()), (boolean)true);
        }
        finally {
            if (con2 != null) {
                con2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFairConnectionStarvation() throws Exception {
        this.init();
        this.config();
        this.datasource.getPoolProperties().setFairQueue(true);
        Connection con1 = this.datasource.getConnection();
        Connection con2 = null;
        try {
            con2 = this.datasource.getConnection();
            try {
                con2.setCatalog("mysql");
            }
            catch (SQLException x) {
                StarvationTest.assertFalse((String)("2nd Connection is not valid:" + x.getMessage()), (boolean)true);
            }
            StarvationTest.assertTrue((String)"Connection 1 should be closed.", (boolean)con1.isClosed());
        }
        catch (Exception x) {
            StarvationTest.assertFalse((String)("Connection got starved:" + x.getMessage()), (boolean)true);
        }
        finally {
            if (con2 != null) {
                con2.close();
            }
        }
    }
}

