/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jdbc.test;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.TestCase;
import org.apache.tomcat.jdbc.pool.FairBlockingQueue;

public class TestAsyncQueue
extends TestCase {
    protected FairBlockingQueue<Object> queue = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.queue = new FairBlockingQueue();
    }

    protected void tearDown() throws Exception {
        this.queue = null;
        super.tearDown();
    }

    public void testAsyncPoll1() throws Exception {
        Object item = new Object();
        this.queue.offer(item);
        Future future = this.queue.pollAsync();
        TestAsyncQueue.assertEquals(future.get(), (Object)item);
    }

    public void testAsyncPoll2() throws Exception {
        Object item = new Object();
        OfferThread thread = new OfferThread(item, 5000L);
        thread.start();
        Future future = this.queue.pollAsync();
        try {
            future.get(2000L, TimeUnit.MILLISECONDS);
            TestAsyncQueue.assertFalse((String)"Request should have timed out", (boolean)true);
        }
        catch (TimeoutException x) {
            TestAsyncQueue.assertTrue((String)"Request timed out properly", (boolean)true);
        }
        catch (Exception x) {
            TestAsyncQueue.assertTrue((String)"Request threw an error", (boolean)false);
            x.printStackTrace();
        }
        TestAsyncQueue.assertEquals(future.get(), (Object)item);
    }

    protected class OfferThread
    extends Thread {
        Object item = null;
        long delay = 5000L;
        volatile boolean offered = false;

        public OfferThread(Object i, long d) {
            this.item = i;
            this.delay = d;
            this.setDaemon(false);
            this.setName(TestAsyncQueue.class.getName() + "-OfferThread");
        }

        public void run() {
            try {
                OfferThread.sleep(this.delay);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.offered = true;
            TestAsyncQueue.this.queue.offer(this.item);
        }
    }
}

