/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jdbc.test;

import java.sql.Connection;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.test.DefaultTestCase;
import org.apache.tomcat.jdbc.test.driver.Driver;

public class TestConcurrency
extends DefaultTestCase {
    public static final boolean debug = Boolean.getBoolean("jdbc.debug");
    protected volatile DataSource ds = null;

    public TestConcurrency(String name) {
        super(name);
    }

    public void setUp() {
        this.ds = this.createDefaultDataSource();
        this.ds.getPoolProperties().setDriverClassName(Driver.class.getName());
        this.ds.getPoolProperties().setUrl("jdbc:tomcat:test");
        this.ds.getPoolProperties().setInitialSize(0);
        this.ds.getPoolProperties().setMaxIdle(0);
        this.ds.getPoolProperties().setMinIdle(0);
        this.ds.getPoolProperties().setMaxActive(10);
        this.ds.getPoolProperties().setRemoveAbandoned(true);
        this.ds.getPoolProperties().setLogAbandoned(true);
        this.ds.getPoolProperties().setTestWhileIdle(true);
        this.ds.getPoolProperties().setMinEvictableIdleTimeMillis(750);
        this.ds.getPoolProperties().setTimeBetweenEvictionRunsMillis(25);
        this.ds.setFairQueue(true);
    }

    protected void tearDown() throws Exception {
        this.ds.close(true);
        Driver.reset();
        super.tearDown();
    }

    public void testSimple() throws Exception {
        int i;
        this.ds.getConnection().close();
        int iter = 10000;
        final AtomicInteger loopcount = new AtomicInteger(0);
        Runnable run = new Runnable(){

            public void run() {
                try {
                    while (loopcount.incrementAndGet() < 10000) {
                        Connection con = TestConcurrency.this.ds.getConnection();
                        Thread.sleep(10L);
                        con.close();
                    }
                }
                catch (Exception x) {
                    loopcount.set(10000);
                    x.printStackTrace();
                }
            }
        };
        Thread[] threads = new Thread[20];
        for (i = 0; i < threads.length; ++i) {
            threads[i] = new Thread(run);
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].start();
        }
        try {
            while (loopcount.get() < 10000) {
                TestConcurrency.assertTrue((String)"Size comparison(less than 11):", (this.ds.getPool().getSize() <= 10 ? 1 : 0) != 0);
                if (debug) {
                    System.out.println("Size: " + this.ds.getPool().getSize());
                    System.out.println("Used: " + this.ds.getPool().getActive());
                    System.out.println("Idle: " + this.ds.getPool().getIdle());
                    System.out.println("Wait: " + this.ds.getPool().getWaitCount());
                }
                Thread.sleep(250L);
            }
        }
        catch (Exception x) {
            loopcount.set(10000);
            x.printStackTrace();
        }
        for (int i2 = 0; i2 < threads.length; ++i2) {
            threads[i2].join();
        }
        TestConcurrency.assertEquals((String)"Size comparison:", (int)10, (int)this.ds.getPool().getSize());
        TestConcurrency.assertEquals((String)"Idle comparison:", (int)10, (int)this.ds.getPool().getIdle());
        TestConcurrency.assertEquals((String)"Used comparison:", (int)0, (int)this.ds.getPool().getActive());
        TestConcurrency.assertEquals((String)"Connect count", (int)10, (int)Driver.connectCount.get());
    }

    public void testBrutal() throws Exception {
        int i;
        this.ds.getPoolProperties().setRemoveAbandoned(false);
        this.ds.getPoolProperties().setRemoveAbandonedTimeout(1);
        this.ds.getPoolProperties().setMinEvictableIdleTimeMillis(100);
        this.ds.getPoolProperties().setTimeBetweenEvictionRunsMillis(10);
        this.ds.getConnection().close();
        int iter = 1000000;
        final AtomicInteger loopcount = new AtomicInteger(0);
        Runnable run = new Runnable(){

            public void run() {
                try {
                    while (loopcount.incrementAndGet() < 1000000) {
                        Connection con = TestConcurrency.this.ds.getConnection();
                        con.close();
                    }
                }
                catch (Exception x) {
                    loopcount.set(1000000);
                    x.printStackTrace();
                }
            }
        };
        Thread[] threads = new Thread[20];
        for (i = 0; i < threads.length; ++i) {
            threads[i] = new Thread(run);
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].start();
        }
        try {
            while (loopcount.get() < 1000000) {
                TestConcurrency.assertTrue((String)"Size comparison(less than 11):", (this.ds.getPool().getSize() <= 10 ? 1 : 0) != 0);
                this.ds.getPool().testAllIdle();
                this.ds.getPool().checkAbandoned();
                this.ds.getPool().checkIdle();
            }
        }
        catch (Exception x) {
            loopcount.set(1000000);
            x.printStackTrace();
        }
        for (int i2 = 0; i2 < threads.length; ++i2) {
            threads[i2].join();
        }
        System.out.println("Connect count:" + Driver.connectCount.get());
        System.out.println("DisConnect count:" + Driver.disconnectCount.get());
        TestConcurrency.assertEquals((String)"Size comparison:", (int)10, (int)this.ds.getPool().getSize());
        TestConcurrency.assertEquals((String)"Idle comparison:", (int)10, (int)this.ds.getPool().getIdle());
        TestConcurrency.assertEquals((String)"Used comparison:", (int)0, (int)this.ds.getPool().getActive());
        TestConcurrency.assertEquals((String)"Connect count", (int)10, (int)Driver.connectCount.get());
    }

    public void testBrutalNonFair() throws Exception {
        int i;
        this.ds.getPoolProperties().setRemoveAbandoned(false);
        this.ds.getPoolProperties().setRemoveAbandonedTimeout(1);
        this.ds.getPoolProperties().setMinEvictableIdleTimeMillis(100);
        this.ds.getPoolProperties().setTimeBetweenEvictionRunsMillis(10);
        this.ds.getConnection().close();
        int iter = 1000000;
        final AtomicInteger loopcount = new AtomicInteger(0);
        Runnable run = new Runnable(){

            public void run() {
                try {
                    while (loopcount.incrementAndGet() < 1000000) {
                        Connection con = TestConcurrency.this.ds.getConnection();
                        con.close();
                    }
                }
                catch (Exception x) {
                    loopcount.set(1000000);
                    x.printStackTrace();
                }
            }
        };
        Thread[] threads = new Thread[20];
        for (i = 0; i < threads.length; ++i) {
            threads[i] = new Thread(run);
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].start();
        }
        try {
            while (loopcount.get() < 1000000) {
                TestConcurrency.assertTrue((String)"Size comparison(less than 11):", (this.ds.getPool().getSize() <= 10 ? 1 : 0) != 0);
                this.ds.getPool().testAllIdle();
                this.ds.getPool().checkAbandoned();
                this.ds.getPool().checkIdle();
            }
        }
        catch (Exception x) {
            loopcount.set(1000000);
            x.printStackTrace();
        }
        for (int i2 = 0; i2 < threads.length; ++i2) {
            threads[i2].join();
        }
        System.out.println("Connect count:" + Driver.connectCount.get());
        System.out.println("DisConnect count:" + Driver.disconnectCount.get());
        TestConcurrency.assertEquals((String)"Size comparison:", (int)10, (int)this.ds.getPool().getSize());
        TestConcurrency.assertEquals((String)"Idle comparison:", (int)10, (int)this.ds.getPool().getIdle());
        TestConcurrency.assertEquals((String)"Used comparison:", (int)0, (int)this.ds.getPool().getActive());
        TestConcurrency.assertEquals((String)"Connect count", (int)10, (int)Driver.connectCount.get());
    }
}

