/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jdbc.test;

import java.sql.Connection;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.interceptor.ConnectionState;
import org.apache.tomcat.jdbc.test.DefaultTestCase;

public class TestConnectionState
extends DefaultTestCase {
    public TestConnectionState(String name) {
        super(name);
    }

    public void testAutoCommitFalse() throws Exception {
        DataSource d1 = this.createDefaultDataSource();
        d1.setMaxActive(1);
        d1.setMinIdle(1);
        d1.setMaxIdle(1);
        d1.setJdbcInterceptors(ConnectionState.class.getName());
        d1.setDefaultAutoCommit(Boolean.FALSE);
        Connection c1 = d1.getConnection();
        TestConnectionState.assertFalse((String)"Auto commit should be false", (boolean)c1.getAutoCommit());
        c1.setAutoCommit(true);
        TestConnectionState.assertTrue((String)"Auto commit should be true", (boolean)c1.getAutoCommit());
        c1.close();
        c1 = d1.getConnection();
        TestConnectionState.assertFalse((String)"Auto commit should be false for a reused connection", (boolean)c1.getAutoCommit());
        d1.close(true);
        TestConnectionState.assertTrue((String)"Connection should be closed", (boolean)c1.isClosed());
    }

    public void testAutoCommitTrue() throws Exception {
        DataSource d1 = this.createDefaultDataSource();
        d1.setMaxActive(1);
        d1.setJdbcInterceptors(ConnectionState.class.getName());
        d1.setDefaultAutoCommit(Boolean.TRUE);
        d1.setMinIdle(1);
        Connection c1 = d1.getConnection();
        TestConnectionState.assertTrue((String)"Auto commit should be true", (boolean)c1.getAutoCommit());
        c1.setAutoCommit(false);
        TestConnectionState.assertFalse((String)"Auto commit should be false", (boolean)c1.getAutoCommit());
        c1.close();
        c1 = d1.getConnection();
        TestConnectionState.assertTrue((String)"Auto commit should be true for a reused connection", (boolean)c1.getAutoCommit());
    }

    public void testDefaultCatalog() throws Exception {
        DataSource d1 = this.createDefaultDataSource();
        d1.setMaxActive(1);
        d1.setJdbcInterceptors(ConnectionState.class.getName());
        d1.setDefaultCatalog("information_schema");
        d1.setMinIdle(1);
        Connection c1 = d1.getConnection();
        TestConnectionState.assertEquals((String)"Catalog should be information_schema", (String)c1.getCatalog(), (String)"information_schema");
        c1.close();
        c1 = d1.getConnection();
        TestConnectionState.assertEquals((String)"Catalog should be information_schema", (String)c1.getCatalog(), (String)"information_schema");
        c1.setCatalog("mysql");
        TestConnectionState.assertEquals((String)"Catalog should be information_schema", (String)c1.getCatalog(), (String)"mysql");
        c1.close();
        c1 = d1.getConnection();
        TestConnectionState.assertEquals((String)"Catalog should be information_schema", (String)c1.getCatalog(), (String)"information_schema");
    }
}

