/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jdbc.test;

import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.AttributeChangeNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import org.apache.tomcat.jdbc.pool.ConnectionPool;
import org.apache.tomcat.jdbc.pool.interceptor.SlowQueryReport;
import org.apache.tomcat.jdbc.pool.interceptor.SlowQueryReportJmx;
import org.apache.tomcat.jdbc.test.DefaultTestCase;

public class TestSlowQueryReport
extends DefaultTestCase {
    public TestSlowQueryReport(String name) {
        super(name);
    }

    public void testSlowSql() throws Exception {
        ResultSet rs;
        PreparedStatement st;
        int i;
        int count = 3;
        this.init();
        this.datasource.setMaxActive(1);
        this.datasource.setJdbcInterceptors(SlowQueryReport.class.getName() + "(threshold=50)");
        Connection con = this.datasource.getConnection();
        String slowSql = "select count(1) from test where val1 like 'ewq%eq' and val2 = 'ew%rre' and val3 = 'sda%da' and val4 = 'dad%ada'";
        for (int i2 = 0; i2 < count; ++i2) {
            Statement st2 = con.createStatement();
            ResultSet rs2 = st2.executeQuery(slowSql);
            rs2.close();
            st2.close();
        }
        ConcurrentHashMap map = SlowQueryReport.getPoolStats((String)this.datasource.getPool().getName());
        TestSlowQueryReport.assertNotNull((Object)map);
        TestSlowQueryReport.assertEquals((int)1, (int)map.size());
        String key = (String)map.keySet().iterator().next();
        SlowQueryReport.QueryStats stats = (SlowQueryReport.QueryStats)map.get(key);
        System.out.println("Stats:" + stats);
        for (i = 0; i < count; ++i) {
            st = con.prepareStatement(slowSql);
            rs = st.executeQuery();
            rs.close();
            st.close();
        }
        System.out.println("Stats:" + stats);
        for (i = 0; i < count; ++i) {
            st = con.prepareCall(slowSql);
            rs = st.executeQuery();
            rs.close();
            st.close();
        }
        System.out.println("Stats:" + stats);
        ConnectionPool pool = this.datasource.getPool();
        con.close();
        this.tearDown();
        TestSlowQueryReport.assertNull((Object)SlowQueryReport.getPoolStats((String)pool.getName()));
    }

    public void testSlowSqlJmx() throws Exception {
        ResultSet rs;
        PreparedStatement st;
        int i;
        int count = 1;
        this.init();
        this.datasource.setMaxActive(1);
        this.datasource.setJdbcInterceptors(SlowQueryReportJmx.class.getName() + "(threshold=50,notifyPool=false)");
        Connection con = this.datasource.getConnection();
        String slowSql = "select count(1) from test where val1 like 'ewq%eq'";
        for (int i2 = 0; i2 < count; ++i2) {
            Statement st2 = con.createStatement();
            ResultSet rs2 = st2.executeQuery(slowSql);
            rs2.close();
            st2.close();
        }
        ConcurrentHashMap map = SlowQueryReport.getPoolStats((String)this.datasource.getPool().getName());
        TestSlowQueryReport.assertNotNull((Object)map);
        TestSlowQueryReport.assertEquals((int)1, (int)map.size());
        String key = (String)map.keySet().iterator().next();
        SlowQueryReport.QueryStats stats = (SlowQueryReport.QueryStats)map.get(key);
        System.out.println("Stats:" + stats);
        ClientListener listener = new ClientListener();
        ConnectionPool pool = this.datasource.getPool();
        ManagementFactory.getPlatformMBeanServer().addNotificationListener(SlowQueryReportJmx.getObjectName(SlowQueryReportJmx.class, (String)pool.getName()), listener, null, null);
        for (i = 0; i < count; ++i) {
            st = con.prepareStatement(slowSql);
            rs = st.executeQuery();
            rs.close();
            st.close();
        }
        System.out.println("Stats:" + stats);
        for (i = 0; i < count; ++i) {
            st = con.prepareCall(slowSql);
            rs = st.executeQuery();
            rs.close();
            st.close();
        }
        System.out.println("Stats:" + stats);
        TestSlowQueryReport.assertEquals((String)("Expecting to have received " + 2 * count + " notifications."), (int)(2 * count), (int)listener.notificationCount);
        con.close();
        this.tearDown();
        TestSlowQueryReport.assertNull((Object)SlowQueryReport.getPoolStats((String)pool.getName()));
    }

    public void testFastSql() throws Exception {
        int count = 3;
        this.init();
        this.datasource.setMaxActive(1);
        this.datasource.setJdbcInterceptors(SlowQueryReport.class.getName());
        Connection con = this.datasource.getConnection();
        String fastSql = this.datasource.getValidationQuery();
        for (int i = 0; i < count; ++i) {
            Statement st = con.createStatement();
            ResultSet rs = st.executeQuery(fastSql);
            rs.close();
            st.close();
        }
        ConcurrentHashMap map = SlowQueryReport.getPoolStats((String)this.datasource.getPool().getName());
        TestSlowQueryReport.assertNotNull((Object)map);
        TestSlowQueryReport.assertEquals((int)0, (int)map.size());
        ConnectionPool pool = this.datasource.getPool();
        con.close();
        this.tearDown();
        TestSlowQueryReport.assertNull((Object)SlowQueryReport.getPoolStats((String)pool.getName()));
    }

    public void testFailedSql() throws Exception {
        int count = 3;
        this.init();
        this.datasource.setMaxActive(1);
        this.datasource.setJdbcInterceptors(SlowQueryReport.class.getName());
        Connection con = this.datasource.getConnection();
        String slowSql = "select 1 from non_existent";
        int exceptionCount = 0;
        for (int i = 0; i < count; ++i) {
            Statement st = con.createStatement();
            try {
                ResultSet rs = st.executeQuery(slowSql);
                rs.close();
            }
            catch (Exception x) {
                ++exceptionCount;
            }
            st.close();
        }
        ConcurrentHashMap map = SlowQueryReport.getPoolStats((String)this.datasource.getPool().getName());
        TestSlowQueryReport.assertNotNull((Object)map);
        TestSlowQueryReport.assertEquals((int)1, (int)map.size());
        ConnectionPool pool = this.datasource.getPool();
        String key = (String)map.keySet().iterator().next();
        SlowQueryReport.QueryStats stats = (SlowQueryReport.QueryStats)map.get(key);
        System.out.println("Stats:" + stats);
        con.close();
        this.tearDown();
        TestSlowQueryReport.assertNull((Object)SlowQueryReport.getPoolStats((String)pool.getName()));
    }

    public class ClientListener
    implements NotificationListener {
        volatile int notificationCount = 0;

        public void handleNotification(Notification notification, Object handback) {
            ++this.notificationCount;
            System.out.println("\nReceived notification:");
            System.out.println("\tClassName: " + notification.getClass().getName());
            System.out.println("\tSource: " + notification.getSource());
            System.out.println("\tType: " + notification.getType());
            System.out.println("\tMessage: " + notification.getMessage());
            if (notification instanceof AttributeChangeNotification) {
                AttributeChangeNotification acn = (AttributeChangeNotification)notification;
                System.out.println("\tAttributeName: " + acn.getAttributeName());
                System.out.println("\tAttributeType: " + acn.getAttributeType());
                System.out.println("\tNewValue: " + acn.getNewValue());
                System.out.println("\tOldValue: " + acn.getOldValue());
            }
        }
    }
}

