/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jdbc.test;

import java.sql.Connection;
import org.apache.tomcat.jdbc.pool.PooledConnection;
import org.apache.tomcat.jdbc.test.DefaultTestCase;

public class TestSuspectTimeout
extends DefaultTestCase {
    public TestSuspectTimeout(String name) {
        super(name);
    }

    public void testSuspect() throws Exception {
        this.init();
        this.datasource.setMaxActive(100);
        this.datasource.setMaxIdle(100);
        this.datasource.setInitialSize(0);
        this.datasource.getPoolProperties().setAbandonWhenPercentageFull(0);
        this.datasource.getPoolProperties().setTimeBetweenEvictionRunsMillis(100);
        this.datasource.getPoolProperties().setRemoveAbandoned(true);
        this.datasource.getPoolProperties().setRemoveAbandonedTimeout(100);
        this.datasource.getPoolProperties().setSuspectTimeout(1);
        this.datasource.getPoolProperties().setLogAbandoned(true);
        Connection con = this.datasource.getConnection();
        TestSuspectTimeout.assertEquals((String)"Number of connections active/busy should be 1", (int)1, (int)this.datasource.getPool().getActive());
        Thread.sleep(3000L);
        PooledConnection pcon = con.unwrap(PooledConnection.class);
        TestSuspectTimeout.assertTrue((String)"Connection should be marked suspect", (boolean)pcon.isSuspect());
        con.close();
    }
}

