/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jdbc.test;

import java.sql.Connection;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.test.DefaultTestCase;

public class TwoDataSources
extends DefaultTestCase {
    public TwoDataSources(String name) {
        super(name);
    }

    public void testTwoDataSources() throws Exception {
        DataSource d1 = this.createDefaultDataSource();
        DataSource d2 = this.createDefaultDataSource();
        d1.setRemoveAbandoned(true);
        d1.setRemoveAbandonedTimeout(10);
        d1.setTimeBetweenEvictionRunsMillis(1000);
        d2.setRemoveAbandoned(false);
        Connection c1 = d1.getConnection();
        Connection c2 = d2.getConnection();
        Thread.sleep(5000L);
        try {
            c1.createStatement();
            TwoDataSources.assertTrue((String)"Connection should have been abandoned.", (boolean)false);
        }
        catch (Exception x) {
            TwoDataSources.assertTrue((String)"This is correct, c1 is abandoned", (boolean)true);
        }
        try {
            c2.createStatement();
            TwoDataSources.assertTrue((String)"Connection should not have been abandoned.", (boolean)true);
        }
        catch (Exception x) {
            TwoDataSources.assertTrue((String)"Connection c2 should be working", (boolean)false);
        }
        try {
            TwoDataSources.assertTrue((String)"Connection should have been closed.", (boolean)c1.isClosed());
        }
        catch (Exception x) {
            TwoDataSources.assertTrue((String)"This is correct, c1 is closed", (boolean)true);
        }
        try {
            TwoDataSources.assertFalse((String)"Connection c2 should not have been closed.", (boolean)c2.isClosed());
        }
        catch (Exception x) {
            TwoDataSources.assertTrue((String)"Connection c2 should be working", (boolean)false);
        }
    }
}

