/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.common.enrichment;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.InjectionProcessor;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.arquillian.common.mockito.MockitoEnricher;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.WebContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.AppFinder;
import org.apache.webbeans.annotation.AnyLiteral;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.inject.OWBInjector;
import org.jboss.arquillian.test.spi.TestClass;

public final class OpenEJBEnricher {
    private static final Logger LOGGER = Logger.getLogger(OpenEJBEnricher.class.getName());

    private OpenEJBEnricher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enrich(Object testInstance, AppContext appCtx) {
        new MockitoEnricher().enrich(testInstance);
        AppContext ctx = appCtx;
        if (ctx == null && (ctx = (AppContext)AppFinder.findAppContextOrWeb((ClassLoader)Thread.currentThread().getContextClassLoader(), (AppFinder.Transformer)AppFinder.AppContextTransformer.INSTANCE)) == null) {
            return;
        }
        BeanContext context = ((ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class)).getBeanContext((Object)(ctx.getId() + "_" + testInstance.getClass().getName()));
        WebBeansContext appWBC = ctx.getWebBeansContext();
        BeanManagerImpl bm = appWBC == null ? null : appWBC.getBeanManagerImpl();
        boolean ok = false;
        for (WebContext web : ctx.getWebContexts()) {
            WebBeansContext webBeansContext = web.getWebBeansContext();
            if (webBeansContext == null) continue;
            BeanManagerImpl webAppBm = webBeansContext.getBeanManagerImpl();
            if (webBeansContext == appWBC || !webAppBm.isInUse()) continue;
            try {
                OpenEJBEnricher.doInject(testInstance, context, webAppBm);
                ok = true;
                break;
            }
            catch (Exception e) {
            }
        }
        if (bm != null && bm.isInUse() && !ok) {
            try {
                OpenEJBEnricher.doInject(testInstance, context, bm);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Failed injection on: " + testInstance.getClass(), e);
                if (RuntimeException.class.isInstance(e)) {
                    throw (RuntimeException)RuntimeException.class.cast(e);
                }
                throw new OpenEJBRuntimeException(e);
            }
        }
        if (context != null) {
            ThreadContext callContext = new ThreadContext(context, null, Operation.INJECTION);
            ThreadContext oldContext = ThreadContext.enter((ThreadContext)callContext);
            try {
                InjectionProcessor processor = new InjectionProcessor(testInstance, (Collection)context.getInjections(), context.getJndiContext());
                processor.createInstance();
            }
            catch (OpenEJBException e) {
            }
            finally {
                ThreadContext.exit((ThreadContext)oldContext);
            }
        }
    }

    private static void doInject(Object testInstance, BeanContext context, BeanManagerImpl bm) throws Exception {
        Set beans = bm.getBeans(testInstance.getClass(), new Annotation[0]);
        Bean bean = bm.resolve(beans);
        CreationalContextImpl cc = bm.createCreationalContext((Contextual)bean);
        if (context != null) {
            context.set(CreationalContext.class, (Object)cc);
        }
        OWBInjector.inject((BeanManager)bm, (Object)testInstance, (CreationalContext)cc);
    }

    private static BeanManagerImpl findBeanManager(AppContext ctx) {
        if (ctx != null) {
            if (ctx.getWebBeansContext() == null) {
                return null;
            }
            return ctx.getWebBeansContext().getBeanManagerImpl();
        }
        try {
            return WebBeansContext.currentInstance().getBeanManagerImpl();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object[] resolve(AppContext appContext, TestClass ignored, Method method) {
        Object[] values = new Object[method.getParameterTypes().length];
        if (appContext == null) {
            return values;
        }
        ArrayList<BeanManagerImpl> beanManagers = new ArrayList<BeanManagerImpl>();
        BeanManagerImpl bm = OpenEJBEnricher.findBeanManager(appContext);
        if (bm != null) {
            for (WebContext web : appContext.getWebContexts()) {
                BeanManagerImpl webAppBm;
                WebBeansContext webBeansContext = web.getWebBeansContext();
                if (webBeansContext == null || bm == (webAppBm = webBeansContext.getBeanManagerImpl())) continue;
                beanManagers.add(webAppBm);
            }
            beanManagers.add(bm);
        }
        if (beanManagers.isEmpty()) {
            return values;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Throwable ex = null;
            for (BeanManager beanManager : beanManagers) {
                try {
                    values[i] = OpenEJBEnricher.getParamInstance(beanManager, i, method);
                    break;
                }
                catch (Exception e) {
                    ex = e;
                }
            }
            if (ex == null) continue;
            LOGGER.info(ex.getMessage());
        }
        return values;
    }

    private static <T> T getParamInstance(BeanManager manager, int position, Method method) {
        CreationalContext creational = manager.createCreationalContext(null);
        return (T)manager.getInjectableReference((InjectionPoint)new MethodParamInjectionPoint(method, position, manager), creational);
    }

    private static final class ParamAnnotated
    implements AnnotatedParameter<Object> {
        private final Method method;
        private final int position;
        private final Set<Type> types = new HashSet<Type>();
        private final Set<Annotation> annotations;

        private ParamAnnotated(Method method, int position) {
            this.method = method;
            this.position = position;
            this.types.add(this.getBaseType());
            this.types.add((Type)((Object)Object.class));
            this.annotations = new HashSet<Annotation>(Arrays.asList(method.getParameterAnnotations()[position]));
        }

        public int getPosition() {
            return this.position;
        }

        public AnnotatedCallable<Object> getDeclaringCallable() {
            return null;
        }

        public Type getBaseType() {
            if (this.method.getGenericParameterTypes().length > 0) {
                return this.method.getGenericParameterTypes()[this.position];
            }
            return this.method.getParameterTypes()[this.position];
        }

        public Set<Type> getTypeClosure() {
            return this.types;
        }

        public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
            for (Annotation a : this.annotations) {
                if (!a.annotationType().getName().equals(annotationType.getName())) continue;
                return (T)a;
            }
            return null;
        }

        public Set<Annotation> getAnnotations() {
            return this.annotations;
        }

        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.getAnnotation(annotationType) != null;
        }
    }

    private static final class MethodParamInjectionPoint
    implements InjectionPoint {
        private final Method method;
        private final int position;
        private final Set<Annotation> qualifiers = new HashSet<Annotation>();

        private MethodParamInjectionPoint(Method method, int position, BeanManager beanManager) {
            this.method = method;
            this.position = position;
            for (Annotation annotation : method.getParameterAnnotations()[position]) {
                if (!beanManager.isQualifier(annotation.annotationType())) continue;
                this.qualifiers.add(annotation);
            }
            if (this.qualifiers.isEmpty()) {
                this.qualifiers.add((Annotation)DefaultLiteral.INSTANCE);
            }
            this.qualifiers.add((Annotation)AnyLiteral.INSTANCE);
        }

        public Type getType() {
            if (this.method.getGenericParameterTypes().length > 0) {
                return this.method.getGenericParameterTypes()[this.position];
            }
            return this.method.getParameterTypes()[this.position];
        }

        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }

        public Bean<?> getBean() {
            return null;
        }

        public Member getMember() {
            return this.method;
        }

        public Annotated getAnnotated() {
            return new ParamAnnotated(this.method, this.position);
        }

        public boolean isDelegate() {
            return false;
        }

        public boolean isTransient() {
            return false;
        }
    }
}

