/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.model;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.Encoded;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.MediaType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.cxf.jaxrs.ext.Oneway;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.Parameter;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;

public class OperationResourceInfo {
    private URITemplate uriTemplate;
    private ClassResourceInfo classResourceInfo;
    private Method methodToInvoke;
    private Method annotatedMethod;
    private String httpMethod;
    private List<MediaType> produceMimes;
    private List<MediaType> consumeMimes;
    private boolean encoded;
    private String defaultParamValue;
    private List<Parameter> parameters;
    private boolean oneway;
    private boolean async;
    private Set<String> nameBindings = new LinkedHashSet<String>();
    private Class<?>[] actualInParamTypes;
    private Type[] actualInGenericParamTypes;
    private Annotation[][] actualInParamAnnotations;
    private Annotation[] actualOutParamAnnotations;

    public OperationResourceInfo(Method mInvoke, ClassResourceInfo cri) {
        this(mInvoke, mInvoke, cri);
    }

    OperationResourceInfo(OperationResourceInfo ori, ClassResourceInfo cri) {
        this.uriTemplate = ori.uriTemplate;
        this.methodToInvoke = ori.methodToInvoke;
        this.annotatedMethod = ori.annotatedMethod;
        this.httpMethod = ori.httpMethod;
        this.produceMimes = ori.produceMimes;
        this.consumeMimes = ori.consumeMimes;
        this.encoded = ori.encoded;
        this.defaultParamValue = ori.defaultParamValue;
        this.parameters = ori.parameters;
        this.oneway = ori.oneway;
        this.async = ori.async;
        this.classResourceInfo = cri;
        this.nameBindings = ori.nameBindings;
        this.initActualMethodProperties();
    }

    public OperationResourceInfo(Method mInvoke, Method mAnnotated, ClassResourceInfo cri) {
        this.methodToInvoke = mInvoke;
        this.annotatedMethod = mAnnotated;
        if (mAnnotated != null) {
            this.parameters = ResourceUtils.getParameters(mAnnotated);
            this.nameBindings = AnnotationUtils.getNameBindings(mAnnotated.getAnnotations());
        }
        this.classResourceInfo = cri;
        this.checkMediaTypes(null, null);
        this.checkEncoded();
        this.checkDefaultParameterValue();
        this.checkOneway();
        this.checkSuspended();
        this.initActualMethodProperties();
    }

    public OperationResourceInfo(Method m, ClassResourceInfo cri, URITemplate template, String httpVerb, String consumeMediaTypes, String produceMediaTypes, List<Parameter> params, boolean oneway) {
        this.methodToInvoke = m;
        this.annotatedMethod = null;
        this.classResourceInfo = cri;
        this.uriTemplate = template;
        this.httpMethod = httpVerb;
        this.checkMediaTypes(consumeMediaTypes, produceMediaTypes);
        this.parameters = params;
        this.oneway = oneway;
        this.initActualMethodProperties();
    }

    private void initActualMethodProperties() {
        Method actualMethod = this.annotatedMethod == null ? this.methodToInvoke : this.annotatedMethod;
        this.actualInParamTypes = actualMethod.getParameterTypes();
        this.actualInGenericParamTypes = actualMethod.getGenericParameterTypes();
        this.actualInParamAnnotations = actualMethod.getParameterAnnotations();
        Annotation[] invokedAnns = this.methodToInvoke.getAnnotations();
        if (this.methodToInvoke != this.annotatedMethod && this.annotatedMethod != null) {
            Annotation[] superAnns = this.annotatedMethod.getAnnotations();
            if (invokedAnns.length > 0) {
                Annotation[] merged = new Annotation[superAnns.length + invokedAnns.length];
                System.arraycopy(superAnns, 0, merged, 0, superAnns.length);
                System.arraycopy(invokedAnns, 0, merged, superAnns.length, invokedAnns.length);
                this.actualOutParamAnnotations = merged;
            } else {
                this.actualOutParamAnnotations = superAnns;
            }
        } else {
            this.actualOutParamAnnotations = invokedAnns;
        }
    }

    public void addNameBindings(List<String> names) {
        this.nameBindings.addAll(names);
    }

    public Set<String> getNameBindings() {
        Set<String> criNames = this.classResourceInfo.getNameBindings();
        if (criNames.isEmpty()) {
            return this.nameBindings;
        }
        LinkedHashSet<String> all = new LinkedHashSet<String>(criNames);
        all.addAll(this.nameBindings);
        return all;
    }

    private void checkOneway() {
        if (this.annotatedMethod != null) {
            this.oneway = AnnotationUtils.getAnnotation(this.annotatedMethod.getAnnotations(), Oneway.class) != null;
        }
    }

    private void checkSuspended() {
        if (this.annotatedMethod != null) {
            for (Annotation[] anns : this.annotatedMethod.getParameterAnnotations()) {
                if (AnnotationUtils.getAnnotation(anns, Suspended.class) == null) continue;
                this.async = true;
                break;
            }
        }
    }

    public boolean isOneway() {
        return this.oneway;
    }

    public boolean isAsync() {
        return this.async;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public URITemplate getURITemplate() {
        return this.uriTemplate;
    }

    public void setURITemplate(URITemplate u) {
        this.uriTemplate = u;
    }

    public ClassResourceInfo getClassResourceInfo() {
        return this.classResourceInfo;
    }

    public Method getMethodToInvoke() {
        return this.methodToInvoke;
    }

    public Method getAnnotatedMethod() {
        return this.annotatedMethod;
    }

    public void setMethodToInvoke(Method m) {
        this.methodToInvoke = m;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String m) {
        this.httpMethod = m;
    }

    public boolean isSubResourceLocator() {
        return this.httpMethod == null;
    }

    public List<MediaType> getProduceTypes() {
        return this.produceMimes;
    }

    public List<MediaType> getConsumeTypes() {
        return this.consumeMimes;
    }

    private void checkMediaTypes(String consumeMediaTypes, String produceMediaTypes) {
        if (consumeMediaTypes != null) {
            this.consumeMimes = JAXRSUtils.sortMediaTypes(consumeMediaTypes, null);
        } else {
            Consumes cm = AnnotationUtils.getMethodAnnotation(this.annotatedMethod, Consumes.class);
            if (cm != null) {
                this.consumeMimes = JAXRSUtils.sortMediaTypes(JAXRSUtils.getMediaTypes(cm.value()), null);
            } else if (this.classResourceInfo != null) {
                this.consumeMimes = JAXRSUtils.sortMediaTypes(this.classResourceInfo.getConsumeMime(), null);
            }
        }
        if (produceMediaTypes != null) {
            this.produceMimes = JAXRSUtils.sortMediaTypes(produceMediaTypes, "qs");
        } else {
            Produces pm = AnnotationUtils.getMethodAnnotation(this.annotatedMethod, Produces.class);
            if (pm != null) {
                this.produceMimes = JAXRSUtils.sortMediaTypes(JAXRSUtils.getMediaTypes(pm.value()), "qs");
            } else if (this.classResourceInfo != null) {
                this.produceMimes = JAXRSUtils.sortMediaTypes(this.classResourceInfo.getProduceMime(), "qs");
            }
        }
    }

    public boolean isEncodedEnabled() {
        return this.encoded;
    }

    public String getDefaultParameterValue() {
        return this.defaultParamValue;
    }

    private void checkEncoded() {
        boolean bl = this.encoded = AnnotationUtils.getMethodAnnotation(this.annotatedMethod, Encoded.class) != null;
        if (!this.encoded && this.classResourceInfo != null) {
            this.encoded = AnnotationUtils.getClassAnnotation(this.classResourceInfo.getServiceClass(), Encoded.class) != null;
        }
    }

    private void checkDefaultParameterValue() {
        DefaultValue dv = AnnotationUtils.getMethodAnnotation(this.annotatedMethod, DefaultValue.class);
        if (dv == null && this.classResourceInfo != null) {
            dv = AnnotationUtils.getClassAnnotation(this.classResourceInfo.getServiceClass(), DefaultValue.class);
        }
        if (dv != null) {
            this.defaultParamValue = dv.value();
        }
    }

    public Annotation[][] getInParameterAnnotations() {
        return this.actualInParamAnnotations;
    }

    public Type[] getInGenericParameterTypes() {
        return this.actualInGenericParamTypes;
    }

    public Class<?>[] getInParameterTypes() {
        return this.actualInParamTypes;
    }

    public Annotation[] getOutAnnotations() {
        return this.actualOutParamAnnotations;
    }
}

