/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import com.ctc.wstx.exc.WstxEOFException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NoContentException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.PropertyException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.annotation.XmlAnyElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.validation.Schema;
import org.apache.cxf.annotations.SchemaValidation;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXBUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.jaxrs.utils.schemas.SchemaHandler;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.staxutils.DepthExceededStaxException;
import org.apache.cxf.staxutils.DepthRestrictingStreamReader;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.DocumentDepthProperties;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.transform.TransformUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractJAXBProvider<T>
extends AbstractConfigurableProvider
implements MessageBodyReader<T>,
MessageBodyWriter<T> {
    protected static final String NS_MAPPER_PROPERTY_RI = "com.sun.xml.bind.namespacePrefixMapper";
    protected static final String NS_MAPPER_PROPERTY_RI_INT = "com.sun.xml.internal.bind.namespacePrefixMapper";
    private static final String JAXB_DEFAULT_NAMESPACE = "##default";
    private static final String JAXB_DEFAULT_NAME = "##default";
    private static final Set<Class<?>> UNSUPPORTED_CLASSES = new HashSet<Class>(Arrays.asList(InputStream.class, OutputStream.class, StreamingOutput.class));
    protected Set<Class<?>> collectionContextClasses = ConcurrentHashMap.newKeySet();
    protected Map<String, String> jaxbElementClassMap = Collections.emptyMap();
    protected boolean unmarshalAsJaxbElement;
    protected boolean marshalAsJaxbElement;
    protected boolean xmlTypeAsJaxbElementOnly;
    protected Map<String, String> outElementsMap;
    protected Map<String, String> outAppendMap;
    protected List<String> outDropElements;
    protected List<String> inDropElements;
    protected Map<String, String> inElementsMap;
    protected Map<String, String> inAppendMap;
    protected Map<String, JAXBContext> packageContexts = new ConcurrentHashMap<String, JAXBContext>();
    protected Map<Class<?>, JAXBContext> classContexts = new ConcurrentHashMap();
    private boolean attributesToElements;
    private MessageContext mc;
    private Schema schema;
    private String catalogLocation;
    private Map<String, SchemaHandler> schemaHandlers;
    private String collectionWrapperName;
    private Map<String, String> collectionWrapperMap;
    private List<String> jaxbElementClassNames;
    private boolean xmlRootAsJaxbElement;
    private Map<String, Object> cProperties;
    private Map<String, Object> uProperties;
    private boolean skipJaxbChecks;
    private boolean singleJaxbContext;
    private boolean useSingleContextForPackages;
    private Class<?>[] extraClass;
    private boolean validateInputIfPossible = true;
    private boolean validateOutputIfPossible;
    private boolean validateBeforeWrite;
    private ValidationEventHandler eventHandler;
    private Unmarshaller.Listener unmarshallerListener;
    private Marshaller.Listener marshallerListener;
    private DocumentDepthProperties depthProperties;
    private String namespaceMapperPropertyName;

    private static JAXBContext newJAXBContextInstance(Class<?>[] classes, Map<String, Object> cProperties) throws JAXBException {
        try {
            return AccessController.doPrivileged(() -> JAXBContext.newInstance((Class[])classes, (Map)cProperties));
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof JAXBException) {
                throw (JAXBException)t;
            }
            throw new RuntimeException(t);
        }
    }

    public void setXmlRootAsJaxbElement(boolean xmlRootAsJaxbElement) {
        this.xmlRootAsJaxbElement = xmlRootAsJaxbElement;
    }

    protected void setNamespaceMapper(Marshaller ms, Map<String, String> map) throws Exception {
        Object nsMapper = org.apache.cxf.common.jaxb.JAXBUtils.setNamespaceMapper(this.getBus(), map, ms);
        if (nsMapper != null && this.namespaceMapperPropertyName != null) {
            AbstractJAXBProvider.setMarshallerProp(ms, nsMapper, this.namespaceMapperPropertyName, null);
        }
    }

    protected static void setMarshallerProp(Marshaller ms, Object value, String name1, String name2) throws Exception {
        try {
            ms.setProperty(name1, value);
        }
        catch (PropertyException ex) {
            if (name2 != null) {
                ms.setProperty(name2, value);
            }
            throw ex;
        }
    }

    public void setValidationHandler(ValidationEventHandler handler) {
        this.eventHandler = handler;
    }

    public void setSingleJaxbContext(boolean useSingleContext) {
        this.singleJaxbContext = useSingleContext;
    }

    public void setUseSingleContextForPackages(boolean use) {
        this.useSingleContextForPackages = use;
    }

    public void setExtraClass(Class<?>[] userExtraClass) {
        this.extraClass = userExtraClass;
    }

    @Override
    public void init(List<ClassResourceInfo> cris) {
        if (this.singleJaxbContext) {
            JAXBContext context = null;
            HashSet allTypes = null;
            if (cris != null) {
                allTypes = new HashSet(ResourceUtils.getAllRequestResponseTypes(cris, true).getAllTypes().keySet());
                context = JAXBUtils.createJaxbContext(allTypes, this.extraClass, this.cProperties);
            } else if (this.extraClass != null) {
                allTypes = new HashSet(Arrays.asList(this.extraClass));
                context = JAXBUtils.createJaxbContext(allTypes, null, this.cProperties);
            }
            if (context != null) {
                for (Class clazz : allTypes) {
                    if (this.useSingleContextForPackages) {
                        this.packageContexts.put(PackageUtils.getPackageName(clazz), context);
                        continue;
                    }
                    this.classContexts.put(clazz, context);
                }
            }
        }
        if (cris != null) {
            LinkedList<String> schemaLocs = new LinkedList<String>();
            SchemaValidation sv = null;
            for (ClassResourceInfo classResourceInfo : cris) {
                sv = classResourceInfo.getServiceClass().getAnnotation(SchemaValidation.class);
                if (sv == null || sv.schemas() == null || sv.type() == SchemaValidation.SchemaValidationType.NONE) continue;
                for (String s : sv.schemas()) {
                    String theSchema = s;
                    if (!theSchema.startsWith("classpath:")) {
                        theSchema = "classpath:" + theSchema;
                    }
                    schemaLocs.add(theSchema);
                }
            }
            if (!schemaLocs.isEmpty()) {
                this.setSchemaLocations(schemaLocs);
                if (cris.isEmpty() && this.schema != null && sv != null) {
                    SchemaValidation.SchemaValidationType type = sv.type();
                    if (type == SchemaValidation.SchemaValidationType.OUT) {
                        this.validateInputIfPossible = false;
                        this.validateOutputIfPossible = true;
                    } else if (type == SchemaValidation.SchemaValidationType.BOTH) {
                        this.validateOutputIfPossible = true;
                    }
                }
            }
        }
    }

    public void setContextProperties(Map<String, Object> contextProperties) {
        this.cProperties = contextProperties;
    }

    public void setUnmarshallerProperties(Map<String, Object> unmarshalProperties) {
        this.uProperties = unmarshalProperties;
    }

    public void setUnmarshallAsJaxbElement(boolean value) {
        this.unmarshalAsJaxbElement = value;
    }

    public void setMarshallAsJaxbElement(boolean value) {
        this.marshalAsJaxbElement = value;
    }

    public void setXmlTypeAsJaxbElementOnly(boolean value) {
        this.xmlTypeAsJaxbElementOnly = value;
    }

    public void setJaxbElementClassNames(List<String> names) {
        this.jaxbElementClassNames = names;
    }

    public void setJaxbElementClassMap(Map<String, String> map) {
        this.jaxbElementClassMap = map;
    }

    protected <X> X getStreamHandlerFromCurrentMessage(Class<X> staxCls) {
        Message m = PhaseInterceptorChain.getCurrentMessage();
        if (m != null) {
            return staxCls.cast(m.getContent(staxCls));
        }
        return null;
    }

    protected boolean isXmlRoot(Class<?> cls) {
        return cls.getAnnotation(XmlRootElement.class) != null;
    }

    protected boolean isXmlType(Class<?> cls) {
        return cls.getAnnotation(XmlType.class) != null;
    }

    protected Object convertToJaxbElementIfNeeded(Object obj, Class<?> cls, Type genericType) throws Exception {
        boolean asJaxbElement;
        Class<?> jaxbElementCls = this.jaxbElementClassNames == null ? null : this.getJaxbElementClass(cls);
        boolean bl = asJaxbElement = jaxbElementCls != null;
        if (!asJaxbElement && this.isXmlRoot(cls) && !this.xmlRootAsJaxbElement) {
            return obj;
        }
        if (jaxbElementCls == null) {
            jaxbElementCls = cls;
        }
        QName name = null;
        String expandedName = this.jaxbElementClassMap.get(jaxbElementCls.getName());
        if (expandedName != null) {
            name = JAXRSUtils.convertStringToQName(expandedName);
        } else if (this.marshalAsJaxbElement || asJaxbElement) {
            name = this.getJaxbQName(jaxbElementCls, genericType, obj, false);
        }
        return name != null ? new JAXBElement(name, jaxbElementCls, null, obj) : obj;
    }

    protected Class<?> getJaxbElementClass(Class<?> cls) {
        if (cls == Object.class) {
            return null;
        }
        if (this.jaxbElementClassNames.contains(cls.getName())) {
            return cls;
        }
        return this.getJaxbElementClass(cls.getSuperclass());
    }

    public void setCollectionWrapperName(String wName) {
        this.collectionWrapperName = wName;
    }

    public void setCollectionWrapperMap(Map<String, String> map) {
        this.collectionWrapperMap = map;
    }

    protected void setContext(MessageContext context) {
        this.mc = context;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] anns, MediaType mt) {
        if (InjectionUtils.isSupportedCollectionOrArray(type) && (type = InjectionUtils.getActualType(genericType)) == null) {
            return false;
        }
        return this.marshalAsJaxbElement && (!this.xmlTypeAsJaxbElementOnly || this.isXmlType(type)) || this.isSupported(type, genericType, anns);
    }

    public void writeTo(T t, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        Class<?> type = t.getClass();
        this.writeTo(t, type, genericType, annotations, mediaType, httpHeaders, entityStream);
    }

    protected JAXBContext getCollectionContext(Class<?> type) throws JAXBException {
        if (this.collectionContextClasses.add(type)) {
            this.collectionContextClasses.add(CollectionWrapper.class);
        }
        return AbstractJAXBProvider.newJAXBContextInstance(this.collectionContextClasses.toArray(new Class[0]), this.cProperties);
    }

    protected QName getCollectionWrapperQName(Class<?> cls, Type type, Object object, boolean pluralName) throws Exception {
        String name = this.getCollectionWrapperName(cls);
        if (name == null) {
            return this.getJaxbQName(cls, type, object, pluralName);
        }
        return JAXRSUtils.convertStringToQName(name);
    }

    private String getCollectionWrapperName(Class<?> cls) {
        if (this.collectionWrapperName != null) {
            return this.collectionWrapperName;
        }
        if (this.collectionWrapperMap != null) {
            return this.collectionWrapperMap.get(cls.getName());
        }
        return null;
    }

    protected QName getJaxbQName(Class<?> cls, Type type, Object object, boolean pluralName) throws Exception {
        if (cls == JAXBElement.class) {
            return object != null ? ((JAXBElement)object).getName() : null;
        }
        XmlRootElement root = cls.getAnnotation(XmlRootElement.class);
        if (root != null) {
            return AbstractJAXBProvider.getQNameFromNamespaceAndName(root.namespace(), root.name(), cls, pluralName);
        }
        if (this.isXmlType(cls)) {
            XmlType xmlType = cls.getAnnotation(XmlType.class);
            return AbstractJAXBProvider.getQNameFromNamespaceAndName(xmlType.namespace(), xmlType.name(), cls, pluralName);
        }
        return new QName(AbstractJAXBProvider.getPackageNamespace(cls), cls.getSimpleName());
    }

    private static QName getQNameFromNamespaceAndName(String ns, String localName, Class<?> cls, boolean plural) {
        String name = AbstractJAXBProvider.getLocalName(localName, cls.getSimpleName(), plural);
        String namespace = AbstractJAXBProvider.getNamespace(ns);
        if ("".equals(namespace)) {
            namespace = AbstractJAXBProvider.getPackageNamespace(cls);
        }
        return new QName(namespace, name);
    }

    private static String getLocalName(String name, String clsName, boolean pluralName) {
        if ("##default".equals(name)) {
            name = clsName;
            name = name.length() > 1 ? name.substring(0, 1).toLowerCase() + name.substring(1) : name.toLowerCase();
        }
        if (pluralName) {
            name = name + 's';
        }
        return name;
    }

    private static String getPackageNamespace(Class<?> cls) {
        String packageNs = org.apache.cxf.common.jaxb.JAXBUtils.getPackageNamespace(cls);
        return packageNs != null ? AbstractJAXBProvider.getNamespace(packageNs) : "";
    }

    private static String getNamespace(String namespace) {
        if ("##default".equals(namespace)) {
            return "";
        }
        return namespace;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] anns, MediaType mt) {
        if (InjectionUtils.isSupportedCollectionOrArray(type) && (type = InjectionUtils.getActualType(genericType)) == null) {
            return false;
        }
        return this.canBeReadAsJaxbElement(type) || this.isSupported(type, genericType, anns);
    }

    protected boolean canBeReadAsJaxbElement(Class<?> type) {
        return this.unmarshalAsJaxbElement && type != Response.class;
    }

    public void setSchemaLocations(List<String> locations) {
        this.schema = SchemaHandler.createSchema(locations, this.catalogLocation, this.getBus());
    }

    public void setCatalogLocation(String name) {
        this.catalogLocation = name;
    }

    public void setSchemaHandler(SchemaHandler handler) {
        this.setSchema(handler.getSchema());
    }

    public void setSchemaHandlers(Map<String, SchemaHandler> handlers) {
        this.schemaHandlers = handlers;
    }

    protected void setSchema(Schema s) {
        this.schema = s;
    }

    public long getSize(T o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return -1L;
    }

    protected MessageContext getContext() {
        return this.mc;
    }

    public JAXBContext getJAXBContext(Class<?> type, Type genericType) throws JAXBException {
        JAXBContext customContext;
        ContextResolver resolver;
        if (this.mc != null && (resolver = this.mc.getResolver(ContextResolver.class, JAXBContext.class)) != null && (customContext = (JAXBContext)resolver.getContext(type)) != null) {
            return customContext;
        }
        JAXBContext context = this.classContexts.get(type);
        if (context != null) {
            return context;
        }
        context = this.getPackageContext(type, genericType);
        return context != null ? context : this.getClassContext(type, genericType);
    }

    public JAXBContext getClassContext(Class<?> type) throws JAXBException {
        return this.getClassContext(type, type);
    }

    protected JAXBContext getClassContext(Class<?> type, Type genericType) throws JAXBException {
        JAXBException[] jaxbException = new JAXBException[]{null};
        JAXBContext context = this.classContexts.computeIfAbsent(type, t -> {
            Class[] classes;
            if (this.extraClass != null) {
                classes = new Class[this.extraClass.length + 1];
                classes[0] = type;
                System.arraycopy(this.extraClass, 0, classes, 1, this.extraClass.length);
            } else {
                classes = new Class[]{type};
            }
            try {
                return AbstractJAXBProvider.newJAXBContextInstance(classes, this.cProperties);
            }
            catch (JAXBException e) {
                jaxbException[0] = e;
                return null;
            }
        });
        if (null != jaxbException[0]) {
            throw jaxbException[0];
        }
        return context;
    }

    public JAXBContext getPackageContext(Class<?> type) {
        return this.getPackageContext(type, type);
    }

    protected JAXBContext getPackageContext(Class<?> type, Type genericType) {
        if (type == null || type == JAXBElement.class) {
            return null;
        }
        String packageName = PackageUtils.getPackageName(type);
        return this.packageContexts.computeIfAbsent(packageName, p -> {
            try {
                ClassLoader loader = AccessController.doPrivileged(() -> type.getClassLoader());
                if (loader != null && this.objectFactoryOrIndexAvailable(type)) {
                    String contextName = packageName;
                    if (this.extraClass != null) {
                        StringBuilder sb = new StringBuilder(contextName);
                        for (Class<?> extra : this.extraClass) {
                            String extraPackage = PackageUtils.getPackageName(extra);
                            if (extraPackage.equals(packageName)) continue;
                            sb.append(':').append(extraPackage);
                        }
                        contextName = sb.toString();
                    }
                    return JAXBContext.newInstance((String)contextName, (ClassLoader)loader, this.cProperties);
                }
            }
            catch (JAXBException ex) {
                LOG.fine("Error creating a JAXBContext using ObjectFactory : " + ex.getMessage());
            }
            return null;
        });
    }

    protected boolean isSupported(Class<?> type, Type genericType, Annotation[] anns) {
        if (this.jaxbElementClassMap != null && this.jaxbElementClassMap.containsKey(type.getName()) || this.isSkipJaxbChecks()) {
            return true;
        }
        if (UNSUPPORTED_CLASSES.contains(type)) {
            return false;
        }
        return this.isXmlRoot(type) || JAXBElement.class.isAssignableFrom(type) || this.objectFactoryOrIndexAvailable(type) || type != genericType && this.objectFactoryForType(genericType) || JAXBUtils.getAdapter(type, anns) != null;
    }

    protected boolean objectFactoryOrIndexAvailable(Class<?> type) {
        return type.getResource("ObjectFactory.class") != null || type.getResource("jaxb.index") != null;
    }

    private boolean objectFactoryForType(Type genericType) {
        return this.objectFactoryOrIndexAvailable(InjectionUtils.getActualType(genericType));
    }

    protected Unmarshaller createUnmarshaller(Class<?> cls, Type genericType) throws JAXBException {
        return this.createUnmarshaller(cls, genericType, false);
    }

    protected Unmarshaller createUnmarshaller(Class<?> cls, Type genericType, boolean isCollection) throws JAXBException {
        Schema theSchema;
        JAXBContext context = isCollection ? this.getCollectionContext(cls) : this.getJAXBContext(cls, genericType);
        Unmarshaller unmarshaller = context.createUnmarshaller();
        if (this.validateInputIfPossible && (theSchema = this.getSchema(cls)) != null) {
            unmarshaller.setSchema(theSchema);
        }
        if (this.eventHandler != null) {
            unmarshaller.setEventHandler(this.eventHandler);
        }
        if (this.unmarshallerListener != null) {
            unmarshaller.setListener(this.unmarshallerListener);
        }
        if (this.uProperties != null) {
            for (Map.Entry<String, Object> entry : this.uProperties.entrySet()) {
                unmarshaller.setProperty(entry.getKey(), entry.getValue());
            }
        }
        return unmarshaller;
    }

    protected Marshaller createMarshaller(Object obj, Class<?> cls, Type genericType, String enc) throws JAXBException {
        Class objClazz = JAXBElement.class.isAssignableFrom(cls) ? ((JAXBElement)obj).getDeclaredType() : cls;
        JAXBContext context = this.getJAXBContext(objClazz, genericType);
        Marshaller marshaller = context.createMarshaller();
        if (enc != null) {
            marshaller.setProperty("jaxb.encoding", (Object)enc);
        }
        if (this.marshallerListener != null) {
            marshaller.setListener(this.marshallerListener);
        }
        this.validateObjectIfNeeded(marshaller, cls, obj);
        return marshaller;
    }

    protected void validateObjectIfNeeded(Marshaller marshaller, Class<?> cls, Object obj) throws JAXBException {
        Schema theSchema;
        if (this.validateOutputIfPossible && (theSchema = this.getSchema(cls)) != null) {
            marshaller.setEventHandler(this.eventHandler);
            marshaller.setSchema(theSchema);
            if (this.validateBeforeWrite) {
                marshaller.marshal(obj, (ContentHandler)new DefaultHandler());
                marshaller.setSchema(null);
            }
        }
    }

    protected Class<?> getActualType(Class<?> type, Type genericType, Annotation[] anns) {
        Class<?> theType = JAXBElement.class.isAssignableFrom(type) ? InjectionUtils.getActualType(genericType) : type;
        XmlJavaTypeAdapter adapter = JAXBUtils.getAdapter(theType, anns);
        theType = JAXBUtils.getTypeFromAdapter(adapter, theType, false);
        return theType;
    }

    protected static Object checkAdapter(Object obj, Class<?> cls, Annotation[] anns, boolean marshal) {
        XmlJavaTypeAdapter adapter = JAXBUtils.getAdapter(cls, anns);
        return JAXBUtils.useAdapter(obj, adapter, marshal);
    }

    protected Schema getSchema() {
        return this.getSchema(null);
    }

    protected Schema getSchema(Class<?> cls) {
        if (this.schema == null && this.schemaHandlers == null) {
            return null;
        }
        if (this.schema != null) {
            return this.schema;
        }
        SchemaHandler handler = this.schemaHandlers.get(cls.getName());
        return handler != null ? handler.getSchema() : null;
    }

    public void clearContexts() {
        this.classContexts.clear();
        this.packageContexts.clear();
    }

    protected static StringBuilder handleExceptionStart(Exception e) {
        LOG.warning(ExceptionUtils.getStackTrace(e));
        StringBuilder sb = new StringBuilder();
        if (e.getMessage() != null) {
            sb.append(e.getMessage()).append(". ");
        }
        if (e.getCause() != null && e.getCause().getMessage() != null) {
            sb.append(e.getCause().getMessage()).append(". ");
        }
        return sb;
    }

    protected static void handleExceptionEnd(Throwable t, String message, boolean read) throws NoContentException {
        if (t instanceof WstxEOFException && t.getMessage().startsWith("Unexpected EOF in prolog")) {
            String noContent = new org.apache.cxf.common.i18n.Message("EMPTY_BODY", BUNDLE, new Object[0]).toString();
            LOG.warning(noContent);
            throw new NoContentException(noContent);
        }
        Response.Status status = read ? Response.Status.BAD_REQUEST : Response.Status.INTERNAL_SERVER_ERROR;
        Response r = JAXRSUtils.toResponseBuilder(status).type("text/plain").entity((Object)message).build();
        throw read ? ExceptionUtils.toBadRequestException(t, r) : ExceptionUtils.toInternalServerErrorException(t, r);
    }

    protected void handleJAXBException(JAXBException e, boolean read) throws NoContentException {
        StringBuilder sb = AbstractJAXBProvider.handleExceptionStart((Exception)((Object)e));
        Throwable linked = e.getLinkedException();
        if (linked != null && linked.getMessage() != null) {
            for (Throwable cause = linked; read && cause != null; cause = cause.getCause()) {
                if (cause instanceof XMLStreamException && cause.getMessage().startsWith("Maximum Number")) {
                    throw ExceptionUtils.toWebApplicationException(null, JAXRSUtils.toResponse(413));
                }
                if (!(cause instanceof DepthExceededStaxException)) continue;
                throw ExceptionUtils.toWebApplicationException(null, JAXRSUtils.toResponse(413));
            }
            String msg = linked.getMessage();
            if (sb.lastIndexOf(msg) == -1) {
                sb.append(msg).append(". ");
            }
        }
        Throwable t = linked != null ? linked : (e.getCause() != null ? e.getCause() : e);
        String message = new org.apache.cxf.common.i18n.Message("JAXB_EXCEPTION", BUNDLE, sb.toString()).toString();
        AbstractJAXBProvider.handleExceptionEnd(t, message, read);
    }

    protected void handleXMLStreamException(XMLStreamException e, boolean read) throws NoContentException {
        StringBuilder sb = AbstractJAXBProvider.handleExceptionStart(e);
        AbstractJAXBProvider.handleExceptionEnd(e, sb.toString(), read);
    }

    public void setOutTransformElements(Map<String, String> outElements) {
        this.outElementsMap = outElements;
    }

    public void setInAppendElements(Map<String, String> inElements) {
        this.inAppendMap = inElements;
    }

    public void setInTransformElements(Map<String, String> inElements) {
        this.inElementsMap = inElements;
    }

    public void setOutAppendElements(Map<String, String> map) {
        this.outAppendMap = map;
    }

    public void setOutDropElements(List<String> dropElementsSet) {
        this.outDropElements = dropElementsSet;
    }

    public void setInDropElements(List<String> dropElementsSet) {
        this.inDropElements = dropElementsSet;
    }

    public void setAttributesToElements(boolean value) {
        this.attributesToElements = value;
    }

    public void setSkipJaxbChecks(boolean skipJaxbChecks) {
        this.skipJaxbChecks = skipJaxbChecks;
    }

    public boolean isSkipJaxbChecks() {
        return this.skipJaxbChecks;
    }

    protected XMLStreamWriter createTransformWriterIfNeeded(XMLStreamWriter writer, OutputStream os, boolean dropAtXmlLevel) {
        return TransformUtils.createTransformWriterIfNeeded(writer, os, this.outElementsMap, dropAtXmlLevel ? this.outDropElements : null, this.outAppendMap, this.attributesToElements, null);
    }

    protected XMLStreamReader createTransformReaderIfNeeded(XMLStreamReader reader, InputStream is) {
        return TransformUtils.createTransformReaderIfNeeded(reader, is, this.inDropElements, this.inElementsMap, this.inAppendMap, true);
    }

    protected XMLStreamReader createDepthReaderIfNeeded(XMLStreamReader reader, InputStream is) {
        DocumentDepthProperties props = this.getDepthProperties();
        if (props != null && props.isEffective()) {
            reader = TransformUtils.createNewReaderIfNeeded(reader, is);
            reader = new DepthRestrictingStreamReader(reader, props);
        } else if (reader != null) {
            reader = this.configureReaderRestrictions(reader);
        }
        return reader;
    }

    protected XMLStreamReader configureReaderRestrictions(XMLStreamReader reader) {
        Message message = PhaseInterceptorChain.getCurrentMessage();
        if (message != null) {
            try {
                return StaxUtils.configureReader(reader, message);
            }
            catch (XMLStreamException ex) {
                throw ExceptionUtils.toInternalServerErrorException(ex, null);
            }
        }
        return reader;
    }

    protected DocumentDepthProperties getDepthProperties() {
        return this.depthProperties;
    }

    public void setValidateBeforeWrite(boolean validateBeforeWrite) {
        this.validateBeforeWrite = validateBeforeWrite;
    }

    public void setValidateOutput(boolean validateOutput) {
        this.validateOutputIfPossible = validateOutput;
    }

    public void setValidateInput(boolean validateInput) {
        this.validateInputIfPossible = validateInput;
    }

    public void setDepthProperties(DocumentDepthProperties depthProperties) {
        this.depthProperties = depthProperties;
    }

    public void setUnmarshallerListener(Unmarshaller.Listener unmarshallerListener) {
        this.unmarshallerListener = unmarshallerListener;
    }

    public void setMarshallerListener(Marshaller.Listener marshallerListener) {
        this.marshallerListener = marshallerListener;
    }

    public void setNamespaceMapperPropertyName(String namespaceMapperProperty) {
        this.namespaceMapperPropertyName = namespaceMapperProperty;
    }

    protected static class JAXBCollectionWrapperReader
    extends DepthXMLStreamReader {
        private boolean firstName;
        private boolean firstNs;

        public JAXBCollectionWrapperReader(XMLStreamReader reader) {
            super(reader);
        }

        @Override
        public String getNamespaceURI() {
            if (!this.firstNs) {
                this.firstNs = true;
                return "";
            }
            return super.getNamespaceURI();
        }

        @Override
        public String getLocalName() {
            if (!this.firstName) {
                this.firstName = true;
                return "collectionWrapper";
            }
            return super.getLocalName();
        }
    }

    @XmlRootElement
    protected static class CollectionWrapper {
        @XmlAnyElement(lax=true)
        private List<?> l;

        protected CollectionWrapper() {
        }

        public void setList(List<?> list) {
            this.l = list;
        }

        public List<?> getList() {
            if (this.l == null) {
                this.l = new ArrayList();
            }
            return this.l;
        }

        public <T> Object getCollectionOrArray(Unmarshaller unm, Class<T> type, Class<?> collectionType, Type genericType, XmlJavaTypeAdapter adapter) throws JAXBException {
            List<?> theList = this.getList();
            boolean adapterChecked = false;
            if (!theList.isEmpty()) {
                ArrayList newList;
                boolean isJaxbElement;
                Object first = theList.get(0);
                if (first instanceof Element) {
                    ArrayList newList2 = new ArrayList(theList.size());
                    for (Object o : theList) {
                        newList2.add(unm.unmarshal((Node)((Element)o), type));
                    }
                    theList = newList2;
                }
                first = theList.get(0);
                Type[] types = InjectionUtils.getActualTypes(genericType);
                boolean bl = isJaxbElement = types != null && types.length > 0 && InjectionUtils.getRawType(types[0]) == JAXBElement.class;
                if (first instanceof JAXBElement && !isJaxbElement && !JAXBElement.class.isAssignableFrom(type)) {
                    adapterChecked = true;
                    newList = new ArrayList(theList.size());
                    for (Object o : theList) {
                        newList.add(JAXBUtils.useAdapter(((JAXBElement)o).getValue(), adapter, false));
                    }
                    theList = newList;
                } else if (!(first instanceof JAXBElement) && isJaxbElement) {
                    newList = new ArrayList(theList.size());
                    XmlRootElement root = type.getAnnotation(XmlRootElement.class);
                    QName qname = AbstractJAXBProvider.getQNameFromNamespaceAndName(root.namespace(), root.name(), type, false);
                    Class<T> theType = type;
                    for (Object o : theList) {
                        newList.add(new JAXBElement(qname, theType, null, o));
                    }
                    theList = newList;
                }
            }
            if (collectionType.isArray()) {
                Object[] values = (Object[])Array.newInstance(type, theList.size());
                for (int i = 0; i < theList.size(); ++i) {
                    values[i] = JAXBUtils.useAdapter(theList.get(i), adapter, false);
                }
                return values;
            }
            if (!adapterChecked && adapter != null) {
                ArrayList newList = new ArrayList(theList.size());
                for (Object o : theList) {
                    newList.add(JAXBUtils.useAdapter(o, adapter, false));
                }
                theList = newList;
            }
            if (collectionType == Set.class) {
                return new HashSet(theList);
            }
            return theList;
        }
    }
}

