/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.spec.AlgorithmParameterSpec;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.rs.security.jose.common.JoseException;
import org.apache.cxf.rs.security.jose.jwa.AlgorithmUtils;
import org.apache.cxf.rs.security.jose.jwa.KeyAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweCompactConsumer;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionInput;
import org.apache.cxf.rs.security.jose.jwe.JweException;
import org.apache.cxf.rs.security.jose.jwe.WrappedKeyDecryptionAlgorithm;
import org.apache.cxf.rt.security.crypto.CryptoUtils;

public class AesGcmWrapKeyDecryptionAlgorithm
extends WrappedKeyDecryptionAlgorithm {
    protected static final Logger LOG = LogUtils.getL7dLogger(AesGcmWrapKeyDecryptionAlgorithm.class);

    public AesGcmWrapKeyDecryptionAlgorithm(String encodedKey) {
        this(encodedKey, null);
    }

    public AesGcmWrapKeyDecryptionAlgorithm(String encodedKey, KeyAlgorithm supportedAlgo) {
        this(CryptoUtils.decodeSequence(encodedKey), supportedAlgo);
    }

    public AesGcmWrapKeyDecryptionAlgorithm(byte[] secretKey) {
        this(secretKey, KeyAlgorithm.A128GCMKW);
    }

    public AesGcmWrapKeyDecryptionAlgorithm(byte[] secretKey, KeyAlgorithm supportedAlgo) {
        this(CryptoUtils.createSecretKeySpec(secretKey, "AES"), supportedAlgo);
    }

    public AesGcmWrapKeyDecryptionAlgorithm(SecretKey secretKey) {
        this(secretKey, null);
    }

    public AesGcmWrapKeyDecryptionAlgorithm(SecretKey secretKey, KeyAlgorithm supportedAlgo) {
        super(secretKey, supportedAlgo);
    }

    @Override
    protected byte[] getEncryptedContentEncryptionKey(JweDecryptionInput jweDecryptionInput) {
        byte[] encryptedCekKey = super.getEncryptedContentEncryptionKey(jweDecryptionInput);
        byte[] tag = this.getDecodedBytes(jweDecryptionInput, "tag");
        return JweCompactConsumer.getCipherWithAuthTag(encryptedCekKey, tag);
    }

    @Override
    protected AlgorithmParameterSpec getAlgorithmParameterSpec(JweDecryptionInput jweDecryptionInput) {
        byte[] iv = this.getDecodedBytes(jweDecryptionInput, "iv");
        return CryptoUtils.getContentEncryptionCipherSpec(128, iv);
    }

    private byte[] getDecodedBytes(JweDecryptionInput jweDecryptionInput, String headerName) {
        try {
            Object ivHeader = jweDecryptionInput.getJweHeaders().getHeader(headerName);
            return Base64UrlUtility.decode(ivHeader.toString());
        }
        catch (Exception ex) {
            throw new JoseException(ex);
        }
    }

    @Override
    protected void validateKeyEncryptionAlgorithm(String keyAlgo) {
        super.validateKeyEncryptionAlgorithm(keyAlgo);
        if (!AlgorithmUtils.isAesGcmKeyWrap(keyAlgo)) {
            LOG.warning("Invalid key encryption algorithm");
            throw new JweException(JweException.Error.INVALID_KEY_ALGORITHM);
        }
    }
}

