/*
 * Decompiled with CFR 0.152.
 */
package javax.ws.rs.client;

import java.security.KeyStore;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientFinder;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;

public abstract class ClientBuilder
implements Configurable<ClientBuilder> {
    public static final String JAXRS_DEFAULT_CLIENT_BUILDER_PROPERTY = "javax.ws.rs.client.ClientBuilder";

    protected ClientBuilder() {
    }

    public static ClientBuilder newBuilder() {
        try {
            Object delegate = ClientFinder.find(JAXRS_DEFAULT_CLIENT_BUILDER_PROPERTY);
            if (!ClientBuilder.class.isInstance(delegate)) {
                throw new LinkageError(delegate + " not an instance of ClientBuilder");
            }
            return (ClientBuilder)ClientBuilder.class.cast(delegate);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Client newClient() {
        return ClientBuilder.newBuilder().build();
    }

    public static Client newClient(Configuration configuration) {
        return ClientBuilder.newBuilder().withConfig(configuration).build();
    }

    public abstract ClientBuilder withConfig(Configuration var1);

    public abstract ClientBuilder sslContext(SSLContext var1);

    public abstract ClientBuilder keyStore(KeyStore var1, char[] var2);

    public ClientBuilder keyStore(KeyStore keyStore, String password) {
        return this.keyStore(keyStore, password.toCharArray());
    }

    public abstract ClientBuilder trustStore(KeyStore var1);

    public abstract ClientBuilder hostnameVerifier(HostnameVerifier var1);

    public abstract Client build();
}

