/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;

public final class EJBMethodPermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String NEW_METHOD_INTERFACES = "org.apache.security.jacc.EJBMethodPermission.methodInterfaces";
    private static String[] methodInterfaces;
    private transient int cachedHashCode;
    private transient MethodSpec methodSpec;

    public EJBMethodPermission(String name, String spec) {
        super(name);
        this.methodSpec = new MethodSpec(spec);
    }

    public EJBMethodPermission(String EJBName, String methodName, String methodInterface, String[] methodParams) {
        super(EJBName);
        this.methodSpec = new MethodSpec(methodName, methodInterface, methodParams);
    }

    public EJBMethodPermission(String EJBName, String methodInterface, Method method) {
        super(EJBName);
        if (method == null) {
            throw new IllegalArgumentException("Parameter method must not be null");
        }
        this.methodSpec = new MethodSpec(methodInterface, method);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof EJBMethodPermission)) {
            return false;
        }
        EJBMethodPermission other = (EJBMethodPermission)o;
        return this.getName().equals(other.getName()) && this.methodSpec.equals(other.methodSpec);
    }

    public String getActions() {
        return this.methodSpec.getActions();
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            this.cachedHashCode = this.getName().hashCode() ^ this.methodSpec.hashCode();
        }
        return this.cachedHashCode;
    }

    public boolean implies(Permission permission) {
        if (permission == null || !(permission instanceof EJBMethodPermission)) {
            return false;
        }
        EJBMethodPermission other = (EJBMethodPermission)permission;
        return this.getName().equals(other.getName()) && this.methodSpec.implies(other.methodSpec);
    }

    public PermissionCollection newPermissionCollection() {
        return new EJBMethodPermissionCollection();
    }

    private synchronized void readObject(ObjectInputStream in) throws IOException {
        this.methodSpec = new MethodSpec(in.readUTF());
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.methodSpec.getActions());
    }

    static {
        String newMethodInterfaces = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(EJBMethodPermission.NEW_METHOD_INTERFACES);
            }
        });
        newMethodInterfaces = newMethodInterfaces != null ? newMethodInterfaces + ",Home,LocalHome,Remote,Local,ServiceEndpoint" : "Home,LocalHome,Remote,Local,ServiceEndpoint";
        methodInterfaces = newMethodInterfaces.split(",", -1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EJBMethodPermissionCollection
    extends PermissionCollection {
        private static final long serialVersionUID = -3557818912959683053L;
        private static final String WILDCARD = "$WILDCARD";
        private static final HashMap<String, HashMap<String, HashSet<String>>> ALL_METHODS = new HashMap();
        private LinkedList<Permission> collection = new LinkedList();
        private transient HashMap<String, HashMap<String, HashMap<String, HashSet<String>>>> permissions = new HashMap();

        private EJBMethodPermissionCollection() {
        }

        @Override
        public void add(Permission permission) {
            if (this.isReadOnly()) {
                throw new IllegalArgumentException("Read only collection");
            }
            if (!(permission instanceof EJBMethodPermission)) {
                throw new IllegalArgumentException("Wrong permission type");
            }
            EJBMethodPermission p = (EJBMethodPermission)permission;
            if (this.collection.contains(p)) {
                return;
            }
            this.collection.add(p);
            this.addEJBMethodPermission(p);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.permissions = new HashMap();
            for (Permission p : this.collection) {
                this.addEJBMethodPermission((EJBMethodPermission)p);
            }
        }

        private void addEJBMethodPermission(EJBMethodPermission p) {
            String parametersKey;
            String interfaceKey;
            HashSet<String> parameters;
            String methodKey;
            HashMap<String, HashSet<String>> interfaces;
            MethodSpec spec = p.methodSpec;
            HashMap<String, HashMap<String, HashSet<String>>> methods = this.permissions.get(p.getName());
            if (methods == ALL_METHODS) {
                return;
            }
            if (spec.methodName == null && spec.methodInterface == null && spec.methodParams == null) {
                this.permissions.put(p.getName(), ALL_METHODS);
                return;
            }
            if (methods == null) {
                methods = new HashMap();
                this.permissions.put(p.getName(), methods);
            }
            if ((interfaces = methods.get(methodKey = spec.methodName == null || spec.methodName.length() == 0 ? WILDCARD : spec.methodName)) == null) {
                interfaces = new HashMap();
                methods.put(methodKey, interfaces);
            }
            if ((parameters = interfaces.get(interfaceKey = spec.methodInterface == null || spec.methodInterface.length() == 0 ? WILDCARD : spec.methodInterface)) == null) {
                parameters = new HashSet();
                interfaces.put(interfaceKey, parameters);
            }
            String string = parametersKey = spec.methodParams == null ? WILDCARD : spec.methodParams;
            if (!parameters.contains(parametersKey)) {
                parameters.add(parametersKey);
            }
        }

        @Override
        public boolean implies(Permission permission) {
            if (!(permission instanceof EJBMethodPermission)) {
                return false;
            }
            EJBMethodPermission p = (EJBMethodPermission)permission;
            MethodSpec spec = p.methodSpec;
            HashMap<String, HashMap<String, HashSet<String>>> methods = this.permissions.get(p.getName());
            if (methods == null) {
                return false;
            }
            if (methods == ALL_METHODS) {
                return true;
            }
            String methodKey = spec.methodName == null || spec.methodName.length() == 0 ? WILDCARD : spec.methodName;
            HashMap<String, HashSet<String>> interfaces = methods.get(methodKey);
            if (this.methodImplies(interfaces, spec)) {
                return true;
            }
            if (methodKey != WILDCARD) {
                return this.methodImplies(methods.get(WILDCARD), spec);
            }
            return false;
        }

        protected boolean methodImplies(HashMap<String, HashSet<String>> interfaces, MethodSpec spec) {
            if (interfaces == null) {
                return false;
            }
            String interfaceKey = spec.methodInterface == null || spec.methodInterface.length() == 0 ? WILDCARD : spec.methodInterface;
            HashSet<String> parameters = interfaces.get(interfaceKey);
            if (this.interfaceImplies(parameters, spec)) {
                return true;
            }
            if (interfaceKey != WILDCARD) {
                return this.interfaceImplies(interfaces.get(WILDCARD), spec);
            }
            return false;
        }

        protected boolean interfaceImplies(HashSet<String> parameters, MethodSpec spec) {
            String parametersKey;
            if (parameters == null) {
                return false;
            }
            String string = parametersKey = spec.methodParams == null ? WILDCARD : spec.methodParams;
            if (parameters.contains(parametersKey)) {
                return true;
            }
            if (parametersKey != WILDCARD) {
                return parameters.contains(WILDCARD);
            }
            return false;
        }

        @Override
        public Enumeration<Permission> elements() {
            return Collections.enumeration(this.collection);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodSpec {
        protected String methodName;
        protected String methodInterface;
        protected String methodParams;
        protected String actions;

        public MethodSpec(String actionString) {
            if (actionString == null || actionString.length() == 0) {
                this.methodName = null;
                this.methodInterface = null;
                this.methodParams = null;
                this.actions = "";
            } else {
                String[] tokens = actionString.split(",", 3);
                switch (tokens.length) {
                    case 1: {
                        this.methodName = this.emptyNullCheck(tokens[0]);
                        this.methodInterface = null;
                        this.methodParams = null;
                        break;
                    }
                    case 2: {
                        if (tokens[1].length() == 0) {
                            throw new IllegalArgumentException("This format of actions requires a method interface");
                        }
                        this.checkMethodInterface(tokens[1]);
                        this.methodName = this.emptyNullCheck(tokens[0]);
                        this.methodInterface = this.emptyNullCheck(tokens[1]);
                        this.methodParams = null;
                        break;
                    }
                    case 3: {
                        this.checkMethodInterface(tokens[1]);
                        if (tokens[2].indexOf(44) > -1) {
                            String[] test;
                            for (String aTest : test = tokens[2].split(",", -1)) {
                                if (aTest.length() != 0) continue;
                                throw new IllegalArgumentException("Invalid type name");
                            }
                        }
                        this.methodName = this.emptyNullCheck(tokens[0]);
                        this.methodInterface = this.emptyNullCheck(tokens[1]);
                        this.methodParams = tokens[2];
                    }
                }
                this.actions = actionString;
            }
        }

        public MethodSpec(String mthdName, String mthdInterface, String[] methodParamsArray) {
            this.checkMethodInterface(mthdInterface);
            this.methodName = this.emptyNullCheck(mthdName);
            this.methodInterface = this.emptyNullCheck(mthdInterface);
            if (methodParamsArray == null) {
                this.methodParams = null;
            } else if (methodParamsArray.length == 0) {
                this.methodParams = "";
            } else {
                if (methodParamsArray[0] == null || methodParamsArray[0].length() == 0) {
                    throw new IllegalArgumentException("Invalid type name");
                }
                StringBuilder buffer = new StringBuilder(methodParamsArray[0]);
                for (int i = 1; i < methodParamsArray.length; ++i) {
                    if (methodParamsArray[i] == null || methodParamsArray[i].length() == 0) {
                        throw new IllegalArgumentException("Invalid type name");
                    }
                    buffer.append(",");
                    buffer.append(methodParamsArray[i]);
                }
                this.methodParams = buffer.toString();
            }
            this.initActions();
        }

        public MethodSpec(String mthdInterface, Method method) {
            this.checkMethodInterface(mthdInterface);
            this.methodName = method.getName();
            this.methodInterface = this.emptyNullCheck(mthdInterface);
            Class<?>[] paramTypes = method.getParameterTypes();
            if (paramTypes.length == 0) {
                this.methodParams = "";
            } else {
                StringBuilder buffer = new StringBuilder(paramTypes[0].getName());
                for (int i = 1; i < paramTypes.length; ++i) {
                    buffer.append(",");
                    MethodSpec.getName(paramTypes[i], buffer);
                }
                this.methodParams = buffer.toString();
            }
            this.initActions();
        }

        private static void getName(Class<?> paramType, StringBuilder buffer) {
            if (paramType.isArray()) {
                MethodSpec.getName(paramType.getComponentType(), buffer);
                buffer.append("[]");
            } else {
                buffer.append(paramType.getName());
            }
        }

        public boolean equals(MethodSpec spec) {
            return this.implies(spec) && spec.implies(this);
        }

        public String getActions() {
            return this.actions;
        }

        public int hashCode() {
            return this.actions.hashCode();
        }

        public boolean implies(MethodSpec methodSpec) {
            if (this.methodName == null || this.methodName.equals(methodSpec.methodName)) {
                if (this.methodInterface == null || this.methodInterface.equals(methodSpec.methodInterface)) {
                    return this.methodParams == null || this.methodParams.equals(methodSpec.methodParams);
                }
                return false;
            }
            return false;
        }

        private void initActions() {
            this.actions = this.methodParams == null ? (this.methodInterface == null ? (this.methodName == null ? "" : this.methodName) : (this.methodName == null ? "," + this.methodInterface : this.methodName + "," + this.methodInterface)) : (this.methodInterface == null ? (this.methodName == null ? ",," + this.methodParams : this.methodName + ",," + this.methodParams) : (this.methodName == null ? "," + this.methodInterface + "," + this.methodParams : this.methodName + "," + this.methodInterface + "," + this.methodParams));
        }

        private void checkMethodInterface(String methodInterface) {
            if (methodInterface == null || methodInterface.length() == 0) {
                return;
            }
            for (int i = 0; i < methodInterfaces.length; ++i) {
                if (!methodInterfaces[i].equals(methodInterface)) continue;
                return;
            }
            throw new IllegalArgumentException("Invalid method interface: " + methodInterface);
        }

        private String emptyNullCheck(String name) {
            if (name != null && name.length() == 0) {
                return null;
            }
            return name;
        }
    }
}

