/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.livereload;

import java.io.IOException;
import java.util.Arrays;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.apache.johnzon.mapper.Mapper;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.OpenEjbVersion;
import org.apache.tomee.livereload.Command;
import org.apache.tomee.livereload.FileWatcher;
import org.apache.tomee.livereload.Instances;

@ServerEndpoint(value="/livereload")
public class LiveReloadEndpoint {
    private static final Command HELLO = new Command();
    private final FileWatcher watcher = Instances.get().getWatcher();
    private final Mapper mapper = Instances.get().getMapper();
    private final Logger logger = Logger.getInstance((LogCategory)Instances.get().getLogCategory(), LiveReloadEndpoint.class);
    private volatile boolean loggedInfo = false;

    @OnMessage
    public void onMessage(String msg, Session session) {
        Command command = (Command)this.mapper.readObject(msg, Command.class);
        if (command.isHello()) {
            try {
                session.getBasicRemote().sendText(this.mapper.writeObjectAsString((Object)HELLO));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            this.watcher.addSession(session);
            this.logger.info("Registered livereload session #" + session.getId());
        } else if (command.isClientUpdate()) {
            this.logger.info("Ignoring livereload client update message: " + msg);
        } else if (command.isInfo()) {
            if (!this.loggedInfo) {
                this.logger.info("Livereload registration:\n  - url:" + command.getUrl() + "\n  - plugins: " + command.getPlugins());
                this.loggedInfo = true;
            }
        } else {
            this.logger.info("Unknown livereload message: " + msg);
        }
    }

    @OnClose
    public void onClose(CloseReason reason, Session session) {
        this.watcher.removeSession(session);
    }

    static {
        HELLO.setCommand("hello");
        HELLO.setProtocols(Arrays.asList("http://livereload.com/protocols/official-7", "http://livereload.com/protocols/connection-check-1"));
        HELLO.setServerName("Apache TomEE " + OpenEjbVersion.get().getVersion());
    }
}

