/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.livereload;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Loader;
import org.apache.catalina.Service;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.servlets.DefaultServlet;
import org.apache.tomcat.websocket.server.WsSci;
import org.apache.tomee.catalina.IgnoredStandardContext;
import org.apache.tomee.catalina.OpenEJBValve;
import org.apache.tomee.catalina.remote.ServerClassLoaderLoader;
import org.apache.tomee.livereload.Instances;
import org.apache.tomee.livereload.LiveReloadEndpoint;
import org.apache.tomee.livereload.LiveReloadJs;
import org.apache.tomee.loader.TomcatHelper;

public class LiveReloadInstaller {
    private LiveReloadInstaller() {
    }

    public static void install(String path, final int port, String folder) {
        StandardServer server = TomcatHelper.getServer();
        if (server == null) {
            throw new IllegalStateException("tomcat not yet starting");
        }
        Service service = server.findServices()[0];
        Engine engine = (Engine)Engine.class.cast(service.getContainer());
        Container host = engine.findChild(engine.getDefaultHost());
        if (LifecycleState.STARTED != host.getState()) {
            throw new IllegalStateException("host not started, call LiveReloadInstaller.install() later.");
        }
        Connector connector = new Connector();
        connector.setPort(port);
        connector.setAttribute("connectionTimeout", (Object)"30000");
        service.addConnector(connector);
        final Closeable watch = Instances.get().getWatcher().watch(folder);
        LiveReloadWebapp liveReloadWebapp = new LiveReloadWebapp(path);
        liveReloadWebapp.addApplicationLifecycleListener(new ServletContextListener(){

            public void contextInitialized(ServletContextEvent servletContextEvent) {
                servletContextEvent.getServletContext().log("Started livereload server on port " + port);
            }

            public void contextDestroyed(ServletContextEvent servletContextEvent) {
                try {
                    watch.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        host.addChild((Container)liveReloadWebapp);
    }

    private static class LiveReloadWebapp
    extends IgnoredStandardContext {
        private LiveReloadWebapp(String path) {
            boolean isRoot = path == null || "/".equals(path) || "ROOT".equals(path);
            this.setDocBase("");
            this.setParentClassLoader(LiveReloadInstaller.class.getClassLoader());
            this.setDelegate(true);
            this.setName(isRoot ? "" : (path.startsWith("/") ? path : '/' + path));
            this.setPath(this.getName());
            this.setLoader((Loader)new ServerClassLoaderLoader((Context)this));
            this.addValve((Valve)new OpenEJBValve());
        }

        protected void initInternal() throws LifecycleException {
            super.initInternal();
            Wrapper servlet = this.createWrapper();
            servlet.setName(DefaultServlet.class.getSimpleName());
            servlet.setServletClass(DefaultServlet.class.getName());
            this.addChild((Container)servlet);
            this.addServletMappingDecoded("/*", DefaultServlet.class.getSimpleName());
            servlet = this.createWrapper();
            servlet.setName(LiveReloadJs.class.getSimpleName());
            servlet.setServletClass(LiveReloadJs.class.getName());
            this.addChild((Container)servlet);
            this.addServletMappingDecoded("/livereload.js", LiveReloadJs.class.getSimpleName());
        }

        protected void startInternal() throws LifecycleException {
            this.addServletContainerInitializer((ServletContainerInitializer)new WsSci(), Collections.singleton(LiveReloadEndpoint.class));
            super.startInternal();
        }
    }
}

