/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.livereload;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.websocket.CloseReason;
import javax.websocket.Session;
import org.apache.johnzon.mapper.Mapper;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.tomee.livereload.Command;

public class FileWatcher {
    private final Logger logger;
    private final Mapper mapper;
    private final Collection<Session> sessions = new ArrayList<Session>();

    public FileWatcher(LogCategory logger, Mapper mapper) {
        this.logger = Logger.getInstance((LogCategory)logger, FileWatcher.class);
        this.mapper = mapper;
    }

    public synchronized void addSession(Session session) {
        this.sessions.add(session);
    }

    public synchronized void removeSession(Session session) {
        this.sessions.remove(session);
    }

    public Closeable watch(final String folder) {
        File file = new File(folder);
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(folder + " is not a directory");
        }
        try {
            final AtomicBoolean again = new AtomicBoolean(true);
            Path path = file.getAbsoluteFile().toPath();
            final WatchService watchService = path.getFileSystem().newWatchService();
            path.register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            final Thread watcherThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (again.get()) {
                        try {
                            WatchKey key = watchService.poll(1L, TimeUnit.SECONDS);
                            if (key == null) continue;
                            for (WatchEvent<?> event : key.pollEvents()) {
                                String path;
                                WatchEvent.Kind<?> kind = event.kind();
                                if (kind != StandardWatchEventKinds.ENTRY_CREATE && kind != StandardWatchEventKinds.ENTRY_DELETE && kind != StandardWatchEventKinds.ENTRY_MODIFY) continue;
                                Path updatedPath = (Path)Path.class.cast(event.context());
                                if (kind != StandardWatchEventKinds.ENTRY_DELETE && !updatedPath.toFile().isFile() || (path = updatedPath.toString()).endsWith("___jb_tmp___") || path.endsWith("___jb_old___")) continue;
                                if (path.endsWith("~")) {
                                    FileWatcher.this.onChange(path.replace(File.pathSeparatorChar, '/').substring(0, path.length() - 1));
                                    continue;
                                }
                                FileWatcher.this.onChange(path.replace(File.pathSeparatorChar, '/'));
                            }
                            key.reset();
                        }
                        catch (InterruptedException e) {
                            Thread.interrupted();
                            again.set(false);
                        }
                        catch (ClosedWatchServiceException closedWatchServiceException) {}
                    }
                }
            });
            watcherThread.setName("livereload-tomee-watcher(" + folder + ")");
            watcherThread.start();
            return new Closeable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    2 var1_1 = this;
                    synchronized (var1_1) {
                        for (Session s : FileWatcher.this.sessions) {
                            FileWatcher.this.removeSession(s);
                            try {
                                s.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, "container shutdowned"));
                            }
                            catch (Exception exception) {}
                        }
                    }
                    again.compareAndSet(true, false);
                    try {
                        watchService.close();
                    }
                    catch (IOException ioe) {
                        FileWatcher.this.logger.warning("Error closing the watch service for " + folder + "(" + ioe.getMessage() + ")");
                    }
                    try {
                        watcherThread.join(TimeUnit.MINUTES.toMillis(1L));
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                    }
                }
            };
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onChange(String path) {
        ArrayList<Session> copy;
        Command command = new Command();
        command.setCommand("reload");
        command.setPath(path);
        command.setLiveCss(true);
        String asStr = this.mapper.writeObjectAsString((Object)command);
        FileWatcher fileWatcher = this;
        synchronized (fileWatcher) {
            copy = new ArrayList<Session>(this.sessions);
        }
        int failed = 0;
        for (Session s : copy) {
            try {
                s.getBasicRemote().sendText(asStr);
            }
            catch (Exception e) {
                this.logger.warning("Can't send one livereload update: " + e.getMessage());
                ++failed;
            }
        }
        if (failed < copy.size()) {
            this.logger.info("Updated livereload path: " + path);
        }
    }
}

