/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.openejb.client.CommandParser;
import org.apache.openejb.client.Options;

public class MulticastTool {
    private static final CommandParser cmd = new CommandParser(){

        @Override
        protected void init() {
            this.category("Options");
            this.opt('h', "host").type(String.class).value("239.255.3.2").description("Address of the multicast channel");
            this.opt('p', "port").type(Integer.TYPE).value(6142).description("Port of the multicast channel");
            this.opt("date-format").type(String.class).value("HH:mm:ss").description("Date format to use for log lines");
            this.category("Sending");
            this.opt('s', "send").type(String.class).description("Optional message to broadcast to the channel");
            this.opt('r', "rate").type(Long.TYPE).value(1000).description("Resend every N milliseconds. Zero sends just once");
            this.category("Advanced");
            this.opt("broadcast").type(Boolean.TYPE).description("java.net.MulticastSocket#setBroadcast");
            this.opt("loopback-mode").type(Boolean.TYPE).description("java.net.MulticastSocket#setLoopbackMode");
            this.opt("receive-buffer-size").type(Integer.TYPE).description("java.net.MulticastSocket#setReceiveBufferSize");
            this.opt("reuse-address").type(Boolean.TYPE).description("java.net.MulticastSocket#setReuseAddress");
            this.opt("send-buffer-size").type(Integer.TYPE).description("java.net.MulticastSocket#setSendBufferSize");
            this.opt("so-timeout").type(Integer.TYPE).description("java.net.MulticastSocket#setSoTimeout");
            this.opt("time-to-live").type(Integer.TYPE).description("java.net.MulticastSocket#setTimeToLive");
            this.opt("traffic-class").type(Integer.TYPE).description("java.net.MulticastSocket#setTrafficClass");
        }

        @Override
        protected List<String> validate(CommandParser.Arguments arguments) {
            return super.validate(arguments);
        }

        @Override
        protected List<String> usage() {
            return super.usage();
        }
    };
    private static final int BUFF_SIZE = 8192;

    public static void main(String[] array) throws Exception {
        CommandParser.Arguments arguments;
        try {
            arguments = cmd.parse(array);
        }
        catch (CommandParser.HelpException e) {
            System.exit(0);
            throw new Exception();
        }
        catch (CommandParser.InvalidOptionsException e) {
            System.exit(1);
            throw new Exception();
        }
        Options options = arguments.options();
        SimpleDateFormat format = new SimpleDateFormat(options.get("date-format", "HH:mm:ss"));
        String host = options.get("host", "239.255.3.2");
        int port = options.get("port", 6142);
        InetAddress inetAddress = InetAddress.getByName(host);
        InetSocketAddress address = new InetSocketAddress(inetAddress, port);
        MulticastSocket multicast = new MulticastSocket(port);
        multicast.joinGroup(inetAddress);
        if (options.has("reuse-address")) {
            multicast.setReuseAddress(options.get("reuse-address", false));
        }
        if (options.has("broadcast")) {
            multicast.setBroadcast(options.get("broadcast", false));
        }
        if (options.has("loopback-mode")) {
            multicast.setLoopbackMode(options.get("loopback-mode", false));
        }
        if (options.has("send-buffer-size")) {
            multicast.setSendBufferSize(options.get("send-buffer-size", 0));
        }
        if (options.has("receive-buffer-size")) {
            multicast.setReceiveBufferSize(options.get("receive-buffer-size", 0));
        }
        if (options.has("so-timeout")) {
            multicast.setSoTimeout(options.get("so-timeout", 0));
        }
        if (options.has("time-to-live")) {
            multicast.setTimeToLive(options.get("time-to-live", 0));
        }
        if (options.has("traffic-class")) {
            multicast.setTrafficClass(options.get("traffic-class", 0));
        }
        System.out.println("Connected");
        MulticastTool.print("host", host);
        MulticastTool.print("port", port);
        System.out.println();
        System.out.println("Socket");
        MulticastTool.print("broadcast", multicast.getBroadcast());
        MulticastTool.print("loopback-mode", multicast.getLoopbackMode());
        MulticastTool.print("receive-buffer-size", multicast.getReceiveBufferSize());
        MulticastTool.print("reuse-address", multicast.getReuseAddress());
        MulticastTool.print("send-buffer-size", multicast.getSendBufferSize());
        MulticastTool.print("so-timeout", multicast.getSoTimeout());
        MulticastTool.print("time-to-live", multicast.getTimeToLive());
        MulticastTool.print("traffic-class", multicast.getTrafficClass());
        System.out.println();
        if (options.has("send")) {
            String send = options.get("send", "");
            long rate = options.get("rate", 1000);
            System.out.println("Sending");
            MulticastTool.print("send", send);
            MulticastTool.print("rate", rate);
            System.out.println();
            Send message = new Send(address, multicast, send);
            if (rate > 0L) {
                Timer timer = new Timer("Multicast Send", true);
                timer.scheduleAtFixedRate((TimerTask)message, 0L, rate);
            } else {
                message.run();
                message.close();
            }
        }
        System.out.println("Listening....");
        byte[] buf = new byte[8192];
        DatagramPacket packet = new DatagramPacket(buf, 0, buf.length);
        while (true) {
            try {
                while (true) {
                    multicast.receive(packet);
                    if (packet.getLength() <= 0) continue;
                    StringBuilder sb = new StringBuilder();
                    sb.append(format.format(new Date()));
                    sb.append(" - ");
                    sb.append(packet.getAddress().getHostAddress());
                    sb.append(" - ");
                    String str = new String(packet.getData(), packet.getOffset(), packet.getLength());
                    sb.append(str);
                    System.out.println(sb.toString());
                }
            }
            catch (SocketTimeoutException e) {
                StringBuilder sb = new StringBuilder();
                sb.append(format.format(new Date()));
                sb.append(" - ");
                sb.append("ERROR");
                sb.append(" - ");
                sb.append(e.getMessage());
                System.out.println(sb.toString());
                continue;
            }
            break;
        }
    }

    private static void print(String name, Object value) {
        System.out.printf(" %-20s: %s", name, value);
        System.out.println();
    }

    static class Send
    extends TimerTask {
        private final MulticastSocket multicast;
        private final String text;
        private final SocketAddress address;

        public Send(SocketAddress address, MulticastSocket multicast, String text) {
            this.address = address;
            this.multicast = multicast;
            this.text = text;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }

        private void close() {
            try {
                this.multicast.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            try {
                byte[] data = this.text.getBytes();
                DatagramPacket packet = new DatagramPacket(data, 0, data.length, this.address);
                this.multicast.send(packet);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public boolean cancel() {
            this.close();
            return super.cancel();
        }
    }
}

