/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.openejb.client.ClusterableResponse;
import org.apache.openejb.client.EJBRequest;
import org.apache.openejb.client.ProtocolMetaData;
import org.apache.openejb.client.ServerMetaData;
import org.apache.openejb.client.ThrowableArtifact;

public class EJBResponse
implements ClusterableResponse {
    public static final byte VERSION = 2;
    private static final long serialVersionUID = 611943612548626399L;
    private transient byte version = (byte)2;
    private transient int responseCode = -1;
    private transient Object result;
    private transient ServerMetaData server;
    private final transient long[] times = new long[Time.values().length];
    private final transient int timesLength = this.times.length;
    private transient EJBRequest request;
    private transient ProtocolMetaData metaData;

    @Override
    public void setMetaData(ProtocolMetaData metaData) {
        this.metaData = metaData;
    }

    public EJBRequest getRequest() {
        return this.request;
    }

    public void setRequest(EJBRequest request) {
        this.request = request;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public Object getResult() {
        return this.result;
    }

    public void setResponse(byte version, int code, Object result) {
        this.version = version;
        this.responseCode = code;
        this.result = result;
    }

    @Override
    public void setServer(ServerMetaData server) {
        this.server = server;
    }

    public ServerMetaData getServer() {
        return this.server;
    }

    public String toString() {
        StringBuffer s;
        switch (this.responseCode) {
            case 9: {
                s = new StringBuffer("EJB_APP_EXCEPTION");
                break;
            }
            case 11: {
                s = new StringBuffer("EJB_ERROR");
                break;
            }
            case 4: {
                s = new StringBuffer("EJB_OK");
                break;
            }
            case 5: {
                s = new StringBuffer("EJB_OK_CREATE");
                break;
            }
            case 6: {
                s = new StringBuffer("EJB_OK_FOUND");
                break;
            }
            case 7: {
                s = new StringBuffer("EJB_OK_FOUND_COLLECTION");
                break;
            }
            case 20: {
                s = new StringBuffer("EJB_OK_FOUND_ENUMERATION");
                break;
            }
            case 8: {
                s = new StringBuffer("EJB_OK_NOT_FOUND");
                break;
            }
            case 10: {
                s = new StringBuffer("EJB_SYS_EXCEPTION");
                break;
            }
            case 3: {
                s = new StringBuffer("AUTH_DENIED");
                break;
            }
            default: {
                s = new StringBuffer("UNKNOWN_RESPONSE");
            }
        }
        s.append(", serverTime=").append(this.times[Time.TOTAL.ordinal()]).append("ns");
        s.append(", containerTime").append(this.times[Time.CONTAINER.ordinal()]).append("ns");
        s.append(" : ").append(this.result);
        return s.toString();
    }

    public void start(Time time) {
        this.times[time.ordinal()] = System.nanoTime();
    }

    public void stop(Time time) {
        this.times[time.ordinal()] = System.nanoTime() - this.times[time.ordinal()];
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        boolean readServer = in.readBoolean();
        if (readServer) {
            this.server = new ServerMetaData();
            this.server.setMetaData(this.metaData);
            this.server.readExternal(in);
        }
        this.responseCode = in.readByte();
        this.result = in.readObject();
        if (version >= 2) {
            int size = in.readByte();
            for (int i = 0; i < size && i < this.timesLength; ++i) {
                this.times[i] = in.readLong();
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(this.version);
        if (null != this.server) {
            out.writeBoolean(true);
            this.server.setMetaData(this.metaData);
            this.server.writeExternal(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeByte(this.responseCode);
        switch (this.responseCode) {
            case 3: 
            case 9: 
            case 10: 
            case 11: {
                if (!(this.result instanceof Throwable)) break;
                Throwable throwable = (Throwable)this.result;
                this.result = new ThrowableArtifact(throwable);
            }
        }
        this.start(Time.SERIALIZATION);
        out.writeObject(this.result);
        this.stop(Time.SERIALIZATION);
        this.stop(Time.TOTAL);
        if (this.version >= 2) {
            out.writeByte(this.timesLength);
            for (long time : this.times) {
                out.writeLong(time);
            }
        }
    }

    public static enum Time {
        TOTAL,
        CONTAINER,
        SERIALIZATION,
        DESERIALIZATION;

    }
}

