/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client.corba;

public final class InstanceOf {
    private static final Class<?> STUB;
    private static final Class<?> PORTABLE_REMOTE_OBJECT;
    private static final Class<?> REMOTE;

    private InstanceOf() {
    }

    public static boolean isStub(Object instance) {
        return STUB != null && STUB.isInstance(instance);
    }

    public static boolean isRemote(Object obj) {
        return REMOTE != null && PORTABLE_REMOTE_OBJECT != null && REMOTE.isInstance(obj) && PORTABLE_REMOTE_OBJECT.isInstance(obj);
    }

    static {
        Class<?> stub = null;
        Class<?> pro = null;
        Class<?> remote = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            stub = loader.loadClass("javax.rmi.CORBA.Stub");
            pro = loader.loadClass("javax.rmi.PortableRemoteObject");
            remote = loader.loadClass("java.rmi.Remote");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        STUB = stub;
        PORTABLE_REMOTE_OBJECT = pro;
        REMOTE = remote;
    }
}

