/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.reflection.Reflections;
import org.apache.xbean.finder.ResourceFinder;

public final class Extensions {
    private static final Logger LOGGER = Logger.getInstance(LogCategory.OPENEJB, Extensions.class);

    private Extensions() {
    }

    public static Collection<Class<?>> findExtensions(Finder finder) {
        try {
            return finder.findAvailableClasses("org.apache.openejb.extension");
        }
        catch (IOException e) {
            LOGGER.error("Extension scanning of 'META-INF/org.apache.openejb.extension' files failed", e);
            return Collections.emptySet();
        }
    }

    public static void installExtensions(Finder finder) {
        try {
            List classes = finder.findAvailableClasses("org.apache.openejb.extension");
            Extensions.addExtensions(classes);
        }
        catch (IOException e) {
            LOGGER.error("Extension scanning of 'META-INF/org.apache.openejb.extension' files failed", e);
        }
    }

    public static void addExtensions(ClassLoader loader, Collection<String> classes) {
        for (String clazz : classes) {
            try {
                Object object = loader.loadClass(clazz).newInstance();
                SystemInstance.get().addObserver(object);
            }
            catch (Throwable t) {
                LOGGER.error("Extension construction failed" + clazz, t);
            }
        }
    }

    public static void addExtensions(Collection<Class<?>> classes) {
        for (Class<?> clazz : classes) {
            try {
                Object object = clazz.newInstance();
                SystemInstance.get().addObserver(object);
            }
            catch (Throwable t) {
                LOGGER.error("Extension construction failed" + clazz.getName(), t);
            }
        }
    }

    public static class Finder
    extends ResourceFinder {
        public Finder(String path, boolean useLoader, URL ... urls) {
            super(path, urls);
            if (!(useLoader || urls != null && urls.length != 0)) {
                Reflections.set((Object)this, "urls", new URL[0]);
            }
        }

        public List<String> findAvailableStrings(String uri) throws IOException {
            List strings = super.findAvailableStrings(uri);
            if (!strings.isEmpty()) {
                ArrayList copy = new ArrayList(strings);
                strings.clear();
                for (String s : copy) {
                    strings.addAll(Arrays.asList(s.replace("\r", "").split("\n")));
                }
            }
            return strings;
        }
    }
}

