/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.locks.ReentrantLock;
import javax.validation.ValidatorFactory;
import org.apache.openejb.assembler.classic.ValidationInfo;
import org.apache.openejb.assembler.classic.ValidatorBuilder;

public class LazyValidatorFactory
implements InvocationHandler {
    private final ReentrantLock lock = new ReentrantLock();
    private final ClassLoader loader;
    private final ValidationInfo info;
    private volatile ValidatorFactory factory;

    public LazyValidatorFactory(ClassLoader classLoader, ValidationInfo validationInfo) {
        this.loader = classLoader;
        this.info = validationInfo;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.ensureDelegate();
        try {
            return method.invoke((Object)this.factory, args);
        }
        catch (InvocationTargetException ite) {
            throw ite.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureDelegate() {
        if (this.factory == null) {
            ReentrantLock l = this.lock;
            l.lock();
            try {
                if (this.factory == null) {
                    this.factory = ValidatorBuilder.buildFactory(this.loader, this.info);
                }
            }
            finally {
                l.unlock();
            }
        }
    }

    public ValidatorFactory getFactory() {
        this.ensureDelegate();
        return this.factory;
    }
}

