/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.openejb.ClassLoaderUtil;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.api.LocalClient;
import org.apache.openejb.api.RemoteClient;
import org.apache.openejb.cdi.CompositeBeans;
import org.apache.openejb.classloader.ClassLoaderConfigurer;
import org.apache.openejb.classloader.WebAppEnricher;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ClientModule;
import org.apache.openejb.config.ConnectorModule;
import org.apache.openejb.config.DeploymentFilterable;
import org.apache.openejb.config.DeploymentModule;
import org.apache.openejb.config.DeploymentsResolver;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.EmptyEjbJar;
import org.apache.openejb.config.FinderFactory;
import org.apache.openejb.config.Module;
import org.apache.openejb.config.NewLoaderLogic;
import org.apache.openejb.config.PersistenceModule;
import org.apache.openejb.config.QuickJarsTxtParser;
import org.apache.openejb.config.ReadDescriptors;
import org.apache.openejb.config.RequireDescriptors;
import org.apache.openejb.config.ResourcesModule;
import org.apache.openejb.config.TldScanner;
import org.apache.openejb.config.UnknownModuleTypeException;
import org.apache.openejb.config.UnsupportedModuleTypeException;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.config.WebappAggregatedArchive;
import org.apache.openejb.config.WsModule;
import org.apache.openejb.config.event.BeforeDeploymentEvent;
import org.apache.openejb.config.sys.Resources;
import org.apache.openejb.core.EmptyResourcesClassLoader;
import org.apache.openejb.core.ParentClassLoaderFinder;
import org.apache.openejb.jee.Application;
import org.apache.openejb.jee.ApplicationClient;
import org.apache.openejb.jee.Beans;
import org.apache.openejb.jee.Connector;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.FacesConfig;
import org.apache.openejb.jee.JavaWsdlMapping;
import org.apache.openejb.jee.JspConfig;
import org.apache.openejb.jee.Taglib;
import org.apache.openejb.jee.TldTaglib;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.WebserviceDescription;
import org.apache.openejb.jee.Webservices;
import org.apache.openejb.jee.oejb3.OpenejbJar;
import org.apache.openejb.loader.FileUtils;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.sxc.ApplicationXml;
import org.apache.openejb.util.AnnotationFinder;
import org.apache.openejb.util.JarExtractor;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.URLs;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.finder.IAnnotationFinder;
import org.apache.xbean.finder.ResourceFinder;
import org.apache.xbean.finder.UrlSet;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.ClassesArchive;
import org.apache.xbean.finder.filter.Filter;
import org.apache.xbean.finder.filter.Filters;

public class DeploymentLoader
implements DeploymentFilterable {
    public static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP_CONFIG, "org.apache.openejb.util.resources");
    public static final String OPENEJB_ALTDD_PREFIX = "openejb.altdd.prefix";
    private static final String ddDir = "META-INF/";
    public static final String EAR_WEBAPP_PERSISTENCE_XML_JARS = "ear-webapp-persistence-xml-jars";
    public static final String EAR_SCOPED_CDI_BEANS = "ear-scoped-cdi-beans_";
    public static final String RAR_URLS_KEY = "rar-urls";
    public static final String URLS_KEY = "urls";
    private static final String RESOURCES_XML = "resources.xml";
    private static final String WEB_FRAGMENT_XML = "web-fragment.xml";
    private final boolean scanManagedBeans = true;
    private static final Collection<String> KNOWN_DESCRIPTORS = Arrays.asList("app-ctx.xml", "module.properties", "application.properties", "web.xml", "ejb-jar.xml", "openejb-jar.xml", "env-entries.properties", "beans.xml", "ra.xml", "application.xml", "application-client.xml", "persistence-fragment.xml", "persistence.xml", "validation.xml", "exclusions.list");
    private static String ALTDD = SystemInstance.get().getOptions().get("openejb.altdd.prefix", (String)null);
    private volatile List<URL> containerUrls = null;

    @Deprecated
    public AppModule load(File jarFile) throws OpenEJBException {
        return this.load(jarFile, null);
    }

    public AppModule load(File jarFile, ExternalConfiguration config) throws OpenEJBException {
        Class<? extends DeploymentModule> moduleClass;
        block29: {
            AppModule appModule;
            block30: {
                String jarLocation;
                URLClassLoader doNotUseClassLoader;
                URL baseUrl;
                String jarPath;
                block27: {
                    AppModule appModule2;
                    block28: {
                        block25: {
                            AppModule appModule3;
                            block26: {
                                block23: {
                                    AppModule appModule42;
                                    block24: {
                                        block21: {
                                            AppModule appModule5;
                                            block22: {
                                                block19: {
                                                    AppModule appModule62;
                                                    block20: {
                                                        block17: {
                                                            AppModule appModule7;
                                                            block18: {
                                                                try {
                                                                    jarPath = jarFile.getCanonicalPath();
                                                                }
                                                                catch (IOException e) {
                                                                    throw new OpenEJBException("Invalid application file path " + jarFile, e);
                                                                }
                                                                baseUrl = DeploymentLoader.getFileUrl(jarFile);
                                                                doNotUseClassLoader = null;
                                                                try {
                                                                    doNotUseClassLoader = ClassLoaderUtil.createClassLoader(jarPath, new URL[]{baseUrl}, this.getOpenEJBClassLoader());
                                                                    moduleClass = this.discoverModuleType(baseUrl, (ClassLoader)ClassLoaderUtil.createTempClassLoader(doNotUseClassLoader), true);
                                                                }
                                                                catch (Exception e) {
                                                                    throw new UnknownModuleTypeException("Unable to determine module type for jar: " + baseUrl.toExternalForm(), e);
                                                                }
                                                                if (!ResourcesModule.class.equals(moduleClass)) break block17;
                                                                AppModule appModule62 = new AppModule(null, jarPath);
                                                                ResourcesModule module = new ResourcesModule();
                                                                module.getAltDDs().put(RESOURCES_XML, baseUrl);
                                                                ReadDescriptors.readResourcesXml(module);
                                                                module.initAppModule(appModule62);
                                                                appModule7 = appModule62;
                                                                if (null == doNotUseClassLoader) break block18;
                                                                ClassLoaderUtil.destroyClassLoader(doNotUseClassLoader);
                                                            }
                                                            return appModule7;
                                                        }
                                                        if (!AppModule.class.equals(moduleClass)) break block19;
                                                        appModule62 = this.createAppModule(jarFile, jarPath);
                                                        if (null == doNotUseClassLoader) break block20;
                                                        ClassLoaderUtil.destroyClassLoader(doNotUseClassLoader);
                                                    }
                                                    return appModule62;
                                                }
                                                if (!EjbModule.class.equals(moduleClass)) break block21;
                                                URL[] urls = new URL[]{baseUrl};
                                                SystemInstance.get().fireEvent((Object)new BeforeDeploymentEvent(urls));
                                                URLClassLoader classLoader = ClassLoaderUtil.createTempClassLoader(jarPath, urls, this.getOpenEJBClassLoader());
                                                EjbModule ejbModule = this.createEjbModule(baseUrl, jarPath, classLoader);
                                                AppModule appModule42 = new AppModule((DeploymentModule[])new EjbModule[]{ejbModule});
                                                DeploymentLoader.addPersistenceUnits(appModule42, baseUrl);
                                                appModule5 = appModule42;
                                                if (null == doNotUseClassLoader) break block22;
                                                ClassLoaderUtil.destroyClassLoader(doNotUseClassLoader);
                                            }
                                            return appModule5;
                                        }
                                        if (!ClientModule.class.equals(moduleClass)) break block23;
                                        String jarLocation2 = URLs.toFilePath(baseUrl);
                                        ClientModule clientModule = this.createClientModule(baseUrl, jarLocation2, this.getOpenEJBClassLoader(), null);
                                        appModule42 = new AppModule((DeploymentModule[])new ClientModule[]{clientModule});
                                        if (null == doNotUseClassLoader) break block24;
                                        ClassLoaderUtil.destroyClassLoader(doNotUseClassLoader);
                                    }
                                    return appModule42;
                                }
                                try {
                                    AppModule appModule8;
                                    String aliases;
                                    ConnectorModule connectorModule;
                                    if (!ConnectorModule.class.equals(moduleClass) || (connectorModule = DeploymentLoader.createConnectorModule(jarLocation = URLs.toFilePath(baseUrl), jarLocation, this.getOpenEJBClassLoader(), null)) == null) break block25;
                                    ArrayList<ConnectorModule> connectorModules = new ArrayList<ConnectorModule>();
                                    String id = connectorModule.getModuleId();
                                    if (!"true".equalsIgnoreCase(SystemInstance.get().getProperty("openejb.connector." + id + ".skip-default", "false"))) {
                                        connectorModules.add(connectorModule);
                                    }
                                    if ((aliases = SystemInstance.get().getProperty("openejb.connector." + id + ".aliases")) != null) {
                                        for (String alias : aliases.split(",")) {
                                            ConnectorModule aliasModule = DeploymentLoader.createConnectorModule(jarLocation, jarLocation, this.getOpenEJBClassLoader(), alias);
                                            connectorModules.add(aliasModule);
                                        }
                                    }
                                    appModule3 = appModule8 = new AppModule((DeploymentModule[])connectorModules.toArray(new ConnectorModule[connectorModules.size()]));
                                    if (null == doNotUseClassLoader) break block26;
                                }
                                catch (Throwable throwable) {
                                    if (null != doNotUseClassLoader) {
                                        ClassLoaderUtil.destroyClassLoader(doNotUseClassLoader);
                                    }
                                    throw throwable;
                                }
                                ClassLoaderUtil.destroyClassLoader(doNotUseClassLoader);
                            }
                            return appModule3;
                        }
                        if (!WebModule.class.equals(moduleClass)) break block27;
                        File file = URLs.toFile(baseUrl);
                        WebModule webModule = this.createWebModule(file.getAbsolutePath(), baseUrl, this.getOpenEJBClassLoader(), this.getContextRoot(), this.getModuleName(), config);
                        AppModule appModule9 = new AppModule(webModule.getClassLoader(), file.getAbsolutePath(), new Application(), true);
                        DeploymentLoader.addWebModule(webModule, appModule9);
                        DeploymentLoader.addWebModuleDescriptors(baseUrl, webModule, appModule9);
                        appModule9.setStandloneWebModule();
                        appModule9.setDelegateFirst(true);
                        appModule2 = appModule9;
                        if (null == doNotUseClassLoader) break block28;
                        ClassLoaderUtil.destroyClassLoader(doNotUseClassLoader);
                    }
                    return appModule2;
                }
                if (!PersistenceModule.class.equals(moduleClass)) break block29;
                jarLocation = URLs.toFilePath(baseUrl);
                URLClassLoader classLoader = ClassLoaderUtil.createTempClassLoader(jarPath, new URL[]{baseUrl}, this.getOpenEJBClassLoader());
                AppModule appModule10 = new AppModule(classLoader, jarLocation);
                DeploymentLoader.addPersistenceUnits(appModule10, baseUrl);
                appModule = appModule10;
                if (null == doNotUseClassLoader) break block30;
                ClassLoaderUtil.destroyClassLoader(doNotUseClassLoader);
            }
            return appModule;
        }
        throw new UnsupportedModuleTypeException("Unsupported module type: " + moduleClass.getSimpleName());
    }

    public static void addWebModuleDescriptors(URL baseUrl, WebModule webModule, AppModule appModule) throws OpenEJBException {
        HashMap<String, Object> otherDD = new HashMap<String, Object>();
        List<URL> urls = webModule.getScannableUrls();
        ResourceFinder finder = new ResourceFinder("", urls.toArray(new URL[urls.size()]));
        otherDD.putAll(DeploymentLoader.getDescriptors(finder, false));
        try {
            List persistenceXmls = finder.findAll("META-INF/persistence.xml");
            if (persistenceXmls.size() >= 1) {
                URL old = (URL)otherDD.get("persistence.xml");
                if (old != null && !persistenceXmls.contains(old)) {
                    persistenceXmls.add(old);
                }
                otherDD.put("persistence.xml", persistenceXmls);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        DeploymentLoader.addConnectorModules(appModule, webModule);
        DeploymentLoader.addWebPersistenceDD("persistence.xml", otherDD, appModule);
        DeploymentLoader.addWebPersistenceDD("persistence-fragment.xml", otherDD, appModule);
        DeploymentLoader.addPersistenceUnits(appModule, baseUrl);
        DeploymentLoader.addWebFragments(webModule, urls);
    }

    private static void addConnectorModules(AppModule appModule, WebModule webModule) throws OpenEJBException {
        File file;
        String jarLocation;
        ConnectorModule connectorModule;
        if (webModule.getAltDDs().containsKey("ra.xml") && (connectorModule = DeploymentLoader.createConnectorModule(jarLocation = new File(webModule.getJarLocation(), "/WEB-INF/classes").getAbsolutePath(), jarLocation, webModule.getClassLoader(), webModule.getModuleId() + "RA", (URL)webModule.getAltDDs().get("ra.xml"))) != null) {
            appModule.getConnectorModules().add(connectorModule);
        }
        for (URL url : webModule.getRarUrls()) {
            try {
                String jarLocation2;
                ConnectorModule connectorModule2;
                file = URLs.toFile(url);
                if (!file.getName().endsWith(".rar") || (connectorModule2 = DeploymentLoader.createConnectorModule(jarLocation2 = file.getAbsolutePath(), jarLocation2, webModule.getClassLoader(), null)) == null) continue;
                appModule.getConnectorModules().add(connectorModule2);
            }
            catch (Exception e) {
                logger.error("error processing url " + url.toExternalForm(), e);
            }
        }
        for (URL url : webModule.getScannableUrls()) {
            try {
                String jarLocation3;
                ConnectorModule connectorModule3;
                file = URLs.toFile(url);
                if (!file.getName().endsWith(".jar")) continue;
                JarFile jarFile = new JarFile(file);
                String name = (ALTDD != null ? ALTDD + "." : "") + "ra.xml";
                JarEntry entry = jarFile.getJarEntry(name);
                if (entry == null) {
                    name = ddDir + name;
                    entry = jarFile.getJarEntry(name);
                }
                if (entry == null || (connectorModule3 = DeploymentLoader.createConnectorModule(jarLocation3 = file.getAbsolutePath(), jarLocation3, webModule.getClassLoader(), null)) == null) continue;
                appModule.getConnectorModules().add(connectorModule3);
            }
            catch (Exception e) {
                logger.error("error processing url " + url.toExternalForm(), e);
            }
        }
    }

    protected ClassLoader getOpenEJBClassLoader() {
        return ParentClassLoaderFinder.Helper.get();
    }

    private static void addWebPersistenceDD(String name, Map<String, Object> otherDD, AppModule appModule) {
        if (otherDD.containsKey(name)) {
            ArrayList<URL> persistenceUrls = (ArrayList<URL>)appModule.getAltDDs().get(name);
            if (persistenceUrls == null) {
                persistenceUrls = new ArrayList<URL>();
                appModule.getAltDDs().put(name, persistenceUrls);
            }
            if (otherDD.containsKey(name)) {
                Object otherUrl = otherDD.get(name);
                if (otherUrl instanceof URL && !persistenceUrls.contains(otherUrl)) {
                    persistenceUrls.add((URL)otherUrl);
                } else if (otherUrl instanceof List) {
                    List otherList = (List)otherDD.get(name);
                    for (URL url : otherList) {
                        if (persistenceUrls.contains(url)) continue;
                        persistenceUrls.add(url);
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected AppModule createAppModule(File jarFile, String jarPath) throws OpenEJBException {
        File appDir = DeploymentLoader.unpack(jarFile);
        try {
            appDir = appDir.getCanonicalFile();
        }
        catch (IOException e) {
            throw new OpenEJBException("Invalid application directory " + appDir.getAbsolutePath());
        }
        URL appUrl = DeploymentLoader.getFileUrl(appDir);
        String appId = appDir.getAbsolutePath();
        URLClassLoader tmpClassLoader = ClassLoaderUtil.createTempClassLoader(appId, new URL[]{appUrl}, this.getOpenEJBClassLoader());
        ResourceFinder finder = new ResourceFinder("", (ClassLoader)tmpClassLoader, new URL[]{appUrl});
        Map<String, URL> appDescriptors = DeploymentLoader.getDescriptors(finder);
        try {
            String absolutePath;
            Map libs;
            Application application;
            LinkedHashMap<String, URL> ejbModules = new LinkedHashMap<String, URL>();
            LinkedHashMap<String, URL> clientModules = new LinkedHashMap<String, URL>();
            LinkedHashMap<String, URL> resouceModules = new LinkedHashMap<String, URL>();
            LinkedHashMap<String, URL> webModules = new LinkedHashMap<String, URL>();
            LinkedHashMap<String, String> webContextRoots = new LinkedHashMap<String, String>();
            URL applicationXmlUrl = appDescriptors.get("application.xml");
            ArrayList<URL> extraLibs = new ArrayList<URL>();
            if (applicationXmlUrl != null) {
                application = DeploymentLoader.unmarshal(applicationXmlUrl);
                for (org.apache.openejb.jee.Module module : application.getModule()) {
                    try {
                        URL url;
                        if (module.getEjb() != null) {
                            url = finder.find(module.getEjb().trim());
                            ejbModules.put(module.getEjb(), url);
                            continue;
                        }
                        if (module.getJava() != null) {
                            url = finder.find(module.getJava().trim());
                            clientModules.put(module.getJava(), url);
                            extraLibs.add(url);
                            continue;
                        }
                        if (module.getConnector() != null) {
                            url = finder.find(module.getConnector().trim());
                            resouceModules.put(module.getConnector(), url);
                            continue;
                        }
                        if (module.getWeb() == null) continue;
                        url = finder.find(module.getWeb().getWebUri().trim());
                        webModules.put(module.getWeb().getWebUri(), url);
                        webContextRoots.put(module.getWeb().getWebUri(), module.getWeb().getContextRoot());
                    }
                    catch (IOException e) {
                        throw new OpenEJBException("Invalid path to module " + e.getMessage(), e);
                    }
                }
            } else {
                application = new Application();
                HashMap<String, URL> files = new HashMap<String, URL>();
                DeploymentLoader.scanDir(appDir, files, "", false);
                files.remove("META-INF/MANIFEST.MF");
                this.createApplicationFromFiles(appId, tmpClassLoader, ejbModules, clientModules, resouceModules, webModules, files);
            }
            ClassLoaderConfigurer configurer = QuickJarsTxtParser.parse(new File(appDir, "META-INF/jars.txt"));
            ArrayList<URL> jarsXmlLib = new ArrayList<URL>();
            if (configurer != null) {
                void var21_29;
                URL[] arr$ = configurer.additionalURLs();
                int len$ = arr$.length;
                boolean bl = false;
                while (var21_29 < len$) {
                    URL url = arr$[var21_29];
                    try {
                        this.detectAndAddModuleToApplication(appId, tmpClassLoader, ejbModules, clientModules, resouceModules, webModules, (Map.Entry<String, URL>)new ImmutablePair((Object)URLs.toFile(url).getAbsolutePath(), (Object)url));
                    }
                    catch (Exception e) {
                        jarsXmlLib.add(url);
                    }
                    ++var21_29;
                }
            }
            if (application.getLibraryDirectory() == null) {
                application.setLibraryDirectory("lib/");
            } else {
                String dir = application.getLibraryDirectory();
                if (!dir.endsWith("/")) {
                    application.setLibraryDirectory(dir + "/");
                }
            }
            try {
                libs = finder.getResourcesMap(application.getLibraryDirectory());
                extraLibs.addAll(libs.values());
            }
            catch (IOException e) {
                logger.warning("Cannot load libs from '" + application.getLibraryDirectory() + "' : " + e.getMessage(), e);
            }
            try {
                libs = finder.getResourcesMap("APP-INF/lib/");
                extraLibs.addAll(libs.values());
            }
            catch (IOException e) {
                logger.warning("Cannot load libs from 'APP-INF/lib/' : " + e.getMessage(), e);
            }
            try {
                libs = finder.getResourcesMap("META-INF/lib/");
                extraLibs.addAll(libs.values());
            }
            catch (IOException e) {
                logger.warning("Cannot load libs from 'META-INF/lib/' : " + e.getMessage(), e);
            }
            HashMap<String, URL> rarLibs = new HashMap<String, URL>();
            for (Map.Entry entry : resouceModules.entrySet()) {
                try {
                    File rarFile = URLs.toFile((URL)entry.getValue());
                    rarFile = DeploymentLoader.unpack(rarFile);
                    entry.setValue(rarFile.toURI().toURL());
                    DeploymentLoader.scanDir(appDir, rarLibs, "");
                }
                catch (MalformedURLException e) {
                    throw new OpenEJBException("Malformed URL to app. " + e.getMessage(), e);
                }
            }
            Iterator iterator = rarLibs.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!((String)entry.getKey()).endsWith(".jar")) continue;
                iterator.remove();
            }
            ArrayList<Object> classPath = new ArrayList<Object>();
            classPath.addAll(ejbModules.values());
            classPath.addAll(clientModules.values());
            classPath.addAll(rarLibs.values());
            classPath.addAll(extraLibs);
            classPath.addAll(jarsXmlLib);
            URL[] uRLArray = classPath.toArray(new URL[classPath.size()]);
            SystemInstance.get().fireEvent((Object)new BeforeDeploymentEvent(uRLArray));
            URLClassLoader appClassLoader = ClassLoaderUtil.createTempClassLoader(appId, uRLArray, this.getOpenEJBClassLoader());
            final AppModule appModule = new AppModule(appClassLoader, appId, application, false);
            appModule.getAdditionalLibraries().addAll(extraLibs);
            appModule.getAltDDs().putAll(appDescriptors);
            appModule.getWatchedResources().add(appId);
            if (applicationXmlUrl != null) {
                appModule.getWatchedResources().add(URLs.toFilePath(applicationXmlUrl));
            }
            if (appDescriptors.containsKey(RESOURCES_XML)) {
                final HashMap<String, URL> altDd = new HashMap<String, URL>(appDescriptors);
                ReadDescriptors.readResourcesXml(new Module(false){

                    @Override
                    public Map<String, Object> getAltDDs() {
                        return altDd;
                    }

                    @Override
                    public void initResources(Resources resources) {
                        appModule.getContainers().addAll(resources.getContainer());
                        appModule.getResources().addAll(resources.getResource());
                        appModule.getServices().addAll(resources.getService());
                    }
                });
            }
            for (String moduleName : ejbModules.keySet()) {
                try {
                    URL ejbUrl = (URL)ejbModules.get(moduleName);
                    if (ClassLoaderUtil.isUrlCached(appModule.getJarLocation(), ejbUrl)) {
                        try {
                            ejbUrl = ClassLoaderUtil.getUrlCachedName(appModule.getJarLocation(), ejbUrl).toURI().toURL();
                        }
                        catch (MalformedURLException ignore) {
                            // empty catch block
                        }
                    }
                    File ejbFile = URLs.toFile(ejbUrl);
                    absolutePath = ejbFile.getAbsolutePath();
                    EjbModule ejbModule = this.createEjbModule(ejbUrl, absolutePath, appClassLoader);
                    appModule.getEjbModules().add(ejbModule);
                }
                catch (OpenEJBException e) {
                    logger.error("Unable to load EJBs from EAR: " + appId + ", module: " + moduleName + ". Exception: " + e.getMessage(), e);
                }
            }
            for (String moduleName : clientModules.keySet()) {
                try {
                    URL clientUrl = (URL)clientModules.get(moduleName);
                    if (ClassLoaderUtil.isUrlCached(appModule.getJarLocation(), clientUrl)) {
                        try {
                            clientUrl = ClassLoaderUtil.getUrlCachedName(appModule.getJarLocation(), clientUrl).toURI().toURL();
                        }
                        catch (MalformedURLException ignore) {
                            // empty catch block
                        }
                    }
                    File clientFile = URLs.toFile(clientUrl);
                    absolutePath = clientFile.getAbsolutePath();
                    ClientModule clientModule = this.createClientModule(clientUrl, absolutePath, appClassLoader, null);
                    appModule.getClientModules().add(clientModule);
                }
                catch (Exception e) {
                    logger.error("Unable to load App Client from EAR: " + appId + ", module: " + moduleName + ". Exception: " + e.getMessage(), e);
                }
            }
            for (String moduleName : resouceModules.keySet()) {
                try {
                    ConnectorModule connectorModule;
                    URL rarUrl = (URL)resouceModules.get(moduleName);
                    if (ClassLoaderUtil.isUrlCached(appModule.getJarLocation(), rarUrl)) {
                        try {
                            rarUrl = ClassLoaderUtil.getUrlCachedName(appModule.getJarLocation(), rarUrl).toURI().toURL();
                        }
                        catch (MalformedURLException ignore) {
                            // empty catch block
                        }
                    }
                    if ((connectorModule = DeploymentLoader.createConnectorModule(appId, URLs.toFilePath(rarUrl), appClassLoader, moduleName)) == null) continue;
                    appModule.getConnectorModules().add(connectorModule);
                }
                catch (OpenEJBException e) {
                    logger.error("Unable to load RAR: " + appId + ", module: " + moduleName + ". Exception: " + e.getMessage(), e);
                }
            }
            for (String moduleName : webModules.keySet()) {
                try {
                    URL warUrl = (URL)webModules.get(moduleName);
                    this.addWebModule(appModule, warUrl, appClassLoader, (String)webContextRoots.get(moduleName), null);
                }
                catch (OpenEJBException e) {
                    logger.error("Unable to load WAR: " + appId + ", module: " + moduleName + ". Exception: " + e.getMessage(), e);
                }
            }
            this.addBeansXmls(appModule);
            Properties p = new Properties();
            p.put(appModule.getModuleId(), appModule.getJarLocation());
            FileUtils base = new FileUtils(appModule.getModuleId(), appModule.getModuleId(), (Hashtable)p);
            ArrayList<URL> filteredUrls = new ArrayList<URL>();
            DeploymentsResolver.loadFromClasspath(base, filteredUrls, appModule.getClassLoader());
            DeploymentLoader.addPersistenceUnits(appModule, filteredUrls.toArray(new URL[filteredUrls.size()]));
            Object pXmls = appModule.getAltDDs().get("persistence.xml");
            for (WebModule webModule : appModule.getWebModules()) {
                ArrayList<URL> foundRootUrls = new ArrayList<URL>();
                List<URL> scannableUrls = webModule.getScannableUrls();
                for (URL url : scannableUrls) {
                    if (DeploymentLoader.addPersistenceUnits(appModule, url).isEmpty()) continue;
                    foundRootUrls.add(url);
                }
                if (pXmls != null && Collection.class.isInstance(pXmls)) {
                    File webapp = webModule.getFile();
                    if (webapp == null) continue;
                    String webappAbsolutePath = webapp.getAbsolutePath();
                    Collection list = (Collection)Collection.class.cast(pXmls);
                    for (URL url : list) {
                        try {
                            File file = URLs.toFile(url);
                            if (!file.getAbsolutePath().startsWith(webappAbsolutePath)) continue;
                            foundRootUrls.add(url);
                        }
                        catch (IllegalArgumentException iae) {}
                    }
                }
                webModule.getAltDDs().put(EAR_WEBAPP_PERSISTENCE_XML_JARS, foundRootUrls);
            }
            for (DeploymentModule module : appModule.getDeploymentModule()) {
                module.setStandaloneModule(false);
            }
            return appModule;
        }
        catch (OpenEJBException e) {
            logger.error("Unable to load EAR: " + jarPath, e);
            throw e;
        }
    }

    private void createApplicationFromFiles(String appId, ClassLoader tmpClassLoader, Map<String, URL> ejbModules, Map<String, URL> clientModules, Map<String, URL> resouceModules, Map<String, URL> webModules, HashMap<String, URL> files) throws OpenEJBException {
        for (Map.Entry<String, URL> entry : files.entrySet()) {
            if (!entry.getKey().matches(".*\\.(jar|war|rar|ear)")) continue;
            try {
                this.detectAndAddModuleToApplication(appId, tmpClassLoader, ejbModules, clientModules, resouceModules, webModules, entry);
            }
            catch (UnsupportedOperationException | UnknownModuleTypeException e) {
                logger.info("Ignoring unknown module type: " + entry.getKey());
            }
            catch (Exception e) {
                throw new OpenEJBException("Unable to determine the module type of " + entry.getKey() + ": Exception: " + e.getMessage(), e);
            }
        }
    }

    private void detectAndAddModuleToApplication(String appId, ClassLoader tmpClassLoader, Map<String, URL> ejbModules, Map<String, URL> clientModules, Map<String, URL> resouceModules, Map<String, URL> webModules, Map.Entry<String, URL> entry) throws IOException, UnknownModuleTypeException {
        URLClassLoader moduleClassLoader = ClassLoaderUtil.createTempClassLoader(appId, new URL[]{entry.getValue()}, tmpClassLoader);
        Class<? extends DeploymentModule> moduleType = this.discoverModuleType(entry.getValue(), (ClassLoader)moduleClassLoader, true);
        if (EjbModule.class.equals(moduleType)) {
            ejbModules.put(entry.getKey(), entry.getValue());
        } else if (ClientModule.class.equals(moduleType)) {
            clientModules.put(entry.getKey(), entry.getValue());
        } else if (ConnectorModule.class.equals(moduleType)) {
            resouceModules.put(entry.getKey(), entry.getValue());
        } else if (WebModule.class.equals(moduleType)) {
            webModules.put(entry.getKey(), entry.getValue());
        }
    }

    protected ClientModule createClientModule(URL clientUrl, String absolutePath, ClassLoader appClassLoader, String moduleName) throws OpenEJBException {
        return this.createClientModule(clientUrl, absolutePath, appClassLoader, moduleName, true);
    }

    protected ClientModule createClientModule(URL clientUrl, String absolutePath, ClassLoader appClassLoader, String moduleName, boolean log) throws OpenEJBException {
        ResourceFinder clientFinder = new ResourceFinder(new URL[]{clientUrl});
        URL manifestUrl = null;
        try {
            manifestUrl = clientFinder.find("META-INF/MANIFEST.MF");
        }
        catch (IOException e) {
            // empty catch block
        }
        String mainClass = null;
        if (manifestUrl != null) {
            try {
                InputStream is = IO.read((URL)manifestUrl);
                Manifest manifest = new Manifest(is);
                mainClass = manifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
            }
            catch (IOException e) {
                throw new OpenEJBException("Unable to determine Main-Class defined in META-INF/MANIFEST.MF file", e);
            }
        }
        Map<String, URL> descriptors = DeploymentLoader.getDescriptors(clientFinder, log);
        ApplicationClient applicationClient = null;
        URL clientXmlUrl = descriptors.get("application-client.xml");
        if (clientXmlUrl != null) {
            applicationClient = ReadDescriptors.readApplicationClient(clientXmlUrl);
        }
        ClientModule clientModule = new ClientModule(applicationClient, appClassLoader, absolutePath, mainClass, moduleName);
        clientModule.getAltDDs().putAll(descriptors);
        if (absolutePath != null) {
            clientModule.getWatchedResources().add(absolutePath);
        }
        if (clientXmlUrl != null && "file".equals(clientXmlUrl.getProtocol())) {
            clientModule.getWatchedResources().add(URLs.toFilePath(clientXmlUrl));
        }
        return clientModule;
    }

    protected EjbModule createEjbModule(URL baseUrl, String jarPath, ClassLoader classLoader) throws OpenEJBException {
        Map<String, URL> descriptors;
        if (baseUrl != null) {
            descriptors = DeploymentLoader.getDescriptors(baseUrl);
        } else {
            try {
                descriptors = this.getDescriptors(classLoader, null);
            }
            catch (IOException e) {
                descriptors = new HashMap<String, URL>();
            }
        }
        EjbJar ejbJar = null;
        URL ejbJarXmlUrl = descriptors.get("ejb-jar.xml");
        if (ejbJarXmlUrl != null) {
            try {
                ejbJar = ReadDescriptors.readEjbJar(ejbJarXmlUrl.openStream());
            }
            catch (IOException e) {
                throw new OpenEJBException(e);
            }
        }
        EjbModule ejbModule = new EjbModule(classLoader, null, jarPath, ejbJar, null);
        ejbModule.getAltDDs().putAll(descriptors);
        if (jarPath != null) {
            ejbModule.getWatchedResources().add(jarPath);
        }
        if (ejbJarXmlUrl != null && "file".equals(ejbJarXmlUrl.getProtocol())) {
            ejbModule.getWatchedResources().add(URLs.toFilePath(ejbJarXmlUrl));
        }
        ejbModule.setClientModule(this.createClientModule(baseUrl, jarPath, classLoader, null, false));
        DeploymentLoader.addWebservices(ejbModule);
        return ejbModule;
    }

    private WebModule createWebModule(String jar, URL warUrl, ClassLoader parentClassLoader, String contextRoot, String moduleName, ExternalConfiguration config) throws OpenEJBException {
        return this.createWebModule(jar, URLs.toFilePath(warUrl), parentClassLoader, contextRoot, moduleName, config);
    }

    public void addWebModule(AppModule appModule, URL warUrl, ClassLoader parentClassLoader, String contextRoot, String moduleName) throws OpenEJBException {
        WebModule webModule = this.createWebModule(appModule.getJarLocation(), URLs.toFilePath(warUrl), parentClassLoader, contextRoot, moduleName, null);
        DeploymentLoader.addWebModule(webModule, appModule);
    }

    public static EjbModule addWebModule(WebModule webModule, AppModule appModule) throws OpenEJBException {
        Object o;
        ArrayList<URL> persistenceXmls;
        Object pXml;
        appModule.getWebModules().add(webModule);
        if (appModule.isStandaloneModule()) {
            appModule.getAdditionalLibraries().addAll(webModule.getUrls());
        }
        ArrayList<URL> arrayList = (pXml = appModule.getAltDDs().get("persistence.xml")) == null ? null : (persistenceXmls = List.class.isInstance(pXml) ? (ArrayList<URL>)pXml : new ArrayList<URL>(Arrays.asList((URL)URL.class.cast(pXml))));
        if (persistenceXmls == null) {
            persistenceXmls = new ArrayList<URL>();
            appModule.getAltDDs().put("persistence.xml", persistenceXmls);
        }
        if ((o = webModule.getAltDDs().get("persistence.xml")) instanceof URL) {
            URL url = (URL)o;
            persistenceXmls.add(url);
        }
        if (o instanceof List) {
            List urls = (List)o;
            persistenceXmls.addAll(urls);
        }
        EjbModule webEjbModule = new EjbModule(webModule.getClassLoader(), webModule.getModuleId(), webModule.getJarLocation(), null, null);
        webEjbModule.setWebapp(true);
        webEjbModule.getAltDDs().putAll(webModule.getAltDDs());
        appModule.getEjbModules().add(webEjbModule);
        try {
            DeploymentLoader.fillEjbJar(webModule, webEjbModule);
            if (webModule.getFinder() == null) {
                IAnnotationFinder finder;
                if (DeploymentLoader.isMetadataComplete(webModule, webEjbModule)) {
                    finder = new AnnotationFinder((Archive)new ClassesArchive(new Class[0]));
                    webModule.setFinder(finder);
                    webEjbModule.setFinder(finder);
                } else {
                    finder = FinderFactory.createFinder(webModule);
                    webModule.setFinder(finder);
                    webEjbModule.setFinder(finder);
                }
            } else if (webEjbModule.getFinder() == null) {
                webEjbModule.setFinder(webModule.getFinder());
            }
        }
        catch (Exception e) {
            throw new OpenEJBException("Unable to create annotation scanner for web module " + webModule.getModuleId(), e);
        }
        DeploymentLoader.addWebservices(webEjbModule);
        return webEjbModule;
    }

    private static void fillEjbJar(WebModule webModule, EjbModule ejbModule) {
        Object o = webModule.getAltDDs().get("ejb-jar.xml");
        if (o != null) {
            return;
        }
        if (ejbModule.getEjbJar() != null) {
            return;
        }
        EjbJar ejbJar = new EjbJar();
        WebApp webApp = webModule.getWebApp();
        ejbJar.setMetadataComplete(webApp.isMetadataComplete());
        ejbModule.setEjbJar(ejbJar);
    }

    private static boolean isMetadataComplete(WebModule webModule, EjbModule ejbModule) {
        if (webModule.getWebApp() == null) {
            return false;
        }
        if (!webModule.getWebApp().isMetadataComplete().booleanValue()) {
            return false;
        }
        if (webModule.getAltDDs().get("beans.xml") == null) {
            return true;
        }
        if (ejbModule.getEjbJar() == null) {
            return true;
        }
        return ejbModule.getEjbJar().isMetadataComplete();
    }

    public WebModule createWebModule(String appId, String warPath, ClassLoader parentClassLoader, String contextRoot, String moduleName, ExternalConfiguration config) throws OpenEJBException {
        ClassLoaderConfigurer configurer;
        Map<String, URL> descriptors;
        File warFile = new File(warPath);
        if (!warFile.isDirectory()) {
            warFile = DeploymentLoader.unpack(warFile);
        }
        try {
            descriptors = DeploymentLoader.getWebDescriptors(warFile);
        }
        catch (IOException e) {
            throw new OpenEJBException("Unable to collect descriptors in web module: " + contextRoot, e);
        }
        URL webXmlUrl = descriptors.get("web.xml");
        WebApp webApp = webXmlUrl != null ? ReadDescriptors.readWebApp(webXmlUrl) : new WebApp();
        ArrayList<URL> webUrls = new ArrayList<URL>();
        this.ensureContainerUrls();
        webUrls.addAll(this.containerUrls);
        SystemInstance systemInstance = SystemInstance.get();
        String externalRepos = systemInstance.getProperty("tomee." + warFile.getName().replace(".war", "") + ".externalRepositories");
        ArrayList<URL> externalUrls = null;
        if (externalRepos != null) {
            externalUrls = new ArrayList<URL>();
            for (String additional : externalRepos.split(",")) {
                String trim = additional.trim();
                if (trim.isEmpty()) continue;
                try {
                    externalUrls.add(new File(trim).toURI().toURL());
                }
                catch (MalformedURLException e) {
                    logger.error(e.getMessage());
                }
            }
            webUrls.addAll(externalUrls);
        }
        Map<String, URL[]> urls = DeploymentLoader.getWebappUrlsAndRars(warFile);
        webUrls.addAll(Arrays.asList((Object[])urls.get(URLS_KEY)));
        ArrayList<URL> addedUrls = new ArrayList<URL>();
        for (URL url : urls.get(RAR_URLS_KEY)) {
            File[] files = DeploymentLoader.unpack(URLs.toFile(url)).listFiles();
            if (files == null) continue;
            for (File f : files) {
                if (!f.getName().endsWith(".jar")) continue;
                try {
                    addedUrls.add(f.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    logger.warning("War path bad: " + f.getAbsolutePath(), e);
                }
            }
        }
        webUrls.addAll(addedUrls);
        if (config != null && config.getClasspath() != null) {
            LinkedHashSet contextXmlUrls = new LinkedHashSet();
            for (String location : config.getClasspath()) {
                try {
                    webUrls.add(new File(location).toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            webUrls.addAll(contextXmlUrls);
        }
        if ((configurer = QuickJarsTxtParser.parse(new File(warFile, "WEB-INF/jars.txt"))) != null) {
            ClassLoaderConfigurer.Helper.configure(webUrls, configurer);
        }
        URL[] webUrlsArray = webUrls.toArray(new URL[webUrls.size()]);
        systemInstance.fireEvent((Object)new BeforeDeploymentEvent(webUrlsArray, parentClassLoader));
        URLClassLoader warClassLoader = ClassLoaderUtil.createTempClassLoader(appId, webUrlsArray, parentClassLoader);
        List<URL> scannableUrls = DeploymentLoader.filterWebappUrls(webUrlsArray, descriptors.get("exclusions.list"));
        if (Boolean.parseBoolean(systemInstance.getProperty("openejb.core.skip-war-in-loader", "true"))) {
            File archive = warFile;
            if (!archive.getName().endsWith(".war")) {
                archive = new File(warFile.getParentFile(), warFile.getName() + ".war");
                String unpackDir = systemInstance.getProperty("tomee.unpack.dir");
                if (unpackDir != null && !archive.isFile()) {
                    try {
                        archive = new File(systemInstance.getBase().getDirectory(unpackDir, false), warFile.getName());
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
            if (archive.isFile()) {
                try {
                    scannableUrls.remove(archive.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
        }
        if (externalUrls != null) {
            for (URL url : externalUrls) {
                if (!scannableUrls.contains(url)) continue;
                scannableUrls.remove(url);
                scannableUrls.add(0, url);
            }
        }
        WebModule webModule = new WebModule(webApp, contextRoot, warClassLoader, warFile.getAbsolutePath(), moduleName);
        webModule.setUrls(webUrls);
        webModule.setAddedUrls(addedUrls);
        webModule.setRarUrls(Arrays.asList((Object[])urls.get(RAR_URLS_KEY)));
        webModule.setScannableUrls(scannableUrls);
        webModule.getAltDDs().putAll(descriptors);
        webModule.getWatchedResources().add(warPath);
        webModule.getWatchedResources().add(warFile.getAbsolutePath());
        if (webXmlUrl != null && "file".equals(webXmlUrl.getProtocol())) {
            webModule.getWatchedResources().add(URLs.toFilePath(webXmlUrl));
        }
        this.addTagLibraries(webModule);
        DeploymentLoader.addWebservices(webModule);
        this.addFacesConfigs(webModule);
        DeploymentLoader.addBeansXmls(webModule);
        return webModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureContainerUrls() {
        if (this.containerUrls == null) {
            if ("true".equalsIgnoreCase(SystemInstance.get().getProperty("openejb.scan.webapp.container", "false"))) {
                DeploymentLoader deploymentLoader = this;
                synchronized (deploymentLoader) {
                    if (this.containerUrls == null) {
                        try {
                            UrlSet urlSet = new UrlSet(ParentClassLoaderFinder.Helper.get());
                            urlSet = URLs.cullSystemJars(urlSet);
                            urlSet = NewLoaderLogic.applyBuiltinExcludes(urlSet);
                            this.containerUrls = urlSet.getUrls();
                            boolean skipContainerFolders = "true".equalsIgnoreCase(SystemInstance.get().getProperty("openejb.scan.webapp.container.skip-folder", "true"));
                            Iterator<URL> it = this.containerUrls.iterator();
                            while (it.hasNext()) {
                                File file = URLs.toFile(it.next());
                                String name = file.getName();
                                if ((!skipContainerFolders || !file.isDirectory()) && !name.endsWith("tomcat-websocket.jar") && !name.startsWith("commons-jcs-") && !name.startsWith("xx-arquillian-tomee") && (!"lib".equals(name) || !file.isDirectory() || !new File(System.getProperty("openejb.base", "-")).equals(file.getParentFile()))) continue;
                                it.remove();
                            }
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage(), e);
                        }
                    }
                }
            }
            this.containerUrls = Collections.emptyList();
        }
    }

    public static List<URL> filterWebappUrls(URL[] webUrls, URL exclusions) {
        Filter excludeFilter = null;
        if (exclusions != null) {
            try {
                String[] prefixes = NewLoaderLogic.readInputStreamList(exclusions.openStream());
                excludeFilter = Filters.prefixes((String[])prefixes);
            }
            catch (IOException e) {
                logger.warning("can't read " + exclusions.toExternalForm());
            }
        }
        UrlSet urls = new UrlSet(webUrls);
        try {
            urls = NewLoaderLogic.applyBuiltinExcludes(urls, null, excludeFilter);
        }
        catch (MalformedURLException e) {
            return Arrays.asList(webUrls);
        }
        return urls.getUrls();
    }

    public static void addBeansXmls(WebModule webModule) {
        List<URL> urls = webModule.getScannableUrls();
        URLClassLoader loader = new URLClassLoader(urls.toArray(new URL[urls.size()]), (ClassLoader)new EmptyResourcesClassLoader());
        LinkedList<URL> xmls = new LinkedList<URL>();
        try {
            URL e = (URL)webModule.getAltDDs().get("beans.xml");
            if (e != null) {
                xmls.add(e);
            }
            xmls.addAll(Collections.list(loader.getResources("META-INF/beans.xml")));
        }
        catch (IOException e) {
            return;
        }
        CompositeBeans complete = new CompositeBeans();
        for (URL url : xmls) {
            if (url == null) continue;
            DeploymentLoader.mergeBeansXml(complete, url);
        }
        if (!complete.getDiscoveryByUrl().isEmpty()) {
            complete.removeDuplicates();
        }
        webModule.getAltDDs().put("beans.xml", (Object)complete);
    }

    private static Beans mergeBeansXml(CompositeBeans current, URL url) {
        try {
            Beans beans;
            try {
                beans = ReadDescriptors.readBeans(url.openStream());
            }
            catch (IOException e) {
                return current;
            }
            DeploymentLoader.doMerge(url, current, beans);
        }
        catch (OpenEJBException e) {
            logger.error("Unable to read beans.xml from: " + url.toExternalForm(), e);
        }
        return current;
    }

    public static void doMerge(URL url, CompositeBeans current, Beans beans) {
        current.mergeClasses(url, beans);
        current.getScan().getExclude().addAll(beans.getScan().getExclude());
        ReadDescriptors.checkDuplicatedByBeansXml(beans, current);
        String beanDiscoveryMode = beans.getBeanDiscoveryMode();
        current.getDiscoveryByUrl().put(url, beanDiscoveryMode == null ? "ALL" : beanDiscoveryMode);
    }

    private void addBeansXmls(AppModule appModule) {
        IAnnotationFinder finder;
        ArrayList<URL> xmls;
        List<URL> urls = appModule.getAdditionalLibraries();
        URLClassLoader loader = new URLClassLoader(urls.toArray(new URL[urls.size()]));
        try {
            xmls = Collections.list(loader.getResources("META-INF/beans.xml"));
        }
        catch (IOException e) {
            return;
        }
        CompositeBeans complete = new CompositeBeans();
        for (URL url : xmls) {
            if (url == null) continue;
            DeploymentLoader.mergeBeansXml(complete, url);
        }
        if (complete.getDiscoveryByUrl().isEmpty()) {
            return;
        }
        complete.removeDuplicates();
        this.ensureContainerUrls();
        appModule.getScannableContainerUrls().addAll(this.containerUrls);
        try {
            finder = FinderFactory.createFinder(appModule);
        }
        catch (Exception e) {
            finder = new FinderFactory.ModuleLimitedFinder(new FinderFactory.OpenEJBAnnotationFinder(new WebappAggregatedArchive(appModule.getClassLoader(), appModule.getAltDDs(), xmls)));
        }
        appModule.setEarLibFinder(finder);
        EjbModule ejbModule = new EjbModule(appModule.getClassLoader(), EAR_SCOPED_CDI_BEANS + appModule.getModuleId(), new EjbJar(), new OpenejbJar());
        ejbModule.setBeans(complete);
        ejbModule.setFinder(finder);
        ejbModule.setEjbJar(new EmptyEjbJar());
        appModule.getEjbModules().add(ejbModule);
    }

    protected String getContextRoot() {
        return null;
    }

    protected String getModuleName() {
        return null;
    }

    public static Map<String, URL[]> getWebappUrlsAndRars(File warFile) {
        WebAppEnricher enricher;
        File[] list;
        HashSet<URL> webClassPath = new HashSet<URL>();
        HashSet<URL> webRars = new HashSet<URL>();
        File webInfDir = new File(warFile, "WEB-INF");
        try {
            webClassPath.add(new File(webInfDir, "classes").toURI().toURL());
        }
        catch (MalformedURLException e) {
            logger.warning("War path bad: " + new File(webInfDir, "classes"), e);
        }
        File libDir = new File(webInfDir, "lib");
        if (libDir.exists() && (list = libDir.listFiles()) != null) {
            for (File file : list) {
                String name = file.getName();
                if (name.endsWith(".jar") || name.endsWith(".zip")) {
                    try {
                        webClassPath.add(file.toURI().toURL());
                    }
                    catch (MalformedURLException e) {
                        logger.warning("War path bad: " + file, e);
                    }
                    continue;
                }
                if (!name.endsWith(".rar")) continue;
                try {
                    webRars.add(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    logger.warning("War path bad: " + file, e);
                }
            }
        }
        if ((enricher = (WebAppEnricher)SystemInstance.get().getComponent(WebAppEnricher.class)) != null) {
            webClassPath.addAll(Arrays.asList(enricher.enrichment(null)));
        }
        HashMap<String, URL[]> urls = new HashMap<String, URL[]>();
        urls.put(URLS_KEY, webClassPath.toArray(new URL[webClassPath.size()]));
        urls.put(RAR_URLS_KEY, webRars.toArray(new URL[webRars.size()]));
        return urls;
    }

    public static URL[] getWebappUrls(File warFile) {
        return DeploymentLoader.getWebappUrlsAndRars(warFile).get(URLS_KEY);
    }

    private static void addWebservices(WsModule wsModule) throws OpenEJBException {
        URL moduleUrl;
        boolean webservicesEnabled = SystemInstance.get().getOptions().get("openejb.webservices.enabled", true);
        if (!webservicesEnabled) {
            wsModule.getAltDDs().remove("webservices.xml");
            wsModule.setWebservices(null);
            return;
        }
        Object webservicesObject = wsModule.getAltDDs().get("webservices.xml");
        if (webservicesObject == null || !(webservicesObject instanceof URL)) {
            return;
        }
        URL webservicesUrl = (URL)webservicesObject;
        try {
            File jarFile = new File(wsModule.getJarLocation());
            moduleUrl = jarFile.toURI().toURL();
            if (jarFile.isFile()) {
                moduleUrl = new URL("jar", "", -1, moduleUrl + "!/");
            }
        }
        catch (MalformedURLException e) {
            logger.warning("Invalid module location " + wsModule.getJarLocation());
            return;
        }
        HashMap<URL, JavaWsdlMapping> jaxrpcMappingCache = new HashMap<URL, JavaWsdlMapping>();
        Webservices webservices = ReadDescriptors.readWebservices(webservicesUrl);
        wsModule.setWebservices(webservices);
        if ("file".equals(webservicesUrl.getProtocol())) {
            wsModule.getWatchedResources().add(URLs.toFilePath(webservicesUrl));
        }
        for (WebserviceDescription webserviceDescription : webservices.getWebserviceDescription()) {
            String jaxrpcMappingFile = webserviceDescription.getJaxrpcMappingFile();
            if (jaxrpcMappingFile == null) continue;
            try {
                URL jaxrpcMappingUrl = new URL(moduleUrl, jaxrpcMappingFile);
                JavaWsdlMapping jaxrpcMapping = (JavaWsdlMapping)jaxrpcMappingCache.get(jaxrpcMappingUrl);
                if (jaxrpcMapping == null) {
                    jaxrpcMapping = ReadDescriptors.readJaxrpcMapping(jaxrpcMappingUrl);
                    jaxrpcMappingCache.put(jaxrpcMappingUrl, jaxrpcMapping);
                }
                webserviceDescription.setJaxrpcMapping(jaxrpcMapping);
                if (!"file".equals(jaxrpcMappingUrl.getProtocol())) continue;
                wsModule.getWatchedResources().add(URLs.toFilePath(jaxrpcMappingUrl));
            }
            catch (MalformedURLException e) {
                logger.warning("Invalid jaxrpc-mapping-file location " + jaxrpcMappingFile);
            }
        }
    }

    private void addTagLibraries(WebModule webModule) throws OpenEJBException {
        HashSet<URL> tldLocations = new HashSet<URL>();
        File warFile = new File(webModule.getJarLocation());
        WebApp webApp = webModule.getWebApp();
        if (webApp != null) {
            for (JspConfig jspConfig : webApp.getJspConfig()) {
                for (Taglib taglib : jspConfig.getTaglib()) {
                    String location = taglib.getTaglibLocation();
                    if (!location.startsWith("/")) {
                        location = "/WEB-INF/" + location;
                    }
                    try {
                        File file = new File(warFile, location).getCanonicalFile().getAbsoluteFile();
                        tldLocations.addAll(TldScanner.scanForTagLibs(file));
                    }
                    catch (IOException e) {
                        logger.warning("JSP tag library location bad: " + location, e);
                    }
                }
            }
        }
        Set<URL> urls = TldScanner.scanWarForTagLibs(warFile);
        tldLocations.addAll(urls);
        ClassLoader parentClassLoader = webModule.getClassLoader().getParent();
        urls = TldScanner.scan(parentClassLoader);
        tldLocations.addAll(urls);
        for (URL location : tldLocations) {
            TldTaglib taglib = ReadDescriptors.readTldTaglib(location);
            if (taglib == null || taglib == ReadDescriptors.SKIP_TAGLIB) continue;
            webModule.getTaglibs().add(taglib);
            if (!"file".equals(location.getProtocol())) continue;
            webModule.getWatchedResources().add(URLs.toFilePath(location));
        }
        TldScanner.quickClean(parentClassLoader);
    }

    private void addFacesConfigs(WebModule webModule) throws OpenEJBException {
        File facesConfigFile;
        File webInf;
        HashSet<URL> facesConfigLocations = new HashSet<URL>();
        File warFile = new File(webModule.getJarLocation());
        WebApp webApp = webModule.getWebApp();
        if (webApp != null) {
            String foundContextParam = (String)webApp.contextParamsAsMap().get("javax.faces.CONFIG_FILES");
            if (foundContextParam != null) {
                String commaDelimitedListOfFiles = foundContextParam.trim();
                String[] configFiles = commaDelimitedListOfFiles.split(",");
                String[] trimmedConfigFiles = new String[configFiles.length];
                for (int i = 0; i < configFiles.length; ++i) {
                    trimmedConfigFiles[i] = configFiles[i].trim();
                }
                for (String location : trimmedConfigFiles) {
                    if (!location.startsWith("/")) {
                        logger.error("A faces configuration file should be context relative when specified in web.xml. Please fix the value of context parameter javax.faces.CONFIG_FILES for the file " + location);
                    }
                    try {
                        File file = new File(warFile, location).getCanonicalFile().getAbsoluteFile();
                        URL url = file.toURI().toURL();
                        facesConfigLocations.add(url);
                    }
                    catch (IOException e) {
                        logger.error("Faces configuration file location bad: " + location, e);
                    }
                }
            } else {
                logger.debug("faces config file is null");
            }
        }
        if ((webInf = new File(warFile, "WEB-INF")).isDirectory() && (facesConfigFile = new File(webInf, "faces-config.xml")).exists()) {
            try {
                facesConfigFile = facesConfigFile.getCanonicalFile().getAbsoluteFile();
                URL url = facesConfigFile.toURI().toURL();
                facesConfigLocations.add(url);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (URL location : facesConfigLocations) {
            FacesConfig facesConfig = ReadDescriptors.readFacesConfig(location);
            webModule.getFacesConfigs().add(facesConfig);
            if (!"file".equals(location.getProtocol())) continue;
            webModule.getWatchedResources().add(URLs.toFilePath(location));
        }
    }

    protected static ConnectorModule createConnectorModule(String appId, String rarPath, ClassLoader parentClassLoader, String moduleId) throws OpenEJBException {
        return DeploymentLoader.createConnectorModule(appId, rarPath, parentClassLoader, moduleId, null);
    }

    protected static ConnectorModule createConnectorModule(String appId, String rarPath, ClassLoader parentClassLoader, String moduleId, URL raXmlUrl) throws OpenEJBException {
        File rarFile = new File(rarPath);
        if (!rarFile.exists()) {
            logger.warning(rarPath + " doesn't exist, skipping connector");
            return null;
        }
        rarFile = DeploymentLoader.unpack(rarFile);
        URL baseUrl = DeploymentLoader.getFileUrl(rarFile);
        Map<String, URL> descriptors = DeploymentLoader.getDescriptors(baseUrl);
        Connector connector = null;
        URL rarXmlUrl = descriptors.get("ra.xml");
        if (rarXmlUrl == null && raXmlUrl != null) {
            descriptors.put("ra.xml", raXmlUrl);
            rarXmlUrl = raXmlUrl;
        }
        if (rarXmlUrl != null) {
            connector = ReadDescriptors.readConnector(rarXmlUrl);
        }
        HashMap<String, URL> rarLibs = new HashMap<String, URL>();
        DeploymentLoader.scanDir(rarFile, rarLibs, "");
        Iterator<Map.Entry<String, URL>> iterator = rarLibs.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, URL> fileEntry = iterator.next();
            if (fileEntry.getKey().endsWith(".jar")) continue;
            iterator.remove();
        }
        ArrayList<URL> classPath = new ArrayList<URL>();
        classPath.addAll(rarLibs.values());
        ClassLoaderConfigurer configurer = QuickJarsTxtParser.parse(new File(rarFile, "META-INF/jars.txt"));
        if (configurer != null) {
            ClassLoaderConfigurer.Helper.configure(classPath, configurer);
        }
        URL[] urls = classPath.toArray(new URL[classPath.size()]);
        URLClassLoader appClassLoader = ClassLoaderUtil.createTempClassLoader(appId, urls, parentClassLoader);
        ConnectorModule connectorModule = new ConnectorModule(connector, appClassLoader, rarPath, moduleId);
        connectorModule.getAltDDs().putAll(descriptors);
        connectorModule.getLibraries().addAll(classPath);
        connectorModule.getWatchedResources().add(rarPath);
        connectorModule.getWatchedResources().add(rarFile.getAbsolutePath());
        if (rarXmlUrl != null && "file".equals(rarXmlUrl.getProtocol())) {
            connectorModule.getWatchedResources().add(URLs.toFilePath(rarXmlUrl));
        }
        return connectorModule;
    }

    protected static void addWebFragments(WebModule webModule, Collection<URL> urls) throws OpenEJBException {
        ArrayList<Object> webFragmentUrls;
        if (urls == null) {
            return;
        }
        try {
            webFragmentUrls = (ArrayList<Object>)webModule.getAltDDs().get(WEB_FRAGMENT_XML);
        }
        catch (ClassCastException e) {
            Object value = webModule.getAltDDs().get(WEB_FRAGMENT_XML);
            webFragmentUrls = new ArrayList<Object>();
            webFragmentUrls.add(URL.class.cast(value));
            webModule.getAltDDs().put(WEB_FRAGMENT_XML, webFragmentUrls);
        }
        if (webFragmentUrls == null) {
            webFragmentUrls = new ArrayList();
            webModule.getAltDDs().put(WEB_FRAGMENT_XML, webFragmentUrls);
        }
        for (URL url : urls) {
            URL descriptor;
            ResourceFinder finder = new ResourceFinder("", webModule.getClassLoader(), new URL[]{url});
            Map<String, URL> descriptors = DeploymentLoader.getDescriptors(finder, false);
            if (!descriptors.containsKey(WEB_FRAGMENT_XML) || webFragmentUrls.contains(descriptor = descriptors.get(WEB_FRAGMENT_XML))) continue;
            String urlString = descriptor.toExternalForm();
            if (!urlString.contains("META-INF/web-fragment.xml")) {
                logger.info("AltDD persistence.xml -> " + urlString);
            }
            webFragmentUrls.add(descriptor);
        }
    }

    protected static Collection<URL> addPersistenceUnits(AppModule appModule, URL ... urls) throws OpenEJBException {
        String urlString;
        URL descriptor;
        Map<String, URL> descriptors;
        ResourceFinder finder;
        ArrayList<URL> persistenceFragmentsUrls;
        ArrayList<Object> persistenceUrls;
        ArrayList<URL> added = new ArrayList<URL>();
        try {
            persistenceUrls = (ArrayList<Object>)appModule.getAltDDs().get("persistence.xml");
        }
        catch (ClassCastException e) {
            Object value = appModule.getAltDDs().get("persistence.xml");
            persistenceUrls = new ArrayList<Object>();
            persistenceUrls.add(URL.class.cast(value));
            added.add((URL)persistenceUrls.iterator().next());
            appModule.getAltDDs().put("persistence.xml", persistenceUrls);
        }
        if (persistenceUrls == null) {
            persistenceUrls = new ArrayList();
            appModule.getAltDDs().put("persistence.xml", persistenceUrls);
        }
        if ((persistenceFragmentsUrls = (ArrayList<URL>)appModule.getAltDDs().get("persistence-fragment.xml")) == null) {
            persistenceFragmentsUrls = new ArrayList<URL>();
            appModule.getAltDDs().put("persistence-fragment.xml", persistenceFragmentsUrls);
        }
        for (URL url : urls) {
            finder = new ResourceFinder("", appModule.getClassLoader(), new URL[]{url});
            descriptors = DeploymentLoader.getDescriptors(finder, false);
            if (!descriptors.containsKey("persistence.xml") || persistenceUrls.contains(descriptor = descriptors.get("persistence.xml"))) continue;
            urlString = descriptor.toExternalForm();
            if (!urlString.contains("META-INF/persistence.xml")) {
                logger.info("AltDD persistence.xml -> " + urlString);
            }
            persistenceUrls.add(descriptor);
            added.add(descriptor);
        }
        for (URL url : urls) {
            finder = new ResourceFinder("", appModule.getClassLoader(), new URL[]{url});
            descriptors = DeploymentLoader.getDescriptors(finder, false);
            if (!descriptors.containsKey("persistence-fragment.xml") || persistenceFragmentsUrls.contains(descriptor = descriptors.get("persistence-fragment.xml"))) continue;
            urlString = descriptor.toExternalForm();
            if (!urlString.contains("META-INF/persistence-fragment.xml")) {
                logger.info("AltDD persistence-fragment.xml -> " + urlString);
            }
            persistenceFragmentsUrls.add(descriptor);
            added.add(descriptor);
        }
        return added;
    }

    public static Map<String, URL> getDescriptors(URL moduleUrl) throws OpenEJBException {
        ResourceFinder finder = new ResourceFinder(new URL[]{moduleUrl});
        return DeploymentLoader.getDescriptors(finder);
    }

    private static Map<String, URL> getDescriptors(ResourceFinder finder) throws OpenEJBException {
        return DeploymentLoader.getDescriptors(finder, true);
    }

    private static Map<String, URL> getDescriptors(ResourceFinder finder, boolean log) throws OpenEJBException {
        try {
            return DeploymentLoader.altDDSources(DeploymentLoader.mapDescriptors(finder), log);
        }
        catch (IOException e) {
            throw new OpenEJBException("Unable to determine descriptors in jar.", e);
        }
    }

    public static Map<String, URL> mapDescriptors(ResourceFinder finder) throws IOException {
        Map map = finder.getResourcesMap(ddDir);
        if (map.size() == 0) {
            for (String descriptor : KNOWN_DESCRIPTORS) {
                URL url = finder.getResource(ddDir + descriptor);
                if (url == null) continue;
                map.put(descriptor, url);
            }
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, URL> altDDSources(Map<String, URL> map, boolean log) {
        if (ALTDD == null || ALTDD.length() <= 0) {
            return map;
        }
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(ALTDD.split(",")));
        Collections.reverse(list);
        HashMap<String, URL> alts = new HashMap<String, URL>();
        for (String string : list) {
            String string2 = string.trim();
            if (!string2.matches(".*[.-]$")) {
                String string3 = string2 + ".";
            }
            for (Map.Entry<String, URL> entry : new HashMap<String, URL>(map).entrySet()) {
                void var5_5;
                String key = entry.getKey();
                URL value = entry.getValue();
                if (!key.startsWith((String)var5_5)) continue;
                key = key.substring(var5_5.length());
                alts.put(key, value);
            }
        }
        for (Map.Entry entry : alts.entrySet()) {
            String key = (String)entry.getKey();
            URL value = (URL)entry.getValue();
            if (value.equals(map.get(key))) continue;
            if (log) {
                logger.info("AltDD " + key + " -> " + value.toExternalForm());
            }
            map.put(key, value);
        }
        return map;
    }

    public static Map<String, URL> getWebDescriptors(File warFile) throws IOException {
        TreeMap<String, URL> descriptors = new TreeMap<String, URL>();
        if (warFile.isFile()) {
            URL jarURL = new URL("jar", "", -1, warFile.toURI().toURL() + "!/");
            try {
                JarFile jarFile = new JarFile(warFile);
                for (JarEntry entry : Collections.list(jarFile.entries())) {
                    String entryName = entry.getName();
                    if (entry.isDirectory() || !entryName.startsWith("WEB-INF/") || !KNOWN_DESCRIPTORS.contains(entryName.substring("WEB-INF/".length())) && !entryName.endsWith(".xml")) continue;
                    descriptors.put(entryName, new URL(jarURL, entry.getName()));
                }
            }
            catch (IOException e) {}
        } else if (warFile.isDirectory()) {
            File[] files;
            File webAppDdDir;
            File[] files2;
            File webInfDir = new File(warFile, "WEB-INF");
            if (webInfDir.isDirectory() && (files2 = webInfDir.listFiles()) != null) {
                for (File file : files2) {
                    if (file.isDirectory()) continue;
                    descriptors.put(file.getName(), file.toURI().toURL());
                }
            }
            if ((webAppDdDir = new File(webInfDir, "classes/META-INF/")).isDirectory() && (files = webAppDdDir.listFiles()) != null) {
                for (File file : files) {
                    String name = file.getName();
                    if (!descriptors.containsKey(name)) {
                        descriptors.put(name, file.toURI().toURL());
                        continue;
                    }
                    logger.warning("Can't have a " + name + " in WEB-INF and WEB-INF/classes/META-INF, second will be ignored");
                }
            }
        }
        return descriptors;
    }

    protected File getFile(URL warUrl) {
        if ("jar".equals(warUrl.getProtocol())) {
            String pathname = warUrl.getPath();
            if (!pathname.startsWith("file:")) {
                return null;
            }
            pathname = pathname.substring("file:".length());
            pathname = pathname.substring(0, pathname.lastIndexOf(33));
            try {
                pathname = URLDecoder.decode(pathname, "UTF-8");
            }
            catch (Exception e) {
                pathname = URLDecoder.decode(pathname);
            }
            return new File(pathname);
        }
        if ("file".equals(warUrl.getProtocol())) {
            String pathname = warUrl.getPath();
            try {
                return new File(URLDecoder.decode(pathname, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                return new File(URLDecoder.decode(pathname));
            }
        }
        return null;
    }

    public static Application unmarshal(URL url) throws OpenEJBException {
        try {
            return ApplicationXml.unmarshal((URL)url);
        }
        catch (Exception e) {
            throw new OpenEJBException("Encountered error parsing the application.xml file: " + url.toExternalForm(), e);
        }
    }

    public static void scanDir(File dir, Map<String, URL> files, String path) {
        DeploymentLoader.scanDir(dir, files, path, true);
    }

    public static void scanDir(File dir, Map<String, URL> files, String path, boolean recursive) {
        File[] dirFiles = dir.listFiles();
        if (dirFiles != null) {
            for (File file : dirFiles) {
                if (file.isDirectory()) {
                    if (DeploymentsResolver.isExtractedDir(file) || !recursive) continue;
                    DeploymentLoader.scanDir(file, files, path + file.getName() + "/");
                    continue;
                }
                String name = file.getName();
                try {
                    files.put(path + name, file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    logger.warning("EAR path bad: " + path + name, e);
                }
            }
        }
    }

    public Class<? extends DeploymentModule> discoverModuleType(URL baseUrl, ClassLoader classLoader, boolean searchForDescriptorlessApplications) throws IOException, UnknownModuleTypeException {
        HashSet<RequireDescriptors> search = new HashSet<RequireDescriptors>();
        if (!searchForDescriptorlessApplications) {
            search.addAll(Arrays.asList(RequireDescriptors.values()));
        }
        return this.discoverModuleType(baseUrl, classLoader, search);
    }

    public Class<? extends DeploymentModule> discoverModuleType(URL baseUrl, ClassLoader classLoader, Set<RequireDescriptors> requireDescriptor) throws IOException, UnknownModuleTypeException {
        Class defaultType;
        BufferedInputStream is;
        Manifest manifest;
        String mainClass;
        Map<String, URL> webDescriptors;
        String path;
        boolean scanPotentialEjbModules = !requireDescriptor.contains((Object)RequireDescriptors.EJB);
        boolean scanPotentialClientModules = !requireDescriptor.contains((Object)RequireDescriptors.CLIENT);
        URL pathToScanDescriptors = baseUrl;
        if (baseUrl != null) {
            path = URLs.toFile(baseUrl).getAbsolutePath();
            if (baseUrl.getProtocol().equals("file") && path.endsWith("WEB-INF/classes/")) {
                pathToScanDescriptors = new URL(path.substring(0, path.lastIndexOf("WEB-INF/classes/")));
            }
        } else {
            path = "";
        }
        Map<String, URL> descriptors = this.getDescriptors(classLoader, pathToScanDescriptors);
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.endsWith(".xml") || path.endsWith(".json")) {
            return ResourcesModule.class;
        }
        if (descriptors.containsKey("application.xml") || path.endsWith(".ear")) {
            return AppModule.class;
        }
        if (descriptors.containsKey("ra.xml") || path.endsWith(".rar")) {
            return ConnectorModule.class;
        }
        if (baseUrl != null && ((webDescriptors = DeploymentLoader.getWebDescriptors(this.getFile(baseUrl))).containsKey("web.xml") || webDescriptors.containsKey(WEB_FRAGMENT_XML) || path.endsWith(".war") || new File(path, "WEB-INF").exists())) {
            return WebModule.class;
        }
        if (descriptors.containsKey("ejb-jar.xml") || descriptors.containsKey("beans.xml")) {
            return EjbModule.class;
        }
        if (descriptors.containsKey("application-client.xml")) {
            return ClientModule.class;
        }
        URL manifestUrl = descriptors.get("MANIFEST.MF");
        if (scanPotentialClientModules && manifestUrl != null && (mainClass = (manifest = new Manifest(is = new BufferedInputStream(manifestUrl.openStream()))).getMainAttributes().getValue(Attributes.Name.MAIN_CLASS)) != null) {
            return ClientModule.class;
        }
        Class<? extends DeploymentModule> cls = this.checkAnnotations(baseUrl, classLoader, scanPotentialEjbModules, scanPotentialClientModules);
        if (cls != null) {
            return cls;
        }
        if (descriptors.containsKey("persistence.xml") || descriptors.containsKey("persistence-fragment.xml")) {
            return PersistenceModule.class;
        }
        File file = URLs.toFile(baseUrl);
        if (DeploymentsResolver.isValidDirectory(file)) {
            File[] files = file.listFiles();
            if (DeploymentLoader.containsEarAssets(files)) {
                return AppModule.class;
            }
            if (DeploymentLoader.containsWebAssets(files)) {
                return WebModule.class;
            }
        }
        if ((defaultType = SystemInstance.get().getOptions().get("openejb.default.deployment-module", (Class)null)) != null) {
            if (WebModule.class.equals((Object)defaultType) && (path.endsWith(".jar!") || path.endsWith(".jar"))) {
                throw new UnknownModuleTypeException("Unknown module type: url=" + path + " which can't be a war.");
            }
            logger.debug("type for '" + path + "' was not found, defaulting to " + defaultType.getSimpleName());
            return defaultType;
        }
        throw new UnknownModuleTypeException("Unknown module type: url=" + path);
    }

    private static boolean containsWebAssets(File[] files) {
        if (files != null) {
            for (File file : files) {
                String fn = file.getName().toLowerCase();
                if (fn.endsWith(".jsp")) {
                    return true;
                }
                if (!fn.endsWith(".html")) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean containsEarAssets(File[] files) {
        if (files != null) {
            for (File file : files) {
                String fn = file.getName().toLowerCase();
                if (fn.endsWith(".jar")) {
                    return true;
                }
                if (fn.endsWith(".war")) {
                    return true;
                }
                if (!fn.endsWith(".rar")) continue;
                return true;
            }
        }
        return false;
    }

    private Map<String, URL> getDescriptors(ClassLoader classLoader, URL pathToScanDescriptors) throws IOException {
        ResourceFinder finder = new ResourceFinder("", classLoader, new URL[]{pathToScanDescriptors});
        return DeploymentLoader.altDDSources(DeploymentLoader.mapDescriptors(finder), false);
    }

    private Class<? extends DeploymentModule> checkAnnotations(URL urls, ClassLoader classLoader, final boolean scanPotentialEjbModules, final boolean scanPotentialClientModules) {
        Class cls = null;
        if (scanPotentialEjbModules || scanPotentialClientModules) {
            org.apache.openejb.util.AnnotationFinder classFinder = new org.apache.openejb.util.AnnotationFinder(classLoader, urls);
            final LinkedHashSet otherTypes = new LinkedHashSet();
            AnnotationFinder.Filter filter = new AnnotationFinder.Filter(){
                final String packageName = LocalClient.class.getName().replace("LocalClient", "");

                @Override
                public boolean accept(String annotationName) {
                    if (scanPotentialClientModules && annotationName.startsWith(this.packageName)) {
                        if (LocalClient.class.getName().equals(annotationName)) {
                            otherTypes.add(ClientModule.class);
                        }
                        if (RemoteClient.class.getName().equals(annotationName)) {
                            otherTypes.add(ClientModule.class);
                        }
                    } else if (scanPotentialEjbModules) {
                        if (annotationName.startsWith("javax.ejb.")) {
                            if ("javax.ejb.Stateful".equals(annotationName)) {
                                return true;
                            }
                            if ("javax.ejb.Stateless".equals(annotationName)) {
                                return true;
                            }
                            if ("javax.ejb.Singleton".equals(annotationName)) {
                                return true;
                            }
                            if ("javax.ejb.MessageDriven".equals(annotationName)) {
                                return true;
                            }
                        } else if ("javax.annotation.ManagedBean".equals(annotationName)) {
                            return true;
                        }
                    }
                    return false;
                }
            };
            if (classFinder.find(filter)) {
                cls = EjbModule.class;
                try {
                    JarFile war;
                    ZipEntry entry;
                    File ar = URLs.toFile(urls);
                    if (!ar.isDirectory() && !ar.getName().endsWith("ar") && (entry = (war = new JarFile(ar)).getEntry("WEB-INF/")) != null) {
                        logger.warning("you deployed " + urls.toExternalForm() + ", it seems it is a war with no extension, please rename it");
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            if (otherTypes.size() > 0) {
                cls = (Class)otherTypes.iterator().next();
            }
        }
        return cls;
    }

    public static File unpack(File jarFile) throws OpenEJBException {
        if (jarFile.isDirectory() || jarFile.getName().endsWith(".jar")) {
            return jarFile;
        }
        String name = jarFile.getName();
        name = name.endsWith(".ear") || name.endsWith(".zip") || name.endsWith(".war") || name.endsWith(".rar") ? name.replaceFirst("....$", "") : name + ".unpacked";
        try {
            return JarExtractor.extract(jarFile, name);
        }
        catch (Throwable e) {
            throw new OpenEJBException("Unable to extract jar. " + e.getMessage(), e);
        }
    }

    protected static URL getFileUrl(File jarFile) throws OpenEJBException {
        URL baseUrl;
        try {
            baseUrl = jarFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new OpenEJBException("Malformed URL to app. " + e.getMessage(), e);
        }
        return baseUrl;
    }

    public static void reloadAltDD() {
        ALTDD = SystemInstance.get().getOptions().get(OPENEJB_ALTDD_PREFIX, (String)null);
    }

    public static class ExternalConfiguration {
        private final String[] classpath;

        public ExternalConfiguration(String[] classpath) {
            this.classpath = classpath;
        }

        public String[] getClasspath() {
            return this.classpath;
        }
    }
}

