/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.cdi.CompositeBeans;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ClientModule;
import org.apache.openejb.config.ConnectorModule;
import org.apache.openejb.config.DeploymentLoader;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.Module;
import org.apache.openejb.config.OpenEjb2Conversion;
import org.apache.openejb.config.PersistenceModule;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.config.sys.JSonConfigReader;
import org.apache.openejb.config.sys.JaxbOpenejb;
import org.apache.openejb.config.sys.Resource;
import org.apache.openejb.config.sys.Resources;
import org.apache.openejb.core.ParentClassLoaderFinder;
import org.apache.openejb.jee.ApplicationClient;
import org.apache.openejb.jee.Beans;
import org.apache.openejb.jee.Connector;
import org.apache.openejb.jee.Connector10;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.FacesConfig;
import org.apache.openejb.jee.HandlerChains;
import org.apache.openejb.jee.JavaWsdlMapping;
import org.apache.openejb.jee.JaxbJavaee;
import org.apache.openejb.jee.Keyable;
import org.apache.openejb.jee.Listener;
import org.apache.openejb.jee.TldTaglib;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.WebFragment;
import org.apache.openejb.jee.Webservices;
import org.apache.openejb.jee.bval.ValidationConfigType;
import org.apache.openejb.jee.jpa.EntityMappings;
import org.apache.openejb.jee.jpa.fragment.PersistenceFragment;
import org.apache.openejb.jee.jpa.fragment.PersistenceUnitFragment;
import org.apache.openejb.jee.jpa.unit.JaxbPersistenceFactory;
import org.apache.openejb.jee.jpa.unit.Persistence;
import org.apache.openejb.jee.jpa.unit.PersistenceUnit;
import org.apache.openejb.jee.oejb2.GeronimoEjbJarType;
import org.apache.openejb.jee.oejb2.JaxbOpenejbJar2;
import org.apache.openejb.jee.oejb2.OpenejbJarType;
import org.apache.openejb.jee.oejb3.JaxbOpenejbJar3;
import org.apache.openejb.jee.oejb3.OpenejbJar;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.sxc.ApplicationClientXml;
import org.apache.openejb.sxc.EjbJarXml;
import org.apache.openejb.sxc.FacesConfigXml;
import org.apache.openejb.sxc.HandlerChainsXml;
import org.apache.openejb.sxc.TldTaglibXml;
import org.apache.openejb.sxc.WebXml;
import org.apache.openejb.sxc.WebservicesXml;
import org.apache.openejb.util.LengthInputStream;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.Saxs;
import org.apache.openejb.util.URLs;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ReadDescriptors
implements DynamicDeployer {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP, ReadDescriptors.class);
    private static final boolean ROOT_URL_FROM_WEBINF = SystemInstance.get().getOptions().get("openejb.jpa.root-url-from-webinf", false);
    public static final TldTaglib SKIP_TAGLIB = new TldTaglib();

    @Override
    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        List persistenceFragmentUrls;
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            if (ejbModule.getEjbJar() == null) {
                this.readEjbJar(ejbModule, appModule);
            }
            if (ejbModule.getOpenejbJar() == null) {
                this.readOpenejbJar(ejbModule);
            }
            if (ejbModule.getBeans() == null) {
                this.readBeans(ejbModule);
            }
            this.readValidationConfigType(ejbModule);
            this.readCmpOrm(ejbModule);
            ReadDescriptors.readResourcesXml(ejbModule);
        }
        for (ClientModule clientModule : appModule.getClientModules()) {
            this.readAppClient(clientModule, appModule);
            this.readValidationConfigType(clientModule);
            ReadDescriptors.readResourcesXml(clientModule);
        }
        for (ConnectorModule connectorModule : appModule.getConnectorModules()) {
            this.readConnector(connectorModule, appModule);
            this.readValidationConfigType(connectorModule);
            ReadDescriptors.readResourcesXml(connectorModule);
        }
        for (WebModule webModule : appModule.getWebModules()) {
            this.readWebApp(webModule, appModule);
            this.readValidationConfigType(webModule);
            ReadDescriptors.readResourcesXml(webModule);
        }
        List persistenceUrls = (List)appModule.getAltDDs().get("persistence.xml");
        if (persistenceUrls != null) {
            for (Object persistenceUrl : persistenceUrls) {
                String rootUrl;
                String moduleName;
                String path;
                boolean url = persistenceUrl instanceof URL;
                Source source = ReadDescriptors.getSource(persistenceUrl);
                if (url) {
                    URL pUrl = (URL)persistenceUrl;
                    File file = URLs.toFile(pUrl);
                    path = file.getAbsolutePath();
                    if (file.getName().endsWith("persistence.xml")) {
                        File parentFile = file.getParentFile();
                        String parent = parentFile.getName();
                        file = parent.equalsIgnoreCase("WEB-INF") || parent.equalsIgnoreCase("META-INF") ? parentFile.getParentFile() : file.getParentFile();
                    }
                    String tmpRootUrl = moduleName = file.toURI().toString();
                    String extForm = pUrl.toExternalForm();
                    if (extForm.contains("WEB-INF/classes/META-INF/")) {
                        tmpRootUrl = !ROOT_URL_FROM_WEBINF ? extForm.substring(0, extForm.indexOf("/META-INF")) : extForm.substring(0, extForm.indexOf("/classes/META-INF"));
                    }
                    if (tmpRootUrl.endsWith(".war")) {
                        tmpRootUrl = tmpRootUrl.substring(0, tmpRootUrl.length() - ".war".length());
                    }
                    rootUrl = tmpRootUrl;
                } else {
                    moduleName = "";
                    rootUrl = "";
                    path = null;
                }
                try {
                    Persistence persistence = (Persistence)JaxbPersistenceFactory.getPersistence(Persistence.class, (InputStream)source.get());
                    PersistenceModule persistenceModule = new PersistenceModule(appModule, rootUrl, persistence);
                    persistenceModule.getWatchedResources().add(moduleName);
                    if (url && "file".equals(((URL)persistenceUrl).getProtocol())) {
                        persistenceModule.getWatchedResources().add(path);
                    }
                    appModule.addPersistenceModule(persistenceModule);
                }
                catch (Exception e1) {
                    DeploymentLoader.logger.error("Unable to load Persistence Unit from EAR: " + appModule.getJarLocation() + ", module: " + moduleName + ". Exception: " + e1.getMessage(), e1);
                }
            }
        }
        if ((persistenceFragmentUrls = (List)appModule.getAltDDs().get("persistence-fragment.xml")) != null) {
            for (URL persistenceFragmentUrl : persistenceFragmentUrls) {
                try {
                    PersistenceFragment persistenceFragment = (PersistenceFragment)JaxbPersistenceFactory.getPersistence(PersistenceFragment.class, (URL)persistenceFragmentUrl);
                    for (PersistenceUnitFragment fragmentUnit : persistenceFragment.getPersistenceUnitFragment()) {
                        for (PersistenceModule persistenceModule : appModule.getPersistenceModules()) {
                            Persistence persistence = persistenceModule.getPersistence();
                            for (PersistenceUnit unit : persistence.getPersistenceUnit()) {
                                if (!fragmentUnit.getName().equals(unit.getName())) continue;
                                if (!persistenceFragment.getVersion().equals(persistence.getVersion())) {
                                    logger.error("persistence unit version and fragment version are different, fragment will be ignored");
                                    continue;
                                }
                                if ("file".equals(persistenceFragmentUrl.getProtocol())) {
                                    persistenceModule.getWatchedResources().add(URLs.toFile(persistenceFragmentUrl).getAbsolutePath());
                                }
                                for (String clazz : fragmentUnit.getClazz()) {
                                    if (unit.getClazz().contains(clazz)) continue;
                                    logger.info("Adding class " + clazz + " to persistence unit " + fragmentUnit.getName());
                                    unit.getClazz().add(clazz);
                                }
                                for (String mappingFile : fragmentUnit.getMappingFile()) {
                                    if (unit.getMappingFile().contains(mappingFile)) continue;
                                    logger.info("Adding mapping file " + mappingFile + " to persistence unit " + fragmentUnit.getName());
                                    unit.getMappingFile().add(mappingFile);
                                }
                                for (String jarFile : fragmentUnit.getJarFile()) {
                                    if (unit.getJarFile().contains(jarFile)) continue;
                                    logger.info("Adding jar file " + jarFile + " to persistence unit " + fragmentUnit.getName());
                                    unit.getJarFile().add(jarFile);
                                }
                                if (!fragmentUnit.isExcludeUnlistedClasses()) continue;
                                unit.setExcludeUnlistedClasses(Boolean.valueOf(true));
                                logger.info("Excluding unlisted classes for persistence unit " + fragmentUnit.getName());
                            }
                        }
                    }
                }
                catch (Exception e1) {
                    DeploymentLoader.logger.error("Unable to load Persistence Unit Fragment from EAR: " + appModule.getJarLocation() + ", fragment: " + persistenceFragmentUrl.toString() + ". Exception: " + e1.getMessage(), e1);
                }
            }
        }
        return appModule;
    }

    public static void readResourcesXml(Module module) {
        Resources openejb;
        Source url = ReadDescriptors.getSource(module.getAltDDs().get("resources.xml"));
        if (url != null) {
            try {
                openejb = JaxbOpenejb.unmarshal(Resources.class, url.get());
                module.initResources(ReadDescriptors.check(openejb));
            }
            catch (Exception e) {
                logger.warning("can't read " + url.toString() + " to load resources for module " + module.toString(), e);
            }
        }
        if ((url = ReadDescriptors.getSource(module.getAltDDs().get("resources.json"))) != null) {
            try {
                openejb = JSonConfigReader.read(Resources.class, url.get());
                module.initResources(ReadDescriptors.check(openejb));
            }
            catch (Exception e) {
                logger.warning("can't read " + url.toString() + " to load resources for module " + module.toString(), e);
            }
        }
    }

    public static Resources check(Resources resources) {
        List<Resource> resourceList = resources.getResource();
        for (Resource resource : resourceList) {
            if (resource.getClassName() == null) continue;
            try {
                ParentClassLoaderFinder.Helper.get().loadClass(resource.getClassName());
            }
            catch (Exception e) {
                Boolean lazySpecified = Boolean.valueOf(resource.getProperties().getProperty("Lazy", "false"));
                resource.getProperties().setProperty("Lazy", "true");
                resource.getProperties().setProperty("UseAppClassLoader", "true");
                if (lazySpecified.booleanValue()) continue;
                resource.getProperties().setProperty("InitializeAfterDeployment", "true");
            }
        }
        return resources;
    }

    private void readValidationConfigType(Module module) throws OpenEJBException {
        if (module.getValidationConfig() != null) {
            return;
        }
        Source value = ReadDescriptors.getSource(module.getAltDDs().get("validation.xml"));
        if (value != null) {
            try {
                ValidationConfigType validationConfigType = JaxbOpenejb.unmarshal(ValidationConfigType.class, value.get(), false);
                module.setValidationConfig(validationConfigType);
            }
            catch (Exception e) {
                logger.warning("can't read validation.xml to construct a validation factory, it will be ignored");
            }
        }
    }

    private void readOpenejbJar(EjbModule ejbModule) throws OpenEJBException {
        Source source1;
        Source source = ReadDescriptors.getSource(ejbModule.getAltDDs().get("openejb-jar.xml"));
        if (source != null) {
            try {
                OpenejbJar openejbJar = ((OpenejbJar)JaxbOpenejbJar3.unmarshal(OpenejbJar.class, (InputStream)source.get())).postRead();
                ejbModule.setOpenejbJar(openejbJar);
            }
            catch (Exception v3ParsingException) {
                OpenejbJar openejbJar = new OpenejbJar();
                ejbModule.setOpenejbJar(openejbJar);
                try {
                    JAXBElement element = (JAXBElement)JaxbOpenejbJar2.unmarshal(OpenejbJarType.class, (InputStream)source.get());
                    OpenejbJarType o2 = (OpenejbJarType)element.getValue();
                    ejbModule.getAltDDs().put("openejb-jar.xml", o2);
                    GeronimoEjbJarType g2 = OpenEjb2Conversion.convertToGeronimoOpenejbXml(o2);
                    ejbModule.getAltDDs().put("geronimo-openejb.xml", g2);
                }
                catch (Exception v2ParsingException) {
                    final Exception[] realIssue = new Exception[]{v3ParsingException};
                    try {
                        SAXParserFactory factory = Saxs.namespaceAwareFactory();
                        SAXParser parser = factory.newSAXParser();
                        parser.parse(source.get(), new DefaultHandler(){

                            @Override
                            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                                if (localName.equals("environment")) {
                                    realIssue[0] = v2ParsingException;
                                    throw new SAXException("Throw exception to stop parsing");
                                }
                                if (uri == null) {
                                    return;
                                }
                                if (uri.contains("openejb-jar-2.") || uri.contains("geronimo.apache.org/xml/ns")) {
                                    realIssue[0] = v2ParsingException;
                                    throw new SAXException("Throw exception to stop parsing");
                                }
                            }
                        });
                    }
                    catch (Exception dontCare) {
                        // empty catch block
                    }
                    String filePath = "<error: could not be written>";
                    try {
                        File tempFile;
                        try {
                            tempFile = File.createTempFile("openejb-jar-", ".xml");
                        }
                        catch (Throwable e) {
                            File tmp = new File("tmp");
                            if (!tmp.exists() && !tmp.mkdirs()) {
                                throw new IOException("Failed to create local tmp directory: " + tmp.getAbsolutePath());
                            }
                            tempFile = File.createTempFile("openejb-jar-", ".xml", tmp);
                        }
                        try {
                            IO.copy((InputStream)source.get(), (File)tempFile);
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        filePath = tempFile.getAbsolutePath();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    Exception e = realIssue[0];
                    if (e instanceof SAXException) {
                        throw new OpenEJBException("Cannot parse the openejb-jar.xml. Xml content written to: " + filePath, e);
                    }
                    if (e instanceof JAXBException) {
                        throw new OpenEJBException("Cannot unmarshall the openejb-jar.xml. Xml content written to: " + filePath, e);
                    }
                    if (e instanceof IOException) {
                        throw new OpenEJBException("Cannot read the openejb-jar.xml.", e);
                    }
                    throw new OpenEJBException("Encountered unknown error parsing the openejb-jar.xml.", e);
                }
            }
        }
        if ((source1 = ReadDescriptors.getSource(ejbModule.getAltDDs().get("geronimo-openejb.xml"))) != null) {
            try {
                GeronimoEjbJarType geronimoEjbJarType = null;
                Object o = JaxbOpenejbJar2.unmarshal(GeronimoEjbJarType.class, (InputStream)source1.get());
                if (o instanceof GeronimoEjbJarType) {
                    geronimoEjbJarType = (GeronimoEjbJarType)o;
                } else if (o instanceof JAXBElement) {
                    JAXBElement element = (JAXBElement)o;
                    geronimoEjbJarType = (GeronimoEjbJarType)element.getValue();
                }
                if (geronimoEjbJarType != null) {
                    OpenejbJar existingOpenejbJar;
                    Object nested = geronimoEjbJarType.getOpenejbJar();
                    if (nested != null && nested instanceof OpenejbJar && ((existingOpenejbJar = ejbModule.getOpenejbJar()) == null || existingOpenejbJar.getEjbDeploymentCount() <= 0)) {
                        OpenejbJar openejbJar = (OpenejbJar)nested;
                        ejbModule.getAltDDs().put("openejb-jar.xml", openejbJar);
                        ejbModule.setOpenejbJar(openejbJar);
                    }
                    ejbModule.getAltDDs().put("geronimo-openejb.xml", geronimoEjbJarType);
                }
            }
            catch (Exception e) {
                throw new OpenEJBException("Failed parsing geronimo-openejb.xml", e);
            }
        }
    }

    private void readAppClient(ClientModule clientModule, AppModule appModule) throws OpenEJBException {
        if (clientModule.getApplicationClient() != null) {
            return;
        }
        Object data = clientModule.getAltDDs().get("application-client.xml");
        if (data instanceof ApplicationClient) {
            clientModule.setApplicationClient((ApplicationClient)data);
        } else if (data instanceof URL) {
            URL url = (URL)data;
            ApplicationClient applicationClient = ReadDescriptors.readApplicationClient(url);
            clientModule.setApplicationClient(applicationClient);
        } else if (!clientModule.isEjbModuleGenerated()) {
            DeploymentLoader.logger.debug("No application-client.xml found assuming annotations present: " + appModule.getJarLocation() + ", module: " + clientModule.getModuleId());
            clientModule.setApplicationClient(new ApplicationClient());
        }
    }

    public void readEjbJar(EjbModule ejbModule, AppModule appModule) throws OpenEJBException {
        if (ejbModule.getEjbJar() != null) {
            return;
        }
        Source data = ReadDescriptors.getSource(ejbModule.getAltDDs().get("ejb-jar.xml"));
        if (data != null) {
            try {
                EjbJar ejbJar = ReadDescriptors.readEjbJar(data.get());
                ejbModule.setEjbJar(ejbJar);
            }
            catch (IOException e) {
                throw new OpenEJBException(e);
            }
        } else {
            DeploymentLoader.logger.debug("No ejb-jar.xml found assuming annotated beans present: " + appModule.getJarLocation() + ", module: " + ejbModule.getModuleId());
            ejbModule.setEjbJar(new EjbJar());
        }
    }

    private static void checkDuplicatedByBeansXml(List<String> list, List<String> duplicated) {
        for (String str : list) {
            if (list.indexOf(str) == list.lastIndexOf(str)) continue;
            duplicated.add(str);
        }
    }

    public static void checkDuplicatedByBeansXml(Beans beans, Beans complete) {
        ReadDescriptors.checkDuplicatedByBeansXml(beans.getAlternativeClasses(), complete.getDuplicatedAlternatives().getClasses());
        ReadDescriptors.checkDuplicatedByBeansXml(beans.getAlternativeStereotypes(), complete.getDuplicatedAlternatives().getStereotypes());
        ReadDescriptors.checkDuplicatedByBeansXml(beans.getDecorators(), complete.getDuplicatedDecorators());
        ReadDescriptors.checkDuplicatedByBeansXml(beans.getInterceptors(), complete.getDuplicatedInterceptors());
    }

    private void readBeans(EjbModule ejbModule) throws OpenEJBException {
        if (ejbModule.getBeans() != null) {
            return;
        }
        Object raw = ejbModule.getAltDDs().get("beans.xml");
        Source data = ReadDescriptors.getSource(raw);
        if (data != null) {
            try {
                Beans beans = ReadDescriptors.readBeans(data.get());
                ReadDescriptors.checkDuplicatedByBeansXml(beans, beans);
                if (UrlSource.class.isInstance(data)) {
                    beans.setUri(((UrlSource)UrlSource.class.cast(data)).getUrl().toExternalForm());
                } else {
                    beans.setUri("jar:file://" + ejbModule.getModuleId() + "!/META-INF/beans.xml");
                }
                ejbModule.setBeans(beans);
            }
            catch (IOException e) {
                throw new OpenEJBException(e);
            }
        } else if (raw instanceof Beans) {
            ejbModule.setBeans((Beans)raw);
        } else if (List.class.isInstance(raw)) {
            CompositeBeans compositeBeans = new CompositeBeans();
            List list = (List)List.class.cast(raw);
            if (!list.isEmpty()) {
                for (Object o : list) {
                    try {
                        UrlSource urlSource = (UrlSource)UrlSource.class.cast(o);
                        ReadDescriptors.mergeBeansXml(compositeBeans, ReadDescriptors.readBeans(urlSource.get()), urlSource.getUrl());
                    }
                    catch (IOException e) {
                        throw new OpenEJBException(e);
                    }
                }
                ejbModule.setBeans(compositeBeans);
            }
        }
    }

    private static Beans mergeBeansXml(CompositeBeans current, Beans beans, URL url) {
        current.mergeClasses(url, beans);
        current.getScan().getExclude().addAll(beans.getScan().getExclude());
        ReadDescriptors.checkDuplicatedByBeansXml(beans, current);
        String beanDiscoveryMode = beans.getBeanDiscoveryMode();
        current.getDiscoveryByUrl().put(url, beanDiscoveryMode == null ? "ALL" : beanDiscoveryMode);
        return current;
    }

    private void readCmpOrm(EjbModule ejbModule) throws OpenEJBException {
        Object data = ejbModule.getAltDDs().get("openejb-cmp-orm.xml");
        if (data != null && !(data instanceof EntityMappings) && data instanceof URL) {
            URL url = (URL)data;
            try {
                EntityMappings entitymappings = (EntityMappings)JaxbJavaee.unmarshalJavaee(EntityMappings.class, (InputStream)IO.read((URL)url));
                ejbModule.getAltDDs().put("openejb-cmp-orm.xml", entitymappings);
            }
            catch (SAXException e) {
                throw new OpenEJBException("Cannot parse the openejb-cmp-orm.xml file: " + url.toExternalForm(), e);
            }
            catch (JAXBException e) {
                throw new OpenEJBException("Cannot unmarshall the openejb-cmp-orm.xml file: " + url.toExternalForm(), e);
            }
            catch (IOException e) {
                throw new OpenEJBException("Cannot read the openejb-cmp-orm.xml file: " + url.toExternalForm(), e);
            }
            catch (Exception e) {
                throw new OpenEJBException("Encountered unknown error parsing the openejb-cmp-orm.xml file: " + url.toExternalForm(), e);
            }
        }
    }

    private void readConnector(ConnectorModule connectorModule, AppModule appModule) throws OpenEJBException {
        if (connectorModule.getConnector() != null) {
            return;
        }
        Object data = connectorModule.getAltDDs().get("ra.xml");
        if (data instanceof Connector) {
            connectorModule.setConnector((Connector)data);
        } else if (data instanceof URL) {
            URL url = (URL)data;
            Connector connector = ReadDescriptors.readConnector(url);
            connectorModule.setConnector(connector);
        } else {
            DeploymentLoader.logger.debug("No ra.xml found assuming annotated beans present: " + appModule.getJarLocation() + ", module: " + connectorModule.getModuleId());
            connectorModule.setConnector(new Connector());
        }
    }

    private void readWebApp(WebModule webModule, AppModule appModule) throws OpenEJBException {
        if (webModule.getWebApp() != null) {
            this.mergeWebFragments(webModule);
            return;
        }
        Object data = webModule.getAltDDs().get("web.xml");
        if (data instanceof WebApp) {
            webModule.setWebApp((WebApp)data);
        } else if (data instanceof URL) {
            URL url = (URL)data;
            WebApp webApp = ReadDescriptors.readWebApp(url);
            webModule.setWebApp(webApp);
        } else {
            DeploymentLoader.logger.debug("No web.xml found assuming annotated beans present: " + appModule.getJarLocation() + ", module: " + webModule.getModuleId());
            webModule.setWebApp(new WebApp());
        }
        this.mergeWebFragments(webModule);
    }

    private void mergeWebFragments(WebModule webModule) {
        Collection urls = (Collection)Collection.class.cast(webModule.getAltDDs().get("web-fragment.xml"));
        if (urls != null) {
            for (URL rawUrl : urls) {
                if (rawUrl == null) continue;
                Source url = ReadDescriptors.getSource(rawUrl);
                try {
                    WebFragment webFragment = (WebFragment)WebFragment.class.cast(JaxbJavaee.unmarshal(WebFragment.class, (InputStream)url.get(), (boolean)false));
                    ReadDescriptors.mergeOnlyMissingEntries(webModule.getWebApp().getPersistenceContextRefMap(), webFragment.getPersistenceContextRef());
                    ReadDescriptors.mergeOnlyMissingEntries(webModule.getWebApp().getPersistenceUnitRefMap(), webFragment.getPersistenceUnitRef());
                    ReadDescriptors.mergeOnlyMissingEntries(webModule.getWebApp().getMessageDestinationRefMap(), webFragment.getMessageDestinationRef());
                    ReadDescriptors.mergeOnlyMissingEntries(webModule.getWebApp().getDataSourceMap(), webFragment.getDataSource());
                    ReadDescriptors.mergeOnlyMissingEntries(webModule.getWebApp().getEjbLocalRefMap(), webFragment.getEjbLocalRef());
                    ReadDescriptors.mergeOnlyMissingEntries(webModule.getWebApp().getEjbRefMap(), webFragment.getEjbRef());
                    ReadDescriptors.mergeOnlyMissingEntries(webModule.getWebApp().getServiceRefMap(), webFragment.getServiceRef());
                    ReadDescriptors.mergeOnlyMissingEntries(webModule.getWebApp().getEnvEntryMap(), webFragment.getEnvEntry());
                    ReadDescriptors.mergeOnlyMissingEntries(webModule.getWebApp().getResourceEnvRefMap(), webFragment.getResourceEnvRef());
                    ReadDescriptors.mergeOnlyMissingEntries(webModule.getWebApp().getResourceRefMap(), webFragment.getResourceRef());
                }
                catch (Exception e) {
                    logger.warning("can't read " + url.toString(), e);
                }
            }
        }
    }

    private static <A extends Keyable<String>> void mergeOnlyMissingEntries(Map<String, A> existing, Collection<A> news) {
        for (Keyable entry : news) {
            String key = (String)entry.getKey();
            if (existing.containsKey(key)) continue;
            existing.put(key, entry);
        }
    }

    public static ApplicationClient readApplicationClient(URL url) throws OpenEJBException {
        ApplicationClient applicationClient;
        try {
            applicationClient = ApplicationClientXml.unmarshal((URL)url);
        }
        catch (SAXException e) {
            throw new OpenEJBException("Cannot parse the application-client.xml file: " + url.toExternalForm(), e);
        }
        catch (JAXBException e) {
            throw new OpenEJBException("Cannot unmarshall the application-client.xml file: " + url.toExternalForm(), e);
        }
        catch (IOException e) {
            throw new OpenEJBException("Cannot read the application-client.xml file: " + url.toExternalForm(), e);
        }
        catch (Exception e) {
            throw new OpenEJBException("Encountered unknown error parsing the application-client.xml file: " + url.toExternalForm(), e);
        }
        return applicationClient;
    }

    public static EjbJar readEjbJar(InputStream is) throws OpenEJBException {
        try {
            String content = IO.slurp((InputStream)is);
            if (ReadDescriptors.isEmptyEjbJar(new ByteArrayInputStream(content.getBytes()))) {
                String id = ReadDescriptors.getId(new ByteArrayInputStream(content.getBytes()));
                return new EjbJar(id);
            }
            return EjbJarXml.unmarshal((InputStream)new ByteArrayInputStream(content.getBytes()));
        }
        catch (SAXException e) {
            throw new OpenEJBException("Cannot parse the ejb-jar.xml", e);
        }
        catch (IOException e) {
            throw new OpenEJBException("Cannot read the ejb-jar.xml", e);
        }
        catch (Exception e) {
            throw new OpenEJBException("Encountered error parsing the ejb-jar.xml", e);
        }
    }

    public static Beans readBeans(InputStream inputStream) throws OpenEJBException {
        try {
            String content = IO.slurp((InputStream)inputStream).trim();
            if (content.length() == 0) {
                Beans beans = new Beans();
                beans.setBeanDiscoveryMode("ALL");
                return beans;
            }
            return (Beans)JaxbJavaee.unmarshalJavaee(Beans.class, (InputStream)new ByteArrayInputStream(content.getBytes()));
        }
        catch (SAXException e) {
            throw new OpenEJBException("Cannot parse the beans.xml", e);
        }
        catch (JAXBException e) {
            e.printStackTrace();
            throw new OpenEJBException("Cannot unmarshall the beans.xml", e);
        }
        catch (IOException e) {
            throw new OpenEJBException("Cannot read the beans.xml", e);
        }
        catch (Exception e) {
            throw new OpenEJBException("Encountered unknown error parsing the beans.xml", e);
        }
    }

    private static boolean isEmptyEjbJar(InputStream is) throws IOException, ParserConfigurationException, SAXException {
        return ReadDescriptors.isEmpty(is, "ejb-jar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isEmpty(InputStream is, final String rootElement) throws IOException, ParserConfigurationException, SAXException {
        SAXParser parser;
        LengthInputStream in = new LengthInputStream(is);
        InputSource inputSource = new InputSource(in);
        Thread thread = Thread.currentThread();
        ClassLoader original = thread.getContextClassLoader();
        thread.setContextClassLoader(Saxs.class.getClassLoader());
        try {
            parser = Saxs.namespaceAwareFactory().newSAXParser();
        }
        finally {
            thread.setContextClassLoader(original);
        }
        try {
            parser.parse(inputSource, new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes att) throws SAXException {
                    if (!localName.equals(rootElement)) {
                        throw new SAXException(localName);
                    }
                }

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
                    return new InputSource(new ByteArrayInputStream(new byte[0]));
                }
            });
            return true;
        }
        catch (SAXException e) {
            return in.getLength() == 0L;
        }
    }

    private static String getId(InputStream is) {
        final String[] id = new String[]{null};
        try {
            LengthInputStream in = new LengthInputStream(is);
            InputSource inputSource = new InputSource(in);
            SAXParser parser = Saxs.namespaceAwareFactory().newSAXParser();
            parser.parse(inputSource, new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes att) throws SAXException {
                    id[0] = att.getValue("id");
                }

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
                    return new InputSource(new ByteArrayInputStream(new byte[0]));
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return id[0];
    }

    public static Webservices readWebservices(URL url) throws OpenEJBException {
        try {
            return WebservicesXml.unmarshal((URL)url);
        }
        catch (SAXException e) {
            throw new OpenEJBException("Cannot parse the webservices.xml file: " + url.toExternalForm(), e);
        }
        catch (JAXBException e) {
            throw new OpenEJBException("Cannot unmarshall the webservices.xml file: " + url.toExternalForm(), e);
        }
        catch (IOException e) {
            throw new OpenEJBException("Cannot read the webservices.xml file: " + url.toExternalForm(), e);
        }
        catch (Exception e) {
            throw new OpenEJBException("Encountered unknown error parsing the webservices.xml file: " + url.toExternalForm(), e);
        }
    }

    public static HandlerChains readHandlerChains(URL url) throws OpenEJBException {
        try {
            return HandlerChainsXml.unmarshal((URL)url);
        }
        catch (SAXException e) {
            throw new OpenEJBException("Cannot parse the webservices.xml file: " + url.toExternalForm(), e);
        }
        catch (JAXBException e) {
            throw new OpenEJBException("Cannot unmarshall the webservices.xml file: " + url.toExternalForm(), e);
        }
        catch (IOException e) {
            throw new OpenEJBException("Cannot read the webservices.xml file: " + url.toExternalForm(), e);
        }
        catch (Exception e) {
            throw new OpenEJBException("Encountered unknown error parsing the webservices.xml file: " + url.toExternalForm(), e);
        }
    }

    public static JavaWsdlMapping readJaxrpcMapping(URL url) throws OpenEJBException {
        JavaWsdlMapping wsdlMapping;
        try {
            wsdlMapping = (JavaWsdlMapping)JaxbJavaee.unmarshalJavaee(JavaWsdlMapping.class, (InputStream)IO.read((URL)url));
        }
        catch (SAXException e) {
            throw new OpenEJBException("Cannot parse the JaxRPC mapping file: " + url.toExternalForm(), e);
        }
        catch (JAXBException e) {
            throw new OpenEJBException("Cannot unmarshall the JaxRPC mapping file: " + url.toExternalForm(), e);
        }
        catch (IOException e) {
            throw new OpenEJBException("Cannot read the JaxRPC mapping file: " + url.toExternalForm(), e);
        }
        catch (Exception e) {
            throw new OpenEJBException("Encountered unknown error parsing the JaxRPC mapping file: " + url.toExternalForm(), e);
        }
        return wsdlMapping;
    }

    public static Connector readConnector(URL url) throws OpenEJBException {
        Connector connector;
        try {
            connector = (Connector)JaxbJavaee.unmarshalJavaee(Connector.class, (InputStream)IO.read((URL)url));
        }
        catch (JAXBException e) {
            try {
                Connector10 connector10 = (Connector10)JaxbJavaee.unmarshalJavaee(Connector10.class, (InputStream)IO.read((URL)url));
                connector = Connector.newConnector((Connector10)connector10);
            }
            catch (ParserConfigurationException | SAXException e1) {
                throw new OpenEJBException("Cannot parse the ra.xml file: " + url.toExternalForm(), e);
            }
            catch (JAXBException e1) {
                throw new OpenEJBException("Cannot unmarshall the ra.xml file: " + url.toExternalForm(), e);
            }
            catch (IOException e1) {
                throw new OpenEJBException("Cannot read the ra.xml file: " + url.toExternalForm(), e);
            }
        }
        catch (SAXException e) {
            throw new OpenEJBException("Cannot parse the ra.xml file: " + url.toExternalForm(), e);
        }
        catch (IOException e) {
            throw new OpenEJBException("Cannot read the ra.xml file: " + url.toExternalForm(), e);
        }
        catch (Exception e) {
            throw new OpenEJBException("Encountered unknown error parsing the ra.xml file: " + url.toExternalForm(), e);
        }
        return connector;
    }

    public static WebApp readWebApp(URL url) throws OpenEJBException {
        WebApp webApp;
        try {
            webApp = WebXml.unmarshal((URL)url);
        }
        catch (SAXException e) {
            throw new OpenEJBException("Cannot parse the web.xml file: " + url.toExternalForm(), e);
        }
        catch (JAXBException e) {
            throw new OpenEJBException("Cannot unmarshall the web.xml file: " + url.toExternalForm(), e);
        }
        catch (IOException e) {
            throw new OpenEJBException("Cannot read the web.xml file: " + url.toExternalForm(), e);
        }
        catch (Exception e) {
            throw new OpenEJBException("Encountered unknown error parsing the web.xml file: " + url.toExternalForm(), e);
        }
        return webApp;
    }

    public static TldTaglib readTldTaglib(URL url) throws OpenEJBException {
        if (url.getPath().contains("jstl-1.2.jar")) {
            return SKIP_TAGLIB;
        }
        if (url.getPath().contains("myfaces-impl")) {
            TldTaglib taglib = new TldTaglib();
            Listener listener = new Listener();
            listener.setListenerClass("org.apache.myfaces.webapp.StartupServletContextListener");
            taglib.getListener().add(listener);
            return taglib;
        }
        try {
            return TldTaglibXml.unmarshal((URL)url);
        }
        catch (SAXException e) {
            String message = "Cannot parse the JSP tag library definition file: " + url.toExternalForm();
            logger.warning(message);
            logger.debug(message, e);
        }
        catch (JAXBException e) {
            String message = "Cannot unmarshall the JSP tag library definition file: " + url.toExternalForm();
            logger.warning(message);
            logger.debug(message, e);
        }
        catch (IOException e) {
            String message = "Cannot read the JSP tag library definition file: " + url.toExternalForm();
            logger.warning(message);
            logger.debug(message, e);
        }
        catch (Exception e) {
            String message = "Encountered unknown error parsing the JSP tag library definition file: " + url.toExternalForm();
            logger.warning(message);
            logger.debug(message, e);
        }
        return SKIP_TAGLIB;
    }

    public static FacesConfig readFacesConfig(URL url) throws OpenEJBException {
        try {
            Source src = ReadDescriptors.getSource(url);
            if (src == null) {
                return new FacesConfig();
            }
            String content = IO.slurp((InputStream)src.get());
            if (ReadDescriptors.isEmpty(new ByteArrayInputStream(content.getBytes()), "faces-config")) {
                return new FacesConfig();
            }
            return FacesConfigXml.unmarshal((InputStream)new ByteArrayInputStream(content.getBytes()));
        }
        catch (SAXException e) {
            throw new OpenEJBException("Cannot parse the faces configuration file: " + url.toExternalForm(), e);
        }
        catch (JAXBException e) {
            throw new OpenEJBException("Cannot unmarshall the faces configuration file: " + url.toExternalForm(), e);
        }
        catch (IOException e) {
            throw new OpenEJBException("Cannot read the faces configuration file: " + url.toExternalForm(), e);
        }
        catch (Exception e) {
            throw new OpenEJBException("Encountered unknown error parsing the faces configuration file: " + url.toExternalForm(), e);
        }
    }

    private static Source getSource(Object o) {
        if (o instanceof URL) {
            return new UrlSource((URL)o);
        }
        if (o instanceof Source) {
            return (Source)o;
        }
        if (o instanceof String) {
            return new StringSource((String)o);
        }
        return null;
    }

    public static class StringSource
    implements Source {
        private final byte[] bytes;

        public StringSource(String content) {
            this.bytes = content.getBytes();
        }

        @Override
        public InputStream get() throws IOException {
            return new ByteArrayInputStream(this.bytes);
        }
    }

    public static class UrlSource
    implements Source {
        private final URL url;

        public UrlSource(URL url) {
            this.url = url;
        }

        @Override
        public InputStream get() throws IOException {
            return IO.read((URL)this.url);
        }

        public URL getUrl() {
            return this.url;
        }
    }

    public static interface Source {
        public InputStream get() throws IOException;
    }
}

