/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.threads.task;

import java.util.concurrent.Callable;
import javax.security.auth.login.LoginException;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.ivm.ClientSecurity;
import org.apache.openejb.core.security.AbstractSecurityService;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.threads.task.ManagedTaskListenerTask;

public abstract class CUTask<T>
extends ManagedTaskListenerTask
implements Comparable<Object> {
    private static final SecurityService SECURITY_SERVICE = (SecurityService)SystemInstance.get().getComponent(SecurityService.class);
    private final Context initialContext;

    public CUTask(Object task) {
        super(task);
        Object stateTmp = SECURITY_SERVICE.currentState();
        boolean associate = stateTmp == null ? (stateTmp = ClientSecurity.getIdentity()) != null : false;
        ThreadContext threadContext = ThreadContext.getThreadContext();
        this.initialContext = new Context(associate, stateTmp, threadContext == null ? null : threadContext.get(AbstractSecurityService.SecurityContext.class), threadContext, Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T invoke(Callable<T> call) throws Exception {
        this.initialContext.enter();
        Throwable throwable = null;
        try {
            this.taskStarting(this.future, this.executor, this.delegate);
            T t = call.call();
            return t;
        }
        catch (Throwable t) {
            throwable = t;
            this.taskAborted(throwable);
            T t2 = this.rethrow(t);
            return t2;
        }
        finally {
            this.taskDone(this.future, this.executor, this.delegate, throwable);
            this.initialContext.exit();
        }
    }

    private T rethrow(Throwable t) throws Exception {
        if (Exception.class.isInstance(t)) {
            throw (Exception)Exception.class.cast(t);
        }
        if (Error.class.isInstance(t)) {
            throw (Error)Error.class.cast(t);
        }
        throw new OpenEJBRuntimeException(t.getMessage(), t);
    }

    @Override
    public int compareTo(Object o) {
        return Comparable.class.isInstance(this.delegate) ? ((Comparable)Comparable.class.cast(this.delegate)).compareTo(o) : -1;
    }

    public static final class Context {
        private final Object securityServiceState;
        private final ThreadContext threadContext;
        private final ClassLoader loader;
        private final boolean associate;
        private final AbstractSecurityService.SecurityContext securityContext;
        private Context currentContext;

        private Context(boolean associate, Object initialSecurityServiceState, AbstractSecurityService.SecurityContext securityContext, ThreadContext initialThreadContext, ClassLoader initialLoader) {
            this.associate = associate;
            this.securityServiceState = initialSecurityServiceState;
            this.securityContext = securityContext;
            this.threadContext = initialThreadContext;
            this.loader = initialLoader;
        }

        public void enter() {
            ThreadContext oldCtx;
            Object threadState;
            Thread thread = Thread.currentThread();
            ClassLoader oldCl = thread.getContextClassLoader();
            thread.setContextClassLoader(this.loader);
            if (this.associate) {
                try {
                    SECURITY_SERVICE.associate(this.securityServiceState);
                }
                catch (LoginException e) {
                    throw new IllegalStateException(e);
                }
                threadState = null;
            } else {
                threadState = SECURITY_SERVICE.currentState();
                SECURITY_SERVICE.setState(this.securityServiceState);
            }
            if (this.threadContext != null) {
                ThreadContext newContext = new ThreadContext(this.threadContext);
                newContext.set(Context.class, this);
                if (this.securityContext != null) {
                    newContext.set(AbstractSecurityService.ProvidedSecurityContext.class, new AbstractSecurityService.ProvidedSecurityContext(this.securityContext));
                }
                oldCtx = ThreadContext.enter(newContext);
            } else {
                oldCtx = null;
            }
            this.currentContext = new Context(this.associate, threadState, this.securityContext, oldCtx, oldCl);
        }

        public void exit() {
            if (this.threadContext != null) {
                ThreadContext.exit(this.currentContext.threadContext);
            }
            if (!this.associate) {
                SECURITY_SERVICE.setState(this.currentContext.securityServiceState);
            } else {
                SECURITY_SERVICE.disassociate();
            }
            Thread.currentThread().setContextClassLoader(this.currentContext.loader);
            this.currentContext = null;
        }
    }
}

