/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.openejb.assembler.classic.BeansInfo;
import org.apache.openejb.loader.SystemInstance;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.spi.BeanArchiveService;
import org.apache.webbeans.xml.DefaultBeanArchiveInformation;

public class OpenEJBBeanInfoService
implements BeanArchiveService {
    private Map<URL, BeanArchiveService.BeanArchiveInformation> beanArchiveInfo = new HashMap<URL, BeanArchiveService.BeanArchiveInformation>();

    public Map<URL, BeanArchiveService.BeanArchiveInformation> getBeanArchiveInfo() {
        return this.beanArchiveInfo;
    }

    public DefaultBeanArchiveInformation createBeanArchiveInformation(BeansInfo.BDAInfo bda, BeansInfo info, ClassLoader loader) {
        String mode;
        String string = mode = bda.discoveryMode == null ? "ALL" : bda.discoveryMode;
        if (info != null && info.version != null && !"1.0".equals(info.version) && info.discoveryMode == null) {
            throw new WebBeansConfigurationException("beans.xml with version 1.1 and higher must declare a bean-discovery-mode!");
        }
        DefaultBeanArchiveInformation information = new DefaultBeanArchiveInformation();
        information.setVersion(info == null ? "1.1" : info.version);
        information.setBeanDiscoveryMode(BeanArchiveService.BeanDiscoveryMode.valueOf((String)mode.trim().toUpperCase(Locale.ENGLISH)));
        information.setDecorators(bda.decorators);
        information.setInterceptors(bda.interceptors);
        if (info != null) {
            information.getAlternativeClasses().addAll(bda.alternatives);
            information.getAlternativeStereotypes().addAll(bda.stereotypeAlternatives);
            for (BeansInfo.ExclusionEntryInfo exclusionInfo : info.excludes) {
                boolean skip = false;
                for (String n : exclusionInfo.exclusion.availableClasses) {
                    if (OpenEJBBeanInfoService.isClassAvailable(loader, n)) continue;
                    skip = true;
                    break;
                }
                if (!skip) {
                    for (String n : exclusionInfo.exclusion.notAvailableClasses) {
                        if (!OpenEJBBeanInfoService.isClassAvailable(loader, n)) continue;
                        skip = true;
                        break;
                    }
                }
                if (!skip) {
                    for (String n : exclusionInfo.exclusion.systemPropertiesPresence) {
                        if (SystemInstance.get().getProperty(n) != null) continue;
                        skip = true;
                        break;
                    }
                }
                if (!skip) {
                    for (String n : exclusionInfo.exclusion.systemProperties.stringPropertyNames()) {
                        if (exclusionInfo.exclusion.systemProperties.getProperty(n).equals(SystemInstance.get().getProperty(n))) continue;
                        skip = true;
                        break;
                    }
                }
                if (skip) continue;
                String name = exclusionInfo.name;
                if (name.endsWith(".*")) {
                    information.addClassExclude(name.substring(0, name.length() - 2));
                    continue;
                }
                if (name.endsWith(".**")) {
                    information.addPackageExclude(name.substring(0, name.length() - 3));
                    continue;
                }
                information.addClassExclude(name);
            }
        }
        return information;
    }

    private static boolean isClassAvailable(ClassLoader loader, String name) {
        try {
            loader.loadClass(name);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public BeanArchiveService.BeanArchiveInformation getBeanArchiveInformation(URL beanArchiveUrl) {
        return this.beanArchiveInfo.get(beanArchiveUrl);
    }

    public Set<URL> getRegisteredBeanArchives() {
        return Collections.emptySet();
    }

    public void release() {
    }
}

