/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.File;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import javax.xml.bind.Marshaller;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.openejb.assembler.classic.ResourceInfo;
import org.apache.openejb.cli.SystemExitException;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.sys.JaxbOpenejb;
import org.apache.openejb.config.sys.Openejb;
import org.apache.openejb.config.sys.Resource;

public final class EffectiveTomEEXml {
    public static void main(String[] args) throws Exception {
        CommandLine line = EffectiveTomEEXml.parseCommand(args);
        if (line == null) {
            return;
        }
        Openejb openejb = JaxbOpenejb.readConfig(EffectiveTomEEXml.findXml(line).getCanonicalPath());
        ConfigurationFactory configFact = new ConfigurationFactory();
        for (Resource r : openejb.getResource()) {
            ResourceInfo ri = configFact.configureService(r, ResourceInfo.class);
            if (!ri.properties.containsKey("SkipImplicitAttributes")) {
                ri.properties.put("SkipImplicitAttributes", "false");
            }
            r.getProperties().clear();
            r.getProperties().putAll((Map<?, ?>)ri.properties);
        }
        Marshaller marshaller = JaxbOpenejb.getContext(Openejb.class).createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)openejb, (OutputStream)System.out);
    }

    private static CommandLine parseCommand(String[] args) throws SystemExitException {
        CommandLine line;
        Options options = new Options();
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withLongOpt((String)"path");
        OptionBuilder.withDescription((String)"[openejb|tomee].xml path");
        options.addOption(OptionBuilder.create((String)"p"));
        try {
            line = new PosixParser().parse(options, args);
        }
        catch (ParseException exp) {
            EffectiveTomEEXml.help(options);
            throw new SystemExitException(-1);
        }
        if (line.hasOption("help")) {
            EffectiveTomEEXml.help(options);
            return null;
        }
        return line;
    }

    private static File findXml(CommandLine line) {
        File xml = null;
        if (line.hasOption("path")) {
            xml = new File(line.getOptionValue("path"));
        } else {
            for (String config : Arrays.asList("tomee.xml", "openejb.xml")) {
                xml = new File(System.getProperty("openejb.base", System.getProperty("openejb.home", System.getProperty("catalina.base", "missing"))), config);
                if (!xml.isFile()) continue;
                break;
            }
        }
        if (xml == null || !xml.isFile()) {
            throw new IllegalArgumentException(xml + " doesnt exist");
        }
        return xml;
    }

    private static void help(Options options) {
        new HelpFormatter().printHelp("effectivetomee [options] <value>", "\n", options, "\n");
    }

    private EffectiveTomEEXml() {
    }
}

