/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.jdbc.router;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.resource.jdbc.router.AbstractRouter;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class FailOverRouter
extends AbstractRouter {
    private static final Logger LOGGER = Logger.getInstance(LogCategory.OPENEJB_SERVER, FailOverRouter.class);
    public static final String DEFAULT_STRATEGY = "default";
    private final AtomicReference<DataSource> facade = new AtomicReference();
    private final Collection<DataSource> dataSources = new CopyOnWriteArrayList<DataSource>();
    private String delimiter = ",";
    private String strategy = "default";
    private String datasourceNames = "";

    @Override
    public DataSource getDataSource() {
        return this.facade.get();
    }

    public void setDatasourceNames(String datasourceNames) {
        this.datasourceNames = datasourceNames;
        this.initDataSources();
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
        this.initDataSources();
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy == null ? DEFAULT_STRATEGY : strategy.toLowerCase(Locale.ENGLISH).trim();
        this.initFacade();
    }

    private void initDataSources() {
        this.dataSources.clear();
        for (String ds : this.datasourceNames.split(Pattern.quote(this.delimiter))) {
            try {
                Object o = this.getOpenEJBResource(ds.trim());
                if (!DataSource.class.isInstance(o)) continue;
                LOGGER.debug("Found datasource '" + ds + "'");
                this.dataSources.add((DataSource)DataSource.class.cast(o));
            }
            catch (NamingException error) {
                LOGGER.error("Can't find datasource '" + ds + "'", error);
            }
        }
        this.initFacade();
    }

    private void initFacade() {
        Class clazz = DataSource.class;
        int xads = 0;
        for (DataSource ds : this.dataSources) {
            if (!XADataSource.class.isInstance(ds)) continue;
            ++xads;
        }
        if (xads > 0 && xads == this.dataSources.size()) {
            clazz = XADataSource.class;
        }
        this.facade.set((DataSource)DataSource.class.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz}, (InvocationHandler)new FacadeHandler(this.dataSources, this.strategy))));
    }

    public Collection<DataSource> getDataSources() {
        return this.dataSources;
    }

    public void updateDataSources(Collection<DataSource> ds) {
        this.dataSources.clear();
        this.dataSources.addAll(ds);
        this.initFacade();
    }

    private static Collection<DataSource> sortFollowingStrategy(String strategy, Collection<DataSource> delegates, AtomicInteger idx) {
        if (strategy == null) {
            return delegates;
        }
        if (DEFAULT_STRATEGY.equals(strategy) || strategy.isEmpty()) {
            return delegates;
        }
        if ("random".equals(strategy)) {
            ArrayList<DataSource> ds = new ArrayList<DataSource>(delegates);
            Collections.shuffle(ds);
            return ds;
        }
        if ("reverse".equals(strategy)) {
            ArrayList<DataSource> ds = new ArrayList<DataSource>(delegates);
            int times = idx.incrementAndGet() % ds.size();
            for (int i = 0; i < times; ++i) {
                Collections.reverse(ds);
            }
            return ds;
        }
        if (strategy.startsWith("round-robin")) {
            int step = strategy.contains("%") ? Math.max(1, Integer.parseInt(strategy.substring(strategy.lastIndexOf("%") + 1))) : 1;
            ArrayList<DataSource> ds = new ArrayList<DataSource>(delegates);
            int currentIdx = 0;
            for (int i = 0; i < step; ++i) {
                currentIdx = idx.incrementAndGet();
            }
            Collections.rotate(ds, 1 + currentIdx % ds.size());
            return ds;
        }
        return delegates;
    }

    private static class FacadeHandler
    implements InvocationHandler {
        private static final TransactionSynchronizationRegistry SYNCHRONIZATION_REGISTRY = (TransactionSynchronizationRegistry)SystemInstance.get().getComponent(TransactionSynchronizationRegistry.class);
        private static final String DATASOURCE_KEY = "router_datasource_in_use";
        private final Collection<DataSource> delegates;
        private final String strategy;
        private final AtomicInteger currentIdx = new AtomicInteger(0);

        public FacadeHandler(Collection<DataSource> dataSources, String strategy) {
            this.delegates = dataSources;
            this.strategy = strategy;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            DataSource currentDs;
            TransactionManager txMgr;
            Transaction transaction;
            if (Object.class.equals(method.getDeclaringClass())) {
                if ("toString".equals(method.getName())) {
                    return "DataSourceFacade" + this.delegates;
                }
                if ("hashCode".equals(method.getName())) {
                    return this.delegates.hashCode();
                }
                if ("equals".equals(method.getName())) {
                    return method.invoke((Object)this, args);
                }
            }
            if ((transaction = (txMgr = OpenEJB.getTransactionManager()).getTransaction()) != null && (currentDs = (DataSource)DataSource.class.cast(SYNCHRONIZATION_REGISTRY.getResource((Object)DATASOURCE_KEY))) != null) {
                return method.invoke((Object)currentDs, args);
            }
            int ex = 0;
            Collection sources = FailOverRouter.sortFollowingStrategy(this.strategy, this.delegates, this.currentIdx);
            int size = sources.size();
            Object out = null;
            for (DataSource ds : sources) {
                try {
                    boolean set = method.getName().startsWith("set");
                    if (set) {
                        method.invoke((Object)ds, args);
                    } else {
                        out = method.invoke((Object)ds, args);
                    }
                    if (transaction != null) {
                        SYNCHRONIZATION_REGISTRY.putResource((Object)DATASOURCE_KEY, (Object)ds);
                        break;
                    }
                    if (set) continue;
                    break;
                }
                catch (InvocationTargetException ite) {
                    if (++ex != size) continue;
                    throw ite.getCause();
                }
            }
            return out;
        }
    }
}

