/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import javax.xml.parsers.SAXParser;
import org.apache.openejb.config.event.BeforeDeploymentEvent;
import org.apache.openejb.loader.Files;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.observer.Observes;
import org.apache.openejb.util.JarCreator;
import org.apache.openejb.util.JarExtractor;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.Saxs;
import org.apache.openejb.util.URLs;
import org.apache.openejb.util.classloader.URLClassLoaderFirst;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DeployTimeEnhancer {
    private static final Logger LOGGER = Logger.getInstance(LogCategory.OPENEJB_DEPLOY, DeployTimeEnhancer.class);
    private static final String OPENEJB_JAR_ENHANCEMENT_INCLUDE = "openejb.jar.enhancement.include";
    private static final String OPENEJB_JAR_ENHANCEMENT_EXCLUDE = "openejb.jar.enhancement.exclude";
    private static final String CLASS_EXT = ".class";
    private static final String PROPERTIES_FILE_PROP = "propertiesFile";
    private static final String META_INF_PERSISTENCE_XML = "META-INF/persistence.xml";
    private static final String TMP_ENHANCEMENT_SUFFIX = ".tmp-enhancement";
    private final Method enhancerMethod;
    private final Constructor<?> optionsConstructor;

    public DeployTimeEnhancer() {
        Method mtd;
        Constructor<?> cstr;
        ClassLoader cl = DeployTimeEnhancer.class.getClassLoader();
        try {
            Class<?> enhancerClass = cl.loadClass("org.apache.openjpa.enhance.PCEnhancer");
            Class<?> arg2 = cl.loadClass("org.apache.openjpa.lib.util.Options");
            cstr = arg2.getConstructor(Properties.class);
            mtd = enhancerClass.getMethod("run", String[].class, arg2);
        }
        catch (Exception e) {
            LOGGER.warning("openjpa enhancer can't be found in the container, will be skipped");
            mtd = null;
            cstr = null;
        }
        this.optionsConstructor = cstr;
        this.enhancerMethod = mtd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enhance(@Observes BeforeDeploymentEvent event) {
        if (this.enhancerMethod == null) {
            LOGGER.debug("OpenJPA is not available so no deploy-time enhancement will be done");
            return;
        }
        HashMap<String, List<String>> classesByPXml = new HashMap<String, List<String>>();
        ArrayList<URL> usedUrls = new ArrayList<URL>();
        for (URL url : event.getUrls()) {
            File file = URLs.toFile(url);
            if (file.isDirectory()) {
                String pXmls = this.getWarPersistenceXml(url);
                if (pXmls != null) {
                    this.feed(classesByPXml, pXmls);
                }
                usedUrls.add(url);
                continue;
            }
            if (file.getName().endsWith(".jar")) {
                JarFile jar = null;
                try {
                    jar = new JarFile(file);
                    ZipEntry entry = jar.getEntry(META_INF_PERSISTENCE_XML);
                    if (entry != null) {
                        String path = file.getAbsolutePath();
                        File unpacked = new File(path.substring(0, path.length() - 4) + TMP_ENHANCEMENT_SUFFIX);
                        JarExtractor.extract(file, unpacked);
                        usedUrls.add(unpacked.toURI().toURL());
                        this.feed(classesByPXml, new File(unpacked, META_INF_PERSISTENCE_XML).getAbsolutePath());
                        continue;
                    }
                    usedUrls.add(url);
                    continue;
                }
                catch (IOException entry) {
                    continue;
                }
                finally {
                    try {
                        if (jar != null) {
                            jar.close();
                        }
                    }
                    catch (IOException entry) {}
                }
            }
            usedUrls.add(url);
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        URLClassLoaderFirst fakeClassLoader = new URLClassLoaderFirst(usedUrls.toArray(new URL[usedUrls.size()]), event.getParentClassLoader());
        LOGGER.info("Enhancing url(s): " + usedUrls);
        Thread.currentThread().setContextClassLoader(fakeClassLoader);
        try {
            for (Map.Entry entry : classesByPXml.entrySet()) {
                Object optsArg;
                Properties opts = new Properties();
                opts.setProperty(PROPERTIES_FILE_PROP, (String)entry.getKey());
                try {
                    optsArg = this.optionsConstructor.newInstance(opts);
                }
                catch (Exception e) {
                    LOGGER.debug("can't create options for enhancing");
                    Thread.currentThread().setContextClassLoader(tccl);
                    usedUrls.clear();
                    return;
                }
                String[] args = this.toFilePaths((List)entry.getValue());
                LOGGER.info("Enhancing: " + Arrays.asList(args));
                try {
                    this.enhancerMethod.invoke(null, args, optsArg);
                }
                catch (Exception e) {
                    LOGGER.warning("can't enhanced at deploy-time entities", e);
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
            usedUrls.clear();
        }
        for (Map.Entry entry : classesByPXml.entrySet()) {
            List values = (List)entry.getValue();
            for (String rawPath : values) {
                if (!rawPath.endsWith(".tmp-enhancement/") && !rawPath.endsWith(TMP_ENHANCEMENT_SUFFIX)) continue;
                File dir = new File(rawPath);
                File file = new File(rawPath.substring(0, rawPath.length() - TMP_ENHANCEMENT_SUFFIX.length() - 1) + ".jar");
                if (!file.exists()) continue;
                String name = dir.getName();
                name = name.substring(0, name.length() - TMP_ENHANCEMENT_SUFFIX.length()) + ".jar";
                File target = new File(dir.getParentFile(), name);
                try {
                    Files.delete((File)file);
                    JarCreator.jarDir(dir, target);
                }
                catch (IOException e) {
                    LOGGER.error("can't repackage enhanced jar file " + file.getName());
                }
                Files.delete((File)dir);
            }
            values.clear();
        }
        classesByPXml.clear();
    }

    private void feed(Map<String, List<String>> classesByPXml, String pXml) {
        ArrayList<String> paths = new ArrayList<String>();
        if (pXml.endsWith(META_INF_PERSISTENCE_XML)) {
            paths.add(pXml.substring(0, pXml.length() - META_INF_PERSISTENCE_XML.length()));
        } else if (pXml.endsWith("/WEB-INF/persistence.xml")) {
            paths.add(pXml.substring(0, pXml.length() - 24));
        }
        try {
            SAXParser parser = Saxs.factory().newSAXParser();
            JarFileParser handler = new JarFileParser();
            parser.parse(new File(pXml), (DefaultHandler)handler);
            for (String path : handler.getPaths()) {
                paths.add(this.relative((String)paths.iterator().next(), path));
            }
        }
        catch (Exception e) {
            LOGGER.error("can't parse '" + pXml + "'", e);
        }
        classesByPXml.put(pXml, paths);
    }

    private String relative(String relativePath, String pXmlPath) {
        return new File(new File(pXmlPath).getParent(), relativePath).getAbsolutePath();
    }

    private String getWarPersistenceXml(URL url) {
        File dir = URLs.toFile(url);
        if (dir.isDirectory() && (dir.getAbsolutePath().endsWith("/WEB-INF/classes") || dir.getAbsolutePath().endsWith("/WEB-INF/classes/"))) {
            File pXmlStd = new File(dir.getParentFile(), "persistence.xml");
            if (pXmlStd.exists()) {
                return pXmlStd.getAbsolutePath();
            }
            File pXml = new File(dir, META_INF_PERSISTENCE_XML);
            if (pXml.exists()) {
                return pXml.getAbsolutePath();
            }
        }
        return null;
    }

    private String[] toFilePaths(List<String> urls) {
        ArrayList<String> files = new ArrayList<String>();
        for (String url : urls) {
            File dir = new File(url);
            if (!dir.isDirectory()) continue;
            for (File f : Files.collect((File)dir, (FileFilter)new ClassFilter())) {
                files.add(f.getAbsolutePath());
            }
        }
        return files.toArray(new String[files.size()]);
    }

    private static class JarFileParser
    extends DefaultHandler {
        private final List<String> paths = new ArrayList<String>();
        private boolean getIt;

        private JarFileParser() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes att) throws SAXException {
            if (!localName.endsWith("jar-file")) {
                return;
            }
            this.getIt = true;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.getIt) {
                this.paths.add(String.valueOf(ch, start, length));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.getIt = false;
        }

        public List<String> getPaths() {
            return this.paths;
        }
    }

    private static class ClassFilter
    implements FileFilter {
        private static final String DEFAULT_INCLUDE = "\\*";
        private static final String DEFAULT_EXCLUDE = "";
        private static final Pattern INCLUDE_PATTERN = Pattern.compile(SystemInstance.get().getOptions().get("openejb.jar.enhancement.include", "\\*"));
        private static final Pattern EXCLUDE_PATTERN = Pattern.compile(SystemInstance.get().getOptions().get("openejb.jar.enhancement.exclude", ""));

        private ClassFilter() {
        }

        @Override
        public boolean accept(File file) {
            boolean isClass = file.getName().endsWith(DeployTimeEnhancer.CLASS_EXT);
            if (DEFAULT_EXCLUDE.equals(EXCLUDE_PATTERN.pattern()) && DEFAULT_INCLUDE.equals(INCLUDE_PATTERN.pattern())) {
                return isClass;
            }
            String path = file.getAbsolutePath();
            return isClass && INCLUDE_PATTERN.matcher(path).matches() && !EXCLUDE_PATTERN.matcher(path).matches();
        }
    }
}

