/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.ObservesAsync;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.DefinitionException;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.inject.spi.Producer;
import javax.enterprise.inject.spi.SessionBeanType;
import javax.inject.Provider;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContextListener;
import javax.servlet.jsp.tagext.JspTag;
import org.apache.openejb.BeanContext;
import org.apache.openejb.BeanType;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.cdi.CdiEjbBean;
import org.apache.openejb.cdi.CdiResourceInjectionService;
import org.apache.openejb.cdi.CurrentCreationalContext;
import org.apache.openejb.cdi.NewCdiEjbBean;
import org.apache.openejb.cdi.OpenEJBBeanBuilder;
import org.apache.openejb.cdi.WebappWebBeansContext;
import org.apache.openejb.core.ivm.IntraVmProxy;
import org.apache.openejb.util.proxy.ProxyManager;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.component.ProducerFieldBean;
import org.apache.webbeans.component.ProducerMethodBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.component.creation.BeanAttributesBuilder;
import org.apache.webbeans.component.creation.ObserverMethodsBuilder;
import org.apache.webbeans.component.creation.ProducerFieldBeansBuilder;
import org.apache.webbeans.component.creation.ProducerMethodBeansBuilder;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.ee.beans.UserTransactionBean;
import org.apache.webbeans.ee.beans.ValidatorBean;
import org.apache.webbeans.ee.beans.ValidatorFactoryBean;
import org.apache.webbeans.ejb.common.component.BaseEjbBean;
import org.apache.webbeans.event.ObserverMethodImpl;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.portable.events.discovery.BeforeShutdownImpl;
import org.apache.webbeans.portable.events.generics.GProcessSessionBean;
import org.apache.webbeans.proxy.NormalScopeProxyFactory;
import org.apache.webbeans.spi.ResourceInjectionService;
import org.apache.webbeans.spi.SecurityService;
import org.apache.webbeans.spi.TransactionService;
import org.apache.webbeans.spi.plugins.AbstractOwbPlugin;
import org.apache.webbeans.spi.plugins.OpenWebBeansEjbPlugin;
import org.apache.webbeans.spi.plugins.OpenWebBeansJavaEEPlugin;
import org.apache.webbeans.util.GenericsUtil;
import org.apache.webbeans.util.WebBeansUtil;

public class CdiPlugin
extends AbstractOwbPlugin
implements OpenWebBeansJavaEEPlugin,
OpenWebBeansEjbPlugin {
    private Map<Class<?>, BeanContext> beans;
    private WebBeansContext webBeansContext;
    private ClassLoader classLoader;
    private Map<Contextual<?>, Object> cacheProxies;

    public void setWebBeansContext(WebBeansContext webBeansContext) {
        WebBeansContext parent;
        this.webBeansContext = webBeansContext;
        if (webBeansContext == null) {
            return;
        }
        this.cacheProxies = !WebappWebBeansContext.class.isInstance(webBeansContext) ? new ConcurrentHashMap() : ((parent = ((WebappWebBeansContext)((Object)WebappWebBeansContext.class.cast(webBeansContext))).getParent()) != null ? ((CdiPlugin)((Object)CdiPlugin.class.cast((Object)parent.getPluginLoader().getEjbPlugin()))).cacheProxies : new ConcurrentHashMap());
    }

    public boolean isEEComponent(Class<?> impl) {
        return Servlet.class.isAssignableFrom(impl) || Filter.class.isAssignableFrom(impl) || ServletContextListener.class.isAssignableFrom(impl) || JspTag.class.isAssignableFrom(impl);
    }

    public void registerEEBeans() {
        BeanManagerImpl beanManagerImpl = this.webBeansContext.getBeanManagerImpl();
        beanManagerImpl.addInternalBean((Bean)new ValidatorBean(this.webBeansContext));
        beanManagerImpl.addInternalBean((Bean)new ValidatorFactoryBean(this.webBeansContext));
        beanManagerImpl.addInternalBean((Bean)new UserTransactionBean(this.webBeansContext));
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void shutDown() {
        super.shutDown();
        if (this.beans != null) {
            this.beans.clear();
        }
    }

    public <T> BeanAttributes<T> createBeanAttributes(AnnotatedType<T> type) {
        return new CdiEjbBean.EJBBeanAttributesImpl(CdiPlugin.findBeanContext(this.webBeansContext, type.getJavaClass()), BeanAttributesBuilder.forContext((WebBeansContext)this.webBeansContext).newBeanAttibutes(type).build());
    }

    public void configureDeployments(List<BeanContext> ejbDeployments) {
        this.beans = new WeakHashMap();
        for (BeanContext deployment : ejbDeployments) {
            if (!deployment.getComponentType().isCdiCompatible()) continue;
            if (deployment.isLocalbean() && !deployment.isDynamicallyImplemented()) {
                this.beans.put(deployment.get(BeanContext.ProxyClass.class).getProxy(), deployment);
            }
            this.beans.put(deployment.getBeanClass(), deployment);
        }
    }

    public void stop() throws OpenEJBException {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            this.webBeansContext.getBeanManagerImpl().fireEvent((Object)new BeforeShutdownImpl(), new Annotation[0]);
            this.webBeansContext.getContextsService().destroy(null);
            this.webBeansContext.getPluginLoader().shutDown();
            this.webBeansContext.getExtensionLoader().clear();
            this.webBeansContext.getBeanManagerImpl().getInjectionResolver().clearCaches();
            this.webBeansContext.getAnnotatedElementFactory().clear();
            CdiResourceInjectionService injectionServices = (CdiResourceInjectionService)this.webBeansContext.getService(ResourceInjectionService.class);
            injectionServices.clear();
            WebBeansFinder.clearInstances((Object)WebBeansUtil.getCurrentClassLoader());
        }
        catch (Exception e) {
            throw new OpenEJBException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    public <T> T getSupportedService(Class<T> serviceClass) {
        return this.supportService(serviceClass) ? (T)serviceClass.cast((Object)this) : null;
    }

    public void isManagedBean(Class<?> clazz) {
    }

    public boolean supportService(Class<?> serviceClass) {
        return serviceClass == TransactionService.class || serviceClass == SecurityService.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSessionBeanProxy(Bean<?> inBean, Class<?> interfce, CreationalContext<?> creationalContext) {
        Object instance = this.cacheProxies.get(inBean);
        if (instance != null) {
            return instance;
        }
        Bean<?> bean = inBean;
        synchronized (bean) {
            instance = this.cacheProxies.get(inBean);
            if (instance != null) {
                return instance;
            }
            Class scopeClass = inBean.getScope();
            CdiEjbBean cdiEjbBean = (CdiEjbBean)inBean;
            CreationalContext<?> cc = creationalContext;
            if (scopeClass == null || Dependent.class == scopeClass) {
                return cdiEjbBean.createEjb(cc);
            }
            InstanceBean<Object> bean2 = new InstanceBean<Object>(cdiEjbBean);
            if (this.webBeansContext.getBeanManagerImpl().isNormalScope(scopeClass)) {
                BeanContext beanContext = cdiEjbBean.getBeanContext();
                final Provider provider = this.webBeansContext.getNormalScopeProxyFactory().getInstanceProvider(beanContext.getClassLoader(), (Bean)cdiEjbBean);
                if (!beanContext.isLocalbean()) {
                    ArrayList<Class<BeanContext.Removable>> interfaces = new ArrayList<Class<BeanContext.Removable>>();
                    InterfaceType type = beanContext.getInterfaceType(interfce);
                    if (type != null) {
                        interfaces.addAll(beanContext.getInterfaces(type));
                    } else {
                        interfaces.addAll(beanContext.getInterfaces(InterfaceType.BUSINESS_LOCAL));
                    }
                    interfaces.add(Serializable.class);
                    interfaces.add(IntraVmProxy.class);
                    if (BeanType.STATEFUL.equals((Object)beanContext.getComponentType()) || BeanType.MANAGED.equals((Object)beanContext.getComponentType())) {
                        interfaces.add(BeanContext.Removable.class);
                    }
                    try {
                        instance = ProxyManager.newProxyInstance(interfaces.toArray(new Class[interfaces.size()]), new InvocationHandler(){

                            @Override
                            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                                try {
                                    return method.invoke(provider.get(), args);
                                }
                                catch (InvocationTargetException ite) {
                                    throw ite.getCause();
                                }
                            }
                        });
                    }
                    catch (IllegalAccessException e) {
                        throw new OpenEJBRuntimeException(e);
                    }
                } else {
                    NormalScopeProxyFactory normalScopeProxyFactory = this.webBeansContext.getNormalScopeProxyFactory();
                    Class proxyClass = normalScopeProxyFactory.createProxyClass(beanContext.getClassLoader(), beanContext.getBeanClass());
                    instance = normalScopeProxyFactory.createProxyInstance(proxyClass, provider);
                }
                this.cacheProxies.put((Contextual<?>)inBean, instance);
            } else {
                Context context = this.webBeansContext.getBeanManagerImpl().getContext(scopeClass);
                instance = context.get(bean2, cc);
            }
            bean2.setOwbProxy(instance);
            return instance;
        }
    }

    public boolean isSessionBean(Class<?> clazz) {
        return this.beans != null && this.beans.containsKey(clazz);
    }

    public boolean isNewSessionBean(Class<?> clazz) {
        return this.isNewSessionBean(this.webBeansContext, clazz) || this.isNewSessionBean(CdiPlugin.superContext(this.webBeansContext), clazz);
    }

    public <T> Bean<T> defineSessionBean(Class<T> clazz, BeanAttributes<T> attributes, AnnotatedType<T> annotatedType) {
        BeanContext bc = CdiPlugin.findBeanContext(this.webBeansContext, clazz);
        Class<Object> superClass = bc.getManagedClass().getSuperclass();
        if (annotatedType.isAnnotationPresent(Specializes.class)) {
            if (superClass != Object.class && !this.isSessionBean(superClass)) {
                throw new DefinitionException("You can only specialize another EJB: " + clazz);
            }
            BeanContext parentBc = CdiPlugin.findBeanContext(this.webBeansContext, superClass);
            ArrayList<Class> businessLocalInterfaces = new ArrayList<Class>(parentBc.getBusinessLocalInterfaces());
            for (Class api : bc.getBusinessLocalInterfaces()) {
                businessLocalInterfaces.removeAll(GenericsUtil.getTypeClosure((Class)api));
            }
            if (!businessLocalInterfaces.isEmpty()) {
                throw new DefinitionException("You can only specialize another EJB with at least the same API: " + clazz);
            }
        }
        BaseEjbBean bean = new OpenEJBBeanBuilder<T>(bc, this.webBeansContext, annotatedType, attributes).createBean((Class)clazz, !annotatedType.isAnnotationPresent(Vetoed.class));
        bc.set(CdiEjbBean.class, bean);
        bc.set(CurrentCreationalContext.class, new CurrentCreationalContext());
        CdiPlugin.validateDisposeMethods(bean);
        CdiPlugin.validateScope(bean);
        Set observerMethods = bean.isEnabled() ? new ObserverMethodsBuilder(this.webBeansContext, bean.getAnnotatedType()).defineObserverMethods((AbstractOwbBean)bean) : new HashSet();
        WebBeansUtil webBeansUtil = this.webBeansContext.getWebBeansUtil();
        Set producerFields = new ProducerFieldBeansBuilder(bean.getWebBeansContext(), bean.getAnnotatedType()).defineProducerFields((InjectionTargetBean)bean);
        Set producerMethods = new ProducerMethodBeansBuilder(bean.getWebBeansContext(), bean.getAnnotatedType()).defineProducerMethods((InjectionTargetBean)bean, producerFields);
        HashMap<Object, AnnotatedMethod> annotatedMethods = new HashMap<Object, AnnotatedMethod>();
        for (Object producerMethod : producerMethods) {
            AnnotatedMethod method = this.webBeansContext.getAnnotatedElementFactory().newAnnotatedMethod(producerMethod.getCreatorMethod(), annotatedType);
            webBeansUtil.inspectDeploymentErrorStack("There are errors that are added by ProcessProducer event observers for ProducerMethods. Look at logs for further details");
            annotatedMethods.put(producerMethod, method);
        }
        HashMap<Object, AnnotatedField> annotatedFields = new HashMap<Object, AnnotatedField>();
        for (Object producerField : producerFields) {
            if (!Modifier.isStatic(producerField.getCreatorField().getModifiers())) {
                throw new DefinitionException("In an EJB all producer fields should be static");
            }
            webBeansUtil.inspectDeploymentErrorStack("There are errors that are added by ProcessProducer event observers for ProducerFields. Look at logs for further details");
            annotatedFields.put(producerField, this.webBeansContext.getAnnotatedElementFactory().newAnnotatedField(producerField.getCreatorField(), this.webBeansContext.getAnnotatedElementFactory().newAnnotatedType(producerField.getBeanClass())));
        }
        HashMap observerMethodsMap = new HashMap();
        for (ObserverMethod observerMethod : observerMethods) {
            ObserverMethodImpl impl = (ObserverMethodImpl)observerMethod;
            AnnotatedMethod method = impl.getObserverMethod();
            observerMethodsMap.put(observerMethod, method);
        }
        CdiPlugin.validateProduceMethods(bean, producerMethods);
        CdiPlugin.validateObserverMethods(bean, observerMethodsMap);
        BeanManagerImpl beanManager = this.webBeansContext.getBeanManagerImpl();
        GProcessSessionBean event = new GProcessSessionBean((Bean)Bean.class.cast(bean), annotatedType, bc.getEjbName(), bean.getEjbType());
        beanManager.fireEvent((Object)event, true, new Annotation[0]);
        event.setStarted();
        webBeansUtil.inspectDeploymentErrorStack("There are errors that are added by ProcessSessionBean event observers for managed beans. Look at logs for further details");
        webBeansUtil.fireProcessProducerMethodBeanEvent(annotatedMethods, annotatedType);
        webBeansUtil.inspectDeploymentErrorStack("There are errors that are added by ProcessProducerMethod event observers for producer method beans. Look at logs for further details");
        webBeansUtil.fireProcessProducerFieldBeanEvent(annotatedFields);
        webBeansUtil.inspectDeploymentErrorStack("There are errors that are added by ProcessProducerField event observers for producer field beans. Look at logs for further details");
        if (!webBeansUtil.isAnnotatedTypeDecoratorOrInterceptor(annotatedType)) {
            for (ProducerMethodBean producerMethod : producerMethods) {
                beanManager.addBean((Bean)producerMethod);
            }
            for (ProducerFieldBean producerField : producerFields) {
                beanManager.addBean((Bean)producerField);
            }
        }
        beanManager.addBean((Bean)bean);
        return bean;
    }

    private boolean isNewSessionBean(WebBeansContext ctx, Class<?> clazz) {
        if (ctx == null) {
            return false;
        }
        Map<Class<?>, BeanContext> map = CdiPlugin.pluginBeans(ctx);
        return map != null && (map.containsKey(clazz) || clazz.isInterface() && CdiPlugin.findBeanContext(ctx, clazz) != null);
    }

    private static WebBeansContext superContext(WebBeansContext ctx) {
        if (!WebappWebBeansContext.class.isInstance(ctx)) {
            return null;
        }
        return ((WebappWebBeansContext)((Object)WebappWebBeansContext.class.cast(ctx))).getParent();
    }

    private static BeanContext findBeanContext(WebBeansContext ctx, Class<?> clazz) {
        Map<Class<?>, BeanContext> beans = CdiPlugin.pluginBeans(ctx);
        BeanContext b = beans.get(clazz);
        if (b != null) {
            return b;
        }
        for (BeanContext bc : beans.values()) {
            CdiEjbBean cdiEjbBean;
            if (bc.isLocalbean() || (cdiEjbBean = bc.get(CdiEjbBean.class)) == null) continue;
            for (Class<?> itf : cdiEjbBean.getBusinessLocalInterfaces()) {
                if (!itf.equals(clazz)) continue;
                return bc;
            }
        }
        WebBeansContext parentCtx = CdiPlugin.superContext(ctx);
        if (parentCtx != null) {
            return CdiPlugin.findBeanContext(parentCtx, clazz);
        }
        return null;
    }

    public <T> Bean<T> defineNewSessionBean(Class<T> clazz) {
        return new NewCdiEjbBean(CdiPlugin.findBeanContext(this.webBeansContext, clazz).get(CdiEjbBean.class));
    }

    private static Map<Class<?>, BeanContext> pluginBeans(WebBeansContext ctx) {
        return ((CdiPlugin)((Object)CdiPlugin.class.cast((Object)ctx.getPluginLoader().getEjbPlugin()))).beans;
    }

    private static void validateObserverMethods(CdiEjbBean<?> bean, Map<ObserverMethod<?>, AnnotatedMethod<?>> methods) {
        BeanContext beanContext = bean.getBeanContext();
        if (beanContext.isLocalbean()) {
            return;
        }
        for (Map.Entry<ObserverMethod<?>, AnnotatedMethod<?>> m : methods.entrySet()) {
            Method method = m.getValue().getJavaMember();
            if (!Modifier.isStatic(method.getModifiers())) {
                Method viewMethod = CdiPlugin.doResolveViewMethod(bean, method);
                if (viewMethod == null) {
                    throw new WebBeansConfigurationException("@Observes " + method + " neither in the ejb view of ejb " + bean.getBeanContext().getEjbName() + " nor static");
                }
                if (beanContext.getBusinessRemoteInterfaces().contains(viewMethod.getDeclaringClass())) {
                    throw new WebBeansConfigurationException(viewMethod + " observer is defined in a @Remote interface");
                }
            }
            if (!m.getValue().getParameters().stream().anyMatch(p -> p.isAnnotationPresent(ObservesAsync.class))) continue;
            throw new WebBeansConfigurationException("@ObservesAsync " + method + " not supported on EJB in CDI 2");
        }
    }

    private static void validateProduceMethods(CdiEjbBean<?> bean, Set<ProducerMethodBean<?>> methods) {
        BeanContext beanContext = bean.getBeanContext();
        if (beanContext.isLocalbean()) {
            return;
        }
        for (ProducerMethodBean<?> m : methods) {
            Method method = m.getCreatorMethod();
            Method viewMethod = CdiPlugin.doResolveViewMethod(bean, method);
            if (viewMethod != null && !beanContext.getBusinessRemoteInterfaces().contains(viewMethod.getDeclaringClass())) continue;
            throw new WebBeansConfigurationException("@Produces " + method + " not in a local ejb view of ejb " + beanContext.getEjbName());
        }
    }

    private static void validateScope(CdiEjbBean<?> bean) {
        Class scope = bean.getScope();
        BeanType beanType = bean.getBeanContext().getComponentType();
        if (BeanType.STATELESS.equals((Object)beanType) && !Dependent.class.equals((Object)scope)) {
            throw new WebBeansConfigurationException("@Stateless can only be @Dependent");
        }
        if (BeanType.SINGLETON.equals((Object)beanType) && !Dependent.class.equals((Object)scope) && !ApplicationScoped.class.equals((Object)scope)) {
            throw new WebBeansConfigurationException("@Singleton can only be @Dependent or @ApplicationScoped");
        }
    }

    private static void validateDisposeMethods(CdiEjbBean<?> bean) {
        if (!bean.getBeanContext().isLocalbean()) {
            for (Method m : bean.getBeanContext().getBeanClass().getMethods()) {
                if (m.getDeclaringClass().equals(Object.class) || m.getParameterTypes().length <= 0) continue;
                Annotation[][] annotationArray = m.getParameterAnnotations();
                int n = annotationArray.length;
                for (int i = 0; i < n; ++i) {
                    Annotation[] a;
                    for (Annotation ann : a = annotationArray[i]) {
                        Method method = CdiPlugin.doResolveViewMethod(bean, m);
                        if (!ann.annotationType().equals(Disposes.class) || method != null && !bean.getBeanContext().getBusinessRemoteInterfaces().contains(method.getDeclaringClass())) continue;
                        throw new WebBeansConfigurationException("@Disposes is forbidden on non business or remote EJB methods");
                    }
                }
            }
        }
    }

    public boolean isSingletonBean(Class<?> clazz) {
        throw new IllegalStateException("Statement should never be reached");
    }

    public boolean isStatefulBean(Class<?> clazz) {
        return BeanType.STATEFUL.equals((Object)this.beans.get(clazz).getComponentType());
    }

    public boolean isStatelessBean(Class<?> clazz) {
        throw new IllegalStateException("Statement should never be reached");
    }

    public static Method doResolveViewMethod(Bean<?> component, Method declaredMethod) {
        if (!(component instanceof CdiEjbBean)) {
            return declaredMethod;
        }
        CdiEjbBean cdiEjbBean = (CdiEjbBean)component;
        BeanContext beanContext = cdiEjbBean.getBeanContext();
        for (Class intface : beanContext.getBusinessLocalInterfaces()) {
            try {
                return intface.getMethod(declaredMethod.getName(), declaredMethod.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        for (Class intface : beanContext.getBusinessRemoteInterfaces()) {
            try {
                return intface.getMethod(declaredMethod.getName(), declaredMethod.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return null;
    }

    public Method resolveViewMethod(Bean<?> component, Method declaredMethod) {
        Method m = CdiPlugin.doResolveViewMethod(component, declaredMethod);
        if (m == null) {
            return declaredMethod;
        }
        return m;
    }

    public void clearProxies() {
        this.cacheProxies.clear();
    }

    private static class EjbProducer<T>
    implements Producer<T> {
        private final CdiEjbBean<T> ejb;
        private final InstanceBean<T> instance;

        public EjbProducer(InstanceBean<T> tInstanceBean, CdiEjbBean<T> bean) {
            this.instance = tInstanceBean;
            this.ejb = bean;
        }

        public T produce(CreationalContext<T> creationalContext) {
            return this.instance.create(creationalContext);
        }

        public void dispose(T instance) {
            this.ejb.destroyComponentInstance(instance);
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return Collections.emptySet();
        }
    }

    private static class InstanceBean<T>
    implements OwbBean<T>,
    PassivationCapable {
        private final CdiEjbBean<T> bean;
        private T owbProxy;

        public InstanceBean(CdiEjbBean<T> tCdiEjbBean) {
            this.bean = tCdiEjbBean;
        }

        public Set<Type> getTypes() {
            return this.bean.getTypes();
        }

        public Set<Annotation> getQualifiers() {
            return this.bean.getQualifiers();
        }

        public Class<? extends Annotation> getScope() {
            return this.bean.getScope();
        }

        public String getName() {
            return this.bean.getName();
        }

        public boolean isNullable() {
            return this.bean.isNullable();
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return Collections.emptySet();
        }

        public Class<?> getBeanClass() {
            return this.bean.getBeanClass();
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return this.bean.getStereotypes();
        }

        public boolean isAlternative() {
            return this.bean.isAlternative();
        }

        public T create(CreationalContext<T> creationalContext) {
            T instance = this.bean.createEjb(creationalContext);
            if (this.owbProxy != null && SessionBeanType.STATEFUL.equals((Object)this.bean.getEjbType())) {
                this.bean.storeStatefulInstance(this.owbProxy, instance);
            }
            return instance;
        }

        public void destroy(T instance, CreationalContext<T> cc) {
            if (!SessionBeanType.STATEFUL.equals((Object)this.bean.getEjbType())) {
                return;
            }
            this.bean.destroy(instance, cc);
        }

        public Producer<T> getProducer() {
            return new EjbProducer<T>(this, this.bean);
        }

        public WebBeansType getWebBeansType() {
            return this.bean.getWebBeansType();
        }

        public Class<T> getReturnType() {
            return this.bean.getReturnType();
        }

        public void setSpecializedBean(boolean specialized) {
        }

        public boolean isSpecializedBean() {
            return this.bean.isSpecializedBean();
        }

        public void setEnabled(boolean enabled) {
        }

        public boolean isEnabled() {
            return this.bean.isEnabled();
        }

        public String getId() {
            return this.bean.getId();
        }

        public boolean isPassivationCapable() {
            return this.bean.isPassivationCapable();
        }

        public boolean isDependent() {
            return this.bean.isDependent();
        }

        public WebBeansContext getWebBeansContext() {
            return this.bean.getWebBeansContext();
        }

        public void setOwbProxy(T owbProxy) {
            this.owbProxy = owbProxy;
        }

        public boolean equals(Object o) {
            if (AbstractOwbBean.class.isInstance(o)) {
                return this.bean.equals(o);
            }
            return InstanceBean.class.isInstance(o) && this.bean.equals(((InstanceBean)InstanceBean.class.cast((Object)o)).bean);
        }

        public int hashCode() {
            return this.bean.hashCode();
        }
    }
}

