/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.managed;

import java.io.File;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.openejb.SystemException;
import org.apache.openejb.core.managed.PassivationStrategy;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.JavaSecurityManagers;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class SimplePassivater
implements PassivationStrategy {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources");
    private File sessionDirectory;

    public SimplePassivater() throws SystemException {
        this.init(null);
    }

    @Override
    public void init(Properties props) throws SystemException {
        if (props == null) {
            props = new Properties();
        }
        String dir = props.getProperty("org/openejb/core/InstanceManager/PASSIVATOR_PATH_PREFIX");
        try {
            this.sessionDirectory = dir != null ? SystemInstance.get().getBase().getDirectory(dir).getAbsoluteFile() : new File(JavaSecurityManagers.getSystemProperty("java.io.tmpdir", File.separator + "tmp")).getAbsoluteFile();
            if (!this.sessionDirectory.exists() && !this.sessionDirectory.mkdirs()) {
                throw new IOException("Failed to create directory: " + this.sessionDirectory.getAbsolutePath());
            }
            logger.info("Using directory " + this.sessionDirectory + " for stateful session passivation");
        }
        catch (IOException e) {
            throw new SystemException(this.getClass().getName() + ".init(): can't use directory prefix " + dir + ":" + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void passivate(Object primaryKey, Object state) throws SystemException {
        try {
            String filename = primaryKey.toString().replace(':', '=');
            File sessionFile = new File(this.sessionDirectory, filename);
            if (!sessionFile.exists() && !sessionFile.createNewFile()) {
                throw new Exception("Failed to create passivation file: " + sessionFile.getAbsolutePath());
            }
            logger.info("Passivating to file " + sessionFile);
            try (OutputStream os = IO.write((File)sessionFile);
                 ObjectOutputStream oos = new ObjectOutputStream(os);){
                oos.writeObject(state);
            }
            finally {
                sessionFile.deleteOnExit();
            }
        }
        catch (NotSerializableException nse) {
            logger.error("Passivation failed ", nse);
            throw (SystemException)new SystemException("The type " + nse.getMessage() + " is not serializable as mandated by the EJB specification.").initCause(nse);
        }
        catch (Exception t) {
            logger.error("Passivation failed ", t);
            throw new SystemException(t);
        }
    }

    @Override
    public void passivate(Map hash) throws SystemException {
        for (Object id : hash.keySet()) {
            this.passivate(id, hash.get(id));
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Object activate(Object primaryKey) throws SystemException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

