/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.testing;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.inject.Inject;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.InjectionProcessor;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.assembler.classic.OpenEjbConfiguration;
import org.apache.openejb.assembler.classic.WebAppBuilder;
import org.apache.openejb.cdi.CdiBuilder;
import org.apache.openejb.cdi.OptimizedLoaderService;
import org.apache.openejb.cdi.ScopeHelper;
import org.apache.openejb.cdi.ThreadSingletonService;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.ConnectorModule;
import org.apache.openejb.config.DeploymentLoader;
import org.apache.openejb.config.DeploymentModule;
import org.apache.openejb.config.DeploymentsResolver;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.FinderFactory;
import org.apache.openejb.config.PersistenceModule;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.config.sys.JSonConfigReader;
import org.apache.openejb.config.sys.JaxbOpenejb;
import org.apache.openejb.config.sys.Openejb;
import org.apache.openejb.config.sys.Resources;
import org.apache.openejb.core.LocalInitialContextFactory;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ParentClassLoaderFinder;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.WebContext;
import org.apache.openejb.core.ivm.naming.InitContextFactory;
import org.apache.openejb.injection.FallbackPropertyInjector;
import org.apache.openejb.jee.Application;
import org.apache.openejb.jee.Beans;
import org.apache.openejb.jee.Connector;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.EnvEntry;
import org.apache.openejb.jee.ManagedBean;
import org.apache.openejb.jee.NamedModule;
import org.apache.openejb.jee.TransactionType;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.jpa.unit.Persistence;
import org.apache.openejb.jee.jpa.unit.PersistenceUnit;
import org.apache.openejb.jee.oejb3.EjbDeployment;
import org.apache.openejb.jee.oejb3.OpenejbJar;
import org.apache.openejb.jee.oejb3.PojoDeployment;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.JarLocation;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.rest.RESTResourceFinder;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.testing.AppResource;
import org.apache.openejb.testing.ApplicationConfiguration;
import org.apache.openejb.testing.CdiExtensions;
import org.apache.openejb.testing.Classes;
import org.apache.openejb.testing.Component;
import org.apache.openejb.testing.Configuration;
import org.apache.openejb.testing.ContainerProperties;
import org.apache.openejb.testing.Default;
import org.apache.openejb.testing.Descriptor;
import org.apache.openejb.testing.Descriptors;
import org.apache.openejb.testing.EnableServices;
import org.apache.openejb.testing.Jars;
import org.apache.openejb.testing.JaxrsProviders;
import org.apache.openejb.testing.MockInjector;
import org.apache.openejb.testing.Module;
import org.apache.openejb.testing.PersistenceRootUrl;
import org.apache.openejb.testing.RandomPort;
import org.apache.openejb.testing.SimpleLog;
import org.apache.openejb.testing.TestInstance;
import org.apache.openejb.testing.WebResource;
import org.apache.openejb.testing.rest.ContextProvider;
import org.apache.openejb.util.JavaSecurityManagers;
import org.apache.openejb.util.Join;
import org.apache.openejb.util.NetworkUtil;
import org.apache.openejb.util.PropertyPlaceHolderHelper;
import org.apache.openejb.util.ServiceManagerProxy;
import org.apache.openejb.util.URLs;
import org.apache.openejb.util.reflection.Reflections;
import org.apache.openejb.web.LightweightWebAppBuilder;
import org.apache.webbeans.inject.OWBInjector;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.spi.LoaderService;
import org.apache.webbeans.web.lifecycle.test.MockHttpSession;
import org.apache.webbeans.web.lifecycle.test.MockServletContext;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.finder.ClassFinder;
import org.apache.xbean.finder.IAnnotationFinder;
import org.apache.xbean.finder.ResourceFinder;
import org.apache.xbean.finder.UrlSet;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.ClassesArchive;
import org.apache.xbean.finder.archive.CompositeArchive;
import org.apache.xbean.finder.archive.FileArchive;
import org.apache.xbean.finder.archive.FilteredArchive;
import org.apache.xbean.finder.archive.JarArchive;
import org.apache.xbean.finder.filter.Filter;
import org.apache.xbean.finder.filter.Filters;
import org.xml.sax.InputSource;

public class ApplicationComposers {
    public static final String OPENEJB_APPLICATION_COMPOSER_CONTEXT = "openejb.application.composer.context";
    private static final Class[] MODULE_TYPES = new Class[]{IAnnotationFinder.class, ClassesArchive.class, AppModule.class, WebModule.class, EjbModule.class, Application.class, WebApp.class, EjbJar.class, EnterpriseBean.class, Persistence.class, PersistenceUnit.class, Connector.class, Beans.class, Class[].class, Class.class, Resources.class};
    private final Map<Object, ClassFinder> testClassFinders;
    private final Class<?> testClass;
    private ServiceManagerProxy serviceManager;
    private ClassLoader originalLoader;
    private AppInfo appInfo;
    private Assembler assembler;
    private AppContext appContext;
    private ThreadContext previous;
    private MockHttpSession session;
    private MockServletContext servletContext;
    private final Collection<String> globalJndiEntries = new ArrayList<String>();
    private final Collection<Runnable> beforeDestroyAfterRunnables = new ArrayList<Runnable>();
    private final Collection<Runnable> afterRunnables = new ArrayList<Runnable>();
    private Properties originalProperties;

    public ApplicationComposers(Object ... modules) {
        this(modules[0].getClass(), modules);
    }

    public ApplicationComposers(Class<?> klass, Object ... additionalModules) {
        this.testClass = klass;
        this.testClassFinders = new HashMap<Object, ClassFinder>();
        this.testClassFinders.put(this, new ClassFinder(org.apache.openejb.util.Classes.ancestors(klass)));
        if (additionalModules != null) {
            for (Object o : additionalModules) {
                Class<?> aClass = o.getClass();
                if (aClass == klass) continue;
                this.testClassFinders.put(o, new ClassFinder(org.apache.openejb.util.Classes.ancestors(aClass)));
            }
        }
        this.validate();
        this.assembler = (Assembler)SystemInstance.get().getComponent(Assembler.class);
    }

    protected boolean isContainer() {
        return true;
    }

    protected boolean isApplication() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void validate() {
        Class<?> type;
        ArrayList<Exception> errors = new ArrayList<Exception>();
        if (this.isContainer()) {
            void var4_6;
            Map<Object, List<Method>> annotatedConfigurationMethods = this.findAnnotatedMethods(new HashMap<Object, List<Method>>(), Configuration.class);
            int nbProp = 0;
            boolean bl = false;
            for (List<Method> list : annotatedConfigurationMethods.values()) {
                for (Method m : list) {
                    type = m.getReturnType();
                    if (Openejb.class.isAssignableFrom(type) || String.class.equals(type)) {
                        ++var4_6;
                        continue;
                    }
                    if (!Properties.class.isAssignableFrom(type)) continue;
                    ++nbProp;
                }
            }
            if (nbProp > 1 || var4_6 > true) {
                String string = "Test class should have no more than one @Configuration method by type (Openejb/String or Properties)";
                errors.add(new Exception("Test class should have no more than one @Configuration method by type (Openejb/String or Properties)"));
            }
            int injectorSize = 0;
            for (List<Method> list : this.findAnnotatedMethods(new HashMap<Object, List<Method>>(), org.apache.openejb.junit.MockInjector.class).values()) {
                injectorSize += list.size();
            }
            for (List<Method> list : this.findAnnotatedMethods(new HashMap<Object, List<Method>>(), MockInjector.class).values()) {
                injectorSize += list.size();
            }
            if (injectorSize > 1) {
                errors.add(new Exception("Test class should have no more than one @MockInjector method"));
            }
            ArrayList<Method> arrayList = new ArrayList<Method>();
            for (List<Method> l : this.findAnnotatedMethods(new HashMap<Object, List<Method>>(), Component.class).values()) {
                arrayList.addAll(l);
            }
            for (List<Method> l : this.findAnnotatedMethods(new HashMap<Object, List<Method>>(), org.apache.openejb.junit.Component.class).values()) {
                arrayList.addAll(l);
            }
            for (Method method : arrayList) {
                if (method.getParameterTypes().length <= 0) continue;
                errors.add(new Exception("@Component methods shouldn't take any parameters"));
            }
            for (ClassFinder finder : this.testClassFinders.values()) {
                for (Field field : finder.findAnnotatedFields(RandomPort.class)) {
                    type = field.getType();
                    if (Integer.TYPE == type || URL.class == type) continue;
                    throw new IllegalArgumentException("@RandomPort is only supported for int fields");
                }
            }
        }
        if (this.isApplication()) {
            void var4_21;
            void var5_44;
            ArrayList<Method> descriptors = new ArrayList<Method>();
            for (List<Method> list : this.findAnnotatedMethods(new HashMap<Object, List<Method>>(), Descriptors.class).values()) {
                descriptors.addAll(list);
            }
            for (List<Method> list : this.findAnnotatedMethods(new HashMap<Object, List<Method>>(), org.apache.openejb.junit.Descriptors.class).values()) {
                descriptors.addAll(list);
            }
            for (Method method : descriptors) {
                Class<?> clazz = method.getReturnType();
                if (clazz.equals(WebModule.class) || clazz.equals(EjbModule.class) || clazz.equals(WebApp.class) || clazz.equals(EjbJar.class) || clazz.equals(AppModule.class)) continue;
                errors.add(new Exception("@Descriptors can't be used on " + clazz.getName()));
            }
            ArrayList<Method> classes = new ArrayList<Method>();
            for (List<Method> list : this.findAnnotatedMethods(new HashMap<Object, List<Method>>(), Classes.class).values()) {
                classes.addAll(list);
            }
            for (List<Method> list : this.findAnnotatedMethods(new HashMap<Object, List<Method>>(), org.apache.openejb.junit.Classes.class).values()) {
                classes.addAll(list);
            }
            for (Method method : classes) {
                Class<?> returnType = method.getReturnType();
                if (returnType.equals(WebModule.class) || returnType.equals(EjbModule.class) || returnType.equals(WebApp.class) || returnType.equals(EjbJar.class) || EnterpriseBean.class.isAssignableFrom(returnType)) continue;
                errors.add(new Exception("@Classes can't be used on a method returning " + returnType));
            }
            for (List<Method> list : this.findAnnotatedMethods(new HashMap<Object, List<Method>>(), Jars.class).values()) {
                for (Method method : list) {
                    Class<?> returnType = method.getReturnType();
                    if (returnType.equals(WebModule.class) || returnType.equals(EjbModule.class) || returnType.equals(WebApp.class) || returnType.equals(EjbJar.class) || EnterpriseBean.class.isAssignableFrom(returnType)) continue;
                    errors.add(new Exception("@Classes can't be used on a method returning " + returnType));
                }
            }
            boolean bl = false;
            boolean bl2 = false;
            ArrayList<Method> moduleMethods = new ArrayList<Method>();
            for (List<Method> l : this.findAnnotatedMethods(new HashMap<Object, List<Method>>(), Module.class).values()) {
                moduleMethods.addAll(l);
            }
            for (List<Method> l : this.findAnnotatedMethods(new HashMap<Object, List<Method>>(), org.apache.openejb.junit.Module.class).values()) {
                moduleMethods.addAll(l);
            }
            for (Method method : moduleMethods) {
                ++var5_44;
                type = method.getReturnType();
                if (Application.class.isAssignableFrom(type)) {
                    ++var4_21;
                    continue;
                }
                if (this.isValidModuleType(type, MODULE_TYPES)) continue;
                String gripe2 = "@Module method must return " + Join.join(" or ", MODULE_TYPES).replaceAll("(class|interface) ", "");
                errors.add(new Exception(gripe2));
            }
            if (var4_21 > true) {
                String string = "Test class should have no more than one @Module method that returns " + Application.class.getName();
                errors.add(new Exception(string));
            }
            if (var5_44 < true && this.testClass.getAnnotation(Classes.class) == null && this.testClass.getAnnotation(Default.class) == null) {
                String string = "Test class should have at least one @Module method";
                errors.add(new Exception("Test class should have at least one @Module method"));
            }
        }
        if (!errors.isEmpty()) {
            throw new OpenEJBRuntimeException(((Object)errors).toString());
        }
    }

    private Map<Object, List<Method>> findAnnotatedMethods(Map<Object, List<Method>> map, Class<? extends Annotation> annotation) {
        for (Map.Entry<Object, ClassFinder> finder : this.testClassFinders.entrySet()) {
            Object key = finder.getKey();
            List newAnnotatedMethods = finder.getValue().findAnnotatedMethods(annotation);
            List annotatedMethods = map.get(key);
            if (annotatedMethods == null) {
                annotatedMethods = newAnnotatedMethods;
                map.put(key, annotatedMethods);
                continue;
            }
            for (Method m : newAnnotatedMethods) {
                if (annotatedMethods.contains(m)) continue;
                annotatedMethods.add(m);
            }
        }
        return map;
    }

    private boolean isValidModuleType(Class<?> type, Class<?>[] moduleTypes) {
        for (Class<?> moduleType : moduleTypes) {
            if (!moduleType.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    public void before(Object inputTestInstance) throws Exception {
        this.fixFakeClassFinder(inputTestInstance);
        this.startContainer(inputTestInstance);
        this.servletContext = new MockServletContext();
        this.session = new MockHttpSession();
        this.deployApp(inputTestInstance);
    }

    public void deployApp(Object inputTestInstance) throws Exception {
        ClassFinder testClassFinder = this.fixFakeClassFinder(inputTestInstance);
        ClassLoader loader = this.testClass.getClassLoader();
        Object appModule = new AppModule(loader, this.testClass.getSimpleName());
        EjbJar ejbJar = new EjbJar();
        OpenejbJar openejbJar = new OpenejbJar();
        ManagedBean testBean = (ManagedBean)ejbJar.addEnterpriseBean((EnterpriseBean)new ManagedBean(this.testClass.getSimpleName(), this.testClass.getName(), true));
        testBean.localBean();
        testBean.setTransactionType(TransactionType.BEAN);
        EjbDeployment ejbDeployment = openejbJar.addEjbDeployment((EnterpriseBean)testBean);
        ejbDeployment.setDeploymentId(this.testClass.getName());
        EjbModule ejbModule = new EjbModule(ejbJar, openejbJar);
        ejbModule.getProperties().setProperty("openejb.cdi.activated", "false");
        FinderFactory.OpenEJBAnnotationFinder finder = new FinderFactory.OpenEJBAnnotationFinder((Archive)new ClassesArchive(org.apache.openejb.util.Classes.ancestors(this.testClass)));
        ejbModule.setFinder((IAnnotationFinder)finder);
        if (finder.findMetaAnnotatedFields(Inject.class).size() + finder.findMetaAnnotatedMethods(Inject.class).size() > 0) {
            ejbModule.setBeans(new Beans());
        }
        ((AppModule)appModule).getEjbModules().add(ejbModule);
        Map<String, URL> additionalDescriptors = ApplicationComposers.descriptorsToMap(this.testClass.getAnnotation(org.apache.openejb.junit.Descriptors.class));
        Map<String, URL> additionalDescriptorsNew = ApplicationComposers.descriptorsToMap(this.testClass.getAnnotation(Descriptors.class));
        additionalDescriptors.putAll(additionalDescriptorsNew);
        Application application = null;
        int webModulesNb = 0;
        Jars globalJarsAnnotation = this.testClass.getAnnotation(Jars.class);
        int moduleNumber = 0;
        int notBusinessModuleNumber = 0;
        HashMap<Object, List<Method>> moduleMethods = new HashMap<Object, List<Method>>();
        this.findAnnotatedMethods(moduleMethods, Module.class);
        this.findAnnotatedMethods(moduleMethods, org.apache.openejb.junit.Module.class);
        for (Map.Entry methods : moduleMethods.entrySet()) {
            moduleNumber += ((List)methods.getValue()).size();
            for (Object method : (List)methods.getValue()) {
                EjbModule ejbModule2;
                Class[] beans;
                Object bean;
                EjbModule ejbModule3;
                Collection<File> files;
                Object obj = ((Method)method).invoke(methods.getKey(), new Object[0]);
                Jars jarsAnnotation = ((Method)method).getAnnotation(Jars.class);
                Classes classesAnnotation = ((Method)method).getAnnotation(Classes.class);
                org.apache.openejb.junit.Classes classesAnnotationOld = ((Method)method).getAnnotation(org.apache.openejb.junit.Classes.class);
                boolean defaultConfig = ((Method)method).getAnnotation(Default.class) != null;
                Class<?>[] classes = null;
                String[] excludes = null;
                Class<?>[] cdiInterceptors = null;
                Class<?>[] cdiAlternatives = null;
                Class<?>[] cdiStereotypes = null;
                Class<?>[] cdiDecorators = null;
                boolean cdi = false;
                boolean innerClassesAsBean = false;
                if (classesAnnotation != null) {
                    classes = classesAnnotation.value();
                    excludes = classesAnnotation.excludes();
                    innerClassesAsBean = classesAnnotation.innerClassesAsBean();
                    cdiInterceptors = classesAnnotation.cdiInterceptors();
                    cdiDecorators = classesAnnotation.cdiDecorators();
                    cdiAlternatives = classesAnnotation.cdiAlternatives();
                    cdiStereotypes = classesAnnotation.cdiStereotypes();
                    cdi = this.isCdi(classesAnnotation.cdi(), cdiInterceptors, cdiAlternatives, cdiStereotypes, cdiDecorators);
                } else if (classesAnnotationOld != null) {
                    classes = classesAnnotationOld.value();
                }
                if (obj instanceof WebApp) {
                    WebApp webApp = (WebApp)WebApp.class.cast(obj);
                    if (webApp.getContextRoot() == null && classesAnnotation != null) {
                        webApp.contextRoot(classesAnnotation.context());
                    }
                    ++webModulesNb;
                    this.addWebApp((AppModule)appModule, testBean, additionalDescriptors, ((Method)method).getAnnotation(Descriptors.class), ((Method)method).getAnnotation(JaxrsProviders.class), webApp, globalJarsAnnotation, jarsAnnotation, classes, excludes, cdiInterceptors, cdiAlternatives, cdiDecorators, cdiStereotypes, cdi, innerClassesAsBean, defaultConfig);
                    continue;
                }
                if (obj instanceof WebModule) {
                    ++webModulesNb;
                    WebModule webModule = (WebModule)obj;
                    webModule.getAltDDs().putAll(additionalDescriptors);
                    webModule.getAltDDs().putAll(ApplicationComposers.descriptorsToMap(((Method)method).getAnnotation(Descriptors.class)));
                    EjbModule ejbModule32 = DeploymentLoader.addWebModule(webModule, (AppModule)appModule);
                    ejbModule32.getProperties().put("openejb.cdi.filter.classloader", "false");
                    if (cdi) {
                        ejbModule32.setBeans(this.beans(new Beans(), cdiDecorators, cdiInterceptors, cdiAlternatives, cdiStereotypes));
                    }
                    files = ApplicationComposers.findFiles(jarsAnnotation);
                    if (defaultConfig) {
                        (files == null ? (files = new LinkedList<File>()) : files).add(JarLocation.jarLocation(this.testClass));
                    }
                    webModule.setFinder(ApplicationComposers.finderFromClasses(webModule, classes, files, excludes));
                    ejbModule32.setFinder(webModule.getFinder());
                    continue;
                }
                if (obj instanceof EjbModule) {
                    EjbModule ejbModule22 = (EjbModule)obj;
                    ejbModule22.getAltDDs().putAll(additionalDescriptors);
                    ejbModule22.getAltDDs().putAll(ApplicationComposers.descriptorsToMap(((Method)method).getAnnotation(Descriptors.class)));
                    ejbModule22.initAppModule((AppModule)appModule);
                    ((AppModule)appModule).getEjbModules().add(ejbModule22);
                    if (cdi) {
                        ejbModule22.setBeans(this.beans(new Beans(), cdiDecorators, cdiInterceptors, cdiAlternatives, cdiStereotypes));
                    }
                    Collection<File> files2 = ApplicationComposers.findFiles(jarsAnnotation);
                    if (defaultConfig) {
                        (files2 == null ? (files2 = new LinkedList<File>()) : files2).add(JarLocation.jarLocation(this.testClass));
                    }
                    ejbModule22.setFinder(ApplicationComposers.finderFromClasses(ejbModule22, classes, files2, excludes));
                    continue;
                }
                if (obj instanceof EjbJar) {
                    EjbJar ejbJar2 = (EjbJar)obj;
                    this.setId(ejbJar2, (Method)method);
                    ejbModule3 = new EjbModule(ejbJar2);
                    ejbModule3.getAltDDs().putAll(additionalDescriptors);
                    ejbModule3.getAltDDs().putAll(ApplicationComposers.descriptorsToMap(((Method)method).getAnnotation(Descriptors.class)));
                    ((AppModule)appModule).getEjbModules().add(ejbModule3);
                    if (cdi) {
                        ejbModule3.setBeans(this.beans(new Beans(), cdiDecorators, cdiInterceptors, cdiAlternatives, cdiStereotypes));
                    }
                    files = ApplicationComposers.findFiles(jarsAnnotation);
                    if (defaultConfig) {
                        (files == null ? (files = new LinkedList<File>()) : files).add(JarLocation.jarLocation(this.testClass));
                    }
                    ejbModule3.setFinder(ApplicationComposers.finderFromClasses(ejbModule3, classes, files, excludes));
                    continue;
                }
                if (obj instanceof EnterpriseBean) {
                    bean = (EnterpriseBean)obj;
                    EjbJar ejbJar3 = new EjbJar(((Method)method).getName());
                    ejbJar3.addEnterpriseBean(bean);
                    EjbModule ejbModule4 = new EjbModule(ejbJar3);
                    Beans beans2 = new Beans();
                    beans2.addManagedClass(bean.getEjbClass());
                    ejbModule4.setBeans(beans2);
                    ((AppModule)appModule).getEjbModules().add(ejbModule4);
                    if (cdi) {
                        ejbModule4.setBeans(this.beans(new Beans(), cdiDecorators, cdiInterceptors, cdiAlternatives, cdiStereotypes));
                    }
                    Collection<File> files3 = ApplicationComposers.findFiles(jarsAnnotation);
                    if (defaultConfig) {
                        (files3 == null ? (files3 = new LinkedList<File>()) : files3).add(JarLocation.jarLocation(this.testClass));
                    }
                    ejbModule4.setFinder(ApplicationComposers.finderFromClasses(ejbModule4, classes, files3, excludes));
                    continue;
                }
                if (obj instanceof Application) {
                    application = (Application)obj;
                    this.setId(application, (Method)method);
                    continue;
                }
                if (obj instanceof Connector) {
                    Connector connector = (Connector)obj;
                    this.setId(connector, (Method)method);
                    ((AppModule)appModule).getConnectorModules().add(new ConnectorModule(connector));
                    continue;
                }
                if (obj instanceof Persistence) {
                    Persistence persistence = (Persistence)obj;
                    ((AppModule)appModule).addPersistenceModule(new PersistenceModule((AppModule)appModule, ApplicationComposers.implicitRootUrl(((Method)method).getAnnotation(PersistenceRootUrl.class)), persistence));
                    ++notBusinessModuleNumber;
                    continue;
                }
                if (obj instanceof PersistenceUnit) {
                    PersistenceUnit unit = (PersistenceUnit)obj;
                    ((AppModule)appModule).addPersistenceModule(new PersistenceModule((AppModule)appModule, ApplicationComposers.implicitRootUrl(((Method)method).getAnnotation(PersistenceRootUrl.class)), new Persistence(new PersistenceUnit[]{unit})));
                    ++notBusinessModuleNumber;
                    continue;
                }
                if (obj instanceof Beans) {
                    beans = (Class[])obj;
                    ejbModule3 = new EjbModule(new EjbJar(((Method)method).getName()));
                    ejbModule3.setBeans((Beans)beans);
                    ((AppModule)appModule).getEjbModules().add(ejbModule3);
                    if (cdi) {
                        ejbModule3.setBeans(this.beans((Beans)beans, cdiDecorators, cdiInterceptors, cdiAlternatives, cdiStereotypes));
                    }
                    files = ApplicationComposers.findFiles(jarsAnnotation);
                    if (defaultConfig) {
                        (files == null ? (files = new LinkedList<File>()) : files).add(JarLocation.jarLocation(this.testClass));
                    }
                    ejbModule3.setFinder(ApplicationComposers.finderFromClasses(ejbModule3, classes, files, excludes));
                    continue;
                }
                if (obj instanceof Class[]) {
                    beans = (Class[])obj;
                    ejbModule3 = new EjbModule(new EjbJar(((Method)method).getName()));
                    ejbModule3.setFinder((IAnnotationFinder)new AnnotationFinder((Archive)new ClassesArchive(beans)).link());
                    ejbModule3.setBeans(new Beans());
                    ((AppModule)appModule).getEjbModules().add(ejbModule3);
                    continue;
                }
                if (obj instanceof Class) {
                    bean = (Class)obj;
                    ejbModule3 = new EjbModule(new EjbJar(((Method)method).getName()));
                    ejbModule3.setFinder((IAnnotationFinder)new AnnotationFinder((Archive)new ClassesArchive(new Class[]{bean})).link());
                    ejbModule3.setBeans(new Beans());
                    ((AppModule)appModule).getEjbModules().add(ejbModule3);
                    continue;
                }
                if (obj instanceof IAnnotationFinder) {
                    ejbModule2 = new EjbModule(new EjbJar(((Method)method).getName()));
                    ejbModule2.setFinder((IAnnotationFinder)obj);
                    ejbModule2.setBeans(new Beans());
                    ((AppModule)appModule).getEjbModules().add(ejbModule2);
                    continue;
                }
                if (obj instanceof ClassesArchive) {
                    ejbModule2 = new EjbModule(new EjbJar(((Method)method).getName()));
                    ejbModule2.setFinder((IAnnotationFinder)new AnnotationFinder((Archive)obj).link());
                    ejbModule2.setBeans(new Beans());
                    ((AppModule)appModule).getEjbModules().add(ejbModule2);
                    continue;
                }
                if (obj instanceof Resources) {
                    Resources asResources = (Resources)Resources.class.cast(obj);
                    ((AppModule)appModule).getResources().addAll(asResources.getResource());
                    ((AppModule)appModule).getContainers().addAll(asResources.getContainer());
                    ++notBusinessModuleNumber;
                    continue;
                }
                if (obj instanceof AppModule) {
                    AppModule module = (AppModule)obj;
                    module.getAltDDs().putAll(additionalDescriptors);
                    module.getAltDDs().putAll(ApplicationComposers.descriptorsToMap(((Method)method).getAnnotation(Descriptors.class)));
                    if (module.getWebModules().size() > 0) {
                        ++webModulesNb;
                    }
                    ((AppModule)appModule).getEjbModules().addAll(module.getEjbModules());
                    ((AppModule)appModule).getPersistenceModules().addAll(module.getPersistenceModules());
                    ((AppModule)appModule).getAdditionalLibMbeans().addAll(module.getAdditionalLibMbeans());
                    ((AppModule)appModule).getWebModules().addAll(module.getWebModules());
                    ((AppModule)appModule).getConnectorModules().addAll(module.getConnectorModules());
                    ((AppModule)appModule).getResources().addAll(module.getResources());
                    ((AppModule)appModule).getServices().addAll(module.getServices());
                    ((AppModule)appModule).getPojoConfigurations().putAll(module.getPojoConfigurations());
                    ((AppModule)appModule).getAdditionalLibraries().addAll(module.getAdditionalLibraries());
                    ((AppModule)appModule).getAltDDs().putAll(module.getAltDDs());
                    ((AppModule)appModule).getProperties().putAll((Map<?, ?>)module.getProperties());
                    continue;
                }
                --moduleNumber;
            }
        }
        Classes classClasses = this.testClass.getAnnotation(Classes.class);
        if (classClasses != null) {
            WebApp webapp = new WebApp();
            webapp.setContextRoot(classClasses.context());
            this.addWebApp((AppModule)appModule, testBean, additionalDescriptors, null, null, webapp, globalJarsAnnotation, null, classClasses.value(), classClasses.excludes(), classClasses.cdiInterceptors(), classClasses.cdiAlternatives(), classClasses.cdiDecorators(), classClasses.cdiStereotypes(), classClasses.cdi(), classClasses.innerClassesAsBean(), this.testClass.getAnnotation(Default.class) != null);
            ++webModulesNb;
            ++moduleNumber;
        }
        if (application != null) {
            Iterator<EjbModule> newModule = new AppModule(((AppModule)appModule).getClassLoader(), ((AppModule)appModule).getModuleId(), application, false);
            ((AppModule)((Object)newModule)).getClientModules().addAll(((AppModule)appModule).getClientModules());
            ((AppModule)((Object)newModule)).addPersistenceModules(((AppModule)appModule).getPersistenceModules());
            ((AppModule)((Object)newModule)).getEjbModules().addAll(((AppModule)appModule).getEjbModules());
            ((AppModule)((Object)newModule)).getConnectorModules().addAll(((AppModule)appModule).getConnectorModules());
            appModule = newModule;
        }
        for (Map.Entry entry : this.findAnnotatedMethods(new HashMap<Object, List<Method>>(), ApplicationConfiguration.class).entrySet()) {
            for (Method m : (List)entry.getValue()) {
                EnterpriseBean[] o = m.invoke(entry.getKey(), new Object[0]);
                if (!Properties.class.isInstance(o)) continue;
                ((AppModule)appModule).getProperties().putAll((Map<?, ?>)((Map)Properties.class.cast(o)));
            }
        }
        for (EjbModule ejbModule4 : ((AppModule)appModule).getEjbModules()) {
            EnterpriseBean[] enterpriseBeans = ejbModule4.getEjbJar().getEnterpriseBeans();
            Beans beans = ejbModule4.getBeans();
            if (beans == null || ejbModule4.getEjbJar() == null) continue;
            for (EnterpriseBean bean : enterpriseBeans) {
                boolean found = false;
                for (List mc : beans.getManagedClasses().values()) {
                    if (!mc.contains(bean.getEjbClass())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                beans.addManagedClass(bean.getEjbClass());
            }
        }
        if (moduleNumber - notBusinessModuleNumber == 1 && webModulesNb == 1) {
            ((AppModule)appModule).setStandloneWebModule();
        }
        if (webModulesNb > 0 && SystemInstance.get().getComponent(WebAppBuilder.class) == null) {
            SystemInstance.get().setComponent(WebAppBuilder.class, (Object)new LightweightWebAppBuilder());
        }
        Context jndiContext = ((ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class)).getJNDIContext();
        for (EnvEntry entry : testBean.getEnvEntry()) {
            String name = entry.getName();
            String jndi = name.startsWith("java:") || name.startsWith("comp/env") ? name : "java:comp/env/" + name;
            jndiContext.bind(jndi, (Object)entry.getEnvEntryValue());
        }
        this.appInfo = ((ConfigurationFactory)SystemInstance.get().getComponent(ConfigurationFactory.class)).configureApplication((AppModule)appModule);
        this.appContext = this.assembler.createApplication(this.appInfo);
        if (this.mockCdiContexts() && this.appContext.getWebBeansContext() != null) {
            ScopeHelper.startContexts(this.appContext.getWebBeansContext().getContextsService(), (ServletContext)this.servletContext, (HttpSession)this.session);
        }
        BeanContext beanContext = ((ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class)).getBeanContext(this.testClass.getName());
        this.enrich(inputTestInstance, beanContext);
        JavaSecurityManagers.setSystemProperty("java.naming.factory.initial", InitContextFactory.class.getName());
        JavaSecurityManagers.setSystemProperty(OPENEJB_APPLICATION_COMPOSER_CONTEXT, this.appContext.getGlobalJndiContext());
        ArrayList fields = new ArrayList(testClassFinder.findAnnotatedFields(AppResource.class));
        fields.addAll(testClassFinder.findAnnotatedFields(org.apache.openejb.junit.AppResource.class));
        for (Field field : fields) {
            Class<?> type = field.getType();
            if (AppModule.class.isAssignableFrom(type)) {
                field.setAccessible(true);
                field.set(inputTestInstance, appModule);
                continue;
            }
            if (Context.class.isAssignableFrom(type)) {
                field.setAccessible(true);
                field.set(inputTestInstance, new InitialContext(new Properties(){
                    {
                        this.setProperty("java.naming.factory.initial", LocalInitialContextFactory.class.getName());
                    }
                }));
                continue;
            }
            if (ApplicationComposers.class.isAssignableFrom(type)) {
                field.setAccessible(true);
                field.set(inputTestInstance, this);
                continue;
            }
            if (ContextProvider.class.isAssignableFrom(type)) {
                RESTResourceFinder finder2 = (RESTResourceFinder)SystemInstance.get().getComponent(RESTResourceFinder.class);
                if (finder2 == null || !ContextProvider.class.isInstance(finder2)) {
                    finder2 = new ContextProvider(finder2);
                    SystemInstance.get().setComponent(RESTResourceFinder.class, (Object)finder2);
                }
                field.setAccessible(true);
                field.set(inputTestInstance, finder2);
                continue;
            }
            throw new IllegalArgumentException("can't find value for type " + type.getName());
        }
        this.previous = ThreadContext.enter(new ThreadContext(beanContext, null, Operation.BUSINESS));
        this.testClassFinders.put(this, testClassFinder);
    }

    private ClassFinder fixFakeClassFinder(final Object inputTestInstance) {
        ApplicationComposers self;
        ClassFinder remove;
        ClassFinder testClassFinder = this.testClassFinders.get(inputTestInstance);
        if (testClassFinder == null && (remove = this.testClassFinders.remove(self = this)) != null) {
            this.testClassFinders.put(inputTestInstance, remove);
            testClassFinder = remove;
            this.afterRunnables.add(new Runnable(){

                @Override
                public void run() {
                    ClassFinder classFinder = (ClassFinder)ApplicationComposers.this.testClassFinders.remove(inputTestInstance);
                    if (classFinder != null) {
                        ApplicationComposers.this.testClassFinders.put(self, classFinder);
                    }
                }
            });
        }
        return testClassFinder;
    }

    private boolean isCdi(boolean cdi, Class<?>[] cdiInterceptors, Class<?>[] cdiAlternatives, Class<?>[] cdiStereotypes, Class<?>[] cdiDecorators) {
        return cdi || this.isNotNullOrEmpty(cdiAlternatives) || this.isNotNullOrEmpty(cdiDecorators) || this.isNotNullOrEmpty(cdiInterceptors) || this.isNotNullOrEmpty(cdiStereotypes);
    }

    private boolean isNotNullOrEmpty(Class<?>[] ca) {
        return null != ca && ca.length > 0;
    }

    protected boolean mockCdiContexts() {
        return "true".equalsIgnoreCase(SystemInstance.get().getProperty("openejb.testing.start-cdi-contexts", "true"));
    }

    private void addWebApp(AppModule appModule, ManagedBean testBean, Map<String, URL> additionalDescriptors, Descriptors descriptors, JaxrsProviders providers, WebApp webapp, Jars globalJarsAnnotation, Jars jarsAnnotation, Class<?>[] cdiClasses, String[] excludes, Class<?>[] cdiInterceptors, Class<?>[] cdiAlternatives, Class<?>[] cdiDecorators, Class<?>[] cdiStereotypes, boolean cdi, boolean innerClassesAsBean, boolean autoConfig) throws OpenEJBException {
        File thisJar;
        String root = webapp.getContextRoot();
        if (root == null) {
            root = "/openejb";
        }
        testBean.getEnvEntry().addAll(webapp.getEnvEntry());
        WebModule webModule = new WebModule(webapp, root, Thread.currentThread().getContextClassLoader(), "", root);
        if (autoConfig) {
            thisJar = JarLocation.jarLocation(this.testClass);
            try {
                webModule.getAltDDs().putAll(DeploymentLoader.mapDescriptors(new ResourceFinder("", webModule.getClassLoader(), new URL[]{thisJar.toURI().toURL()})));
                webModule.getAltDDs().putAll(DeploymentLoader.getWebDescriptors(new File(thisJar.getParentFile().getParentFile(), "src/main/webapp")));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        } else {
            thisJar = null;
        }
        webModule.getAltDDs().putAll(additionalDescriptors);
        for (Descriptors d : Arrays.asList(this.testClass.getAnnotation(Descriptors.class), descriptors)) {
            if (d == null) continue;
            webModule.getAltDDs().putAll(ApplicationComposers.descriptorsToMap(d));
        }
        EjbModule ejbModule = DeploymentLoader.addWebModule(webModule, appModule);
        ejbModule.getProperties().put("openejb.cdi.filter.classloader", "false");
        if (this.isCdi(cdi, cdiInterceptors, cdiAlternatives, cdiStereotypes, cdiDecorators)) {
            ejbModule.setBeans(this.beans(new Beans(), cdiDecorators, cdiInterceptors, cdiAlternatives, cdiStereotypes));
        }
        Class<?>[] classes = cdiClasses;
        Object[] providersClasses = providers == null ? null : providers.value();
        for (JaxrsProviders jaxrsProviders : Arrays.asList(this.testClass.getAnnotation(JaxrsProviders.class), providers)) {
            if (jaxrsProviders == null) continue;
            if (classes == null) {
                classes = jaxrsProviders.value();
                continue;
            }
            ArrayList newClasses = new ArrayList(Arrays.asList(classes));
            newClasses.addAll(Arrays.asList(jaxrsProviders.value()));
            classes = newClasses.toArray(new Class[newClasses.size()]);
        }
        if (innerClassesAsBean) {
            LinkedList inners = new LinkedList();
            for (Class<?> clazz : this.testClass.getClasses()) {
                int modifiers = clazz.getModifiers();
                try {
                    if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers) || clazz.getConstructor(new Class[0]) == null) continue;
                    inners.add(clazz);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (!inners.isEmpty()) {
                ArrayList arrayList = new ArrayList(Arrays.asList(classes));
                arrayList.addAll(inners);
                classes = arrayList.toArray(new Class[arrayList.size()]);
            }
        }
        LinkedList<File> libs = null;
        for (Jars jars : Arrays.asList(jarsAnnotation, globalJarsAnnotation)) {
            Collection<File> files = ApplicationComposers.findFiles(jars);
            if (files == null) continue;
            if (libs == null) {
                libs = new LinkedList();
            }
            libs.addAll(files);
        }
        if (autoConfig) {
            File file;
            if (libs == null) {
                libs = new LinkedList<File>();
            }
            libs.add(thisJar);
            if ("test-classes".equals(thisJar.getName()) && "target".equals(thisJar.getParentFile().getName())) {
                File file2 = new File(thisJar.getParentFile(), "classes");
                if (file2.exists()) {
                    libs.add(file2);
                }
            } else if ("test".equals(thisJar.getName()) && "classes".equals(thisJar.getParentFile().getName()) && (file = new File(thisJar.getParentFile(), "main")).exists()) {
                libs.add(file);
            }
        }
        IAnnotationFinder iAnnotationFinder = ApplicationComposers.finderFromClasses(webModule, classes, (Collection<File>)libs, excludes);
        webModule.setFinder(iAnnotationFinder);
        ejbModule.setFinder(webModule.getFinder());
        if (providersClasses != null) {
            OpenejbJar openejbJar = ejbModule.getOpenejbJar();
            if (openejbJar == null) {
                openejbJar = new OpenejbJar();
                ejbModule.setOpenejbJar(openejbJar);
            }
            PojoDeployment pojoDeployment = new PojoDeployment();
            pojoDeployment.setClassName(providers.applicationName());
            pojoDeployment.getProperties().setProperty("cxf.jaxrs.providers", Join.join(",", providersClasses).replace("class ", ""));
            pojoDeployment.getProperties().setProperty("cxf.jaxrs.skip-provider-scanning", "true");
            openejbJar.getPojoDeployment().add(pojoDeployment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enrich(Object inputTestInstance, BeanContext context) throws OpenEJBException {
        if (context == null) {
            return;
        }
        ThreadContext callContext = new ThreadContext(context, null, Operation.INJECTION);
        ThreadContext oldContext = ThreadContext.enter(callContext);
        try {
            InjectionProcessor<Object> processor = new InjectionProcessor<Object>(inputTestInstance, context.getInjections(), context.getJndiContext());
            processor.createInstance();
            Throwable error = null;
            try {
                if (this.appContext.getBeanManager() != null) {
                    OWBInjector.inject((BeanManager)this.appContext.getBeanManager(), (Object)inputTestInstance, null);
                }
            }
            catch (Throwable t) {
                error = t;
            }
            for (WebContext web : this.appContext.getWebContexts()) {
                if (web.getWebBeansContext() == null) continue;
                try {
                    OWBInjector.inject((BeanManager)web.getWebBeansContext().getBeanManagerImpl(), (Object)inputTestInstance, null);
                    error = null;
                    break;
                }
                catch (Throwable t) {
                    if (error != null) continue;
                    error = t;
                }
            }
            if (error != null) {
                error.printStackTrace();
            }
        }
        finally {
            ThreadContext.exit(oldContext);
        }
    }

    public static Collection<File> findFiles(Jars jarsAnnotation) {
        if (jarsAnnotation == null) {
            return null;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ArrayList<URL> classpathAppsUrls = new ArrayList<URL>(8);
        if (jarsAnnotation.excludeDefaults()) {
            DeploymentsResolver.loadFromClasspath(null, classpathAppsUrls, classLoader);
        } else {
            UrlSet urlSet;
            try {
                urlSet = new UrlSet(classLoader);
                urlSet = URLs.cullSystemJars(urlSet);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            classpathAppsUrls.addAll(urlSet.getUrls());
        }
        String[] value = jarsAnnotation.value();
        ArrayList<File> files = new ArrayList<File>(value.length);
        for (String v : value) {
            int size = files.size();
            for (URL path : classpathAppsUrls) {
                File file = URLs.toFile(path);
                if (file.getName().startsWith(v) && file.getName().endsWith(".jar")) {
                    files.add(file);
                    continue;
                }
                if (!"classes".equals(file.getName()) || !"target".equals(file.getParentFile().getName()) || !file.getParentFile().getParentFile().getName().startsWith(v)) continue;
                files.add(file);
            }
            if (size != files.size()) continue;
            throw new IllegalArgumentException(v + " not found in classpath");
        }
        return files;
    }

    private Beans beans(Beans beans, Class<?>[] cdiDecorators, Class<?>[] cdiInterceptors, Class<?>[] cdiAlternatives, Class<?>[] cdiStereotypes) {
        if (cdiDecorators != null) {
            for (Class<?> clazz : cdiDecorators) {
                beans.addDecorator(clazz);
            }
        }
        if (cdiInterceptors != null) {
            for (Class<?> clazz : cdiInterceptors) {
                beans.addInterceptor(clazz);
            }
        }
        if (cdiAlternatives != null) {
            for (Class<?> clazz : cdiAlternatives) {
                beans.addAlternativeClass(clazz);
            }
        }
        if (cdiStereotypes != null) {
            for (Class<?> clazz : cdiStereotypes) {
                beans.addAlternativeStereotype(clazz);
            }
        }
        return beans;
    }

    private void setComponent(Object testInstance, Method method) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<?> key;
        Object value = method.invoke(testInstance, new Object[0]);
        if (value instanceof Class) {
            value = ((Class)value).newInstance();
        }
        if (!(key = method.getReturnType()).isInstance(value)) {
            throw new OpenEJBRuntimeException(value + " is not an instance of " + key.getName());
        }
        SystemInstance.get().setComponent(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T evaluate(Object testInstance, Callable<T> next) throws Exception {
        this.before(testInstance);
        try {
            T t = next.call();
            return t;
        }
        finally {
            ThreadContext.exit(this.previous);
            this.after();
        }
    }

    public void evaluate(Object testInstance, final Runnable next) throws Exception {
        this.evaluate(testInstance, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                next.run();
                return null;
            }
        });
    }

    public void after() throws Exception {
        try {
            this.runAll(this.beforeDestroyAfterRunnables);
            if (this.assembler != null) {
                this.stopApplication();
            }
            if (this.serviceManager != null) {
                try {
                    this.serviceManager.stop();
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            OpenEJB.destroy();
        }
        finally {
            this.runAll(this.afterRunnables);
            if (this.originalLoader != null) {
                Thread.currentThread().setContextClassLoader(this.originalLoader);
            }
            if (this.originalProperties != null) {
                System.setProperties(this.originalProperties);
            }
        }
    }

    public void stopApplication() throws NamingException {
        ContainerSystem component;
        if (this.appContext != null && this.appContext.getWebBeansContext() != null) {
            ContextsService contextsService = this.appContext.getWebBeansContext().getContextsService();
            contextsService.endContext(SessionScoped.class, (Object)this.session);
            contextsService.endContext(RequestScoped.class, null);
        }
        if (this.appInfo != null) {
            try {
                this.assembler.destroyApplication(this.appInfo.path);
            }
            catch (Exception contextsService) {
                // empty catch block
            }
        }
        if (null != (component = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class))) {
            Context context = component.getJNDIContext();
            for (String entry : this.globalJndiEntries) {
                context.unbind(entry);
            }
        }
        this.globalJndiEntries.clear();
        if (this.mockCdiContexts() && this.appContext != null && this.appContext.getWebBeansContext() != null) {
            try {
                ScopeHelper.stopContexts(this.appContext.getWebBeansContext().getContextsService(), (ServletContext)this.servletContext, (HttpSession)this.session);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void runAll(Collection<Runnable> runnables) {
        for (Runnable r : runnables) {
            try {
                r.run();
            }
            catch (Exception exception) {}
        }
        runnables.clear();
    }

    private <M extends NamedModule> M setId(M module, Method method) {
        return this.setId(module, method.getName());
    }

    private <M extends NamedModule> M setId(M module, String name) {
        if (module.getModuleName() != null) {
            return module;
        }
        if (module.getId() != null) {
            return module;
        }
        module.setId(name);
        return module;
    }

    private static String implicitRootUrl(PersistenceRootUrl annotation) {
        if (annotation != null) {
            return annotation.value();
        }
        ResourceFinder finder = new ResourceFinder("", Thread.currentThread().getContextClassLoader());
        try {
            URL url = DeploymentLoader.altDDSources(DeploymentLoader.mapDescriptors(finder), false).get("persistence.xml");
            if (url == null) {
                return "";
            }
            File file = URLs.toFile(url);
            String filename = file.getName();
            if (filename.endsWith("persistence.xml")) {
                String parent = file.getParentFile().getName();
                if (parent.equalsIgnoreCase("META-INF")) {
                    return file.getParentFile().getParentFile().getAbsolutePath();
                }
                return file.getParentFile().getAbsolutePath();
            }
            if (filename.endsWith(".jar")) {
                return file.toURI().toURL().toExternalForm();
            }
            return url.toExternalForm();
        }
        catch (IOException e) {
            return "";
        }
    }

    private static Map<String, URL> descriptorsToMap(Object descriptors) {
        if (descriptors != null) {
            HashMap<String, URL> dds = new HashMap<String, URL>();
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (descriptors instanceof Descriptors) {
                for (Descriptor descriptor : ((Descriptors)descriptors).value()) {
                    URL resource = loader.getResource(descriptor.path());
                    try {
                        dds.put(descriptor.name(), resource == null ? new File(descriptor.path()).toURI().toURL() : resource);
                    }
                    catch (MalformedURLException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
            } else if (descriptors instanceof org.apache.openejb.junit.Descriptors) {
                for (org.apache.openejb.junit.Descriptor descriptor : ((org.apache.openejb.junit.Descriptors)descriptors).value()) {
                    URL resource = loader.getResource(descriptor.path());
                    try {
                        dds.put(descriptor.name(), resource == null ? new File(descriptor.path()).toURI().toURL() : resource);
                    }
                    catch (MalformedURLException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
            }
            return dds;
        }
        return new HashMap<String, URL>();
    }

    private static IAnnotationFinder finderFromClasses(DeploymentModule module, Class<?>[] value, Collection<File> others, String[] excludes) {
        ArrayList<Object> archives = new ArrayList<Object>(1 + (others == null ? 0 : others.size()));
        Filter filter = excludes == null || excludes.length == 0 ? null : Filters.invert((Filter)Filters.prefixes((String[])excludes));
        ArrayList classes = new ArrayList(Arrays.asList(FinderFactory.ensureMinimalClasses(module)));
        if (value != null) {
            classes.addAll(Arrays.asList(value));
        }
        ClassesArchive classesArchive = new ClassesArchive(classes);
        archives.add(filter == null ? classesArchive : new FilteredArchive((Archive)classesArchive, filter));
        if (others != null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            for (File f : others) {
                try {
                    FileArchive archive = f.isDirectory() ? new FileArchive(classLoader, f) : new JarArchive(classLoader, f.toURI().toURL());
                    archives.add(filter == null ? archive : new FilteredArchive((Archive)archive, filter));
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        return new FinderFactory.OpenEJBAnnotationFinder((Archive)new CompositeArchive(archives)).link();
    }

    private void initFilteredServiceManager(String[] services) {
        Class<?> serviceManagerClass;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            serviceManagerClass = classLoader.loadClass("org.apache.openejb.server.FilteredServiceManager");
        }
        catch (ClassNotFoundException e) {
            String msg = "Services filtering requires class 'org.apache.openejb.server.FilteredServiceManager' to be available.  Make sure you have the openejb-server-*.jar in your classpath.";
            throw new IllegalStateException("Services filtering requires class 'org.apache.openejb.server.FilteredServiceManager' to be available.  Make sure you have the openejb-server-*.jar in your classpath.", e);
        }
        try {
            Method initServiceManager = serviceManagerClass.getMethod("initServiceManager", String[].class);
            initServiceManager.invoke(null, new Object[]{services});
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed initializing FilteredServiceManager with services " + Arrays.toString(services), e);
        }
    }

    private static void linkageErrorProtection() {
        ClassLoader loader = ApplicationComposers.class.getClassLoader();
        try {
            Class.forName("sun.security.pkcs11.SunPKCS11", true, loader);
            Class.forName("sun.security.pkcs11.SunPKCS11$Descriptor", true, loader);
            Class.forName("sun.security.pkcs11.wrapper.PKCS11Exception", true, loader);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startContainer(Object instance) throws Exception {
        CdiExtensions cdiExtensions;
        Object value;
        WebResource webResource;
        org.apache.openejb.junit.EnableServices annotationOld;
        this.originalProperties = (Properties)JavaSecurityManagers.getSystemProperties().clone();
        this.originalLoader = Thread.currentThread().getContextClassLoader();
        this.fixFakeClassFinder(instance);
        Properties configuration = new Properties();
        configuration.put("openejb.deployments.classpath", "false");
        EnableServices annotation = this.testClass.getAnnotation(EnableServices.class);
        if (annotation != null && annotation.httpDebug()) {
            configuration.setProperty("httpejbd.print", "true");
            configuration.setProperty("httpejbd.indent.xml", "true");
            configuration.setProperty("logging.level.OpenEJB.server.http", "FINE");
        }
        if ((annotationOld = this.testClass.getAnnotation(org.apache.openejb.junit.EnableServices.class)) != null && annotationOld.httpDebug()) {
            configuration.setProperty("httpejbd.print", "true");
            configuration.setProperty("httpejbd.indent.xml", "true");
            configuration.setProperty("logging.level.OpenEJB.server.http", "FINE");
        }
        if ((webResource = this.testClass.getAnnotation(WebResource.class)) != null && webResource.value().length > 0) {
            configuration.setProperty("openejb.embedded.http.resources", Join.join(",", webResource.value()));
        }
        Openejb openejb = null;
        HashMap<Object, List<Method>> configs = new HashMap<Object, List<Method>>();
        this.findAnnotatedMethods(configs, Configuration.class);
        this.findAnnotatedMethods(configs, org.apache.openejb.junit.Configuration.class);
        for (Map.Entry method : configs.entrySet()) {
            for (Method method2 : (List)method.getValue()) {
                Object o = method2.invoke(method.getKey(), new Object[0]);
                if (o instanceof Properties) {
                    Properties properties = (Properties)o;
                    configuration.putAll((Map<?, ?>)properties);
                    continue;
                }
                if (Openejb.class.isInstance(o)) {
                    openejb = (Openejb)Openejb.class.cast(o);
                    continue;
                }
                if (!String.class.isInstance(o)) continue;
                String path = (String)String.class.cast(o);
                URL url = Thread.currentThread().getContextClassLoader().getResource(path);
                if (url == null) {
                    throw new IllegalArgumentException(o.toString() + " not found");
                }
                InputStream in = url.openStream();
                try {
                    if (path.endsWith(".json")) {
                        openejb = JSonConfigReader.read(Openejb.class, in);
                        continue;
                    }
                    openejb = JaxbOpenejb.readConfig(new InputSource(in));
                }
                finally {
                    IO.close((Closeable)in);
                }
            }
        }
        if (SystemInstance.isInitialized()) {
            SystemInstance.reset();
        }
        LinkedList<String> propertiesToSetAgain = null;
        ContainerProperties configAnnot = this.testClass.getAnnotation(ContainerProperties.class);
        if (configAnnot != null) {
            for (ContainerProperties.Property p : configAnnot.value()) {
                value = p.value();
                if ("__not__set__so__ignored".equals(value)) {
                    System.clearProperty(p.name());
                    continue;
                }
                String name = p.name();
                configuration.put(name, value);
                if (!((String)value).contains("${")) continue;
                if (propertiesToSetAgain == null) {
                    propertiesToSetAgain = new LinkedList<String>();
                }
                propertiesToSetAgain.add(name);
            }
        }
        SystemInstance.init((Properties)configuration);
        if (SystemInstance.get().getComponent(ThreadSingletonService.class) == null) {
            CdiBuilder.initializeOWB();
        }
        for (Map.Entry entry : this.testClassFinders.entrySet()) {
            for (Field field : ((ClassFinder)entry.getValue()).findAnnotatedFields(RandomPort.class)) {
                int random;
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                Iterator<Method> service = field.getAnnotation(RandomPort.class).value();
                String key = (String)("http".equals(service) ? "httpejbd" : service) + ".port";
                String existing = SystemInstance.get().getProperty(key);
                if (existing == null) {
                    random = NetworkUtil.getNextAvailablePort();
                    SystemInstance.get().setProperty(key, Integer.toString(random));
                } else {
                    random = Integer.parseInt(existing);
                }
                if (Integer.TYPE == field.getType()) {
                    field.set(entry.getKey(), random);
                    continue;
                }
                if (URL.class != field.getType()) continue;
                field.set(entry.getKey(), new URL("http://localhost:" + random + "/"));
            }
        }
        for (Map.Entry entry : this.testClassFinders.entrySet()) {
            if (((ClassFinder)entry.getValue()).findAnnotatedClasses(SimpleLog.class).isEmpty()) continue;
            SystemInstance.get().setProperty("openejb.jul.forceReload", "true");
            break;
        }
        if ((cdiExtensions = this.testClass.getAnnotation(CdiExtensions.class)) != null) {
            SystemInstance.get().setComponent(LoaderService.class, (Object)new ExtensionAwareOptimizedLoaderService(cdiExtensions.value()));
        }
        SystemInstance.get().setComponent(TestInstance.class, (Object)new TestInstance(this.testClass, instance));
        HashMap<Object, List<Method>> hashMap = new HashMap<Object, List<Method>>();
        this.findAnnotatedMethods(hashMap, MockInjector.class);
        this.findAnnotatedMethods(hashMap, org.apache.openejb.junit.MockInjector.class);
        if (!hashMap.isEmpty() && !((List)hashMap.values().iterator().next()).isEmpty()) {
            Map.Entry methods = hashMap.entrySet().iterator().next();
            Object o = ((Method)((List)methods.getValue()).iterator().next()).invoke(methods.getKey(), new Object[0]);
            if (o instanceof Class) {
                o = ((Class)o).newInstance();
            }
            if (o instanceof FallbackPropertyInjector) {
                SystemInstance.get().setComponent(FallbackPropertyInjector.class, (Object)((FallbackPropertyInjector)o));
            }
        }
        for (Map.Entry<Object, List<Method>> method : this.findAnnotatedMethods(new HashMap<Object, List<Method>>(), Component.class).entrySet()) {
            for (Method m : method.getValue()) {
                this.setComponent(method.getKey(), m);
            }
        }
        for (Map.Entry<Object, List<Method>> method : this.findAnnotatedMethods(new HashMap<Object, List<Method>>(), org.apache.openejb.junit.Component.class).entrySet()) {
            for (Method m : method.getValue()) {
                this.setComponent(method.getKey(), m);
            }
        }
        ConfigurationFactory config = new ConfigurationFactory();
        config.init(SystemInstance.get().getProperties());
        SystemInstance.get().setComponent(ConfigurationFactory.class, (Object)config);
        this.assembler = new Assembler();
        SystemInstance.get().setComponent(Assembler.class, (Object)this.assembler);
        OpenEjbConfiguration openEjbConfiguration = openejb != null ? config.getOpenEjbConfiguration(openejb) : config.getOpenEjbConfiguration();
        this.assembler.buildContainerSystem(openEjbConfiguration);
        if ("true".equals(configuration.getProperty("openejb.embedded.remotable", "false")) || annotation != null || annotationOld != null) {
            try {
                if (annotation != null) {
                    value = new ArrayList<String>(Arrays.asList(annotation.value()));
                    if (annotation.jaxrs()) {
                        value.add("jaxrs");
                    }
                    if (annotation.jaxws()) {
                        value.add("jaxws");
                    }
                    this.initFilteredServiceManager(value.toArray(new String[value.size()]));
                }
                if (annotationOld != null) {
                    this.initFilteredServiceManager(annotationOld.value());
                }
                this.serviceManager = new ServiceManagerProxy(false);
                this.serviceManager.start();
            }
            catch (ServiceManagerProxy.AlreadyStartedException e) {
                throw new OpenEJBRuntimeException(e);
            }
        }
        if (propertiesToSetAgain != null) {
            for (String name : propertiesToSetAgain) {
                String value2 = PropertyPlaceHolderHelper.simpleValue(SystemInstance.get().getProperty(name));
                configuration.put(name, value2);
                JavaSecurityManagers.setSystemProperty(name, value2);
            }
            propertiesToSetAgain.clear();
        }
    }

    public static void run(Class<?> type, String ... args) {
        final ApplicationComposers composer = new ApplicationComposers(type, new Object[0]);
        try {
            Object instance;
            try {
                Constructor<?> constructor = type.getConstructor(String[].class);
                instance = constructor.newInstance(new Object[]{args});
            }
            catch (Exception e) {
                instance = type.newInstance();
            }
            composer.before(instance);
            composer.testClassFinders.remove(composer);
            final CountDownLatch latch = new CountDownLatch(1);
            final Thread hook = new Thread(){

                @Override
                public void run() {
                    try {
                        composer.after();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            Runtime.getRuntime().addShutdownHook(hook);
            composer.afterRunnables.add(new Runnable(){

                @Override
                public void run() {
                    Runtime.getRuntime().removeShutdownHook(hook);
                    latch.countDown();
                }
            });
            composer.handleLifecycle(type, instance);
            latch.await();
        }
        catch (InterruptedException ie) {
            Thread.interrupted();
        }
        catch (Exception e) {
            throw new OpenEJBRuntimeException(e);
        }
    }

    public void handleLifecycle(final Class<?> type, final Object appInstance) throws IllegalAccessException, InvocationTargetException {
        this.beforeDestroyAfterRunnables.add(new Runnable(){

            @Override
            public void run() {
                for (Map.Entry m : ApplicationComposers.this.testClassFinders.entrySet()) {
                    for (Method mtd : ((ClassFinder)m.getValue()).findAnnotatedMethods(PreDestroy.class)) {
                        if (mtd.getParameterTypes().length != 0) continue;
                        if (!mtd.isAccessible()) {
                            mtd.setAccessible(true);
                        }
                        try {
                            mtd.invoke(mtd.getDeclaringClass() == type ? appInstance : m.getKey(), new Object[0]);
                        }
                        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {}
                    }
                }
            }
        });
        if (!this.appContext.getWebContexts().isEmpty()) {
            this.beforeDestroyAfterRunnables.add(new Runnable(){

                @Override
                public void run() {
                    try {
                        Object sessionManager = SystemInstance.get().getComponent(ParentClassLoaderFinder.Helper.get().loadClass("org.apache.openejb.server.httpd.session.SessionManager"));
                        if (sessionManager != null) {
                            Class[] paramTypes = new Class[]{WebContext.class};
                            for (WebContext web : ApplicationComposers.this.appContext.getWebContexts()) {
                                Reflections.invokeByReflection(sessionManager, "destroy", paramTypes, new Object[]{web});
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
        }
        for (Map.Entry<Object, ClassFinder> m : this.testClassFinders.entrySet()) {
            for (Method mtd : m.getValue().findAnnotatedMethods(PostConstruct.class)) {
                if (mtd.getParameterTypes().length != 0) continue;
                if (!mtd.isAccessible()) {
                    mtd.setAccessible(true);
                }
                mtd.invoke(mtd.getDeclaringClass() == type ? appInstance : m.getKey(), new Object[0]);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            throw new IllegalArgumentException("provide at least application class as parameter");
        }
        Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(args[0]);
        ArrayList<String> a = new ArrayList<String>(Arrays.asList(args));
        a.remove(0);
        ApplicationComposers.run(c, a.toArray(new String[a.size()]));
    }

    static {
        ApplicationComposers.linkageErrorProtection();
    }

    protected static class ExtensionAwareOptimizedLoaderService
    extends OptimizedLoaderService {
        private final Class<? extends Extension>[] extensions;

        protected ExtensionAwareOptimizedLoaderService(Class<? extends Extension>[] extensions) {
            super(new Properties());
            this.extensions = extensions;
        }

        @Override
        protected List<? extends Extension> loadExtensions(ClassLoader classLoader) {
            ArrayList<Extension> list = new ArrayList<Extension>();
            for (Class<? extends Extension> e : this.extensions) {
                try {
                    list.add(e.newInstance());
                }
                catch (Exception e1) {
                    throw new OpenEJBRuntimeException(e1);
                }
            }
            return list;
        }
    }
}

