/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.openejb.Container;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.assembler.classic.ContainerInfo;
import org.apache.openejb.assembler.classic.MdbContainerInfo;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.core.mdb.MdbContainer;
import org.apache.openejb.jee.ActivationConfig;
import org.apache.openejb.jee.ActivationConfigProperty;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.MessageDrivenBean;
import org.apache.openejb.jee.oejb3.EjbDeployment;
import org.apache.openejb.jee.oejb3.OpenejbJar;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.JavaSecurityManagers;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.PropertyPlaceHolderHelper;

public class ActivationConfigPropertyOverride
implements DynamicDeployer {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP_CONFIG, ActivationConfigPropertyOverride.class);

    @Override
    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        Properties system = new Properties();
        system.putAll((Map<?, ?>)SystemInstance.get().getProperties());
        system.putAll((Map<?, ?>)appModule.getProperties());
        system.putAll((Map<?, ?>)JavaSecurityManagers.getSystemProperties());
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            EjbJar ejbJar = ejbModule.getEjbJar();
            OpenejbJar openejbJar = ejbModule.getOpenejbJar();
            Properties module = new Properties();
            module.putAll((Map<?, ?>)openejbJar.getProperties());
            module.putAll((Map<?, ?>)system);
            Map deployments = openejbJar.getDeploymentsByEjbName();
            for (EnterpriseBean bean : ejbJar.getEnterpriseBeans()) {
                String ejbName = bean.getEjbName();
                EjbDeployment ejbDeployment = (EjbDeployment)deployments.get(ejbName);
                if (!(bean instanceof MessageDrivenBean)) continue;
                Properties properties = new Properties();
                properties.putAll((Map<?, ?>)module);
                properties.putAll((Map<?, ?>)ejbDeployment.getProperties());
                MessageDrivenBean mdb = (MessageDrivenBean)bean;
                if (mdb.getActivationConfig() != null) {
                    for (ActivationConfigProperty property : mdb.getActivationConfig().getActivationConfigProperty()) {
                        String originalValue = property.getActivationConfigPropertyValue();
                        String value = PropertyPlaceHolderHelper.simpleValue(originalValue);
                        if (value == null || originalValue.equals(value)) continue;
                        property.setActivationConfigPropertyValue(value);
                    }
                }
                Properties overrides = new Properties();
                MdbContainerDetails mdbContainer = this.getMdbContainer(appModule, ejbDeployment.getContainerId(), appModule.getModuleId());
                if (mdbContainer != null) {
                    overrides.putAll((Map<?, ?>)ConfigurationFactory.getOverrides(properties, "mdb.container." + mdbContainer.getContainerId() + ".activation", "EnterpriseBean"));
                    overrides.putAll((Map<?, ?>)ConfigurationFactory.getOverrides(mdbContainer.getProperties(), "activation", "EnterpriseBean"));
                }
                overrides.putAll((Map<?, ?>)ConfigurationFactory.getOverrides(properties, "mdb.activation", "EnterpriseBean"));
                overrides.putAll((Map<?, ?>)ConfigurationFactory.getOverrides(properties, mdb.getMessagingType() + ".activation", "EnterpriseBean"));
                overrides.putAll((Map<?, ?>)ConfigurationFactory.getOverrides(properties, ejbName + ".activation", "EnterpriseBean"));
                overrides.putAll((Map<?, ?>)ConfigurationFactory.getOverrides(properties, ejbDeployment.getDeploymentId() + ".activation", "EnterpriseBean"));
                if (overrides.size() == 0) continue;
                if (mdb.getActivationConfig() == null) {
                    mdb.setActivationConfig(new ActivationConfig());
                }
                List activationConfigList = mdb.getActivationConfig().getActivationConfigProperty();
                for (Map.Entry<Object, Object> entry : overrides.entrySet()) {
                    String property = String.valueOf(entry.getKey());
                    String value = String.valueOf(entry.getValue());
                    ActivationConfigProperty activationConfigProperty = this.findActivationProperty(activationConfigList, property.toString());
                    if (activationConfigProperty != null) {
                        logger.info(String.format("Found %s bean with activation-config property %s=%s to override", ejbName, activationConfigProperty.getActivationConfigPropertyName(), activationConfigProperty.getActivationConfigPropertyValue()));
                        logger.info(String.format("Overriding %s bean activation-config property.%s=%s", ejbName, property, value));
                        activationConfigProperty.setActivationConfigPropertyValue(entry.getValue().toString());
                        continue;
                    }
                    logger.info(String.format("Adding %s bean activation-config property %s=%s", ejbName, property, value));
                    activationConfigProperty = new ActivationConfigProperty();
                    activationConfigProperty.setActivationConfigPropertyName(property.toString());
                    activationConfigProperty.setActivationConfigPropertyValue(value.toString());
                    activationConfigList.add(activationConfigProperty);
                }
            }
        }
        return appModule;
    }

    private MdbContainerDetails getMdbContainer(AppModule appModule, String containerId, String moduleId) {
        ContainerSystem containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
        ConfigurationFactory configurationFactory = (ConfigurationFactory)SystemInstance.get().getComponent(ConfigurationFactory.class);
        if (containerId == null || containerId.length() == 0) {
            Container[] containers;
            for (Container container : containers = containerSystem.containers()) {
                if (!MdbContainer.class.isInstance(container)) continue;
                return this.convert((MdbContainer)MdbContainer.class.cast(container));
            }
            List<ContainerInfo> containerInfos = configurationFactory.getContainerInfos();
            for (ContainerInfo containerInfo : containerInfos) {
                if (!MdbContainerInfo.class.isInstance(containerInfo)) continue;
                return this.convert((MdbContainerInfo)MdbContainerInfo.class.cast(containerInfo));
            }
            return null;
        }
        Container appContainer = containerSystem.getContainer(moduleId + "/" + containerId);
        if (appContainer != null && MdbContainer.class.isInstance(appContainer)) {
            return this.convert((MdbContainer)MdbContainer.class.cast(appContainer));
        }
        MdbContainerDetails appContainerInfo = this.findContainerInfo(configurationFactory.getContainerInfos(), moduleId + "/" + containerId);
        if (appContainerInfo != null) {
            return appContainerInfo;
        }
        Container container = containerSystem.getContainer(containerId);
        if (MdbContainer.class.isInstance(container)) {
            return this.convert((MdbContainer)MdbContainer.class.cast(container));
        }
        MdbContainerDetails containerInfo = this.findContainerInfo(configurationFactory.getContainerInfos(), containerId);
        if (containerInfo != null) {
            return containerInfo;
        }
        MdbContainerDetails moduleContainer = this.findModuleContainer(appModule, configurationFactory, containerId);
        if (moduleContainer != null) {
            return moduleContainer;
        }
        return null;
    }

    private MdbContainerDetails findModuleContainer(AppModule appModule, ConfigurationFactory configurationFactory, String containerId) {
        Collection<org.apache.openejb.config.sys.Container> containers = appModule.getContainers();
        for (org.apache.openejb.config.sys.Container appMopduleContainer : containers) {
            if (!appMopduleContainer.getId().equals(containerId) && !appMopduleContainer.getId().equals(appModule.getModuleId() + "/" + containerId)) continue;
            try {
                ContainerInfo containerInfo = configurationFactory.createContainerInfo(appMopduleContainer);
                if (containerInfo == null || !MdbContainerInfo.class.isInstance(containerInfo)) continue;
                return this.convert((MdbContainerInfo)MdbContainerInfo.class.cast(containerInfo));
            }
            catch (OpenEJBException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private MdbContainerDetails convert(MdbContainerInfo mdbContainerInfo) {
        return new MdbContainerDetails(mdbContainerInfo.id, mdbContainerInfo.properties);
    }

    private MdbContainerDetails findContainerInfo(List<ContainerInfo> containerInfos, String id) {
        for (ContainerInfo containerInfo : containerInfos) {
            if (!MdbContainerInfo.class.isInstance(containerInfo) || !containerInfo.id.equals(id)) continue;
            return new MdbContainerDetails(containerInfo.id, containerInfo.properties);
        }
        return null;
    }

    private MdbContainerDetails convert(MdbContainer mdbContainer) {
        if (mdbContainer == null) {
            return null;
        }
        if (mdbContainer.getContainerID() == null) {
            throw new IllegalStateException("Container has no ID");
        }
        return new MdbContainerDetails(mdbContainer.getContainerID().toString(), mdbContainer.getProperties());
    }

    private ActivationConfigProperty findActivationProperty(List<ActivationConfigProperty> activationConfigList, String nameOfProperty) {
        for (ActivationConfigProperty activationProp : activationConfigList) {
            if (!activationProp.getActivationConfigPropertyName().equals(nameOfProperty)) continue;
            return activationProp;
        }
        return null;
    }

    private static class MdbContainerDetails {
        private final String containerId;
        private final Properties properties;

        public MdbContainerDetails(String containerId, Properties properties) {
            this.containerId = containerId;
            this.properties = properties;
        }

        public String getContainerId() {
            return this.containerId;
        }

        public Properties getProperties() {
            return this.properties;
        }
    }
}

