/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ConfigurableClasspathArchive;
import org.apache.openejb.config.ConnectorModule;
import org.apache.openejb.config.DeploymentModule;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.Module;
import org.apache.openejb.config.NewLoaderLogic;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.config.WebappAggregatedArchive;
import org.apache.openejb.jee.Beans;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.Handler;
import org.apache.openejb.jee.HandlerChain;
import org.apache.openejb.jee.Interceptor;
import org.apache.openejb.jee.PortComponent;
import org.apache.openejb.jee.Servlet;
import org.apache.openejb.jee.SessionBean;
import org.apache.openejb.jee.WebserviceDescription;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.Classes;
import org.apache.xbean.finder.Annotated;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.finder.IAnnotationFinder;
import org.apache.xbean.finder.UrlSet;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.ClassesArchive;
import org.apache.xbean.finder.archive.ClasspathArchive;

public class FinderFactory {
    private static final FinderFactory factory = new FinderFactory();
    public static final String FORCE_LINK = "openejb.finder.force.link";
    private static volatile boolean MODULE_LIMITED = "true".equalsIgnoreCase(SystemInstance.get().getProperty("openejb.finder.module-scoped", "false"));

    private static FinderFactory get() {
        FinderFactory factory = (FinderFactory)SystemInstance.get().getComponent(FinderFactory.class);
        return factory != null ? factory : FinderFactory.factory;
    }

    public static IAnnotationFinder createFinder(DeploymentModule module) throws Exception {
        return FinderFactory.get().create(module);
    }

    public static AnnotationFinder getFinder(ClassLoader classLoader, URL url) {
        return FinderFactory.newFinder(ClasspathArchive.archive((ClassLoader)classLoader, (URL)url));
    }

    public IAnnotationFinder create(DeploymentModule module) throws Exception {
        OpenEJBAnnotationFinder finder;
        if (module instanceof WebModule) {
            WebModule webModule = (WebModule)module;
            finder = FinderFactory.newFinder(new WebappAggregatedArchive(webModule, webModule.getScannableUrls()));
            finder = this.useFallbackFinderIfNeededOrLink(module, finder);
        } else if (module instanceof ConnectorModule) {
            ConnectorModule connectorModule = (ConnectorModule)module;
            finder = FinderFactory.newFinder((Archive)new ConfigurableClasspathArchive((Module)connectorModule, connectorModule.getLibraries()));
            finder = this.useFallbackFinderIfNeededOrLink(module, finder);
        } else if (module instanceof AppModule) {
            AppModule appModule = (AppModule)AppModule.class.cast(module);
            List urls = NewLoaderLogic.applyBuiltinExcludes(new UrlSet(appModule.getAdditionalLibraries())).getUrls();
            urls.addAll(appModule.getScannableContainerUrls());
            finder = FinderFactory.newFinder(new WebappAggregatedArchive(module.getClassLoader(), module.getAltDDs(), urls));
            finder = this.useFallbackFinderIfNeededOrLink(module, finder);
        } else if (module.getJarLocation() != null) {
            URL url;
            String location = module.getJarLocation();
            File file = new File(location);
            if (file.exists()) {
                url = file.toURI().toURL();
                File webInfClassesFolder = new File(file, "WEB-INF/classes");
                if (webInfClassesFolder.exists() && webInfClassesFolder.isDirectory()) {
                    url = webInfClassesFolder.toURI().toURL();
                }
            } else {
                url = new URL(location);
            }
            if (module instanceof Module) {
                DebugArchive archive = new DebugArchive((Archive)new ConfigurableClasspathArchive((Module)((Object)module), url));
                finder = FinderFactory.newFinder(archive);
            } else {
                finder = FinderFactory.newFinder(new DebugArchive((Archive)new ConfigurableClasspathArchive(module.getClassLoader(), url)));
            }
            finder = this.useFallbackFinderIfNeededOrLink(module, finder);
        } else {
            finder = this.fallbackAnnotationFinder(module);
        }
        return MODULE_LIMITED ? new ModuleLimitedFinder(finder) : finder;
    }

    private OpenEJBAnnotationFinder useFallbackFinderIfNeededOrLink(DeploymentModule module, OpenEJBAnnotationFinder finder) {
        OpenEJBAnnotationFinder fbFinder;
        if (!finder.foundSomething() && (fbFinder = this.fallbackAnnotationFinder(module)).foundSomething()) {
            return fbFinder;
        }
        finder.link();
        return finder;
    }

    private OpenEJBAnnotationFinder fallbackAnnotationFinder(DeploymentModule module) {
        OpenEJBAnnotationFinder finder = new OpenEJBAnnotationFinder((Archive)new ClassesArchive((Class[])FinderFactory.ensureMinimalClasses(module)));
        finder.enableMetaAnnotations();
        return finder;
    }

    public static Class<?>[] ensureMinimalClasses(DeploymentModule module) {
        HashSet finderClasses;
        block39: {
            block38: {
                finderClasses = new HashSet();
                if (!EjbModule.class.isInstance(module)) break block38;
                EjbModule ejb = (EjbModule)EjbModule.class.cast(module);
                EnterpriseBean[] enterpriseBeans = ejb.getEjbJar().getEnterpriseBeans();
                ClassLoader classLoader = ejb.getClassLoader();
                if (classLoader == null) {
                    classLoader = Thread.currentThread().getContextClassLoader();
                }
                EnterpriseBean[] enterpriseBeanArray = enterpriseBeans;
                int n = enterpriseBeanArray.length;
                for (int i = 0; i < n; ++i) {
                    SessionBean sessionBean;
                    EnterpriseBean bean = enterpriseBeanArray[i];
                    Object name = SessionBean.class.isInstance(bean) ? ((sessionBean = (SessionBean)SessionBean.class.cast(bean)).getProxy() == null ? sessionBean.getEjbClass() : sessionBean.getProxy()) : bean.getEjbClass();
                    try {
                        Class<?> clazz = classLoader.loadClass((String)name);
                        finderClasses.addAll(Classes.ancestors(clazz));
                        continue;
                    }
                    catch (ClassNotFoundException clazz) {
                        // empty catch block
                    }
                }
                if (ejb.getWebservices() != null) {
                    for (WebserviceDescription webservice : ejb.getWebservices().getWebserviceDescription()) {
                        for (PortComponent port : webservice.getPortComponent()) {
                            if (port.getHandlerChains() == null) continue;
                            for (HandlerChain handlerChain : port.getHandlerChains().getHandlerChain()) {
                                for (Handler handler : handlerChain.getHandler()) {
                                    if (handler.getHandlerClass() == null) continue;
                                    try {
                                        finderClasses.addAll(Classes.ancestors(classLoader.loadClass(handler.getHandlerClass())));
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {}
                                }
                            }
                        }
                    }
                }
                for (Interceptor interceptor : ejb.getEjbJar().getInterceptors()) {
                    try {
                        finderClasses.addAll(Classes.ancestors(classLoader.loadClass(interceptor.getInterceptorClass())));
                    }
                    catch (ClassNotFoundException name) {
                        // empty catch block
                    }
                }
                Beans beans = ejb.getBeans();
                if (beans == null || ejb.getEjbJar() == null) break block39;
                for (List managedClasses : beans.getManagedClasses().values()) {
                    for (Object name : managedClasses) {
                        try {
                            finderClasses.addAll(Classes.ancestors(classLoader.loadClass((String)name)));
                        }
                        catch (ClassNotFoundException classNotFoundException) {}
                    }
                }
                for (String name : beans.getInterceptors()) {
                    try {
                        finderClasses.addAll(Classes.ancestors(classLoader.loadClass(name)));
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
                for (String name : beans.getAlternativeClasses()) {
                    try {
                        finderClasses.addAll(Classes.ancestors(classLoader.loadClass(name)));
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
                for (String name : beans.getDecorators()) {
                    try {
                        finderClasses.addAll(Classes.ancestors(classLoader.loadClass(name)));
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
                break block39;
            }
            if (WebModule.class.isInstance(module)) {
                WebModule web = (WebModule)WebModule.class.cast(module);
                ClassLoader classLoader = web.getClassLoader();
                if (web.getWebApp() != null) {
                    for (Servlet servlet : web.getWebApp().getServlet()) {
                        String servletClass = servlet.getServletClass();
                        if (servletClass == null) continue;
                        try {
                            finderClasses.addAll(Classes.ancestors(classLoader.loadClass(servletClass)));
                        }
                        catch (ClassNotFoundException classNotFoundException) {}
                    }
                    for (String string : web.getRestClasses()) {
                        try {
                            finderClasses.addAll(Classes.ancestors(classLoader.loadClass(string)));
                        }
                        catch (ClassNotFoundException classNotFoundException) {}
                    }
                    for (String string : web.getEjbWebServices()) {
                        try {
                            finderClasses.addAll(Classes.ancestors(classLoader.loadClass(string)));
                        }
                        catch (ClassNotFoundException classNotFoundException) {}
                    }
                }
            }
        }
        return finderClasses.toArray(new Class[finderClasses.size()]);
    }

    private static OpenEJBAnnotationFinder newFinder(Archive archive) {
        return new OpenEJBAnnotationFinder(archive);
    }

    public static Map<String, String> urlByClass(IAnnotationFinder finder) {
        Archive archive;
        IAnnotationFinder limitedFinder = finder instanceof ModuleLimitedFinder ? ((ModuleLimitedFinder)finder).getDelegate() : finder;
        if (limitedFinder instanceof AnnotationFinder && (archive = ((AnnotationFinder)limitedFinder).getArchive()) instanceof WebappAggregatedArchive) {
            Map<URL, List<String>> index = ((WebappAggregatedArchive)archive).getClassesMap();
            HashMap<String, String> urlByClasses = new HashMap<String, String>();
            for (Map.Entry<URL, List<String>> entry : index.entrySet()) {
                String url = entry.getKey().toExternalForm();
                for (String current : entry.getValue()) {
                    urlByClasses.put(current, url);
                }
            }
            return urlByClasses;
        }
        return Collections.emptyMap();
    }

    public static class DoLoadClassesArchive
    extends ClassesArchive {
        public DoLoadClassesArchive(ClassLoader loader, Collection<String> classes) {
            super(DoLoadClassesArchive.load(loader, classes));
        }

        private static Iterable<Class<?>> load(ClassLoader loader, Collection<String> classes) {
            ArrayList loaded = new ArrayList(classes.size());
            for (String n : classes) {
                try {
                    loaded.add(loader.loadClass(n));
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            return loaded;
        }
    }

    public static class OpenEJBAnnotationFinder
    extends AnnotationFinder {
        private static final String[] JVM_SCANNING_CONFIG = SystemInstance.get().getProperty("openejb.scanning.xbean.jvm", "java.").split(",");

        public OpenEJBAnnotationFinder(Archive archive) {
            super(archive);
        }

        protected boolean isJvm(String name) {
            return OpenEJBAnnotationFinder.sharedIsJvm(name);
        }

        public static boolean sharedIsJvm(String name) {
            for (String s : JVM_SCANNING_CONFIG) {
                if (!name.startsWith(s)) continue;
                return true;
            }
            return false;
        }

        public boolean foundSomething() {
            return !this.classInfos.isEmpty();
        }
    }

    public static class ModuleLimitedFinder
    implements IAnnotationFinder {
        private final OpenEJBAnnotationFinder delegate;

        public ModuleLimitedFinder(OpenEJBAnnotationFinder delegate) {
            this.delegate = delegate;
        }

        public boolean isAnnotationPresent(Class<? extends Annotation> annotation) {
            return this.delegate.isAnnotationPresent(annotation);
        }

        public List<String> getClassesNotLoaded() {
            return this.delegate.getClassesNotLoaded();
        }

        public List<Package> findAnnotatedPackages(Class<? extends Annotation> annotation) {
            return this.delegate.findAnnotatedPackages(annotation);
        }

        public List<Class<?>> findAnnotatedClasses(Class<? extends Annotation> annotation) {
            try {
                return ModuleLimitedFinder.filter(this.delegate.findAnnotatedClasses(annotation), new ClassPredicate(this.getAnnotatedClassNames()));
            }
            catch (TypeNotPresentException tnpe) {
                throw this.handleException(tnpe, annotation);
            }
        }

        private RuntimeException handleException(TypeNotPresentException tnpe, Class<? extends Annotation> annotation) {
            try {
                Method mtd = AnnotationFinder.class.getDeclaredMethod("getAnnotationInfos", String.class);
                mtd.setAccessible(true);
                List infos = (List)mtd.invoke((Object)this.delegate, new Object[0]);
                for (Object info : infos) {
                    if (!(info instanceof AnnotationFinder.ClassInfo)) continue;
                    AnnotationFinder.ClassInfo classInfo = (AnnotationFinder.ClassInfo)info;
                    try {
                        classInfo.get().isAnnotationPresent(annotation);
                    }
                    catch (TypeNotPresentException tnpe2) {
                        throw new OpenEJBRuntimeException("Missing type for annotation " + annotation.getName() + " on class " + classInfo.getName(), tnpe2);
                    }
                    catch (ThreadDeath threadDeath) {
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return tnpe;
        }

        public List<Class<?>> findInheritedAnnotatedClasses(Class<? extends Annotation> annotation) {
            return ModuleLimitedFinder.filter(this.delegate.findInheritedAnnotatedClasses(annotation), new ClassPredicate(this.getAnnotatedClassNames()));
        }

        public List<Method> findAnnotatedMethods(Class<? extends Annotation> annotation) {
            return ModuleLimitedFinder.filter(this.delegate.findAnnotatedMethods(annotation), new MethodPredicate(this.getAnnotatedClassNames()));
        }

        public List<Constructor> findAnnotatedConstructors(Class<? extends Annotation> annotation) {
            return ModuleLimitedFinder.filter(this.delegate.findAnnotatedConstructors(annotation), new ConstructorPredicate(this.getAnnotatedClassNames()));
        }

        public List<Field> findAnnotatedFields(Class<? extends Annotation> annotation) {
            return ModuleLimitedFinder.filter(this.delegate.findAnnotatedFields(annotation), new FieldPredicate(this.getAnnotatedClassNames()));
        }

        public List<Class<?>> findClassesInPackage(String packageName, boolean recursive) {
            return ModuleLimitedFinder.filter(this.delegate.findClassesInPackage(packageName, recursive), new ClassPredicate(this.getAnnotatedClassNames()));
        }

        public <T> List<Class<? extends T>> findSubclasses(Class<T> clazz) {
            return ModuleLimitedFinder.filter(this.delegate.findSubclasses(clazz), new ClassPredicate(this.getAnnotatedClassNames()));
        }

        public <T> List<Class<? extends T>> findImplementations(Class<T> clazz) {
            return ModuleLimitedFinder.filter(this.delegate.findImplementations(clazz), new ClassPredicate(this.getAnnotatedClassNames()));
        }

        public List<Annotated<Method>> findMetaAnnotatedMethods(Class<? extends Annotation> annotation) {
            return ModuleLimitedFinder.filter(this.delegate.findMetaAnnotatedMethods(annotation), new AnnotatedMethodPredicate(this.getAnnotatedClassNames()));
        }

        public List<Annotated<Field>> findMetaAnnotatedFields(Class<? extends Annotation> annotation) {
            return ModuleLimitedFinder.filter(this.delegate.findMetaAnnotatedFields(annotation), new AnnotatedFieldPredicate(this.getAnnotatedClassNames()));
        }

        public List<Annotated<Class<?>>> findMetaAnnotatedClasses(Class<? extends Annotation> annotation) {
            try {
                return ModuleLimitedFinder.filter(this.delegate.findMetaAnnotatedClasses(annotation), new AnnotatedClassPredicate(this.getAnnotatedClassNames()));
            }
            catch (TypeNotPresentException tnpe) {
                throw this.handleException(tnpe, annotation);
            }
        }

        public List<String> getAnnotatedClassNames() {
            return this.delegate.getAnnotatedClassNames();
        }

        private static <T> List<T> filter(List<T> list, Predicate<T> predicate) {
            ArrayList<T> ts = new ArrayList<T>();
            for (T t : list) {
                if (!predicate.accept(t)) continue;
                ts.add(t);
            }
            return ts;
        }

        public IAnnotationFinder getDelegate() {
            return this.delegate;
        }

        private static class AnnotatedFieldPredicate
        extends Predicate<Annotated<Field>> {
            public AnnotatedFieldPredicate(List<String> list) {
                super(list);
            }

            @Override
            protected String name(Annotated<Field> field) {
                return ((Field)field.get()).getDeclaringClass().getName();
            }
        }

        private static class AnnotatedMethodPredicate
        extends Predicate<Annotated<Method>> {
            public AnnotatedMethodPredicate(List<String> list) {
                super(list);
            }

            @Override
            protected String name(Annotated<Method> method) {
                return ((Method)method.get()).getDeclaringClass().getName();
            }
        }

        private static class AnnotatedClassPredicate
        extends Predicate<Annotated<Class<?>>> {
            public AnnotatedClassPredicate(List<String> list) {
                super(list);
            }

            @Override
            protected String name(Annotated<Class<?>> aClass) {
                return ((Class)aClass.get()).getName();
            }
        }

        private static class ConstructorPredicate
        extends Predicate<Constructor> {
            public ConstructorPredicate(List<String> list) {
                super(list);
            }

            @Override
            protected String name(Constructor constructor) {
                return constructor.getDeclaringClass().getName();
            }
        }

        private static class FieldPredicate
        extends Predicate<Field> {
            public FieldPredicate(List<String> list) {
                super(list);
            }

            @Override
            protected String name(Field field) {
                return field.getDeclaringClass().getName();
            }
        }

        private static class MethodPredicate
        extends Predicate<Method> {
            public MethodPredicate(List<String> list) {
                super(list);
            }

            @Override
            protected String name(Method method) {
                return method.getDeclaringClass().getName();
            }
        }

        private static class ClassPredicate<T>
        extends Predicate<Class<? extends T>> {
            public ClassPredicate(List<String> list) {
                super(list);
            }

            @Override
            protected String name(Class<? extends T> aClass) {
                return aClass.getName();
            }
        }

        private static abstract class Predicate<T> {
            protected final List<String> accepted;

            public Predicate(List<String> list) {
                this.accepted = list;
            }

            protected boolean accept(T t) {
                return this.accepted.contains(this.name(t));
            }

            protected abstract String name(T var1);
        }
    }

    public static final class DebugArchive
    implements Archive {
        private final Archive archive;

        private DebugArchive(Archive archive) {
            this.archive = archive;
        }

        public Iterator<Archive.Entry> iterator() {
            return this.archive.iterator();
        }

        public InputStream getBytecode(String s) throws IOException, ClassNotFoundException {
            return this.archive.getBytecode(s);
        }

        public Class<?> loadClass(String s) throws ClassNotFoundException {
            try {
                return this.archive.loadClass(s);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw e;
            }
        }
    }
}

