/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ClientModule;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.jee.ApplicationClient;
import org.apache.openejb.jee.CmpField;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.EjbRef;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.EntityBean;
import org.apache.openejb.jee.JndiReference;
import org.apache.openejb.jee.PersistenceType;
import org.apache.openejb.jee.PortComponent;
import org.apache.openejb.jee.PortComponentRef;
import org.apache.openejb.jee.ServiceImplBean;
import org.apache.openejb.jee.ServiceRef;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.jpa.AttributeOverride;
import org.apache.openejb.jee.jpa.Attributes;
import org.apache.openejb.jee.jpa.Basic;
import org.apache.openejb.jee.jpa.Column;
import org.apache.openejb.jee.jpa.Entity;
import org.apache.openejb.jee.jpa.EntityMappings;
import org.apache.openejb.jee.jpa.Field;
import org.apache.openejb.jee.jpa.Id;
import org.apache.openejb.jee.jpa.JoinColumn;
import org.apache.openejb.jee.jpa.JoinTable;
import org.apache.openejb.jee.jpa.ManyToOne;
import org.apache.openejb.jee.jpa.NamedQuery;
import org.apache.openejb.jee.jpa.OneToMany;
import org.apache.openejb.jee.jpa.OneToOne;
import org.apache.openejb.jee.jpa.PrimaryKeyJoinColumn;
import org.apache.openejb.jee.jpa.RelationField;
import org.apache.openejb.jee.jpa.Table;
import org.apache.openejb.jee.oejb3.EjbDeployment;
import org.apache.openejb.jee.oejb3.EjbLink;
import org.apache.openejb.jee.oejb3.OpenejbJar;
import org.apache.openejb.jee.oejb3.ResourceLink;
import org.apache.openejb.jee.sun.Cmp;
import org.apache.openejb.jee.sun.CmpFieldMapping;
import org.apache.openejb.jee.sun.CmrFieldMapping;
import org.apache.openejb.jee.sun.ColumnName;
import org.apache.openejb.jee.sun.ColumnPair;
import org.apache.openejb.jee.sun.Ejb;
import org.apache.openejb.jee.sun.EntityMapping;
import org.apache.openejb.jee.sun.Finder;
import org.apache.openejb.jee.sun.JaxbSun;
import org.apache.openejb.jee.sun.MessageDestination;
import org.apache.openejb.jee.sun.MessageDestinationRef;
import org.apache.openejb.jee.sun.OneOneFinders;
import org.apache.openejb.jee.sun.PortInfo;
import org.apache.openejb.jee.sun.ResourceEnvRef;
import org.apache.openejb.jee.sun.ResourceRef;
import org.apache.openejb.jee.sun.SecondaryTable;
import org.apache.openejb.jee.sun.StubProperty;
import org.apache.openejb.jee.sun.SunApplication;
import org.apache.openejb.jee.sun.SunApplicationClient;
import org.apache.openejb.jee.sun.SunCmpMapping;
import org.apache.openejb.jee.sun.SunCmpMappings;
import org.apache.openejb.jee.sun.SunEjbJar;
import org.apache.openejb.jee.sun.SunWebApp;
import org.apache.openejb.jee.sun.Web;
import org.apache.openejb.jee.sun.WebserviceDescription;
import org.apache.openejb.jee.sun.WebserviceEndpoint;
import org.apache.openejb.jee.sun.WsdlPort;
import org.apache.openejb.loader.IO;

public class SunConversion
implements DynamicDeployer {
    @Override
    public AppModule deploy(AppModule appModule) {
        SunApplication sunApplication = this.getSunApplication(appModule);
        if (sunApplication != null) {
            block0: for (Web web : sunApplication.getWeb()) {
                String webUri = web.getWebUri();
                for (WebModule webModule : appModule.getWebModules()) {
                    if (!webUri.equals(webModule.getModuleId())) continue;
                    webModule.setContextRoot(web.getContextRoot());
                    continue block0;
                }
            }
            for (ClientModule clientModule : appModule.getClientModules()) {
                JndiReference resEnvRef;
                String refName;
                Object ref22;
                ApplicationClient applicationClient = clientModule.getApplicationClient();
                if (applicationClient == null) continue;
                Map refMap = applicationClient.getEjbRefMap();
                for (Object ref22 : sunApplication.getEjbRef()) {
                    if (ref22.getJndiName() == null) continue;
                    String refName2 = ref22.getEjbRefName();
                    refName2 = this.normalize(refName2);
                    EjbRef ejbRef = (EjbRef)refMap.get(refName2);
                    for (Map.Entry aRef : refMap.entrySet()) {
                        if (!refName2.equals(((EjbRef)aRef.getValue()).getLookupName())) continue;
                        ejbRef = (EjbRef)aRef.getValue();
                        break;
                    }
                    if (ejbRef == null) {
                        ejbRef = new EjbRef();
                        ejbRef.setEjbRefName(refName2);
                        refMap.put(refName2, ejbRef);
                        applicationClient.getEjbRef().add(ejbRef);
                    }
                    ejbRef.setMappedName(ref22.getJndiName());
                }
                TreeMap treeMap = new TreeMap();
                treeMap.putAll(applicationClient.getResourceEnvRefMap());
                treeMap.putAll(applicationClient.getMessageDestinationRefMap());
                for (ResourceRef ref3 : sunApplication.getResourceRef()) {
                    if (ref3.getJndiName() == null) continue;
                    refName = ref3.getResRefName();
                    resEnvRef = (JndiReference)treeMap.get(refName = this.normalize(refName));
                    if (resEnvRef == null) continue;
                    resEnvRef.setMappedName(ref3.getJndiName());
                }
                for (ResourceEnvRef ref : sunApplication.getResourceEnvRef()) {
                    if (ref.getJndiName() == null) continue;
                    refName = ref.getResourceEnvRefName();
                    resEnvRef = (JndiReference)treeMap.get(refName = this.normalize(refName));
                    if (resEnvRef == null) continue;
                    resEnvRef.setMappedName(ref.getJndiName());
                }
                for (ResourceEnvRef ref : sunApplication.getMessageDestinationRef()) {
                    if (ref.getJndiName() == null) continue;
                    refName = ref.getMessageDestinationRefName();
                    resEnvRef = (JndiReference)treeMap.get(refName = this.normalize(refName));
                    if (resEnvRef == null) continue;
                    resEnvRef.setMappedName(ref.getJndiName());
                }
                ref22 = sunApplication.getMessageDestination().iterator();
                while (ref22.hasNext()) {
                    MessageDestination destination = (MessageDestination)ref22.next();
                    if (destination.getJndiName() == null) continue;
                    String name = destination.getMessageDestinationName();
                    JndiReference ref4 = (JndiReference)treeMap.get(name = this.normalize(name));
                    if (ref4 == null) continue;
                    ref4.setMappedName(destination.getJndiName());
                }
                Map serviceRefMap = applicationClient.getServiceRefMap();
                for (org.apache.openejb.jee.sun.ServiceRef ref5 : sunApplication.getServiceRef()) {
                    String refName3 = ref5.getServiceRefName();
                    ServiceRef serviceRef = (ServiceRef)serviceRefMap.get(refName3 = this.normalize(refName3));
                    if (serviceRef == null) continue;
                    TreeMap<String, PortComponentRef> ports = new TreeMap<String, PortComponentRef>();
                    for (PortComponentRef portComponentRef : serviceRef.getPortComponentRef()) {
                        ports.put(portComponentRef.getServiceEndpointInterface(), portComponentRef);
                    }
                    for (PortInfo portInfo : ref5.getPortInfo()) {
                        PortComponentRef portComponentRef = (PortComponentRef)ports.get(portInfo.getServiceEndpointInterface());
                        if (portComponentRef == null) continue;
                        WsdlPort wsdlPort = portInfo.getWsdlPort();
                        if (wsdlPort != null) {
                            QName qname = new QName(wsdlPort.getNamespaceURI(), wsdlPort.getLocalpart());
                            portComponentRef.setQName(qname);
                        }
                        for (StubProperty stubProperty : portInfo.getStubProperty()) {
                            String name = stubProperty.getName();
                            String value = stubProperty.getValue();
                            portComponentRef.getProperties().setProperty(name, value);
                        }
                    }
                    String wsdlOverride = ref5.getWsdlOverride();
                    if (wsdlOverride == null || wsdlOverride.length() <= 0) continue;
                    String serviceId = SunConversion.extractServiceId(wsdlOverride);
                    serviceRef.setMappedName(serviceId);
                }
            }
        }
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            this.convertModule(ejbModule, appModule.getCmpMappings());
        }
        for (ClientModule clientModule : appModule.getClientModules()) {
            this.convertModule(clientModule);
        }
        for (WebModule webModule : appModule.getWebModules()) {
            this.convertModule(webModule);
        }
        return appModule;
    }

    private SunApplication getSunApplication(AppModule appModule) {
        Object altDD = appModule.getAltDDs().get("sun-application.xml");
        if (altDD instanceof String) {
            try {
                altDD = JaxbSun.unmarshal(SunApplication.class, (InputStream)new ByteArrayInputStream(((String)altDD).getBytes()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (altDD instanceof URL) {
            try {
                altDD = JaxbSun.unmarshal(SunApplication.class, (InputStream)IO.read((URL)((URL)altDD)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (altDD instanceof SunApplication) {
            return (SunApplication)altDD;
        }
        return null;
    }

    private SunApplicationClient getSunApplicationClient(ClientModule clientModule) {
        Object altDD = clientModule.getAltDDs().get("sun-application-client.xml");
        if (altDD instanceof String) {
            try {
                altDD = JaxbSun.unmarshal(SunApplicationClient.class, (InputStream)new ByteArrayInputStream(((String)altDD).getBytes()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (altDD instanceof URL) {
            try {
                altDD = JaxbSun.unmarshal(SunApplicationClient.class, (InputStream)IO.read((URL)((URL)altDD)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (altDD instanceof SunApplicationClient) {
            return (SunApplicationClient)altDD;
        }
        return null;
    }

    private SunWebApp getSunWebApp(WebModule webModule) {
        Object altDD = webModule.getAltDDs().get("sun-web.xml");
        if (altDD instanceof String) {
            try {
                altDD = JaxbSun.unmarshal(SunWebApp.class, (InputStream)new ByteArrayInputStream(((String)altDD).getBytes()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (altDD instanceof URL) {
            try {
                altDD = JaxbSun.unmarshal(SunWebApp.class, (InputStream)IO.read((URL)((URL)altDD)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (altDD instanceof SunWebApp) {
            return (SunWebApp)altDD;
        }
        return null;
    }

    private SunEjbJar getSunEjbJar(EjbModule ejbModule) {
        Object altDD = ejbModule.getAltDDs().get("sun-ejb-jar.xml");
        if (altDD instanceof String) {
            try {
                altDD = JaxbSun.unmarshal(SunCmpMappings.class, (InputStream)new ByteArrayInputStream(((String)altDD).getBytes()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (altDD instanceof URL) {
            try {
                altDD = JaxbSun.unmarshal(SunEjbJar.class, (InputStream)IO.read((URL)((URL)altDD)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (altDD instanceof SunEjbJar) {
            return (SunEjbJar)altDD;
        }
        return null;
    }

    private SunCmpMappings getSunCmpMappings(EjbModule ejbModule) {
        Object altDD = ejbModule.getAltDDs().get("sun-cmp-mappings.xml");
        if (altDD instanceof String) {
            try {
                altDD = JaxbSun.unmarshal(SunCmpMappings.class, (InputStream)new ByteArrayInputStream(((String)altDD).getBytes()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (altDD instanceof URL) {
            try {
                altDD = JaxbSun.unmarshal(SunCmpMappings.class, (InputStream)IO.read((URL)((URL)altDD)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (altDD instanceof SunCmpMappings) {
            return (SunCmpMappings)altDD;
        }
        return null;
    }

    public void convertModule(ClientModule clientModule) {
        JndiReference resEnvRef;
        String refName;
        if (clientModule == null) {
            return;
        }
        ApplicationClient applicationClient = clientModule.getApplicationClient();
        if (applicationClient == null) {
            return;
        }
        SunApplicationClient sunApplicationClient = this.getSunApplicationClient(clientModule);
        if (sunApplicationClient == null) {
            return;
        }
        Map refMap = applicationClient.getEjbRefMap();
        for (Object ref : sunApplicationClient.getEjbRef()) {
            if (ref.getJndiName() == null) continue;
            String refName2 = ref.getEjbRefName();
            EjbRef ejbRef = (EjbRef)refMap.get(refName2 = this.normalize(refName2));
            if (ejbRef == null) {
                ejbRef = new EjbRef();
                ejbRef.setEjbRefName(refName2);
                refMap.put(refName2, ejbRef);
                applicationClient.getEjbRef().add(ejbRef);
            }
            ejbRef.setMappedName(ref.getJndiName());
        }
        TreeMap resEnvMap = new TreeMap();
        resEnvMap.putAll(applicationClient.getResourceEnvRefMap());
        resEnvMap.putAll(applicationClient.getMessageDestinationRefMap());
        for (ResourceRef ref : sunApplicationClient.getResourceRef()) {
            if (ref.getJndiName() == null) continue;
            refName = ref.getResRefName();
            resEnvRef = (JndiReference)resEnvMap.get(refName = this.normalize(refName));
            if (resEnvRef == null) continue;
            resEnvRef.setMappedName(ref.getJndiName());
        }
        for (ResourceRef ref : sunApplicationClient.getResourceEnvRef()) {
            if (ref.getJndiName() == null) continue;
            refName = ref.getResourceEnvRefName();
            resEnvRef = (JndiReference)resEnvMap.get(refName = this.normalize(refName));
            if (resEnvRef == null) continue;
            resEnvRef.setMappedName(ref.getJndiName());
        }
        for (ResourceRef ref : sunApplicationClient.getMessageDestinationRef()) {
            if (ref.getJndiName() == null) continue;
            refName = ref.getMessageDestinationRefName();
            resEnvRef = (JndiReference)resEnvMap.get(refName = this.normalize(refName));
            if (resEnvRef == null) continue;
            resEnvRef.setMappedName(ref.getJndiName());
        }
        Map serviceRefMap = applicationClient.getServiceRefMap();
        for (org.apache.openejb.jee.sun.ServiceRef ref : sunApplicationClient.getServiceRef()) {
            String refName3 = ref.getServiceRefName();
            ServiceRef serviceRef = (ServiceRef)serviceRefMap.get(refName3 = this.normalize(refName3));
            if (serviceRef == null) continue;
            TreeMap<String, PortComponentRef> ports = new TreeMap<String, PortComponentRef>();
            for (PortComponentRef portComponentRef : serviceRef.getPortComponentRef()) {
                ports.put(portComponentRef.getServiceEndpointInterface(), portComponentRef);
            }
            for (PortInfo portInfo : ref.getPortInfo()) {
                PortComponentRef portComponentRef = (PortComponentRef)ports.get(portInfo.getServiceEndpointInterface());
                if (portComponentRef == null) continue;
                WsdlPort wsdlPort = portInfo.getWsdlPort();
                if (wsdlPort != null) {
                    QName qname = new QName(wsdlPort.getNamespaceURI(), wsdlPort.getLocalpart());
                    portComponentRef.setQName(qname);
                }
                for (StubProperty stubProperty : portInfo.getStubProperty()) {
                    String name = stubProperty.getName();
                    String value = stubProperty.getValue();
                    portComponentRef.getProperties().setProperty(name, value);
                }
            }
            String wsdlOverride = ref.getWsdlOverride();
            if (wsdlOverride == null || wsdlOverride.length() <= 0) continue;
            String serviceId = SunConversion.extractServiceId(wsdlOverride);
            serviceRef.setMappedName(serviceId);
        }
    }

    private String normalize(String refName) {
        if (!((String)refName).startsWith("java:")) {
            refName = "java:comp/env/" + (String)refName;
        }
        return ((String)refName).startsWith("java:/") ? "java:" + ((String)refName).substring("java:/".length()) : refName;
    }

    public void convertModule(WebModule webModule) {
        JndiReference resEnvRef;
        String refName;
        if (webModule == null) {
            return;
        }
        WebApp webApp = webModule.getWebApp();
        if (webApp == null) {
            return;
        }
        SunWebApp sunWebApp = this.getSunWebApp(webModule);
        if (sunWebApp == null) {
            return;
        }
        if (sunWebApp.getContextRoot() != null) {
            webModule.setContextRoot(sunWebApp.getContextRoot());
        }
        TreeMap<String, JndiReference> refMap = new TreeMap<String, JndiReference>();
        refMap.putAll(webApp.getEjbRefMap());
        refMap.putAll(webApp.getEjbLocalRefMap());
        for (Object ref : sunWebApp.getEjbRef()) {
            if (ref.getJndiName() == null) continue;
            String refName2 = ref.getEjbRefName();
            JndiReference ejbRef = (JndiReference)refMap.get(refName2);
            if (ejbRef == null) {
                ejbRef = new EjbRef();
                ejbRef.setName(refName2);
                refMap.put(refName2, ejbRef);
                webApp.getEjbRef().add((EjbRef)ejbRef);
            }
            ejbRef.setMappedName(ref.getJndiName());
        }
        TreeMap resEnvMap = new TreeMap();
        resEnvMap.putAll(webApp.getResourceRefMap());
        resEnvMap.putAll(webApp.getResourceEnvRefMap());
        resEnvMap.putAll(webApp.getMessageDestinationRefMap());
        for (Object ref : sunWebApp.getResourceRef()) {
            if (ref.getJndiName() == null) continue;
            refName = ref.getResRefName();
            resEnvRef = (JndiReference)resEnvMap.get(refName = this.normalize(refName));
            if (resEnvRef == null) continue;
            resEnvRef.setMappedName(ref.getJndiName());
        }
        for (Object ref : sunWebApp.getResourceEnvRef()) {
            if (ref.getJndiName() == null) continue;
            refName = ref.getResourceEnvRefName();
            resEnvRef = (JndiReference)resEnvMap.get(refName = this.normalize(refName));
            if (resEnvRef == null) continue;
            resEnvRef.setMappedName(ref.getJndiName());
        }
        for (Object ref : sunWebApp.getMessageDestinationRef()) {
            if (ref.getJndiName() == null) continue;
            refName = ref.getMessageDestinationRefName();
            resEnvRef = (JndiReference)resEnvMap.get(refName = this.normalize(refName));
            if (resEnvRef == null) continue;
            resEnvRef.setMappedName(ref.getJndiName());
        }
        Map serviceRefMap = webApp.getServiceRefMap();
        for (org.apache.openejb.jee.sun.ServiceRef ref : sunWebApp.getServiceRef()) {
            String refName3 = ref.getServiceRefName();
            ServiceRef serviceRef = (ServiceRef)serviceRefMap.get(refName3 = this.normalize(refName3));
            if (serviceRef == null) continue;
            TreeMap<String, PortComponentRef> ports = new TreeMap<String, PortComponentRef>();
            for (PortComponentRef portComponentRef : serviceRef.getPortComponentRef()) {
                ports.put(portComponentRef.getServiceEndpointInterface(), portComponentRef);
            }
            for (PortInfo portInfo : ref.getPortInfo()) {
                PortComponentRef portComponentRef = (PortComponentRef)ports.get(portInfo.getServiceEndpointInterface());
                if (portComponentRef == null) continue;
                WsdlPort wsdlPort = portInfo.getWsdlPort();
                if (wsdlPort != null) {
                    QName qname = new QName(wsdlPort.getNamespaceURI(), wsdlPort.getLocalpart());
                    portComponentRef.setQName(qname);
                }
                for (StubProperty stubProperty : portInfo.getStubProperty()) {
                    String name = stubProperty.getName();
                    String value = stubProperty.getValue();
                    portComponentRef.getProperties().setProperty(name, value);
                }
            }
            String wsdlOverride = ref.getWsdlOverride();
            if (wsdlOverride == null || wsdlOverride.length() <= 0) continue;
            String serviceId = SunConversion.extractServiceId(wsdlOverride);
            serviceRef.setMappedName(serviceId);
        }
        if (webModule.getWebservices() != null) {
            Map descriptions = webModule.getWebservices().getWebserviceDescriptionMap();
            for (WebserviceDescription sunDescription : sunWebApp.getWebserviceDescription()) {
                String serviceId;
                org.apache.openejb.jee.WebserviceDescription description = (org.apache.openejb.jee.WebserviceDescription)descriptions.get(sunDescription.getWebserviceDescriptionName());
                if (description == null || (serviceId = SunConversion.extractSerivceId(sunDescription.getWsdlPublishLocation(), description.getWsdlFile())) == null) continue;
                description.setId(serviceId);
            }
        }
    }

    public static String extractServiceId(String location) {
        return SunConversion.extractSerivceId(location, null);
    }

    public static String extractSerivceId(String location, String wsdlFile) {
        if (location == null) {
            return null;
        }
        if (((String)location).startsWith("file:")) {
            location = ((String)location).replaceFirst("file:[^/]*/", "");
            if (wsdlFile != null) {
                wsdlFile = wsdlFile.replaceFirst("META-INF/wsdl/", "");
                wsdlFile = wsdlFile.replaceFirst("WEB-INF/wsdl/", "");
                location = (String)location + "/" + wsdlFile;
            }
            location = ((String)location).replaceFirst("\\.wsdl$", "");
        } else if (((String)location).startsWith("http:") || ((String)location).startsWith("https:")) {
            location = ((String)location).replaceFirst("http[s]?://[^/]*/", "");
            location = ((String)location).replaceFirst("\\?.*$", "");
        }
        if (((String)location).length() == 0) {
            location = null;
        }
        return location;
    }

    public void convertModule(EjbModule ejbModule, EntityMappings entityMappings) {
        TreeMap<String, EntityData> entities = new TreeMap<String, EntityData>();
        if (entityMappings != null) {
            for (Entity entity : entityMappings.getEntity()) {
                entities.put(entity.getDescription(), new EntityData(entity));
            }
        }
        SunEjbJar sunEjbJar = this.getSunEjbJar(ejbModule);
        this.mergeEjbConfig(ejbModule, sunEjbJar);
        this.mergeEntityMappings(entities, ejbModule.getModuleId(), ejbModule.getEjbJar(), ejbModule.getOpenejbJar(), sunEjbJar);
        SunCmpMappings sunCmpMappings = this.getSunCmpMappings(ejbModule);
        if (sunCmpMappings != null) {
            for (SunCmpMapping sunCmpMapping : sunCmpMappings.getSunCmpMapping()) {
                this.mergeEntityMappings(entities, ejbModule.getModuleId(), ejbModule, entityMappings, sunCmpMapping);
            }
        }
    }

    private void mergeEjbConfig(EjbModule ejbModule, SunEjbJar sunEjbJar) {
        EjbJar ejbJar = ejbModule.getEjbJar();
        OpenejbJar openejbJar = ejbModule.getOpenejbJar();
        if (openejbJar == null) {
            return;
        }
        if (sunEjbJar == null) {
            return;
        }
        if (sunEjbJar.getEnterpriseBeans() == null) {
            return;
        }
        HashMap<String, Map> endpointMap = new HashMap<String, Map>();
        for (Ejb ejb : sunEjbJar.getEnterpriseBeans().getEjb()) {
            ResourceLink link;
            Object refName;
            Object ref2;
            EjbDeployment deployment = (EjbDeployment)openejbJar.getDeploymentsByEjbName().get(ejb.getEjbName());
            if (deployment == null) continue;
            if (ejb.getJndiName() != null) {
                deployment.setDeploymentId(ejb.getJndiName());
            }
            Map linksMap = deployment.getEjbLinksMap();
            for (Object ref2 : ejb.getEjbRef()) {
                if (ref2.getJndiName() == null) continue;
                String refName2 = ref2.getEjbRefName();
                EjbLink link2 = (EjbLink)linksMap.get(refName2 = this.normalize(refName2));
                if (link2 == null) {
                    link2 = new EjbLink();
                    link2.setEjbRefName(refName2);
                    linksMap.put(refName2, link2);
                    deployment.getEjbLink().add(link2);
                }
                link2.setDeployentId(ref2.getJndiName());
            }
            Map resourceLinksMap = deployment.getResourceLinksMap();
            for (ResourceRef ref3 : ejb.getResourceRef()) {
                if (ref3.getJndiName() == null) continue;
                refName = ref3.getResRefName();
                link = (ResourceLink)resourceLinksMap.get(refName = this.normalize((String)refName));
                if (link == null) {
                    link = new ResourceLink();
                    link.setResRefName((String)refName);
                    resourceLinksMap.put(refName, link);
                    deployment.getResourceLink().add(link);
                }
                link.setResId(ref3.getJndiName());
            }
            for (ResourceRef ref3 : ejb.getResourceEnvRef()) {
                if (ref3.getJndiName() == null) continue;
                refName = ref3.getResourceEnvRefName();
                link = (ResourceLink)resourceLinksMap.get(refName = this.normalize((String)refName));
                if (link == null) {
                    link = new ResourceLink();
                    link.setResRefName((String)refName);
                    resourceLinksMap.put(refName, link);
                    deployment.getResourceLink().add(link);
                }
                link.setResId(ref3.getJndiName());
            }
            ref2 = ejb.getMessageDestinationRef().iterator();
            while (ref2.hasNext()) {
                ResourceRef ref3;
                ref3 = (MessageDestinationRef)ref2.next();
                if (ref3.getJndiName() == null) continue;
                refName = ref3.getMessageDestinationRefName();
                link = (ResourceLink)resourceLinksMap.get(refName = this.normalize((String)refName));
                if (link == null) {
                    link = new ResourceLink();
                    link.setResRefName((String)refName);
                    resourceLinksMap.put(refName, link);
                    deployment.getResourceLink().add(link);
                }
                link.setResId(ref3.getJndiName());
            }
            EnterpriseBean bean = (EnterpriseBean)ejbJar.getEnterpriseBeansByEjbName().get(ejb.getEjbName());
            if (bean != null) {
                Map serviceRefMap = bean.getServiceRefMap();
                for (org.apache.openejb.jee.sun.ServiceRef ref4 : ejb.getServiceRef()) {
                    String refName3 = ref4.getServiceRefName();
                    ServiceRef serviceRef = (ServiceRef)serviceRefMap.get(refName3 = this.normalize(refName3));
                    if (serviceRef == null) continue;
                    TreeMap<String, PortComponentRef> ports = new TreeMap<String, PortComponentRef>();
                    for (PortComponentRef portComponentRef : serviceRef.getPortComponentRef()) {
                        ports.put(portComponentRef.getServiceEndpointInterface(), portComponentRef);
                    }
                    for (PortInfo portInfo : ref4.getPortInfo()) {
                        PortComponentRef portComponentRef = (PortComponentRef)ports.get(portInfo.getServiceEndpointInterface());
                        if (portComponentRef == null) continue;
                        WsdlPort wsdlPort = portInfo.getWsdlPort();
                        if (wsdlPort != null) {
                            QName qname = new QName(wsdlPort.getNamespaceURI(), wsdlPort.getLocalpart());
                            portComponentRef.setQName(qname);
                        }
                        for (StubProperty stubProperty : portInfo.getStubProperty()) {
                            String name = stubProperty.getName();
                            String value = stubProperty.getValue();
                            portComponentRef.getProperties().setProperty(name, value);
                        }
                    }
                    String wsdlOverride = ref4.getWsdlOverride();
                    if (wsdlOverride == null || wsdlOverride.length() <= 0) continue;
                    String serviceId = SunConversion.extractServiceId(wsdlOverride);
                    serviceRef.setMappedName(serviceId);
                }
            }
            if (ejb.getMdbResourceAdapter() != null) {
                String resourceAdapterId = ejb.getMdbResourceAdapter().getResourceAdapterMid();
                deployment.setContainerId(resourceAdapterId);
            }
            endpointMap.put(ejb.getEjbName(), ejb.getWebserviceEndpointMap());
        }
        if (ejbModule.getWebservices() != null) {
            Map sunDescriptions = sunEjbJar.getEnterpriseBeans().getWebserviceDescriptionMap();
            for (org.apache.openejb.jee.WebserviceDescription description : ejbModule.getWebservices().getWebserviceDescription()) {
                WebserviceDescription sunDescription = (WebserviceDescription)sunDescriptions.get(description.getWebserviceDescriptionName());
                String serviceId = null;
                if (sunDescription != null) {
                    serviceId = SunConversion.extractSerivceId(sunDescription.getWsdlPublishLocation(), description.getWsdlFile());
                }
                if (serviceId != null) {
                    description.setId(serviceId);
                }
                for (PortComponent port : description.getPortComponent()) {
                    WebserviceEndpoint endpoint;
                    Map endpoints;
                    ServiceImplBean bean = port.getServiceImplBean();
                    if (bean == null || bean.getEjbLink() == null || (endpoints = (Map)endpointMap.get(bean.getEjbLink())) == null || (endpoint = (WebserviceEndpoint)endpoints.get(port.getPortComponentName())) == null || endpoint.getEndpointAddressUri() == null) continue;
                    port.setLocation(endpoint.getEndpointAddressUri());
                }
            }
        }
    }

    private void mergeEntityMappings(Map<String, EntityData> entities, String moduleId, EjbJar ejbJar, OpenejbJar openejbJar, SunEjbJar sunEjbJar) {
        if (openejbJar == null) {
            return;
        }
        if (sunEjbJar == null) {
            return;
        }
        if (sunEjbJar.getEnterpriseBeans() == null) {
            return;
        }
        for (Ejb ejb : sunEjbJar.getEnterpriseBeans().getEjb()) {
            EnterpriseBean enterpriseBean;
            Cmp cmp = ejb.getCmp();
            if (cmp == null || !((enterpriseBean = ejbJar.getEnterpriseBean(ejb.getEjbName())) instanceof EntityBean) || ((EntityBean)enterpriseBean).getPersistenceType() != PersistenceType.CONTAINER) continue;
            EntityBean bean = (EntityBean)enterpriseBean;
            EntityData entityData = entities.get(moduleId + "#" + ejb.getEjbName());
            if (entityData == null) continue;
            ArrayList<String> cmpFields = new ArrayList<String>(bean.getCmpField().size());
            for (CmpField cmpField : bean.getCmpField()) {
                cmpFields.add(cmpField.getFieldName());
            }
            OneOneFinders oneOneFinders = cmp.getOneOneFinders();
            if (oneOneFinders == null) continue;
            for (Finder finder : oneOneFinders.getFinder()) {
                List<List<String>> params = this.parseQueryParamters(finder.getQueryParams());
                String queryFilter = finder.getQueryFilter();
                String ejbQl = this.convertToEjbQl(entityData.entity.getName(), cmpFields, finder.getQueryParams(), queryFilter);
                NamedQuery namedQuery = new NamedQuery();
                StringBuilder name = new StringBuilder();
                name.append(entityData.entity.getName()).append(".").append(finder.getMethodName());
                if (!params.isEmpty()) {
                    name.append('(');
                    boolean first = true;
                    for (List<String> methodParam : params) {
                        if (!first) {
                            name.append(",");
                        }
                        name.append(methodParam.get(0));
                        first = false;
                    }
                    name.append(')');
                }
                namedQuery.setName(name.toString());
                namedQuery.setQuery(ejbQl);
                entityData.entity.getNamedQuery().add(namedQuery);
            }
        }
    }

    public void mergeEntityMappings(Map<String, EntityData> entities, String moduleId, EjbModule ejbModule, EntityMappings entityMappings, SunCmpMapping sunCmpMapping) {
        for (EntityMapping bean : sunCmpMapping.getEntityMapping()) {
            Field field;
            String fieldName;
            EntityData entityData = entities.get(moduleId + "#" + bean.getEjbName());
            if (entityData == null) continue;
            Table table = new Table();
            table.setName(bean.getTableName());
            entityData.entity.setTable(table);
            for (SecondaryTable sunSecondaryTable : bean.getSecondaryTable()) {
                org.apache.openejb.jee.jpa.SecondaryTable secondaryTable = new org.apache.openejb.jee.jpa.SecondaryTable();
                secondaryTable.setName(sunSecondaryTable.getTableName());
                for (ColumnPair columnPair : sunSecondaryTable.getColumnPair()) {
                    Object localColumnName = new SunColumnName((ColumnName)columnPair.getColumnName().get(0), table.getName());
                    Object referencedColumnName = new SunColumnName((ColumnName)columnPair.getColumnName().get(1), table.getName());
                    if (((SunColumnName)localColumnName).table != null) {
                        Object temp = localColumnName;
                        localColumnName = referencedColumnName;
                        referencedColumnName = temp;
                    }
                    PrimaryKeyJoinColumn primaryKeyJoinColumn = new PrimaryKeyJoinColumn();
                    primaryKeyJoinColumn.setName(((SunColumnName)localColumnName).column);
                    primaryKeyJoinColumn.setReferencedColumnName(((SunColumnName)referencedColumnName).column);
                    secondaryTable.getPrimaryKeyJoinColumn().add(primaryKeyJoinColumn);
                }
            }
            for (CmpFieldMapping cmpFieldMapping : bean.getCmpFieldMapping()) {
                fieldName = cmpFieldMapping.getFieldName();
                field = entityData.fields.get(fieldName);
                if (field == null) continue;
                boolean readOnly = cmpFieldMapping.getReadOnly() != null;
                for (ColumnName columnName : cmpFieldMapping.getColumnName()) {
                    SunColumnName sunColumnName = new SunColumnName(columnName, table.getName());
                    Column column = new Column();
                    column.setTable(sunColumnName.table);
                    column.setName(sunColumnName.column);
                    if (readOnly) {
                        column.setInsertable(Boolean.valueOf(false));
                        column.setUpdatable(Boolean.valueOf(false));
                    }
                    field.setColumn(column);
                }
            }
            for (CmrFieldMapping cmrFieldMapping : bean.getCmrFieldMapping()) {
                JoinColumn joinColumn;
                SunColumnName referencedColumnName;
                SunColumnName localColumnName;
                fieldName = cmrFieldMapping.getCmrFieldName();
                cmrFieldMapping.getColumnPair();
                field = entityData.relations.get(fieldName);
                if (field == null) continue;
                if (field instanceof OneToOne) {
                    for (ColumnPair columnPair : cmrFieldMapping.getColumnPair()) {
                        boolean isFk;
                        localColumnName = new SunColumnName((ColumnName)columnPair.getColumnName().get(0), table.getName());
                        referencedColumnName = new SunColumnName((ColumnName)columnPair.getColumnName().get(1), table.getName());
                        if (localColumnName.table != null) {
                            SunColumnName temp = localColumnName;
                            localColumnName = referencedColumnName;
                            referencedColumnName = temp;
                        }
                        if (!(isFk = !entityData.hasPkColumnMapping(localColumnName.column))) continue;
                        field.setMappedBy(null);
                        field.getRelatedField().setMappedBy(field.getName());
                        joinColumn = new JoinColumn();
                        joinColumn.setName(localColumnName.column);
                        joinColumn.setReferencedColumnName(referencedColumnName.column);
                        field.getJoinColumn().add(joinColumn);
                    }
                    continue;
                }
                if (field instanceof OneToMany) {
                    if (!field.getRelatedField().isSyntheticField()) continue;
                    for (ColumnPair columnPair : cmrFieldMapping.getColumnPair()) {
                        localColumnName = new SunColumnName((ColumnName)columnPair.getColumnName().get(0), table.getName());
                        SunColumnName otherColumnName = new SunColumnName((ColumnName)columnPair.getColumnName().get(1), table.getName());
                        if (localColumnName.table != null) {
                            SunColumnName temp = localColumnName;
                            localColumnName = otherColumnName;
                            otherColumnName = temp;
                        }
                        JoinColumn joinColumn2 = new JoinColumn();
                        joinColumn2.setName(otherColumnName.column);
                        joinColumn2.setReferencedColumnName(localColumnName.column);
                        field.getRelatedField().getJoinColumn().add(joinColumn2);
                    }
                    continue;
                }
                if (field instanceof ManyToOne) {
                    for (ColumnPair columnPair : cmrFieldMapping.getColumnPair()) {
                        localColumnName = new SunColumnName((ColumnName)columnPair.getColumnName().get(0), table.getName());
                        referencedColumnName = new SunColumnName((ColumnName)columnPair.getColumnName().get(1), table.getName());
                        if (localColumnName.table != null) {
                            SunColumnName temp = localColumnName;
                            localColumnName = referencedColumnName;
                            referencedColumnName = temp;
                        }
                        JoinColumn joinColumn3 = new JoinColumn();
                        joinColumn3.setName(localColumnName.column);
                        joinColumn3.setReferencedColumnName(referencedColumnName.column);
                        field.getJoinColumn().add(joinColumn3);
                    }
                    continue;
                }
                if (field.getMappedBy() != null) continue;
                JoinTable joinTable = new JoinTable();
                field.setJoinTable(joinTable);
                for (ColumnPair columnPair : cmrFieldMapping.getColumnPair()) {
                    SunColumnName temp;
                    SunColumnName localColumnName2 = new SunColumnName((ColumnName)columnPair.getColumnName().get(0), table.getName());
                    SunColumnName joinTableColumnName = new SunColumnName((ColumnName)columnPair.getColumnName().get(1), table.getName());
                    if (localColumnName2.table == null || joinTableColumnName.table == null) {
                        if (localColumnName2.table != null) {
                            temp = localColumnName2;
                            localColumnName2 = joinTableColumnName;
                            joinTableColumnName = temp;
                        }
                        joinTable.setName(joinTableColumnName.table);
                        joinColumn = new JoinColumn();
                        joinColumn.setName(joinTableColumnName.column);
                        joinColumn.setReferencedColumnName(localColumnName2.column);
                        joinTable.getJoinColumn().add(joinColumn);
                        continue;
                    }
                    if (localColumnName2.table.equals(joinTable.getName())) {
                        temp = localColumnName2;
                        localColumnName2 = joinTableColumnName;
                        joinTableColumnName = temp;
                    }
                    joinColumn = new JoinColumn();
                    joinColumn.setName(joinTableColumnName.column);
                    joinColumn.setReferencedColumnName(localColumnName2.column);
                    joinTable.getInverseJoinColumn().add(joinColumn);
                }
            }
        }
    }

    public String convertToEjbQl(String abstractSchemaName, String queryParams, String queryFilter) {
        return this.convertToEjbQl(abstractSchemaName, Collections.emptyList(), queryParams, queryFilter);
    }

    public String convertToEjbQl(String abstractSchemaName, Collection<String> cmpFields, String queryParams, String queryFilter) {
        List<List<String>> variableNames = this.parseQueryParamters(queryParams);
        StringBuilder ejbQl = new StringBuilder();
        ejbQl.append("SELECT OBJECT(o) FROM ").append(abstractSchemaName).append(" AS o");
        String filter = this.convertToEjbQlFilter(cmpFields, variableNames, queryFilter);
        if (filter != null) {
            ejbQl.append(" WHERE ").append(filter);
        }
        return ejbQl.toString();
    }

    private List<List<String>> parseQueryParamters(String queryParams) {
        if (queryParams == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> bits = Collections.list(new StringTokenizer(queryParams, " \t\n\r\f,", false));
        ArrayList<List<String>> params = new ArrayList<List<String>>(bits.size() / 2);
        for (int i = 0; i < bits.size(); ++i) {
            String type = this.resolveType((String)bits.get(i));
            String param = (String)bits.get(++i);
            params.add(Arrays.asList(type, param));
        }
        return params;
    }

    private String resolveType(String type) {
        try {
            ClassLoader.getSystemClassLoader().loadClass(type);
            return type;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                String javaLangType = "java.lang" + type;
                ClassLoader.getSystemClassLoader().loadClass(javaLangType);
                return javaLangType;
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return type;
            }
        }
    }

    private String convertToEjbQlFilter(Collection<String> cmpFields, List<List<String>> queryParams, String queryFilter) {
        if (queryFilter == null) {
            return null;
        }
        TreeMap<String, CallSite> variableMap = new TreeMap<String, CallSite>();
        for (String cmpField : cmpFields) {
            variableMap.put(cmpField, (CallSite)((Object)("o." + cmpField)));
        }
        for (int i = 0; i < queryParams.size(); ++i) {
            List<String> param = queryParams.get(i);
            variableMap.put(param.get(1), (CallSite)((Object)("?" + (i + 1))));
        }
        TreeMap<String, String> symbolMap = new TreeMap<String, String>();
        symbolMap.put("&&", "and");
        symbolMap.put("||", "or");
        symbolMap.put("!", "not");
        symbolMap.put("==", "=");
        symbolMap.put("!=", "<>");
        StringBuilder ejbQlFilter = new StringBuilder(queryFilter.length() * 2);
        List<String> tokens = this.tokenize(queryFilter);
        for (String token : tokens) {
            String mappedToken = (String)symbolMap.get(token);
            if (mappedToken == null) {
                mappedToken = (String)variableMap.get(token);
            }
            if (mappedToken != null) {
                ejbQlFilter.append(mappedToken);
            } else {
                ejbQlFilter.append(token);
            }
            ejbQlFilter.append(" ");
        }
        String filter = ejbQlFilter.toString().trim();
        if (filter.equalsIgnoreCase("true")) {
            return null;
        }
        return filter;
    }

    private List<String> tokenize(String queryFilter) {
        LinkedList<String> tokens = new LinkedList<String>();
        ArrayList<Object> bits = Collections.list(new StringTokenizer(queryFilter, " \t\n\r\f()&|<>=!~+-/*", true));
        boolean inWitespace = false;
        StringBuilder currentSymbol = new StringBuilder();
        for (Object e : bits) {
            TokenType tokenType;
            String bit = (String)e;
            switch (bit.charAt(0)) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    inWitespace = true;
                    tokenType = TokenType.WHITESPACE;
                    break;
                }
                case '!': 
                case '&': 
                case '<': 
                case '=': 
                case '>': 
                case '|': {
                    currentSymbol.append(bit.charAt(0));
                    tokenType = TokenType.SYMBOL;
                    break;
                }
                default: {
                    tokenType = TokenType.NORMAL;
                }
            }
            if (tokenType != TokenType.WHITESPACE && inWitespace) {
                inWitespace = false;
            }
            if (tokenType != TokenType.SYMBOL && currentSymbol.length() > 0) {
                tokens.add(currentSymbol.toString());
                currentSymbol = new StringBuilder();
            }
            if (tokenType != TokenType.NORMAL) continue;
            tokens.add(bit);
        }
        if (currentSymbol.length() > 0) {
            tokens.add(currentSymbol.toString());
            currentSymbol = new StringBuilder();
        }
        if (((String)tokens.getFirst()).equals(" ")) {
            tokens.removeFirst();
        }
        return tokens;
    }

    private class EntityData {
        private final Entity entity;
        private final Map<String, Id> ids = new TreeMap<String, Id>();
        private final Map<String, Field> fields = new TreeMap<String, Field>();
        private final Map<String, RelationField> relations = new TreeMap<String, RelationField>();

        public EntityData(Entity entity) {
            String name;
            if (entity == null) {
                throw new NullPointerException("entity is null");
            }
            this.entity = entity;
            Attributes attributes = entity.getAttributes();
            if (attributes != null) {
                for (Id id : attributes.getId()) {
                    name = id.getName();
                    this.ids.put(name, id);
                    this.fields.put(name, (Field)id);
                }
                for (Basic basic : attributes.getBasic()) {
                    name = basic.getName();
                    this.fields.put(name, (Field)basic);
                }
                for (RelationField relationField : attributes.getOneToOne()) {
                    name = relationField.getName();
                    this.relations.put(name, relationField);
                }
                for (RelationField relationField : attributes.getOneToMany()) {
                    name = relationField.getName();
                    this.relations.put(name, relationField);
                }
                for (RelationField relationField : attributes.getManyToOne()) {
                    name = relationField.getName();
                    this.relations.put(name, relationField);
                }
                for (RelationField relationField : attributes.getManyToMany()) {
                    name = relationField.getName();
                    this.relations.put(name, relationField);
                }
            }
            for (AttributeOverride attributeOverride : entity.getAttributeOverride()) {
                name = attributeOverride.getName();
                this.fields.put(name, (Field)attributeOverride);
            }
        }

        public boolean hasPkColumnMapping(String column) {
            if (this.ids.size() > 1) {
                return false;
            }
            for (Id id : this.ids.values()) {
                if (!column.equals(id.getColumn().getName())) continue;
                return true;
            }
            return false;
        }
    }

    private class SunColumnName {
        private final String table;
        private final String column;

        public SunColumnName(ColumnName columnName, String primaryTableName) {
            this(columnName.getvalue(), primaryTableName);
        }

        public SunColumnName(String fullName, String primaryTableName) {
            int dot = fullName.indexOf(46);
            if (dot > 0) {
                String t = fullName.substring(0, dot);
                this.table = primaryTableName.equals(t) ? null : t;
                this.column = fullName.substring(dot + 1);
            } else {
                this.table = null;
                this.column = fullName;
            }
        }
    }

    private static enum TokenType {
        WHITESPACE,
        SYMBOL,
        NORMAL;

    }
}

