/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.cmp.cmp2;

import jakarta.ejb.EJBException;
import jakarta.ejb.EJBLocalObject;
import jakarta.ejb.EntityBean;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.openejb.BeanContext;
import org.apache.openejb.core.cmp.cmp2.Cmp2Entity;
import org.apache.openejb.core.cmp.cmp2.Cmp2Util;
import org.apache.openejb.core.cmp.cmp2.CmrSet;
import org.apache.openejb.loader.SystemInstance;

public class SetValuedCmr<Bean extends EntityBean, Proxy extends EJBLocalObject> {
    private final EntityBean source;
    private final String sourceProperty;
    private final String relatedProperty;
    private final BeanContext relatedInfo;
    private final TransactionSynchronizationRegistry transactionRegistry;

    public SetValuedCmr(EntityBean source, String sourceProperty, Class<Bean> relatedType, String relatedProperty) {
        if (source == null) {
            throw new NullPointerException("source is null");
        }
        if (relatedType == null) {
            throw new NullPointerException("relatedType is null");
        }
        this.source = source;
        this.sourceProperty = sourceProperty;
        this.relatedProperty = relatedProperty;
        this.relatedInfo = Cmp2Util.getBeanContext(relatedType);
        this.transactionRegistry = (TransactionSynchronizationRegistry)SystemInstance.get().getComponent(TransactionSynchronizationRegistry.class);
    }

    public Set<Proxy> get(Set<Bean> others) {
        if (this.sourceProperty == null) {
            throw new EJBException("Internal error: this container managed relationship is unidirectional and, this entity does not have a cmr field for the relationship");
        }
        if (others == null) {
            throw new NullPointerException("others is null");
        }
        CmrSet cmrSet = null;
        try {
            cmrSet = (CmrSet)this.transactionRegistry.getResource((Object)this);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (cmrSet == null) {
            cmrSet = new CmrSet(this.source, this.sourceProperty, this.relatedInfo, this.relatedProperty, others);
            try {
                this.transactionRegistry.putResource((Object)this, cmrSet);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return cmrSet;
    }

    public void set(Set<Bean> relatedBeans, Collection newProxies) {
        if (this.sourceProperty == null) {
            throw new EJBException("Internal error: this container managed relationship is unidirectional and, this entity does not have a cmr field for the relationship");
        }
        if (newProxies == null) {
            throw new IllegalArgumentException("null can not be set into a collection-valued cmr-field");
        }
        if (this.relatedProperty != null) {
            for (EntityBean oldBean : relatedBeans) {
                if (oldBean == null) continue;
                this.toCmp2Entity(oldBean).OpenEJB_removeCmr(this.relatedProperty, this.source);
            }
        }
        relatedBeans.clear();
        for (Object o : new ArrayList(newProxies)) {
            EJBLocalObject newProxy = (EJBLocalObject)o;
            Object newBean = Cmp2Util.getEntityBean(newProxy);
            if (newProxy == null) continue;
            Object oldBackRef = null;
            if (this.relatedProperty != null) {
                oldBackRef = this.toCmp2Entity(newBean).OpenEJB_addCmr(this.relatedProperty, this.source);
            }
            relatedBeans.add(newBean);
            if (this.relatedProperty == null || oldBackRef == null) continue;
            this.toCmp2Entity(oldBackRef).OpenEJB_removeCmr(this.sourceProperty, newBean);
        }
    }

    public void deleted(Set<Bean> relatedBeans) {
        CmrSet cmrSet = (CmrSet)this.transactionRegistry.getResource((Object)this);
        if (cmrSet != null) {
            this.transactionRegistry.putResource((Object)this, null);
            cmrSet.entityDeleted();
        }
        if (this.relatedProperty != null) {
            for (EntityBean oldBean : relatedBeans) {
                if (oldBean == null) continue;
                this.toCmp2Entity(oldBean).OpenEJB_removeCmr(this.relatedProperty, this.source);
            }
        }
    }

    private Cmp2Entity toCmp2Entity(Object object) {
        return (Cmp2Entity)object;
    }
}

