/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf.rs;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import javax.naming.Context;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.apache.cxf.BusException;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.AbstractEndpointFactory;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerImpl;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.JAXRSServiceImpl;
import org.apache.cxf.jaxrs.ext.ResourceComparator;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.MethodDispatcher;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.validation.ValidationExceptionMapper;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.servlet.BaseUrlHelper;
import org.apache.johnzon.jaxrs.ConfigurableJohnzonProvider;
import org.apache.johnzon.jaxrs.JohnzonProvider;
import org.apache.johnzon.jaxrs.WadlDocumentMessageBodyWriter;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.Injection;
import org.apache.openejb.api.internal.Internal;
import org.apache.openejb.api.jmx.Description;
import org.apache.openejb.api.jmx.MBean;
import org.apache.openejb.api.jmx.ManagedAttribute;
import org.apache.openejb.api.jmx.ManagedOperation;
import org.apache.openejb.assembler.classic.ServiceInfo;
import org.apache.openejb.assembler.classic.util.ServiceConfiguration;
import org.apache.openejb.assembler.classic.util.ServiceInfos;
import org.apache.openejb.core.WebContext;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.JarLocation;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.monitoring.LocalMBeanServer;
import org.apache.openejb.monitoring.ObjectNameBuilder;
import org.apache.openejb.rest.ThreadLocalContextManager;
import org.apache.openejb.server.cxf.rs.AutoJAXRSInvoker;
import org.apache.openejb.server.cxf.rs.CdiSingletonResourceProvider;
import org.apache.openejb.server.cxf.rs.EJBExceptionMapper;
import org.apache.openejb.server.cxf.rs.Logs;
import org.apache.openejb.server.cxf.rs.NoopResourceProvider;
import org.apache.openejb.server.cxf.rs.OpenEJBEJBInvoker;
import org.apache.openejb.server.cxf.rs.OpenEJBPerRequestPojoResourceProvider;
import org.apache.openejb.server.cxf.rs.event.ExtensionProviderRegistration;
import org.apache.openejb.server.cxf.rs.event.ServerCreated;
import org.apache.openejb.server.cxf.rs.event.ServerDestroyed;
import org.apache.openejb.server.cxf.transport.HttpDestination;
import org.apache.openejb.server.cxf.transport.util.CxfUtil;
import org.apache.openejb.server.httpd.HttpRequest;
import org.apache.openejb.server.httpd.HttpRequestImpl;
import org.apache.openejb.server.httpd.HttpResponse;
import org.apache.openejb.server.httpd.ServletRequestAdapter;
import org.apache.openejb.server.rest.EJBRestServiceInfo;
import org.apache.openejb.server.rest.InternalApplication;
import org.apache.openejb.server.rest.RsHttpListener;
import org.apache.openejb.util.AppFinder;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.proxy.ProxyEJB;
import org.apache.openejb.util.reflection.Reflections;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.creational.CreationalContextImpl;

public class CxfRsHttpListener
implements RsHttpListener {
    private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.OPENEJB_RS, CxfRsHttpListener.class);
    private static final java.util.logging.Logger SERVER_IMPL_LOGGER = LogUtils.getL7dLogger(ServerImpl.class);
    public static final String CXF_JAXRS_PREFIX = "cxf.jaxrs.";
    public static final String PROVIDERS_KEY = "cxf.jaxrs.providers";
    public static final String STATIC_RESOURCE_KEY = "cxf.jaxrs.static-resources-list";
    public static final String STATIC_SUB_RESOURCE_RESOLUTION_KEY = "staticSubresourceResolution";
    public static final String RESOURCE_COMPARATOR_KEY = "cxf.jaxrs.resourceComparator";
    private static final String GLOBAL_PROVIDERS = SystemInstance.get().getProperty("cxf.jaxrs.providers");
    public static final boolean TRY_STATIC_RESOURCES = "true".equalsIgnoreCase(SystemInstance.get().getProperty("openejb.jaxrs.static-first", "true"));
    private static final boolean FAIL_ON_CONSTRAINED_TO = "true".equalsIgnoreCase(SystemInstance.get().getProperty("openejb.jaxrs.fail-on-constrainedto", "true"));
    private static final Map<String, String> STATIC_CONTENT_TYPES;
    private static final String[] DEFAULT_WELCOME_FILES;
    private final DestinationFactory transportFactory;
    private final String wildcard;
    private HttpDestination destination;
    private Server server;
    private String context = "";
    private String servlet = "";
    private final Collection<Pattern> staticResourcesList = new CopyOnWriteArrayList<Pattern>();
    private final List<ObjectName> jmxNames = new ArrayList<ObjectName>();
    private final Collection<CreationalContext<?>> toRelease = new LinkedHashSet();
    private final Collection<CdiSingletonResourceProvider> singletons = new LinkedHashSet<CdiSingletonResourceProvider>();
    private static final char[] URL_SEP;
    private String pattern;

    public CxfRsHttpListener(DestinationFactory destinationFactory, String star) {
        this.transportFactory = destinationFactory;
        this.wildcard = star;
    }

    public void setUrlPattern(String pattern) {
        this.pattern = pattern;
    }

    public void onMessage(HttpRequest httpRequest, HttpResponse httpResponse) throws Exception {
        String pathInfo;
        if (HttpRequestImpl.class.isInstance(httpRequest)) {
            HttpRequestImpl requestImpl = (HttpRequestImpl)HttpRequestImpl.class.cast(httpRequest);
            requestImpl.initPathFromContext((!this.context.startsWith("/") ? "/" : "") + this.context);
            requestImpl.initServletPath(this.servlet);
        }
        boolean matchedStatic = false;
        if ((TRY_STATIC_RESOURCES || (matchedStatic = this.matchPath((HttpServletRequest)httpRequest))) && this.serveStaticContent((HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse, pathInfo = httpRequest.getPathInfo())) {
            if (matchedStatic) {
                throw new ServletException("Static resource " + pathInfo + " is not available");
            }
            return;
        }
        this.doInvoke(httpRequest, httpResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInvoke(HttpRequest httpRequest, HttpResponse httpResponse) throws IOException {
        String baseURL = BaseUrlHelper.getBaseURL((HttpServletRequest)(this.pattern != null ? new ServletRequestAdapter((HttpServletRequest)httpRequest){

            public String getServletPath() {
                return CxfRsHttpListener.this.pattern;
            }
        } : httpRequest));
        if (!baseURL.endsWith("/")) {
            baseURL = baseURL + "/";
        }
        httpRequest.setAttribute("org.apache.cxf.transport.endpoint.address", (Object)baseURL);
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(CxfUtil.initBusLoader());
        try {
            this.destination.invoke(null, httpRequest.getServletContext(), (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
        }
        finally {
            CxfUtil.clearBusLoader((ClassLoader)oldLoader);
        }
    }

    public boolean matchPath(HttpServletRequest request) {
        if (this.staticResourcesList.isEmpty()) {
            return false;
        }
        String path = request.getRequestURI().substring(request.getContextPath().length());
        if (path.isEmpty()) {
            path = "/";
        }
        for (Pattern pattern : this.staticResourcesList) {
            if (!pattern.matcher(path).matches()) continue;
            return true;
        }
        return false;
    }

    public InputStream findStaticContent(HttpServletRequest request, String[] welcomeFiles) throws ServletException {
        String pathInfo = request.getRequestURI().substring(request.getContextPath().length());
        for (char c : URL_SEP) {
            int indexOf = pathInfo.indexOf(c);
            if (indexOf <= 0) continue;
            pathInfo = pathInfo.substring(0, indexOf);
        }
        InputStream is = request.getServletContext().getResourceAsStream(pathInfo);
        if (is == null && ("/".equals(pathInfo) || pathInfo.isEmpty())) {
            for (String n : welcomeFiles) {
                is = request.getServletContext().getResourceAsStream(n);
                if (is != null) break;
            }
        }
        return is;
    }

    public boolean serveStaticContent(HttpServletRequest request, HttpServletResponse response, String pathInfo) throws ServletException {
        InputStream is = this.findStaticContent(request, DEFAULT_WELCOME_FILES);
        if (is == null) {
            return false;
        }
        try {
            String type;
            int ind = pathInfo.lastIndexOf(".");
            if (ind != -1 && ind < pathInfo.length() && (type = STATIC_CONTENT_TYPES.get(pathInfo.substring(ind + 1))) != null) {
                response.setContentType(type);
            }
            ServletOutputStream os = response.getOutputStream();
            IOUtils.copy((InputStream)is, (OutputStream)os);
            os.flush();
            response.setStatus(200);
        }
        catch (IOException ex) {
            throw new ServletException("Static resource " + pathInfo + " can not be written to the output stream");
        }
        return true;
    }

    @Deprecated
    public void deploySingleton(String contextRoot, String fullContext, Object o, Application appInstance, Collection<Object> additionalProviders, ServiceConfiguration configuration) {
        this.deploy(contextRoot, o.getClass(), fullContext, (ResourceProvider)new SingletonResourceProvider(o), o, appInstance, null, additionalProviders, configuration, null);
    }

    @Deprecated
    public void deployPojo(ClassLoader loader, String contextRoot, String fullContext, Class<?> loadedClazz, Application app, Collection<Injection> injections, Context context, WebBeansContext owbCtx, Collection<Object> additionalProviders, ServiceConfiguration configuration) {
        this.deploy(contextRoot, loadedClazz, fullContext, new OpenEJBPerRequestPojoResourceProvider(loader, loadedClazz, injections, context, owbCtx), null, app, null, additionalProviders, configuration, owbCtx);
    }

    @Deprecated
    public void deployEJB(String contextRoot, String fullContext, BeanContext beanContext, Collection<Object> additionalProviders, ServiceConfiguration configuration) {
        Object proxy = ProxyEJB.subclassProxy((BeanContext)beanContext);
        this.deploy(contextRoot, beanContext.getBeanClass(), fullContext, new NoopResourceProvider(beanContext.getBeanClass(), proxy), proxy, null, (Invoker)new OpenEJBEJBInvoker(Collections.singleton(beanContext)), additionalProviders, configuration, beanContext.getWebBeansContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deploy(String contextRoot, Class<?> clazz, String address, ResourceProvider rp, Object serviceBean, Application app, Invoker invoker, Collection<Object> additionalProviders, ServiceConfiguration configuration, WebBeansContext webBeansContext) {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(CxfUtil.initBusLoader());
        try {
            JAXRSServerFactoryBean factory = this.newFactory(address, CxfRsHttpListener.createServiceJmxName(clazz.getClassLoader()), CxfRsHttpListener.createEndpointName(app));
            this.configureFactory(additionalProviders, configuration, factory, webBeansContext);
            factory.setResourceClasses(new Class[]{clazz});
            this.context = contextRoot;
            if (this.context == null) {
                this.context = "";
            }
            if (!this.context.startsWith("/")) {
                this.context = "/" + this.context;
            }
            if (rp != null) {
                factory.setResourceProvider(rp);
            }
            if (app != null) {
                factory.setApplication(app);
            }
            if (invoker != null) {
                factory.setInvoker(invoker);
            }
            if (serviceBean != null) {
                factory.setServiceBean(serviceBean);
            } else {
                factory.setServiceClass(clazz);
            }
            this.server = factory.create();
            this.destination = (HttpDestination)this.server.getDestination();
            this.fireServerCreated(oldLoader);
        }
        finally {
            if (oldLoader != null) {
                CxfUtil.clearBusLoader((ClassLoader)oldLoader);
            }
        }
    }

    private void fireServerCreated(ClassLoader oldLoader) {
        WebContext webContext;
        Object ctx = AppFinder.findAppContextOrWeb((ClassLoader)oldLoader, (AppFinder.Transformer)new AppFinder.Transformer<Object>(){

            public Object from(AppContext appCtx) {
                return appCtx;
            }

            public Object from(WebContext webCtx) {
                return webCtx;
            }
        });
        AppContext appCtx = AppContext.class.isInstance(ctx) ? (AppContext)AppContext.class.cast(ctx) : ((WebContext)WebContext.class.cast(ctx)).getAppContext();
        WebContext webContext2 = webContext = appCtx == ctx ? null : (WebContext)WebContext.class.cast(ctx);
        if (webContext == null && appCtx.getWebContexts().size() == 1 && ((WebContext)appCtx.getWebContexts().get(0)).getClassLoader() == oldLoader) {
            webContext = (WebContext)appCtx.getWebContexts().get(0);
        }
        SystemInstance.get().fireEvent((Object)new ServerCreated(this.server, appCtx, webContext, this.context));
    }

    private List<Object> providers(Collection<ServiceInfo> services, Collection<Object> additionalProviders, WebBeansContext ctx) {
        ArrayList<Object> instances = new ArrayList<Object>();
        BeanManagerImpl bm = ctx == null ? null : ctx.getBeanManagerImpl();
        for (Object o : additionalProviders) {
            String name;
            Class<?> clazz;
            if (o instanceof Class) {
                List instance;
                clazz = (Class<?>)o;
                if (this.isNotServerProvider(clazz) || CxfRsHttpListener.shouldSkipProvider(name = clazz.getName())) continue;
                if (bm != null && bm.isInUse()) {
                    try {
                        Set beans = bm.getBeans(clazz, new Annotation[0]);
                        if (beans != null && !beans.isEmpty()) {
                            Bean bean = bm.resolve(beans);
                            CreationalContextImpl creationalContext = bm.createCreationalContext((Contextual)bean);
                            instances.add(bm.getReference(bean, clazz, (CreationalContext)creationalContext));
                            this.toRelease.add((CreationalContext<?>)creationalContext);
                            continue;
                        }
                    }
                    catch (Throwable th) {
                        LOGGER.info("Can't use CDI to create provider " + name);
                    }
                }
                if ((instance = ServiceInfos.resolve(services, (String[])new String[]{name}, (ServiceInfos.Factory)OpenEJBProviderFactory.INSTANCE)) != null && !instance.isEmpty()) {
                    instances.add(instance.iterator().next());
                    continue;
                }
                try {
                    instances.add(this.newProvider(clazz));
                }
                catch (Exception e) {
                    LOGGER.error("can't instantiate " + name, (Throwable)e);
                }
                continue;
            }
            clazz = o.getClass();
            if (this.isNotServerProvider(clazz) || CxfRsHttpListener.shouldSkipProvider(name = clazz.getName())) continue;
            instances.add(o);
        }
        return instances;
    }

    private boolean isNotServerProvider(Class<?> clazz) {
        ConstrainedTo ct = clazz.getAnnotation(ConstrainedTo.class);
        if (ct != null && ct.value() != RuntimeType.SERVER) {
            if (!FAIL_ON_CONSTRAINED_TO) {
                LOGGER.warning(clazz + " is not a SERVER provider, ignoring");
                return true;
            }
            throw new IllegalArgumentException(clazz + " is not a SERVER provider");
        }
        return false;
    }

    private static boolean shouldSkipProvider(String name) {
        return "false".equalsIgnoreCase(SystemInstance.get().getProperty(name + ".activated", "true")) || name.startsWith("org.apache.wink.common.internal.");
    }

    private static void addMandatoryProviders(Collection<Object> instances) {
        instances.add(new WadlDocumentMessageBodyWriter());
        instances.add(new EJBExceptionMapper());
        instances.add(new ValidationExceptionMapper());
    }

    private Object newProvider(Class<?> clazz) throws IllegalAccessException, InstantiationException {
        return clazz.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy() {
        for (ObjectName objectName : this.jmxNames) {
            LocalMBeanServer.unregisterSilently((ObjectName)objectName);
        }
        for (CreationalContext creationalContext : this.toRelease) {
            try {
                creationalContext.release();
            }
            catch (Exception e) {
                LOGGER.warning(e.getMessage(), (Throwable)e);
            }
        }
        for (CdiSingletonResourceProvider cdiSingletonResourceProvider : this.singletons) {
            try {
                cdiSingletonResourceProvider.release();
            }
            catch (Exception e) {
                LOGGER.warning(e.getMessage(), (Throwable)e);
            }
        }
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(CxfUtil.initBusLoader());
        try {
            this.server.destroy();
            SystemInstance.get().fireEvent((Object)new ServerDestroyed(this.server));
        }
        catch (RuntimeException runtimeException) {
            LOGGER.warning("Can't stop correctly the endpoint " + this.server);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(runtimeException.getMessage(), (Throwable)runtimeException);
            }
        }
        finally {
            if (oldLoader != null) {
                CxfUtil.clearBusLoader((ClassLoader)oldLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployApplication(Application application, String prefix, String webContext, Collection<Object> additionalProviders, Map<String, EJBRestServiceInfo> restEjbs, ClassLoader classLoader, Collection<Injection> injections, Context context, WebBeansContext owbCtx, ServiceConfiguration serviceConfiguration) {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(CxfUtil.initBusLoader());
        try {
            JAXRSServerFactoryBean factory = this.newFactory(prefix, CxfRsHttpListener.createServiceJmxName(classLoader), CxfRsHttpListener.createEndpointName(application));
            this.configureFactory(additionalProviders, serviceConfiguration, factory, owbCtx);
            factory.setApplication(application);
            ArrayList classes = new ArrayList();
            for (Class clazz : application.getClasses()) {
                if (additionalProviders.contains(clazz) || clazz.isInterface()) continue;
                classes.add(clazz);
                EJBRestServiceInfo restServiceInfo = this.getEjbRestServiceInfo(restEjbs, clazz);
                if (restServiceInfo != null) {
                    Object proxy = ProxyEJB.subclassProxy((BeanContext)restServiceInfo.context);
                    factory.setResourceProvider(clazz, (ResourceProvider)new NoopResourceProvider(restServiceInfo.context.getBeanClass(), proxy));
                    continue;
                }
                factory.setResourceProvider(clazz, (ResourceProvider)new OpenEJBPerRequestPojoResourceProvider(classLoader, clazz, injections, context, owbCtx));
            }
            for (Object o : application.getSingletons()) {
                if (additionalProviders.contains(o)) continue;
                Class<?> clazz = CxfRsHttpListener.realClass(o.getClass());
                classes.add(clazz);
                EJBRestServiceInfo restServiceInfo = this.getEjbRestServiceInfo(restEjbs, clazz);
                if (restServiceInfo != null) {
                    Object proxy = ProxyEJB.subclassProxy((BeanContext)restServiceInfo.context);
                    factory.setResourceProvider(clazz, (ResourceProvider)new NoopResourceProvider(restServiceInfo.context.getBeanClass(), proxy));
                    continue;
                }
                if (owbCtx.getBeanManagerImpl().isInUse()) {
                    CdiSingletonResourceProvider provider = new CdiSingletonResourceProvider(classLoader, clazz, o, injections, context, owbCtx);
                    this.singletons.add(provider);
                    factory.setResourceProvider(clazz, (ResourceProvider)provider);
                    continue;
                }
                factory.setResourceProvider(clazz, (ResourceProvider)new SingletonResourceProvider(o));
            }
            factory.setResourceClasses(classes);
            factory.setInvoker((Invoker)new AutoJAXRSInvoker(restEjbs));
            this.context = webContext;
            if (!webContext.startsWith("/")) {
                this.context = "/" + webContext;
            }
            Level level = SERVER_IMPL_LOGGER.getLevel();
            try {
                SERVER_IMPL_LOGGER.setLevel(Level.OFF);
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
            try {
                this.server = factory.create();
                this.fixProviderIfKnown();
                this.fireServerCreated(oldLoader);
                ServerProviderFactory spf = (ServerProviderFactory)ServerProviderFactory.class.cast(this.server.getEndpoint().get((Object)ServerProviderFactory.class.getName()));
                LOGGER.info("Using readers:");
                for (Object provider : (List)List.class.cast(Reflections.get((Object)spf, (String)"messageReaders"))) {
                    LOGGER.info("     " + ((ProviderInfo)ProviderInfo.class.cast(provider)).getProvider());
                }
                LOGGER.info("Using writers:");
                for (Object provider : (List)List.class.cast(Reflections.get((Object)spf, (String)"messageWriters"))) {
                    LOGGER.info("     " + ((ProviderInfo)ProviderInfo.class.cast(provider)).getProvider());
                }
                LOGGER.info("Using exception mappers:");
                for (Object provider : (List)List.class.cast(Reflections.get((Object)spf, (String)"exceptionMappers"))) {
                    LOGGER.info("     " + ((ProviderInfo)ProviderInfo.class.cast(provider)).getProvider());
                }
            }
            finally {
                try {
                    SERVER_IMPL_LOGGER.setLevel(level);
                }
                catch (UnsupportedOperationException e) {}
            }
            int servletIdx = 1 + this.context.substring(1).indexOf(47);
            if (servletIdx > 0) {
                this.servlet = this.context.substring(servletIdx);
                this.context = this.context.substring(0, servletIdx);
            }
            this.destination = (HttpDestination)this.server.getDestination();
            String base = prefix.endsWith("/") ? prefix.substring(0, prefix.length() - 1) : (prefix.endsWith(this.wildcard) ? prefix.substring(0, prefix.length() - this.wildcard.length()) : prefix);
            this.logEndpoints(application, prefix, restEjbs, factory, base);
        }
        finally {
            if (oldLoader != null) {
                CxfUtil.clearBusLoader((ClassLoader)oldLoader);
            }
        }
    }

    private void fixProviderIfKnown() {
        ServerProviderFactory spf = (ServerProviderFactory)ServerProviderFactory.class.cast(this.server.getEndpoint().get((Object)ServerProviderFactory.class.getName()));
        block0: for (String field : Arrays.asList("messageWriters", "messageReaders")) {
            List values = (List)List.class.cast(Reflections.get((Object)spf, (String)field));
            boolean customJsonProvider = false;
            for (ProviderInfo o : values) {
                if (!ConfigurableJohnzonProvider.class.getName().equals(o.getResourceClass().getName()) && !o.getResourceClass().getName().contains("com.fasterxml.jackson.jaxrs.json")) continue;
                customJsonProvider = true;
                break;
            }
            if (!customJsonProvider) continue;
            Iterator it = values.iterator();
            while (it.hasNext()) {
                if (!JohnzonProvider.class.getName().equals(((ProviderInfo)it.next()).getResourceClass().getName())) continue;
                it.remove();
                continue block0;
            }
        }
    }

    private static Class<?> realClass(Class<?> aClass) {
        Class<?> result = aClass;
        while (result.getName().contains("$$")) {
            if ((result = result.getSuperclass()) != null) continue;
            return aClass;
        }
        return result;
    }

    private EJBRestServiceInfo getEjbRestServiceInfo(Map<String, EJBRestServiceInfo> restEjbs, Class<?> clazz) {
        String name = clazz.getName();
        EJBRestServiceInfo restServiceInfo = restEjbs.get(name);
        if (name.endsWith("$$Impl") && (restServiceInfo = restEjbs.get(name = name.substring(0, name.length() - "$$Impl".length()))) != null) {
            restEjbs.put(clazz.getName(), restServiceInfo);
        }
        return restServiceInfo;
    }

    private static String createEndpointName(Application application) {
        if (application == null) {
            return "jaxrs-application";
        }
        if (InternalApplication.class.isInstance(application)) {
            Application original = ((InternalApplication)InternalApplication.class.cast(application)).getOriginal();
            if (original != null) {
                return original.getClass().getSimpleName();
            }
            return "jaxrs-application";
        }
        return application.getClass().getSimpleName();
    }

    private static String createServiceJmxName(ClassLoader classLoader) {
        AppContext app = (AppContext)AppFinder.findAppContextOrWeb((ClassLoader)classLoader, (AppFinder.Transformer)AppFinder.AppContextTransformer.INSTANCE);
        return app == null ? "application" : app.getId();
    }

    private void logEndpoints(Application application, String prefix, Map<String, EJBRestServiceInfo> restEjbs, JAXRSServerFactoryBean factory, String base) {
        ArrayList<Logs.LogResourceEndpointInfo> resourcesToLog = new ArrayList<Logs.LogResourceEndpointInfo>();
        int classSize = 0;
        int addressSize = 0;
        JAXRSServiceImpl service = (JAXRSServiceImpl)factory.getServiceFactory().getService();
        List resources = service.getClassResourceInfos();
        for (ClassResourceInfo info : resources) {
            if (info.getResourceClass() == null) continue;
            String address = Logs.singleSlash(base, info.getURITemplate().getValue());
            String clazz = info.getResourceClass().getName();
            String type = restEjbs.containsKey(clazz) ? "EJB" : "Pojo";
            classSize = Math.max(classSize, clazz.length());
            addressSize = Math.max(addressSize, address.length());
            int methodSize = 7;
            int methodStrSize = 0;
            ArrayList<Logs.LogOperationEndpointInfo> toLog = new ArrayList<Logs.LogOperationEndpointInfo>();
            MethodDispatcher md = info.getMethodDispatcher();
            for (OperationResourceInfo ori : md.getOperationResourceInfos()) {
                String httpMethod = ori.getHttpMethod();
                String currentAddress = Logs.singleSlash(address, ori.getURITemplate().getValue());
                String methodToStr = Logs.toSimpleString(ori.getMethodToInvoke());
                toLog.add(new Logs.LogOperationEndpointInfo(httpMethod, currentAddress, methodToStr));
                if (httpMethod != null) {
                    methodSize = Math.max(methodSize, httpMethod.length());
                }
                addressSize = Math.max(addressSize, currentAddress.length());
                methodStrSize = Math.max(methodStrSize, methodToStr.length());
            }
            Collections.sort(toLog);
            resourcesToLog.add(new Logs.LogResourceEndpointInfo(type, address, clazz, toLog, methodSize, methodStrSize));
        }
        LOGGER.info("REST Application: " + Logs.forceLength(prefix, addressSize, true) + " -> " + application.getClass().getName());
        Collections.sort(resourcesToLog);
        for (Logs.LogResourceEndpointInfo resource : resourcesToLog) {
            ObjectNameBuilder jmxName = new ObjectNameBuilder("openejb.management").set("j2eeType", "JAX-RS").set("J2EEServer", "openejb").set("J2EEApplication", base).set("EndpointType", resource.type).set("name", resource.classname);
            ObjectName jmxObjectName = jmxName.build();
            LocalMBeanServer.registerDynamicWrapperSilently((Object)new RestServiceMBean(resource), (ObjectName)jmxObjectName);
            this.jmxNames.add(jmxObjectName);
            LOGGER.info("     Service URI: " + Logs.forceLength(resource.address, addressSize, true) + " -> " + Logs.forceLength(resource.type, 4, false) + " " + Logs.forceLength(resource.classname, classSize, true));
            for (Logs.LogOperationEndpointInfo log : resource.operations) {
                LOGGER.info("          " + Logs.forceLength(log.http, resource.methodSize, false) + " " + Logs.forceLength(log.address, addressSize, true) + " ->      " + Logs.forceLength(log.method, resource.methodStrSize, true));
            }
            resource.operations.clear();
        }
        resourcesToLog.clear();
    }

    private JAXRSServerFactoryBean newFactory(String prefix, final String service, final String endpoint) {
        JAXRSServerFactoryBean factory = new JAXRSServerFactoryBean(){

            protected Endpoint createEndpoint() throws BusException, EndpointException {
                Endpoint created = super.createEndpoint();
                created.put((Object)"managed.service.name", (Object)service);
                created.put((Object)"managed.endpoint.name", (Object)endpoint);
                return created;
            }
        };
        factory.setDestinationFactory(this.transportFactory);
        factory.setBus(CxfUtil.getBus());
        factory.setAddress(prefix);
        return factory;
    }

    private void configureFactory(Collection<Object> givenAdditionalProviders, ServiceConfiguration serviceConfiguration, JAXRSServerFactoryBean factory, WebBeansContext ctx) {
        String staticResources;
        String resourceComparator;
        Comparator<?> providerComparator;
        if (!"true".equalsIgnoreCase(SystemInstance.get().getProperty("openejb.cxf.rs.skip-provider-sorting", "false")) && (providerComparator = this.findProviderComparator(serviceConfiguration, ctx)) != null) {
            factory.setProviderComparator(providerComparator);
        }
        CxfUtil.configureEndpoint((AbstractEndpointFactory)factory, (ServiceConfiguration)serviceConfiguration, (String)CXF_JAXRS_PREFIX);
        Collection services = serviceConfiguration.getAvailableServices();
        String staticSubresourceResolution = serviceConfiguration.getProperties().getProperty("cxf.jaxrs.staticSubresourceResolution");
        if (staticSubresourceResolution != null) {
            factory.setStaticSubresourceResolution("true".equalsIgnoreCase(staticSubresourceResolution));
        }
        if ((resourceComparator = serviceConfiguration.getProperties().getProperty(RESOURCE_COMPARATOR_KEY)) != null) {
            try {
                ResourceComparator instance = (ResourceComparator)ServiceInfos.resolve((Collection)services, (String)resourceComparator);
                if (instance == null) {
                    instance = (ResourceComparator)Thread.currentThread().getContextClassLoader().loadClass(resourceComparator).newInstance();
                }
                factory.setResourceComparator(instance);
            }
            catch (Exception e) {
                LOGGER.error("Can't create the resource comparator " + resourceComparator, (Throwable)e);
            }
        }
        if ((staticResources = serviceConfiguration.getProperties().getProperty(STATIC_RESOURCE_KEY)) != null) {
            String[] resources;
            for (String r : resources = staticResources.split(",")) {
                String trimmed = r.trim();
                if (trimmed.isEmpty()) continue;
                this.staticResourcesList.add(Pattern.compile(trimmed));
            }
        }
        HashSet<String> providersConfig = null;
        String provider = serviceConfiguration.getProperties().getProperty(PROVIDERS_KEY);
        if (provider != null) {
            providersConfig = new HashSet<String>();
            for (String p : Arrays.asList(provider.split(","))) {
                providersConfig.add(p.trim());
            }
        }
        if (GLOBAL_PROVIDERS != null) {
            if (providersConfig == null) {
                providersConfig = new HashSet();
            }
            providersConfig.addAll(Arrays.asList(GLOBAL_PROVIDERS.split(",")));
        }
        String key = "cxf.jaxrs.skip-provider-scanning";
        boolean ignoreAutoProviders = "true".equalsIgnoreCase(SystemInstance.get().getProperty("cxf.jaxrs.skip-provider-scanning", serviceConfiguration.getProperties().getProperty("cxf.jaxrs.skip-provider-scanning", "false")));
        Collection<Object> additionalProviders = ignoreAutoProviders ? Collections.emptyList() : givenAdditionalProviders;
        ArrayList<Object> providers = null;
        if (providersConfig != null && (providers = ServiceInfos.resolve((Collection)services, (String[])providersConfig.toArray(new String[providersConfig.size()]), (ServiceInfos.Factory)OpenEJBProviderFactory.INSTANCE)) != null && additionalProviders != null && !additionalProviders.isEmpty()) {
            providers.addAll(this.providers(serviceConfiguration.getAvailableServices(), additionalProviders, ctx));
        }
        if (providers == null) {
            providers = new ArrayList(4);
            if (additionalProviders != null && !additionalProviders.isEmpty()) {
                providers.addAll(this.providers(serviceConfiguration.getAvailableServices(), additionalProviders, ctx));
            }
        }
        if (!ignoreAutoProviders) {
            CxfRsHttpListener.addMandatoryProviders(providers);
        }
        SystemInstance.get().fireEvent((Object)new ExtensionProviderRegistration((AppContext)AppFinder.findAppContextOrWeb((ClassLoader)Thread.currentThread().getContextClassLoader(), (AppFinder.Transformer)AppFinder.AppContextTransformer.INSTANCE), providers));
        if (!providers.isEmpty()) {
            factory.setProviders(providers);
        }
    }

    private Comparator<?> findProviderComparator(ServiceConfiguration serviceConfiguration, WebBeansContext ctx) {
        BeanManagerImpl bm;
        String comparatorKey = "cxf.jaxrs.provider-comparator";
        String comparatorClass = serviceConfiguration.getProperties().getProperty("cxf.jaxrs.provider-comparator", SystemInstance.get().getProperty("cxf.jaxrs.provider-comparator"));
        Object comparator = null;
        if (comparatorClass == null) {
            return null;
        }
        BeanManagerImpl beanManagerImpl = bm = ctx == null ? null : ctx.getBeanManagerImpl();
        if (bm != null && bm.isInUse()) {
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(comparatorClass);
                Set beans = bm.getBeans(clazz, new Annotation[0]);
                if (beans != null && !beans.isEmpty()) {
                    Bean bean = bm.resolve(beans);
                    CreationalContextImpl creationalContext = bm.createCreationalContext((Contextual)bean);
                    comparator = (Comparator)Comparator.class.cast(bm.getReference(bean, clazz, (CreationalContext)creationalContext));
                    this.toRelease.add((CreationalContext<?>)creationalContext);
                }
            }
            catch (Throwable th) {
                LOGGER.debug("Can't use CDI to load comparator " + comparatorClass);
            }
        }
        if (comparator == null) {
            comparator = (Comparator)Comparator.class.cast(ServiceInfos.resolve((Collection)serviceConfiguration.getAvailableServices(), (String)comparatorClass));
        }
        if (comparator == null) {
            try {
                comparator = (Comparator)Comparator.class.cast(Thread.currentThread().getContextClassLoader().loadClass(comparatorClass).newInstance());
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        for (Type itf : comparator.getClass().getGenericInterfaces()) {
            ParameterizedType pt;
            if (!ParameterizedType.class.isInstance(itf) || Comparator.class != (pt = (ParameterizedType)ParameterizedType.class.cast(itf)).getRawType() || pt.getActualTypeArguments().length <= 0) continue;
            Type t = pt.getActualTypeArguments()[0];
            if (Class.class.isInstance(t) && ProviderInfo.class == t) {
                return comparator;
            }
            if (!ParameterizedType.class.isInstance(t) || ProviderInfo.class != ((ParameterizedType)ParameterizedType.class.cast(t)).getRawType()) continue;
            return comparator;
        }
        return new ProviderComparatorWrapper((Comparator)comparator);
    }

    static {
        DEFAULT_WELCOME_FILES = new String[]{"/index.html", "/index.htm"};
        URL_SEP = new char[]{'?', '#', ';'};
        STATIC_CONTENT_TYPES = new HashMap<String, String>();
        STATIC_CONTENT_TYPES.put("html", "text/html");
        STATIC_CONTENT_TYPES.put("htm", "text/html");
        STATIC_CONTENT_TYPES.put("xhtml", "text/html");
        STATIC_CONTENT_TYPES.put("txt", "text/plain");
        STATIC_CONTENT_TYPES.put("css", "text/css");
        STATIC_CONTENT_TYPES.put("jpg", "image/jpg");
        STATIC_CONTENT_TYPES.put("png", "image/png");
        STATIC_CONTENT_TYPES.put("ico", "image/ico");
        STATIC_CONTENT_TYPES.put("pdf", "application/pdf");
        STATIC_CONTENT_TYPES.put("xsd", "application/xml");
    }

    @MBean
    @Internal
    @Description(value="JAX-RS service information")
    public class RestServiceMBean {
        private final String type;
        private final String address;
        private final String classname;
        private final TabularData operations;

        public RestServiceMBean(Logs.LogResourceEndpointInfo jmxName) {
            this.type = jmxName.type;
            this.address = jmxName.address;
            this.classname = jmxName.classname;
            String[] names = new String[jmxName.operations.size()];
            Object[] values = new String[jmxName.operations.size()];
            int idx = 0;
            for (Logs.LogOperationEndpointInfo operation : jmxName.operations) {
                names[idx] = operation.http + " " + operation.address;
                values[idx] = operation.method;
                ++idx;
            }
            this.operations = LocalMBeanServer.tabularData((String)"Operations", (String)"Operations for this endpoint", (String[])names, (Object[])values);
        }

        @ManagedAttribute
        @Description(value="The type of the REST service")
        public String getWadlUrl() {
            if (this.address.endsWith("?_wadl")) {
                return this.address;
            }
            return this.address + "?_wadl";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ManagedOperation
        @Description(value="The type of the REST service")
        public String getWadl(String format) {
            if (format != null && format.toLowerCase().contains("json")) {
                InputStream inputStream = null;
                try {
                    URL url = new URL(this.getWadlUrl() + "&_type=json");
                    HttpURLConnection connection = (HttpURLConnection)HttpURLConnection.class.cast(url.openConnection());
                    connection.setRequestProperty("Accept", "application/json");
                    connection.setRequestProperty("Content-type", "application/json");
                    inputStream = connection.getInputStream();
                    String string = IO.slurp((InputStream)inputStream);
                    IO.close((Closeable)inputStream);
                    return string;
                }
                catch (Exception e) {
                    String string = e.getMessage();
                    return string;
                }
                finally {
                    IO.close(inputStream);
                }
            }
            try {
                return IO.slurp((URL)new URL(this.getWadlUrl()));
            }
            catch (IOException e) {
                return e.getMessage();
            }
        }

        @ManagedAttribute
        @Description(value="The type of the REST service")
        public String getType() {
            return this.type;
        }

        @ManagedAttribute
        @Description(value="The REST service address")
        public String getAddress() {
            return this.address;
        }

        @ManagedAttribute
        @Description(value="The REST service class name")
        public String getClassname() {
            return this.classname;
        }

        @ManagedAttribute
        @Description(value="All available methods")
        public TabularData getOperations() {
            return this.operations;
        }
    }

    private static class OpenEJBProviderFactory
    implements ServiceInfos.Factory {
        private static final ServiceInfos.Factory INSTANCE = new OpenEJBProviderFactory();

        private OpenEJBProviderFactory() {
        }

        public Object newInstance(Class<?> clazz) throws Exception {
            boolean found = false;
            Object instance = null;
            for (Constructor<?> c : clazz.getConstructors()) {
                int contextAnnotations = 0;
                Annotation[][] arr$ = c.getParameterAnnotations();
                int len$ = arr$.length;
                block1: for (int i$ = 0; i$ < len$; ++i$) {
                    Annotation[] annotations;
                    for (Annotation a : annotations = arr$[i$]) {
                        if (!javax.ws.rs.core.Context.class.equals(a.annotationType())) continue;
                        ++contextAnnotations;
                        continue block1;
                    }
                }
                if (contextAnnotations != c.getParameterTypes().length) continue;
                if (found) {
                    LOGGER.warning("Found multiple matching constructor for " + clazz.getName());
                    return instance;
                }
                Object[] params = new Object[c.getParameterTypes().length];
                for (int i = 0; i < params.length; ++i) {
                    params[i] = ThreadLocalContextManager.findThreadLocal(c.getParameterTypes()[i]);
                }
                instance = c.newInstance(params);
                found = true;
            }
            if (instance != null) {
                return instance;
            }
            return clazz.newInstance();
        }
    }

    private static final class ProviderComparatorWrapper
    implements Comparator<ProviderInfo<?>> {
        private final Comparator<Object> delegate;

        private ProviderComparatorWrapper(Comparator<Object> delegate) {
            this.delegate = delegate;
        }

        @Override
        public int compare(ProviderInfo<?> o1, ProviderInfo<?> o2) {
            return this.delegate.compare(o1.getProvider(), o2.getProvider());
        }
    }

    public static final class DefaultProviderComparator
    extends ProviderFactory
    implements Comparator<ProviderInfo<?>> {
        private static final ClassLoader SYSTEM_LOADER = ClassLoader.getSystemClassLoader();

        public DefaultProviderComparator() {
            super(null);
        }

        @Override
        public int compare(ProviderInfo<?> o1, ProviderInfo<?> o2) {
            boolean loadersNotNull;
            if (o1 == o2 || o1 != null && o1.equals(o2)) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            Class<?> c1 = o1.getProvider().getClass();
            Class<?> c2 = o2.getProvider().getClass();
            if (c1.getName().startsWith("org.apache.cxf.")) {
                if (!c2.getName().startsWith("org.apache.cxf.")) {
                    return 1;
                }
                return -1;
            }
            if (c2.getName().startsWith("org.apache.cxf.")) {
                return -1;
            }
            ClassLoader classLoader1 = c1.getClassLoader();
            ClassLoader classLoader2 = c2.getClassLoader();
            boolean bl = loadersNotNull = classLoader1 != null && classLoader2 != null;
            if (classLoader1 != classLoader2 && loadersNotNull && !classLoader1.equals(classLoader2) && !classLoader2.equals(classLoader1)) {
                if (DefaultProviderComparator.isParent(classLoader1, classLoader2)) {
                    return 1;
                }
                if (DefaultProviderComparator.isParent(classLoader2, classLoader1)) {
                    return -1;
                }
            } else {
                Boolean custom2;
                Boolean custom1;
                int customComp;
                List types2;
                List types1;
                int result = DefaultProviderComparator.compareClasses((Object)o1.getProvider(), (Object)o2.getProvider());
                if (result != 0) {
                    return result;
                }
                if (MessageBodyWriter.class.isInstance(o1.getProvider())) {
                    types1 = JAXRSUtils.sortMediaTypes((List)JAXRSUtils.getProviderProduceTypes((MessageBodyWriter)((MessageBodyWriter)MessageBodyWriter.class.cast(o1.getProvider()))), (String)"qs");
                    types2 = JAXRSUtils.sortMediaTypes((List)JAXRSUtils.getProviderProduceTypes((MessageBodyWriter)((MessageBodyWriter)MessageBodyWriter.class.cast(o2.getProvider()))), (String)"qs");
                    if (types1.contains(MediaType.WILDCARD_TYPE) && !types2.contains(MediaType.WILDCARD_TYPE)) {
                        return 1;
                    }
                    if (types2.contains(MediaType.WILDCARD_TYPE) && !types1.contains(MediaType.WILDCARD_TYPE)) {
                        return -1;
                    }
                    result = JAXRSUtils.compareSortedMediaTypes((List)types1, (List)types2, (String)"qs");
                    if (result != 0) {
                        return result;
                    }
                } else if (MessageBodyReader.class.isInstance(o1.getProvider())) {
                    types1 = JAXRSUtils.sortMediaTypes((List)JAXRSUtils.getProviderConsumeTypes((MessageBodyReader)((MessageBodyReader)MessageBodyReader.class.cast(o1.getProvider()))), null);
                    types2 = JAXRSUtils.sortMediaTypes((List)JAXRSUtils.getProviderConsumeTypes((MessageBodyReader)((MessageBodyReader)MessageBodyReader.class.cast(o2.getProvider()))), null);
                    if (types1.contains(MediaType.WILDCARD_TYPE) && !types2.contains(MediaType.WILDCARD_TYPE)) {
                        return 1;
                    }
                    if (types2.contains(MediaType.WILDCARD_TYPE) && !types1.contains(MediaType.WILDCARD_TYPE)) {
                        return -1;
                    }
                    result = JAXRSUtils.compareSortedMediaTypes((List)types1, (List)types2, (String)"qs");
                    if (result != 0) {
                        return result;
                    }
                }
                if ((customComp = (custom1 = Boolean.valueOf(o1.isCustom())).compareTo(custom2 = Boolean.valueOf(o2.isCustom())) * -1) != 0) {
                    return customComp;
                }
                try {
                    File file1 = JarLocation.jarLocation(c1);
                    File file2 = JarLocation.jarLocation(c2);
                    if ("classes".equals(file1.getName())) {
                        if ("classes".equals(file2.getName())) {
                            return c1.getName().compareTo(c2.getName());
                        }
                        return -1;
                    }
                    if ("classes".equals(file2.getName())) {
                        return 1;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return c1.getName().compareTo(c2.getName());
        }

        private static boolean isParent(ClassLoader l1, ClassLoader l2) {
            for (ClassLoader current = l2; current != null && current != SYSTEM_LOADER; current = current.getParent()) {
                if (!current.equals(l1) && !l1.equals(current)) continue;
                return true;
            }
            return false;
        }

        public Configuration getConfiguration(Message message) {
            throw new UnsupportedOperationException("not a real inheritance");
        }

        protected void setProviders(boolean custom, boolean bus, Object ... providers) {
            throw new UnsupportedOperationException("not a real inheritance");
        }
    }
}

