/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.sxc;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.openejb.sxc.JavaeeNamespaceFilter;
import org.metatype.sxc.jaxb.ExtendedMarshaller;
import org.metatype.sxc.jaxb.ExtendedUnmarshaller;
import org.metatype.sxc.jaxb.JAXBObject;
import org.metatype.sxc.jaxb.RuntimeContext;
import org.metatype.sxc.util.PrettyPrintXMLStreamWriter;
import org.metatype.sxc.util.RuntimeXMLStreamException;
import org.metatype.sxc.util.XoXMLStreamReader;
import org.metatype.sxc.util.XoXMLStreamReaderImpl;
import org.metatype.sxc.util.XoXMLStreamWriter;
import org.metatype.sxc.util.XoXMLStreamWriterImpl;

public class Sxc {
    public static void marshall(JAXBObject objectType, Object object, OutputStream outputStream) throws JAXBException {
        StreamResult result = new StreamResult(outputStream);
        Sxc.marshal(objectType, object, result);
    }

    public static void marshal(JAXBObject objectType, Object object, Result result) throws JAXBException {
        if (result == null) {
            throw new IllegalArgumentException("result is null");
        }
        if (!(result instanceof StreamResult)) {
            throw new IllegalArgumentException("result is null");
        }
        if (object == null) {
            throw new IllegalArgumentException("object is null");
        }
        if (objectType == null) {
            throw new IllegalArgumentException("jaxbObject is null");
        }
        StreamResult streamResult = (StreamResult)result;
        XMLStreamWriter writer = null;
        try {
            XMLOutputFactory xof = Sxc.getXmOutputFactory();
            writer = xof.createXMLStreamWriter(streamResult.getOutputStream(), "UTF-8");
            writer = new PrettyPrintXMLStreamWriter(writer);
            XoXMLStreamWriterImpl w = new XoXMLStreamWriterImpl(writer);
            try {
                w.writeStartDocument("UTF-8", null);
                RuntimeContext context = new RuntimeContext((ExtendedMarshaller)null);
                try {
                    QName name = objectType.getXmlRootElement();
                    w.writeStartElementWithAutoPrefix(name.getNamespaceURI(), name.getLocalPart());
                    objectType.write((XoXMLStreamWriter)w, object, context);
                    w.writeEndElement();
                }
                catch (Exception e2) {
                    XMLStreamException e2;
                    if (e2 instanceof JAXBException) {
                        throw (JAXBException)e2;
                    }
                    if (e2 instanceof RuntimeXMLStreamException) {
                        e2 = ((RuntimeXMLStreamException)e2).getCause();
                    }
                    if (e2 instanceof XMLStreamException) {
                        Throwable cause = e2.getCause();
                        if (cause instanceof JAXBException) {
                            throw (JAXBException)e2;
                        }
                        throw new MarshalException(cause == null ? e2 : cause);
                    }
                    throw new MarshalException((Throwable)e2);
                }
                w.writeEndDocument();
            }
            catch (Exception e) {
                throw new MarshalException((Throwable)e);
            }
        }
        catch (XMLStreamException e) {
            throw new JAXBException("Could not close XMLStreamWriter.", (Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
        }
    }

    public static <T> T unmarshalJavaee(URL resource, JAXBObject<T> jaxbType) throws Exception {
        try (InputStream inputStream = resource.openStream();){
            T t = Sxc.unmarshalJavaee(jaxbType, inputStream);
            return t;
        }
    }

    public static <T> T unmarshalJavaee(JAXBObject<T> jaxbType, InputStream inputStream) throws Exception {
        XMLStreamReader filter = Sxc.prepareReader(inputStream);
        return Sxc.unmarhsal(jaxbType, filter);
    }

    public static XMLStreamReader prepareReader(InputStream inputStream) throws XMLStreamException {
        StreamSource source = new StreamSource(inputStream);
        XMLStreamReader streamReader = Sxc.getXmlInputFactory().createXMLStreamReader(source);
        return new JavaeeNamespaceFilter(streamReader);
    }

    public static <T> T unmarhsal(JAXBObject<T> jaxbType, XMLStreamReader xmlStreamReader) throws Exception {
        XoXMLStreamReaderImpl reader = new XoXMLStreamReaderImpl(xmlStreamReader);
        return Sxc.unmarshall(jaxbType, (XoXMLStreamReader)reader);
    }

    public static <T> T unmarshall(JAXBObject<T> jaxbType, XoXMLStreamReader reader) throws Exception {
        int event = reader.getEventType();
        while (event != 1 && reader.hasNext()) {
            event = reader.next();
        }
        return (T)jaxbType.read(reader, new RuntimeContext((ExtendedUnmarshaller)null));
    }

    private static XMLInputFactory getXmlInputFactory() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Sxc.class.getClassLoader());
            XMLInputFactory factory = null;
            try {
                factory = (XMLInputFactory)Sxc.class.getClassLoader().loadClass("com.sun.xml.internal.stream.XMLInputFactoryImpl").newInstance();
                factory.setProperty("http://java.sun.com/xml/stream/properties/ignore-external-dtd", Boolean.TRUE);
            }
            catch (Exception e) {
                factory = XMLInputFactory.newInstance();
            }
            factory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
            factory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
            factory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
            XMLInputFactory xMLInputFactory = factory;
            return xMLInputFactory;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private static XMLOutputFactory getXmOutputFactory() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Sxc.class.getClassLoader());
            XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
            return xMLOutputFactory;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }
}

