/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jee;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.openejb.jee.AroundInvoke;
import org.apache.openejb.jee.AroundTimeout;
import org.apache.openejb.jee.AsyncMethod;
import org.apache.openejb.jee.ConcurrencyManagementType;
import org.apache.openejb.jee.ConcurrentMethod;
import org.apache.openejb.jee.DataSource;
import org.apache.openejb.jee.EjbLocalRef;
import org.apache.openejb.jee.EjbRef;
import org.apache.openejb.jee.Empty;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.EnvEntry;
import org.apache.openejb.jee.Icon;
import org.apache.openejb.jee.InitMethod;
import org.apache.openejb.jee.KeyedCollection;
import org.apache.openejb.jee.LifecycleCallback;
import org.apache.openejb.jee.LocalCollection;
import org.apache.openejb.jee.MessageDestinationRef;
import org.apache.openejb.jee.NamedMethod;
import org.apache.openejb.jee.PersistenceContextRef;
import org.apache.openejb.jee.PersistenceUnitRef;
import org.apache.openejb.jee.RemoteBean;
import org.apache.openejb.jee.RemoveMethod;
import org.apache.openejb.jee.ResourceEnvRef;
import org.apache.openejb.jee.ResourceRef;
import org.apache.openejb.jee.SecurityIdentity;
import org.apache.openejb.jee.SecurityRoleRef;
import org.apache.openejb.jee.ServiceRef;
import org.apache.openejb.jee.Session;
import org.apache.openejb.jee.SessionType;
import org.apache.openejb.jee.Text;
import org.apache.openejb.jee.TextMap;
import org.apache.openejb.jee.Timeout;
import org.apache.openejb.jee.Timer;
import org.apache.openejb.jee.TimerConsumer;
import org.apache.openejb.jee.TransactionType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="session-beanType", propOrder={"descriptions", "displayNames", "icon", "ejbName", "mappedName", "home", "remote", "localHome", "local", "businessLocal", "businessRemote", "localBean", "serviceEndpoint", "ejbClass", "sessionType", "statefulTimeout", "timeoutMethod", "timer", "initOnStartup", "concurrencyManagementType", "concurrentMethod", "dependsOn", "initMethod", "removeMethod", "asyncMethod", "transactionType", "afterBeginMethod", "beforeCompletionMethod", "afterCompletionMethod", "aroundInvoke", "aroundTimeout", "envEntry", "ejbRef", "ejbLocalRef", "serviceRef", "resourceRef", "resourceEnvRef", "messageDestinationRef", "persistenceContextRef", "persistenceUnitRef", "postConstruct", "preDestroy", "dataSource", "postActivate", "prePassivate", "securityRoleRef", "securityIdentity", "passivationCapable"})
public class SessionBean
implements RemoteBean,
Session,
TimerConsumer {
    @XmlTransient
    protected TextMap description = new TextMap();
    @XmlTransient
    protected TextMap displayName = new TextMap();
    @XmlElement(name="icon", required=true)
    protected LocalCollection<Icon> icon = new LocalCollection();
    @XmlElement(name="ejb-name", required=true)
    protected String ejbName;
    @XmlElement(name="mapped-name")
    protected String mappedName;
    protected String home;
    protected String remote;
    @XmlElement(name="local-home")
    protected String localHome;
    protected String local;
    @XmlElement(name="business-local")
    protected LinkedHashSet<String> businessLocal;
    @XmlElement(name="business-remote")
    protected LinkedHashSet<String> businessRemote;
    @XmlElement(name="local-bean")
    protected Empty localBean;
    @XmlElement(name="service-endpoint")
    protected String serviceEndpoint;
    @XmlElement(name="ejb-class")
    protected String ejbClass;
    @XmlElement(name="session-type")
    protected SessionType sessionType;
    @XmlElement(name="stateful-timeout")
    protected Timeout statefulTimeout;
    @XmlElement(name="timeout-method")
    protected NamedMethod timeoutMethod;
    @XmlElement(name="timer")
    protected List<Timer> timer;
    @XmlElement(name="init-on-startup")
    protected Boolean initOnStartup;
    @XmlElement(name="passivation-capable")
    protected Boolean passivationCapable;
    @XmlElement(name="concurrency-management-type")
    protected ConcurrencyManagementType concurrencyManagementType;
    @XmlElement(name="concurrent-method")
    protected List<ConcurrentMethod> concurrentMethod;
    @XmlElementWrapper(name="depends-on")
    @XmlElement(name="ejb-name")
    protected List<String> dependsOn;
    @XmlElement(name="init-method")
    protected List<InitMethod> initMethod;
    @XmlElement(name="remove-method")
    protected List<RemoveMethod> removeMethod;
    @XmlElement(name="async-method")
    protected List<AsyncMethod> asyncMethod;
    @XmlElement(name="transaction-type")
    protected TransactionType transactionType;
    @XmlTransient
    protected NamedMethod afterBeginMethod;
    @XmlTransient
    protected NamedMethod beforeCompletionMethod;
    @XmlTransient
    protected NamedMethod afterCompletionMethod;
    @XmlTransient
    private Set<String> asynchronousClasses;
    @XmlElement(name="around-invoke", required=true)
    protected List<AroundInvoke> aroundInvoke;
    @XmlElement(name="around-timeout")
    protected List<AroundTimeout> aroundTimeout;
    @XmlElement(name="env-entry", required=true)
    protected KeyedCollection<String, EnvEntry> envEntry;
    @XmlElement(name="ejb-ref", required=true)
    protected KeyedCollection<String, EjbRef> ejbRef;
    @XmlElement(name="ejb-local-ref", required=true)
    protected KeyedCollection<String, EjbLocalRef> ejbLocalRef;
    @XmlElement(name="service-ref", required=true)
    protected KeyedCollection<String, ServiceRef> serviceRef;
    @XmlElement(name="resource-ref", required=true)
    protected KeyedCollection<String, ResourceRef> resourceRef;
    @XmlElement(name="resource-env-ref", required=true)
    protected KeyedCollection<String, ResourceEnvRef> resourceEnvRef;
    @XmlElement(name="message-destination-ref", required=true)
    protected KeyedCollection<String, MessageDestinationRef> messageDestinationRef;
    @XmlElement(name="persistence-context-ref", required=true)
    protected KeyedCollection<String, PersistenceContextRef> persistenceContextRef;
    @XmlElement(name="persistence-unit-ref", required=true)
    protected KeyedCollection<String, PersistenceUnitRef> persistenceUnitRef;
    @XmlElement(name="post-construct", required=true)
    protected List<LifecycleCallback> postConstruct;
    @XmlElement(name="pre-destroy", required=true)
    protected List<LifecycleCallback> preDestroy;
    @XmlElement(name="data-source")
    protected KeyedCollection<String, DataSource> dataSource;
    @XmlElement(name="post-activate", required=true)
    protected List<LifecycleCallback> postActivate;
    @XmlElement(name="pre-passivate", required=true)
    protected List<LifecycleCallback> prePassivate;
    @XmlElement(name="security-role-ref", required=true)
    protected List<SecurityRoleRef> securityRoleRef;
    @XmlElement(name="security-identity")
    protected SecurityIdentity securityIdentity;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    protected String id;
    @XmlTransient
    private List<LifecycleCallback> afterBegin;
    @XmlTransient
    private List<LifecycleCallback> beforeCompletion;
    @XmlTransient
    private List<LifecycleCallback> afterCompletion;
    @XmlTransient
    private boolean restService = false;
    @XmlTransient
    private String proxy;
    @XmlTransient
    private final Collection<String> parents = new ArrayList<String>();

    public SessionBean() {
    }

    public SessionBean(String ejbName, String ejbClass, SessionType sessionType) {
        this.ejbName = ejbName;
        this.ejbClass = ejbClass;
        this.sessionType = sessionType;
    }

    @Override
    public String getJndiConsumerName() {
        return this.ejbName;
    }

    @XmlElement(name="description", required=true)
    public Text[] getDescriptions() {
        return this.description.toArray();
    }

    public void setDescriptions(Text[] text) {
        this.description.set(text);
    }

    public String getDescription() {
        return this.description.get();
    }

    @XmlElement(name="display-name", required=true)
    public Text[] getDisplayNames() {
        return this.displayName.toArray();
    }

    public void setDisplayNames(Text[] text) {
        this.displayName.set(text);
    }

    public String getDisplayName() {
        return this.displayName.get();
    }

    public Collection<Icon> getIcons() {
        if (this.icon == null) {
            this.icon = new LocalCollection();
        }
        return this.icon;
    }

    public Map<String, Icon> getIconMap() {
        if (this.icon == null) {
            this.icon = new LocalCollection();
        }
        return this.icon.toMap();
    }

    public Icon getIcon() {
        return this.icon.getLocal();
    }

    @Override
    public String getEjbName() {
        return this.ejbName;
    }

    @Override
    public void setEjbName(String value) {
        this.ejbName = value;
    }

    @Override
    public String getMappedName() {
        return this.mappedName;
    }

    @Override
    public void setMappedName(String value) {
        this.mappedName = value;
    }

    @Override
    public String getHome() {
        return this.home;
    }

    @Override
    public void setHome(String value) {
        this.home = value;
    }

    @Override
    public String getRemote() {
        return this.remote;
    }

    @Override
    public void setRemote(String value) {
        this.remote = value;
    }

    public void setHomeAndRemote(String home, String remote) {
        this.remote = remote;
        this.home = home;
    }

    public void setHomeAndRemote(Class<?> home, Class<?> remote) {
        this.remote = remote.getName();
        this.home = home.getName();
    }

    public void setHomeAndLocal(String localHome, String local) {
        this.local = local;
        this.localHome = localHome;
    }

    public void setHomeAndLocal(Class<?> localHome, Class<?> local) {
        this.local = local.getName();
        this.localHome = localHome.getName();
    }

    @Override
    public String getLocalHome() {
        return this.localHome;
    }

    @Override
    public void setLocalHome(String value) {
        this.localHome = value;
    }

    @Override
    public String getLocal() {
        return this.local;
    }

    @Override
    public void setLocal(String value) {
        this.local = value;
    }

    @Override
    public Collection<String> getBusinessLocal() {
        if (this.businessLocal == null) {
            this.businessLocal = new LinkedHashSet();
        }
        return this.businessLocal;
    }

    public void addBusinessLocal(String businessLocal) {
        if (businessLocal == null) {
            return;
        }
        this.getBusinessLocal().add(businessLocal);
    }

    public void addBusinessLocal(Class businessLocal) {
        this.addBusinessLocal(businessLocal.getName());
    }

    @Override
    public Collection<String> getBusinessRemote() {
        if (this.businessRemote == null) {
            this.businessRemote = new LinkedHashSet();
        }
        return this.businessRemote;
    }

    public void addBusinessRemote(String businessRemote) {
        if (businessRemote == null) {
            return;
        }
        this.getBusinessRemote().add(businessRemote);
    }

    public void addBusinessRemote(Class businessRemote) {
        this.addBusinessRemote(businessRemote.getName());
    }

    public Empty getLocalBean() {
        return this.localBean;
    }

    public void setLocalBean(Empty localBean) {
        this.localBean = localBean;
    }

    public String getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    public void setServiceEndpoint(String value) {
        this.serviceEndpoint = value;
    }

    @Override
    public String getEjbClass() {
        return this.ejbClass;
    }

    @Override
    public void setEjbClass(String value) {
        this.ejbClass = value;
    }

    @Override
    public void setEjbClass(Class value) {
        this.ejbClass = value.getName();
    }

    public SessionType getSessionType() {
        return this.sessionType;
    }

    public void setSessionType(SessionType value) {
        this.sessionType = value;
    }

    @Override
    public NamedMethod getTimeoutMethod() {
        return this.timeoutMethod;
    }

    @Override
    public void setTimeoutMethod(NamedMethod value) {
        this.timeoutMethod = value;
    }

    @Override
    public List<InitMethod> getInitMethod() {
        if (this.initMethod == null) {
            this.initMethod = new ArrayList<InitMethod>();
        }
        return this.initMethod;
    }

    @Override
    public List<RemoveMethod> getRemoveMethod() {
        if (this.removeMethod == null) {
            this.removeMethod = new ArrayList<RemoveMethod>();
        }
        return this.removeMethod;
    }

    @Override
    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    @Override
    public void setTransactionType(TransactionType value) {
        this.transactionType = value;
    }

    public NamedMethod getAfterBeginMethod() {
        return this.afterBeginMethod;
    }

    @XmlElement(name="after-begin-method")
    public void setAfterBeginMethod(NamedMethod afterBeginMethod) {
        this.afterBeginMethod = afterBeginMethod;
        this.getAfterBegin().clear();
        this.getAfterBegin().add(new LifecycleCallback(afterBeginMethod));
    }

    public NamedMethod getBeforeCompletionMethod() {
        return this.beforeCompletionMethod;
    }

    @XmlElement(name="before-completion-method")
    public void setBeforeCompletionMethod(NamedMethod beforeCompletionMethod) {
        this.beforeCompletionMethod = beforeCompletionMethod;
        this.getBeforeCompletion().clear();
        this.getBeforeCompletion().add(new LifecycleCallback(beforeCompletionMethod));
    }

    public NamedMethod getAfterCompletionMethod() {
        return this.afterCompletionMethod;
    }

    @XmlElement(name="after-completion-method")
    public void setAfterCompletionMethod(NamedMethod afterCompletionMethod) {
        this.afterCompletionMethod = afterCompletionMethod;
        this.getAfterCompletion().clear();
        this.getAfterCompletion().add(new LifecycleCallback(afterCompletionMethod));
    }

    @Override
    public List<AroundInvoke> getAroundInvoke() {
        if (this.aroundInvoke == null) {
            this.aroundInvoke = new ArrayList<AroundInvoke>();
        }
        return this.aroundInvoke;
    }

    @Override
    public void addAroundInvoke(String method) {
        assert (this.ejbClass != null) : "Set the ejbClass before calling this method";
        this.getAroundInvoke().add(new AroundInvoke(this.ejbClass, method));
    }

    @Override
    public Collection<EnvEntry> getEnvEntry() {
        if (this.envEntry == null) {
            this.envEntry = new KeyedCollection();
        }
        return this.envEntry;
    }

    @Override
    public Map<String, EnvEntry> getEnvEntryMap() {
        if (this.envEntry == null) {
            this.envEntry = new KeyedCollection();
        }
        return this.envEntry.toMap();
    }

    @Override
    public Collection<EjbRef> getEjbRef() {
        if (this.ejbRef == null) {
            this.ejbRef = new KeyedCollection();
        }
        return this.ejbRef;
    }

    @Override
    public Map<String, EjbRef> getEjbRefMap() {
        if (this.ejbRef == null) {
            this.ejbRef = new KeyedCollection();
        }
        return this.ejbRef.toMap();
    }

    @Override
    public Collection<EjbLocalRef> getEjbLocalRef() {
        if (this.ejbLocalRef == null) {
            this.ejbLocalRef = new KeyedCollection();
        }
        return this.ejbLocalRef;
    }

    @Override
    public Map<String, EjbLocalRef> getEjbLocalRefMap() {
        if (this.ejbLocalRef == null) {
            this.ejbLocalRef = new KeyedCollection();
        }
        return this.ejbLocalRef.toMap();
    }

    @Override
    public Collection<ServiceRef> getServiceRef() {
        if (this.serviceRef == null) {
            this.serviceRef = new KeyedCollection();
        }
        return this.serviceRef;
    }

    @Override
    public Map<String, ServiceRef> getServiceRefMap() {
        if (this.serviceRef == null) {
            this.serviceRef = new KeyedCollection();
        }
        return this.serviceRef.toMap();
    }

    @Override
    public Collection<ResourceRef> getResourceRef() {
        if (this.resourceRef == null) {
            this.resourceRef = new KeyedCollection();
        }
        return this.resourceRef;
    }

    @Override
    public Map<String, ResourceRef> getResourceRefMap() {
        if (this.resourceRef == null) {
            this.resourceRef = new KeyedCollection();
        }
        return this.resourceRef.toMap();
    }

    @Override
    public Collection<ResourceEnvRef> getResourceEnvRef() {
        if (this.resourceEnvRef == null) {
            this.resourceEnvRef = new KeyedCollection();
        }
        return this.resourceEnvRef;
    }

    @Override
    public Map<String, ResourceEnvRef> getResourceEnvRefMap() {
        if (this.resourceEnvRef == null) {
            this.resourceEnvRef = new KeyedCollection();
        }
        return this.resourceEnvRef.toMap();
    }

    @Override
    public Collection<MessageDestinationRef> getMessageDestinationRef() {
        if (this.messageDestinationRef == null) {
            this.messageDestinationRef = new KeyedCollection();
        }
        return this.messageDestinationRef;
    }

    @Override
    public Map<String, MessageDestinationRef> getMessageDestinationRefMap() {
        if (this.messageDestinationRef == null) {
            this.messageDestinationRef = new KeyedCollection();
        }
        return this.messageDestinationRef.toMap();
    }

    @Override
    public Collection<PersistenceContextRef> getPersistenceContextRef() {
        if (this.persistenceContextRef == null) {
            this.persistenceContextRef = new KeyedCollection();
        }
        return this.persistenceContextRef;
    }

    @Override
    public Map<String, PersistenceContextRef> getPersistenceContextRefMap() {
        if (this.persistenceContextRef == null) {
            this.persistenceContextRef = new KeyedCollection();
        }
        return this.persistenceContextRef.toMap();
    }

    @Override
    public Collection<PersistenceUnitRef> getPersistenceUnitRef() {
        if (this.persistenceUnitRef == null) {
            this.persistenceUnitRef = new KeyedCollection();
        }
        return this.persistenceUnitRef;
    }

    @Override
    public Map<String, PersistenceUnitRef> getPersistenceUnitRefMap() {
        if (this.persistenceUnitRef == null) {
            this.persistenceUnitRef = new KeyedCollection();
        }
        return this.persistenceUnitRef.toMap();
    }

    @Override
    public List<LifecycleCallback> getPostConstruct() {
        if (this.postConstruct == null) {
            this.postConstruct = new ArrayList<LifecycleCallback>();
        }
        return this.postConstruct;
    }

    @Override
    public void addPostConstruct(String method) {
        assert (this.ejbClass != null) : "Set the ejbClass before calling this method";
        this.getPostConstruct().add(new LifecycleCallback(this.ejbClass, method));
    }

    @Override
    public List<LifecycleCallback> getPreDestroy() {
        if (this.preDestroy == null) {
            this.preDestroy = new ArrayList<LifecycleCallback>();
        }
        return this.preDestroy;
    }

    @Override
    public void addPreDestroy(String method) {
        assert (this.ejbClass != null) : "Set the ejbClass before calling this method";
        this.getPreDestroy().add(new LifecycleCallback(this.ejbClass, method));
    }

    @Override
    public List<LifecycleCallback> getPostActivate() {
        if (this.postActivate == null) {
            this.postActivate = new ArrayList<LifecycleCallback>();
        }
        return this.postActivate;
    }

    @Override
    public void addPostActivate(String method) {
        assert (this.ejbClass != null) : "Set the ejbClass before calling this method";
        this.getPostActivate().add(new LifecycleCallback(this.ejbClass, method));
    }

    @Override
    public List<LifecycleCallback> getPrePassivate() {
        if (this.prePassivate == null) {
            this.prePassivate = new ArrayList<LifecycleCallback>();
        }
        return this.prePassivate;
    }

    @Override
    public void addPrePassivate(String method) {
        assert (this.ejbClass != null) : "Set the ejbClass before calling this method";
        this.getPrePassivate().add(new LifecycleCallback(this.ejbClass, method));
    }

    @Override
    public List<SecurityRoleRef> getSecurityRoleRef() {
        if (this.securityRoleRef == null) {
            this.securityRoleRef = new ArrayList<SecurityRoleRef>();
        }
        return this.securityRoleRef;
    }

    @Override
    public SecurityIdentity getSecurityIdentity() {
        return this.securityIdentity;
    }

    @Override
    public void setSecurityIdentity(SecurityIdentity value) {
        this.securityIdentity = value;
    }

    public List<String> getDependsOn() {
        return this.dependsOn;
    }

    public void setDependsOn(String ... ejbNames) {
        this.setDependsOn(Arrays.asList(ejbNames));
    }

    public void setDependsOn(List<String> ejbNames) {
        this.dependsOn = new ArrayList<String>(ejbNames);
    }

    public boolean hasInitOnStartup() {
        return this.initOnStartup != null;
    }

    public boolean getInitOnStartup() {
        return this.initOnStartup != null && this.initOnStartup != false;
    }

    public void setInitOnStartup(boolean initOnStartup) {
        this.initOnStartup = initOnStartup;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String value) {
        this.id = value;
    }

    public Timeout getStatefulTimeout() {
        return this.statefulTimeout;
    }

    public void setStatefulTimeout(Timeout statefulTimeout) {
        this.statefulTimeout = statefulTimeout;
    }

    @Override
    public List<AroundTimeout> getAroundTimeout() {
        if (this.aroundTimeout == null) {
            this.aroundTimeout = new ArrayList<AroundTimeout>();
        }
        return this.aroundTimeout;
    }

    public List<AsyncMethod> getAsyncMethod() {
        if (this.asyncMethod == null) {
            this.asyncMethod = new ArrayList<AsyncMethod>();
        }
        return this.asyncMethod;
    }

    public ConcurrencyManagementType getConcurrencyManagementType() {
        return this.concurrencyManagementType;
    }

    public void setConcurrencyManagementType(ConcurrencyManagementType concurrencyManagementType) {
        this.concurrencyManagementType = concurrencyManagementType;
    }

    public List<ConcurrentMethod> getConcurrentMethod() {
        if (this.concurrentMethod == null) {
            this.concurrentMethod = new ArrayList<ConcurrentMethod>();
        }
        return this.concurrentMethod;
    }

    @Override
    public void addAfterBegin(String method) {
        assert (this.ejbClass != null) : "Set the ejbClass before calling this method";
        this.getAfterBegin().add(new LifecycleCallback(this.ejbClass, method));
    }

    @Override
    public void addAfterCompletion(String method) {
        assert (this.ejbClass != null) : "Set the ejbClass before calling this method";
        this.getAfterCompletion().add(new LifecycleCallback(this.ejbClass, method));
    }

    @Override
    public void addBeforeCompletion(String method) {
        assert (this.ejbClass != null) : "Set the ejbClass before calling this method";
        this.getBeforeCompletion().add(new LifecycleCallback(this.ejbClass, method));
    }

    @Override
    public List<LifecycleCallback> getAfterBegin() {
        if (this.afterBegin == null) {
            this.afterBegin = new ArrayList<LifecycleCallback>();
        }
        return this.afterBegin;
    }

    @Override
    public List<LifecycleCallback> getAfterCompletion() {
        if (this.afterCompletion == null) {
            this.afterCompletion = new ArrayList<LifecycleCallback>();
        }
        return this.afterCompletion;
    }

    @Override
    public List<LifecycleCallback> getBeforeCompletion() {
        if (this.beforeCompletion == null) {
            this.beforeCompletion = new ArrayList<LifecycleCallback>();
        }
        return this.beforeCompletion;
    }

    @Override
    public Collection<DataSource> getDataSource() {
        if (this.dataSource == null) {
            this.dataSource = new KeyedCollection();
        }
        return this.dataSource;
    }

    @Override
    public Map<String, DataSource> getDataSourceMap() {
        if (this.dataSource == null) {
            this.dataSource = new KeyedCollection();
        }
        return this.dataSource.toMap();
    }

    @Override
    public List<Timer> getTimer() {
        if (this.timer == null) {
            this.timer = new ArrayList<Timer>();
        }
        return this.timer;
    }

    @Override
    public void addAroundTimeout(String method) {
        assert (this.ejbClass != null) : "Set the ejbClass before calling this method";
        this.getAroundTimeout().add(new AroundTimeout(this.ejbClass, method));
    }

    public Set<String> getAsynchronousClasses() {
        if (this.asynchronousClasses == null) {
            this.asynchronousClasses = new HashSet<String>();
        }
        return this.asynchronousClasses;
    }

    public void addAsynchronousClass(String cls) {
        this.getAsynchronousClasses().add(cls);
    }

    @Override
    public String getTimerConsumerName() {
        return this.ejbName;
    }

    public boolean isRestService() {
        return this.restService;
    }

    public void setRestService(boolean restService) {
        this.restService = restService;
    }

    public void setProxy(String name) {
        this.proxy = name;
    }

    public String getProxy() {
        return this.proxy;
    }

    public Collection<String> getParents() {
        return this.parents;
    }

    public EnterpriseBean localBean() {
        this.setLocalBean(new Empty());
        return this;
    }

    public Boolean getPassivationCapable() {
        return this.passivationCapable;
    }

    public void setPassivationCapable(Boolean passivationCapable) {
        this.passivationCapable = passivationCapable;
    }
}

